/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.schema;

import com.oceanbase.tools.loaddump.base.State;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.context.TaskContext;
import com.oceanbase.tools.loaddump.loader.schema.AbstractSchemaFileLoader;
import com.oceanbase.tools.loaddump.reader.schema.SchemaFileReaderV2;
import com.oceanbase.tools.loaddump.resource.ResourceFinderV2;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaFileLoader
extends AbstractSchemaFileLoader {
    public SchemaFileLoader(LoadParameter parameter) {
        super(parameter);
    }

    @Override
    public TaskContext loadSchemaAsync() throws Exception {
        super.checkState();
        SchemaFileReaderV2 reader = new SchemaFileReaderV2(this.parameter);
        reader.setSupervisor(this.supervisor);
        this.writerExecutor.submit(reader);
        this.state = State.RUNNING;
        return this;
    }

    @Override
    protected List<SubFile> generateSubFiles() throws Exception {
        DataFormat dataFormat = this.parameter.getDataFormat();
        ResourceFinderV2 finder = new ResourceFinderV2(this.parameter);
        List<ResourceV2> resources = finder.listSchemaResources();
        return resources.stream().map(r -> new SubFile((ResourceV2)r, 0, 0L, r.getTotalSize(), dataFormat == DataFormat.MIX ? dataFormat : DataFormat.DDL)).collect(Collectors.toList());
    }
}

