/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.manager;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.concurrent.SemaphoreLimiter;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.vmoption.JavaOpts;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager {
    private static final Logger log = LoggerFactory.getLogger(MemoryManager.class);
    private static final Double SAFE_MEMORY_FACTOR = 0.8;
    private static final Long MAX_HEAP_LIMIT = 0xC00000000L;
    private final boolean useKilobyte;
    private final SemaphoreLimiter semaphoreLimiter;

    public MemoryManager() {
        long jvmHeapSize = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        Preconditions.checkState((jvmHeapSize < MAX_HEAP_LIMIT ? 1 : 0) != 0, (Object)"Heap memory exceeds limit. -Xmx must less than 48G");
        double safeHeapSize = Math.floor((double)jvmHeapSize * SAFE_MEMORY_FACTOR);
        log.info("Bootstrap with Max Heap: {}, Safe Heap: {}", (Object)FileUtils.byteCountToDisplaySize((long)jvmHeapSize), (Object)FileUtils.byteCountToDisplaySize(safeHeapSize));
        this.useKilobyte = safeHeapSize > 2.147483646E9;
        int maxHeapSize = safeHeapSize > 2.147483646E9 ? (int)(safeHeapSize / 1024.0) : (int)safeHeapSize;
        this.semaphoreLimiter = new SemaphoreLimiter(maxHeapSize);
    }

    public void alloc(long byteSize) throws Exception {
        if (!JavaOpts.isDisableMemoryCheck) {
            int allocBytes = (int)(this.useKilobyte ? byteSize / 1024L : byteSize);
            this.semaphoreLimiter.acquire(allocBytes);
        }
    }

    public void free(long byteSize) {
        if (!JavaOpts.isDisableMemoryCheck) {
            int freeBytes = (int)Math.max(1L, this.useKilobyte ? byteSize / 1024L : byteSize);
            this.semaphoreLimiter.release(freeBytes);
        }
    }
}

