/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.mybatis.type.custom;

import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.mybatis.type.custom.AbstractToStringTypeHandler;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;

public class SdoGeometryToStringTypeHandler
extends AbstractToStringTypeHandler {
    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object result = rs.getObject(columnName);
        if (result instanceof Struct) {
            return this.toSdoGeometryString((Struct)result);
        }
        if (result instanceof byte[]) {
            return new String((byte[])result);
        }
        return result == null ? null : result.toString();
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object result = rs.getObject(columnIndex);
        if (result instanceof Struct) {
            return this.toSdoGeometryString((Struct)result);
        }
        if (result instanceof byte[]) {
            return new String((byte[])result);
        }
        return result == null ? null : result.toString();
    }

    private String toSdoGeometryString(Struct struct) throws SQLException {
        if (struct == null) {
            return null;
        }
        Object[] objects = struct.getAttributes();
        Object sdoGtype = objects[0];
        Object sdoSrid = objects[1];
        JdbcType.SdoPointType sdoPointType = null;
        if (objects[2] != null) {
            sdoPointType = new JdbcType.SdoPointType(((Struct)objects[2]).getAttributes());
        }
        JdbcType.SdoElemInfoArray sdoElemInfo = null;
        if (objects[3] != null) {
            sdoElemInfo = new JdbcType.SdoElemInfoArray((Object[])((Array)objects[3]).getArray());
        }
        JdbcType.SdoOrdinateArray sdoOrdinates = null;
        if (objects[4] != null) {
            sdoOrdinates = new JdbcType.SdoOrdinateArray((Object[])((Array)objects[4]).getArray());
        }
        return new JdbcType.SdoGeometry(sdoGtype, sdoSrid, sdoPointType, sdoElemInfo, sdoOrdinates).toString();
    }
}

