/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.object.pool;

import com.oceanbase.tools.loaddump.object.pool.LargeObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringBuilderPool
extends LargeObjectPool<StringBuilder> {
    private static final Logger log = LoggerFactory.getLogger(StringBuilderPool.class);
    final ThreadLocal<StringBuilder> threadLocal = this.createThreadLocal();

    @Override
    public StringBuilder getObject(int initCapacity) {
        return this.threadLocal.get();
    }

    @Override
    protected ThreadLocal<StringBuilder> createThreadLocal() {
        return new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder(4096);
            }

            @Override
            public StringBuilder get() {
                StringBuilder b = (StringBuilder)super.get();
                b.setLength(0);
                return b;
            }
        };
    }
}

