/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.par;

import com.oceanbase.tools.loaddump.parser.record.par.ColumnHandler;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.NanoTime;
import org.apache.parquet.io.api.Binary;

public class Int96ColumnHandler
implements ColumnHandler {
    public static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
    public static final long NANOS_PER_DAY = TimeUnit.DAYS.toNanos(1L);

    @Override
    public String getValue(Group group, int colIdx) {
        if (group.getFieldRepetitionCount(colIdx) == 0) {
            return null;
        }
        Binary int96 = group.getInt96(colIdx, 0);
        NanoTime nt = NanoTime.fromBinary((Binary)int96);
        long nanos = (long)(nt.getJulianDay() - 2440588) * NANOS_PER_DAY + nt.getTimeOfDayNanos();
        String tsNanos = LocalDateTime.ofEpochSecond(nanos / 1000000000L, (int)(nanos % 1000000000L), ZoneOffset.UTC).toString();
        return tsNanos;
    }
}

