/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.par;

import com.oceanbase.tools.loaddump.parser.record.par.ColumnHandler;
import java.time.LocalTime;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeColumnHandler
implements ColumnHandler {
    private static final Logger log = LoggerFactory.getLogger(TimeColumnHandler.class);
    private final LogicalTypeAnnotation.TimeUnit timeUnit;

    public TimeColumnHandler(LogicalTypeAnnotation.TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public String getValue(Group group, int colIdx) {
        if (group.getFieldRepetitionCount(colIdx) == 0) {
            return null;
        }
        long value = group.getLong(colIdx, 0);
        switch (this.timeUnit) {
            case MILLIS: {
                return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(value)).toString();
            }
            case MICROS: {
                return LocalTime.ofNanoOfDay(TimeUnit.MICROSECONDS.toNanos(value)).toString();
            }
            case NANOS: {
                return LocalTime.ofNanoOfDay(value).toString();
            }
        }
        log.warn("Unexpected time unit for TimestampLogicalTypeAnnotation: {}", (Object)this.timeUnit);
        return null;
    }
}

