/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.pos;

import java.io.Serializable;

public class Offset
implements Serializable {
    private static final long serialVersionUID = -2440463569223610947L;
    private final int beginIndex;
    private final int endIndex;
    private final OffsetType type;
    private final int relLen;
    private boolean filler;

    @Deprecated
    public Offset(int beginIndex, int endIndex) {
        this.type = OffsetType.ABSOLUTE;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.relLen = -1;
    }

    public Offset(int beginIndex, int endIndex, boolean filler) {
        this.type = OffsetType.ABSOLUTE;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.filler = filler;
        this.relLen = -1;
    }

    public Offset(int relLen, boolean filler) {
        this.type = OffsetType.RELATIVE;
        this.relLen = relLen;
        this.filler = filler;
        this.beginIndex = -1;
        this.endIndex = -1;
    }

    public int getLength() {
        return this.type == OffsetType.ABSOLUTE ? this.endIndex - this.beginIndex + 1 : this.relLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Offset)) {
            return false;
        }
        Offset offset = (Offset)o;
        if (this.getBeginIndex() != offset.getBeginIndex()) {
            return false;
        }
        if (this.getEndIndex() != offset.getEndIndex()) {
            return false;
        }
        if (this.getRelLen() != offset.getRelLen()) {
            return false;
        }
        if (this.isFiller() != offset.isFiller()) {
            return false;
        }
        return this.getType() == offset.getType();
    }

    public int hashCode() {
        int result = this.getBeginIndex();
        result = 31 * result + this.getEndIndex();
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + this.getRelLen();
        result = 31 * result + (this.isFiller() ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Offset{beginIndex=" + this.beginIndex + ", endIndex=" + this.endIndex + ", type=" + (Object)((Object)this.type) + ", relLen=" + this.relLen + ", filler=" + this.filler + '}';
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public OffsetType getType() {
        return this.type;
    }

    public int getRelLen() {
        return this.relLen;
    }

    public boolean isFiller() {
        return this.filler;
    }

    static enum OffsetType {
        ABSOLUTE,
        RELATIVE;

    }
}

