/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.reader.record;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.lmax.disruptor.RingBuffer;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.tools.loaddump.common.model.Insertion;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.context.LoadContext;
import com.oceanbase.tools.loaddump.manager.ControlManager;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.reader.AbstractFileReader;
import com.oceanbase.tools.loaddump.resource.Payload;
import com.oceanbase.tools.loaddump.ringbuffer.RingBufferGroup;
import com.oceanbase.tools.loaddump.strategy.AdaptiveBatchStrategy;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordFileReader
extends AbstractFileReader {
    private static final Logger log = LoggerFactory.getLogger(RecordFileReader.class);
    protected Meter meter;
    protected SubFile subFile;
    protected TableInfo tableInfo;
    protected TableEntry tableEntry;
    protected RingBufferGroup bufferGroup;
    protected ControlManager controlManager;
    protected AdaptiveBatchStrategy adaptiveBatchStrategy;
    protected Map<String, Map<Long, String>> tablePartLeaderMap;
    protected int batchSize;
    protected LoadContext loadCtx;
    protected boolean canWrite;

    public RecordFileReader(LoadParameter parameter) {
        super(parameter);
        this.subFiles = parameter.getSubFiles();
        this.controlManager = parameter.getControlManager();
        this.batchSize = parameter.getBatchSize();
        this.canWrite = parameter.isCanWrite();
    }

    @Override
    public void run() {
        try {
            boolean isShouldRetry;
            int totalBatch = 0;
            if (this.subFile.isSuccess()) {
                return;
            }
            this.subFile.setTaskState(TaskState.RUNNING);
            if (!this.subFile.isVisited()) {
                this.subFile.setVisited(true);
                this.updateCheckpoint();
            }
            boolean bl = isShouldRetry = this.parameter.isRetry() && this.subFile.isVisited();
            if (isShouldRetry && CollectionUtils.isEmpty(this.tableInfo.getPrimaryCols())) {
                log.error("Ignore to retry insert into table: \"{}\" without primary key....", (Object)this.subFile.getObjectName());
                return;
            }
            totalBatch = this.runInternal(isShouldRetry);
            log.info("File: \"{}\" has been parsed finished", (Object)this.subFile.getUniquePath());
            if (this.supervisor.get()) {
                this.loadCtx.waitForAllBatchesConsumed(this.subFile, totalBatch);
            }
        }
        catch (Throwable e) {
            String cause = ExceptionUtils.getRootCauseMessage(e);
            this.subFile.setMessage(cause);
            this.subFile.setTaskState(TaskState.FAILURE);
            log.error("Load data file: \"{}\" failed. ", (Object)this.subFile.getUniquePath(), (Object)e);
        }
        finally {
            this.updateCurrentTaskState();
            this.updateCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int runInternal(boolean isShouldRetry) throws Exception {
        totalBatch = 0;
        payloadMap = new HashMap<Long, Payload>(16);
        calculator = null;
        if (!this.parameter.isDirectMode()) {
            calculator = this.connectionKey.createPartitionIdCalculator(this.tableEntry, this.subsequentV4);
        }
        currentRecordParser = this.subFile.createRecordParser(this.parameter);
        var6_6 = null;
        try {
            iter = currentRecordParser.iterator();
            isFirstRecord = true;
lbl12:
            // 2 sources

            while (true) {
                block35: {
                    block37: {
                        block36: {
                            if (!this.supervisor.get() || this.subFile.isFailure() || !iter.hasNext()) break block35;
                            if (this.loadCtx.shouldFail(this.tableInfo.getTable())) {
                                var9_12 = totalBatch;
                                return var9_12;
                            }
                            record = iter.next();
                            if (this.subFile.isSkipFooter() && !iter.hasNext()) {
                                footer = record == null ? "<No Footer>" : (record.isValid() != false ? record.getValues().toString() : record.getOriginContent());
                                RecordFileReader.log.debug("Skip footer: \"{}\" finish", (Object)footer);
                                continue;
                            }
                            recordList = new ArrayList();
                            if (!record.isParsed()) break block36;
                            if (record.isValid()) {
                                recordList = Lists.newArrayList((Object[])new Record[]{record});
                                break block37;
                            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)record.getOriginContent())) {
                                recordList = SqlUtils.parseStatement(record, this.tableInfo);
                            }
                            break block37;
                        }
                        recordList = Lists.newArrayList((Object[])new Record[]{record});
                    }
                    this.subFile.addParsedCount(recordList.size());
                    var11_15 = recordList.iterator();
                    break;
                }
                if (payloadMap.isEmpty() != false) return totalBatch;
                var9_11 = payloadMap.entrySet().iterator();
                while (var9_11.hasNext() != false) {
                    entry = var9_11.next();
                    if (((Payload)entry.getValue()).getRecordCount() <= 0) continue;
                    this.enqueue((Payload)entry.getValue(), (Long)entry.getKey(), this.parameter.isDirectMode(), isShouldRetry);
                    ++totalBatch;
                }
                return totalBatch;
            }
        }
        catch (Throwable var7_9) {
            var6_6 = var7_9;
            throw var7_9;
        }
        finally {
            payloadMap.clear();
        }
        while (true) {
            if (var11_15.hasNext()) ** break;
            ** continue;
            var12_17 = (Record)var11_15.next();
            byteSize = this.getByteSize(var12_17, this.fileEncoding);
            columnCount = this.tableInfo.getColumnInfoList().size();
            if (isFirstRecord) {
                this.batchSize = this.adaptiveBatchStrategy.getBatchSize(this.tableInfo.getTable(), byteSize, columnCount, this.parameter.getBatchSize());
                isFirstRecord = false;
                RecordFileReader.log.debug("Automatic reset batch size {} to {} for loading table \"{}\"", new Object[]{this.parameter.getBatchSize(), this.batchSize, this.tableInfo.getTable()});
            }
            partId = this.parameter.isDirectMode() != false ? 0L : DBUtils.calculatePartitionId(this.tableInfo, calculator, var12_17);
            var12_16 = this.doCleaning(this.tableInfo.getSchema(), this.tableInfo.getTable(), var12_17);
            if (!var12_16.isValid() || var12_16.getValues().size() != columnCount) {
                insertSql = CollectionUtils.isEmpty(var12_16.getValues()) != false ? var12_16.getOriginContent() : this.tableInfo.toInsertSql(var12_16);
                RecordFileReader.BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)insertSql, (Object)(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)var12_16.getBadCause()) != false ? "The number of columns parsed does not match the number of columns in the table" : var12_16.getBadCause()));
                if (!this.loadCtx.incrementAndIsExceedMaxErrors(this.tableInfo.getTable())) continue;
                this.subFile.setMessage("Too many bad records were found in file: " + this.subFile.getFilePath() + ". See the bad record in \"ob-loader-dumper.bad\"");
                var18_22 = totalBatch;
                return var18_22;
            }
            payload = payloadMap.computeIfAbsent(partId, (Function<Long, Payload>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$runInternal$0(java.lang.Long ), (Ljava/lang/Long;)Lcom/oceanbase/tools/loaddump/resource/Payload;)()).addRecord(var12_16).addByteSize(byteSize);
            if (!payload.isShouldCommit(this.batchSize)) continue;
            this.enqueue(payload, partId, this.parameter.isDirectMode(), isShouldRetry);
            ++totalBatch;
        }
    }

    protected void enqueue(Payload payload, long partId, boolean isDirectMode, boolean isRetryMode) throws Exception {
        Insertion insertion = new Insertion(this.subFile, partId, isRetryMode);
        insertion.setRecordList(payload.getRecordList());
        insertion.setByteSize(payload.getByteSize());
        insertion.setLeaderServer(isDirectMode ? "0.0.0.0" : this.getLeaderServer(this.tableInfo.getTable(), partId));
        payload.reset();
        this.enqueue(insertion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Insertion insertion) throws Exception {
        this.loadCtx.batchProduced(insertion);
        String leaderServer = insertion.getLeaderServer();
        RingBuffer<Insertion> buffer = this.bufferGroup.getBuffer(leaderServer);
        long sequence = buffer.next();
        try {
            Insertion event = (Insertion)buffer.get(sequence);
            event.setRetry(insertion.isRetry());
            event.setSubFile(insertion.getSubFile());
            event.setByteSize(insertion.getByteSize());
            event.setRecordList(insertion.getRecordList());
            event.setPartitionId(insertion.getPartitionId());
            event.setLeaderServer(insertion.getLeaderServer());
            event.setCommit(insertion.isCommit());
            long produced = (long)buffer.getBufferSize() - buffer.remainingCapacity();
            this.meter.mark(leaderServer, insertion.getRecordCount(), insertion.getByteSize(), produced);
        }
        finally {
            buffer.publish(sequence);
        }
    }

    protected Record doCleaning(String schemaName, String tableName, Record record) throws Exception {
        if (this.controlManager == null || !this.controlManager.isControlDefined(schemaName, tableName) || !record.isValid()) {
            return record;
        }
        String schemaTable = this.tableInfo.getSchemaTable();
        Map<String, MapObject> columnIndexMapping = this.tableInfo.getColumnIndexMapping();
        ArrayList newValues = Lists.newArrayListWithCapacity((int)columnIndexMapping.size());
        try {
            for (Map.Entry<String, MapObject> entry : columnIndexMapping.entrySet()) {
                String columnName = entry.getKey();
                MapObject mapObj = entry.getValue();
                Integer srcOffset = mapObj.getSource();
                if (srcOffset == null && mapObj.getGeneratedDefine() != null) {
                    newValues.add(mapObj.getGeneratedDefine().getValue());
                    continue;
                }
                Preconditions.checkArgument((srcOffset != null ? 1 : 0) != 0, (String)"Cannot find a match for column %s of table %s. It may caused by invalid definitions in control file", (Object)columnName, (Object)schemaTable);
                newValues.add(this.controlManager.transform(schemaName, tableName, columnName, record.getString(srcOffset)));
            }
            record.replaceAll(newValues);
        }
        catch (Exception e) {
            record.setParsed(false);
            record.setBadCause(ExceptionUtils.getRootCauseMessage(e));
            log.error("Clean data failed. Record: [{}]. Reason: {}.", (Object)record, (Object)ExceptionUtils.getRootCauseMessage(e));
        }
        return record;
    }

    protected void updateCurrentTaskState() {
        long failedRecordCnt = this.subFile.getParsedCount().get() - this.subFile.getLoadedCount().get();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.subFile.getMessage())) {
            this.subFile.compareAndSetState(TaskState.RUNNING, TaskState.FAILURE);
            log.error("Fatal error occurred while loading data from \"{}\" into table {}. Reason: {}", new Object[]{this.subFile.getFilePath(), this.tableInfo.getSchemaTable(), this.subFile.getMessage()});
        } else if (failedRecordCnt > 0L) {
            String errMsg = MessageFormat.format("Failed to load {0} records from \"{1}\" into table {2}. Check \"ob-loader-dumper.bad\" and \"ob-loader-dumper.discard\" for details", failedRecordCnt, this.subFile.getFilePath(), this.tableInfo.getSchemaTable());
            log.warn(errMsg);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.subFile.getMessage())) {
                this.subFile.setMessage(errMsg);
            }
            this.subFile.compareAndSetState(TaskState.RUNNING, this.loadCtx.isStrict() ? TaskState.FAILURE : TaskState.SUCCESS);
        } else {
            this.subFile.compareAndSetState(TaskState.RUNNING, TaskState.SUCCESS);
        }
        this.updateTaskDetail(this.subFile);
    }

    private void updateCheckpoint() {
        if (this.canWrite) {
            try {
                SerializeUtils.serializeListByKryo(this.subFiles, this.checkpointPath);
            }
            catch (Throwable e) {
                log.warn("Unable to serialize the checkpoint file. But it won't affect the data integrity. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
        }
    }

    protected String getLeaderServer(String table, Long partId) {
        Map<Long, String> partLeaderMap = this.tablePartLeaderMap.get(table);
        Preconditions.checkState((boolean)MapUtils.isNotEmpty(partLeaderMap), (String)"Leader server map is empty. Table: \"%s\"", (Object)table);
        if (this.parameter.hasNoSysPrivileges() || partId == Long.MIN_VALUE || this.parameter.isDirectMode()) {
            return partLeaderMap.computeIfAbsent(partId, v -> "0.0.0.0");
        }
        String leaderServer = partLeaderMap.get(partId);
        Preconditions.checkState((boolean)StringUtils.isNotBlank(leaderServer), (String)"Get leader server is null. Table: \"%s\", Part: %s", (Object)table, (Object)partId);
        return leaderServer;
    }

    protected int getByteSize(Record record, String charset) {
        List<Object> values = record.getValues();
        if (CollectionUtils.isEmpty(values)) {
            return 0;
        }
        int total = values.size() * 2 + 4;
        for (Object obj : values) {
            String value = obj != null ? obj.toString() : null;
            try {
                total += value == null ? 1 : value.getBytes(StringUtils.isBlank(charset) ? "UTF-8" : charset).length;
            }
            catch (Exception e) {
                total += (int)((double)value.length() * 1.5);
            }
        }
        return total;
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public void setSubFile(SubFile subFile) {
        this.subFile = subFile;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public void setTableEntry(TableEntry tableEntry) {
        this.tableEntry = tableEntry;
    }

    public void setBufferGroup(RingBufferGroup bufferGroup) {
        this.bufferGroup = bufferGroup;
    }

    public void setControlManager(ControlManager controlManager) {
        this.controlManager = controlManager;
    }

    public void setAdaptiveBatchStrategy(AdaptiveBatchStrategy adaptiveBatchStrategy) {
        this.adaptiveBatchStrategy = adaptiveBatchStrategy;
    }

    public void setTablePartLeaderMap(Map<String, Map<Long, String>> tablePartLeaderMap) {
        this.tablePartLeaderMap = tablePartLeaderMap;
    }

    public void setLoadCtx(LoadContext loadCtx) {
        this.loadCtx = loadCtx;
    }

    private static /* synthetic */ Payload lambda$runInternal$0(Long v) {
        return new Payload();
    }
}

