/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource;

import com.oceanbase.tools.loaddump.parser.record.Record;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class Payload {
    private long byteSize = 0L;
    @NonNull
    private List<Record> recordList = new ArrayList<Record>();

    public Payload addByteSize(long byteSize) {
        this.byteSize += byteSize;
        return this;
    }

    public Payload addRecord(Record record) {
        this.recordList.add(record);
        return this;
    }

    public int getRecordCount() {
        return this.recordList.size();
    }

    public boolean isShouldCommit(int batchSize) {
        int recordCount = this.getRecordCount();
        return recordCount > 0 && recordCount % batchSize == 0;
    }

    public void reset() {
        this.recordList = new ArrayList<Record>();
        this.byteSize = 0L;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    @NonNull
    public List<Record> getRecordList() {
        return this.recordList;
    }
}

