/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.resource;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.loaddump.vmoption.JavaOpts;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFinderV2 {
    private static final Logger log = LoggerFactory.getLogger(ResourceFinderV2.class);
    LoadParameter parameter;
    StorageConfig storageConfig;
    String filePath;
    FileStatus inputFile;
    String fileExtension;
    String fileSuffix;
    Pattern fileNameRegularExprPattern;
    final List<String> tableNames;
    final Map<String, String> sourceTargetTableMap;

    public ResourceFinderV2(LoadParameter parameter) {
        this.parameter = parameter;
        this.filePath = parameter.getFilePath();
        this.storageConfig = parameter.getStorageConfig();
        this.inputFile = parameter.getInputFile();
        String fileNameRegularExpr = parameter.getFileNameRegExp();
        if (StringUtils.isNotBlank(fileNameRegularExpr)) {
            this.fileNameRegularExprPattern = Pattern.compile(fileNameRegularExpr);
        }
        this.tableNames = parameter.getDatabase().getTableNames();
        this.sourceTargetTableMap = parameter.getSourceTargetTableMap();
        this.fileSuffix = parameter.getFileSuffix();
        this.fileExtension = this.fileSuffix.startsWith(".") ? this.fileSuffix.substring(1) : this.fileSuffix;
    }

    public List<ResourceV2> listSchemaResources() throws Exception {
        ArrayList resources;
        if (this.inputFile != null) {
            return Lists.newArrayList((Object[])new ResourceV2[]{new ResourceV2(this.storageConfig, ObjectType.FILE.getName(), this.inputFile.getPath().getName(), this.inputFile.getPath(), this.inputFile.getLen())});
        }
        log.info("List all matched data files in dest path...");
        Stopwatch stopwatch = Stopwatch.createStarted();
        DataFormat dataFormat = this.parameter.getDataFormat();
        String suffix = dataFormat == DataFormat.MIX || dataFormat == DataFormat.DDL ? this.fileSuffix : DataFormat.DDL.getDefaultFileSuffix();
        List<FileStatus> fileStatuses = this.listFileStatus(suffix);
        if (fileStatuses.size() == 1 && fileStatuses.get(0).getLen() > 0L) {
            FileStatus locatedFile = fileStatuses.get(0);
            String fileName = locatedFile.getPath().getName();
            resources = Lists.newArrayList((Object[])new ResourceV2[]{new ResourceV2(this.storageConfig, ObjectType.FILE.getName(), fileName, locatedFile.getPath(), locatedFile.getLen())});
        } else {
            resources = this.filterMatchedSchemaResources(fileStatuses);
        }
        log.info("Find {} data files in \"{}\" success. Elapsed: {}", new Object[]{resources.size(), new Path(this.storageConfig.getUri()), stopwatch});
        return resources;
    }

    private List<ResourceV2> filterMatchedSchemaResources(List<FileStatus> fileStatuses) {
        ServerMode serverMode = this.parameter.getDatabase().getServerMode();
        Map<ObjectType, Set<String>> whiteListMap = this.parameter.getWhiteListMap();
        Map<ObjectType, Set<String>> blackListMap = this.parameter.getBlackListMap();
        boolean compatibleWith3rd = this.parameter.getDataFormat() == DataFormat.MIX;
        ArrayList<ResourceV2> resources = new ArrayList<ResourceV2>(fileStatuses.size());
        for (FileStatus fileStatus : fileStatuses) {
            Path filePath = fileStatus.getPath();
            String fileName = filePath.getName();
            String parentPath = filePath.getParent().toString();
            String objectTypeName = ObjectType.FILE.getName();
            if (!compatibleWith3rd && this.parameter.isIncludeDdl()) {
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            ObjectType objectType = ObjectType.valueOfName(objectTypeName);
            if (compatibleWith3rd && objectType == ObjectType.FILE) {
                resources.add(new ResourceV2(this.storageConfig, objectTypeName, fileName, filePath, fileStatus.getLen()));
                continue;
            }
            if (!whiteListMap.containsKey((Object)objectType)) continue;
            int index = fileName.lastIndexOf("-schema.sql");
            String objectName = index > 0 ? fileName.substring(0, index) : fileName;
            List<String> whiteSet = DBUtils.toCaseInsensitiveNamesList(serverMode, (Collection<String>)whiteListMap.get((Object)objectType));
            List<String> blackSet = DBUtils.toCaseInsensitiveNamesList(serverMode, (Collection<String>)blackListMap.get((Object)objectType));
            if (blackSet.contains(objectName) || !CollectionUtils.isEmpty(whiteSet) && !whiteSet.contains(objectName)) continue;
            resources.add(new ResourceV2(this.storageConfig, objectTypeName, objectName, filePath, fileStatus.getLen()));
        }
        return resources;
    }

    public List<ResourceV2> listRecordResources() throws Exception {
        ArrayList resources;
        if (this.inputFile != null) {
            return Lists.newArrayList((Object[])new ResourceV2[]{new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), this.tableNames.get(0), this.inputFile.getPath(), this.inputFile.getLen())});
        }
        log.info("Listing all matched data files in dest path...");
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<FileStatus> fileStatuses = this.listFileStatus(this.fileSuffix);
        if (fileStatuses.size() == 1 && fileStatuses.get(0).getLen() > 0L) {
            FileStatus fileStatus = fileStatuses.get(0);
            long fileLength = fileStatus.getLen();
            resources = Lists.newArrayList((Object[])new ResourceV2[]{new ResourceV2(this.storageConfig, ObjectType.TABLE.getName(), this.tableNames.get(0), fileStatus.getPath(), fileLength)});
        } else {
            resources = this.filterMatchedRecordResources(fileStatuses);
        }
        log.info("Find {} data files in: \"{}\" success. Elapsed: {}", new Object[]{resources.size(), new Path(this.storageConfig.getUri()), stopwatch});
        return resources;
    }

    private List<ResourceV2> filterMatchedRecordResources(List<FileStatus> fileStatuses) {
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        ArrayList<ResourceV2> resources = new ArrayList<ResourceV2>(fileStatuses.size());
        for (FileStatus fileStatus : fileStatuses) {
            String tableName;
            Path filePath = fileStatus.getPath();
            String string = tableName = isNotUseRegularExpr ? this.binding0(this.tableNames, filePath) : this.binding1(this.tableNames, filePath);
            if (tableName == null) {
                log.info("Cannot find a binding for \"{}\", ignore it", (Object)filePath);
                continue;
            }
            String objectTypeName = ObjectType.FILE.getName();
            if (this.parameter.isIncludeDdl()) {
                String parentPath = filePath.getParent().toString();
                objectTypeName = parentPath.substring(parentPath.lastIndexOf(File.separator) + 1);
            }
            resources.add(new ResourceV2(this.storageConfig, objectTypeName, tableName, filePath, fileStatus.getLen()));
            log.info("Binding table: \"{}\" to file: \"{}\" finished", (Object)tableName, (Object)filePath);
        }
        return resources;
    }

    private List<FileStatus> listFileStatus(String suffix) throws Exception {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        boolean isNotUseRegularExpr = this.fileNameRegularExprPattern == null;
        FileSystem fs = this.storageConfig.getFileSystem();
        Iterator<FileStatus> fIter = FileUtils.listFiles(fs, new Path(this.storageConfig.getUri()), true);
        HashSet<String> foundPaths = new HashSet<String>();
        while (fIter.hasNext()) {
            FileStatus status = fIter.next();
            String path = status.getPath().toUri().getPath();
            if (foundPaths.contains(path)) continue;
            foundPaths.add(path);
            if (isNotUseRegularExpr && !StringUtils.endsWith((CharSequence)path, (CharSequence)suffix) || !status.isFile()) continue;
            if (status.getLen() == 0L) {
                log.info("File: \"{}\" is empty, ignore it", (Object)path);
                continue;
            }
            if (isNotUseRegularExpr && !StringUtils.endsWith((CharSequence)path, (CharSequence)suffix)) continue;
            result.add(status);
        }
        return result;
    }

    protected String binding0(Collection<String> tableNames, Path path) {
        String name = path.getName();
        if (StringUtils.isNotBlank(name) && name.startsWith(".")) {
            return null;
        }
        String tableName = DBUtils.extractObjectName(FileUtils.getTableName(name), null);
        if (JavaOpts.isBackupRestoreMode && MapUtils.isNotEmpty(this.sourceTargetTableMap)) {
            String targetTable = this.sourceTargetTableMap.get(tableName);
            return targetTable != null && tableNames.contains(targetTable) ? targetTable : null;
        }
        return tableNames.contains(tableName) ? tableName : null;
    }

    protected String binding1(Collection<String> tableNames, Path path) {
        Preconditions.checkArgument((tableNames.size() == 1 ? 1 : 0) != 0, (String)"Specified table count=(%s) is unexpected. As --file-regular-expression is specified.", (int)tableNames.size());
        return this.fileNameRegularExprPattern.matcher(DBUtils.extractObjectName(path.getName(), null)).matches() ? tableNames.iterator().next() : null;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public Map<String, String> getSourceTargetTableMap() {
        return this.sourceTargetTableMap;
    }
}

