/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema;

import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractOwnership;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.base.IDefiner;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import java.math.BigDecimal;
import java.util.List;

public abstract class AbstractSequence
extends AbstractOwnership
implements IDefiner {
    private BigDecimal increment;
    private BigDecimal start;
    private BigDecimal maxValue;
    private BigDecimal minValue;
    private String cycle;
    private BigDecimal cache;
    private String order;

    public AbstractSequence(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE SEQUENCE ").append(this.getSchemaObjectName()).append((CharSequence)this.buildSequenceGrammar());
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.SEQUENCE, this.getSimpleObjectName(), this.terminate(sb))});
    }

    public StringBuilder buildIdentityGrammar() {
        return null;
    }

    public abstract StringBuilder buildSequenceGrammar();

    public AbstractSequence() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSequence)) {
            return false;
        }
        AbstractSequence other = (AbstractSequence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigDecimal this$increment = this.getIncrement();
        BigDecimal other$increment = other.getIncrement();
        if (this$increment == null ? other$increment != null : !((Object)this$increment).equals(other$increment)) {
            return false;
        }
        BigDecimal this$start = this.getStart();
        BigDecimal other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        BigDecimal this$maxValue = this.getMaxValue();
        BigDecimal other$maxValue = other.getMaxValue();
        if (this$maxValue == null ? other$maxValue != null : !((Object)this$maxValue).equals(other$maxValue)) {
            return false;
        }
        BigDecimal this$minValue = this.getMinValue();
        BigDecimal other$minValue = other.getMinValue();
        if (this$minValue == null ? other$minValue != null : !((Object)this$minValue).equals(other$minValue)) {
            return false;
        }
        String this$cycle = this.getCycle();
        String other$cycle = other.getCycle();
        if (this$cycle == null ? other$cycle != null : !this$cycle.equals(other$cycle)) {
            return false;
        }
        BigDecimal this$cache = this.getCache();
        BigDecimal other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !this$order.equals(other$order));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSequence;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigDecimal $increment = this.getIncrement();
        result = result * 59 + ($increment == null ? 43 : ((Object)$increment).hashCode());
        BigDecimal $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        BigDecimal $maxValue = this.getMaxValue();
        result = result * 59 + ($maxValue == null ? 43 : ((Object)$maxValue).hashCode());
        BigDecimal $minValue = this.getMinValue();
        result = result * 59 + ($minValue == null ? 43 : ((Object)$minValue).hashCode());
        String $cycle = this.getCycle();
        result = result * 59 + ($cycle == null ? 43 : $cycle.hashCode());
        BigDecimal $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        return result;
    }

    public BigDecimal getIncrement() {
        return this.increment;
    }

    public void setIncrement(BigDecimal increment) {
        this.increment = increment;
    }

    public BigDecimal getStart() {
        return this.start;
    }

    public void setStart(BigDecimal start) {
        this.start = start;
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    public String getCycle() {
        return this.cycle;
    }

    public void setCycle(String cycle) {
        this.cycle = cycle;
    }

    public BigDecimal getCache() {
        return this.cache;
    }

    public void setCache(BigDecimal cache) {
        this.cache = cache;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }
}

