/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.accessor;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.exception.DatabaseAccessException;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.concurrent.NamedThreadFactory;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.jdbc.ResultMapHandler;
import com.oceanbase.tools.loaddump.jdbc.ResultsHandler;
import com.oceanbase.tools.loaddump.schema.AbstractConstraint;
import com.oceanbase.tools.loaddump.schema.AbstractIndexPartition;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.AbstractTable;
import com.oceanbase.tools.loaddump.schema.TableGroupPartition;
import com.oceanbase.tools.loaddump.schema.TableGroupSubPartition;
import com.oceanbase.tools.loaddump.schema.accessor.AbstractMetadataAccessor;
import com.oceanbase.tools.loaddump.schema.base.KeyColumn;
import com.oceanbase.tools.loaddump.schema.obmysql.AbstractObMySqlConstraint;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlCheck;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlColumn;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlDatabase;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlDependency;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlForeignKey;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlFunction;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlIndex;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlIndexPartition;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlPrimaryKey;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlProcedure;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlRoutine;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSequence;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlTable;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlTableGroup;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlTablePartition;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlUniqueKey;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlView;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTablePartition;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMySqlMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(ObMySqlMetadataAccessor.class);

    public ObMySqlMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public ObMySqlDatabase queryMetadata() throws Exception {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        ObMySqlSchema schema = this.querySchema();
        ObMySqlDatabase database = new ObMySqlDatabase(schema);
        if (schema == null) {
            log.error("Schema: {} was not found.", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        database.getDependencies().addAll(this.queryDependencies(schema));
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (this.isChecked(ObjectType.TABLE_GROUP)) {
            stopwatch.reset().start();
            database.getTableGroupMapping().putAll(this.queryTableGroupMapping(schema));
            log.info("Query {} tablegroups elapsed {}", (Object)database.getTableGroupMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBMYSQL_2230.isPrior(this.getDbType()) && this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            database.getFunctionMapping().putAll(this.queryFunctionMapping(schema));
            log.info("Query {} functions elapsed {}", (Object)database.getFunctionMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBMYSQL_2230.isPrior(this.getDbType()) && this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            database.getProcedureMapping().putAll(this.queryProcedureMapping(schema));
            log.info("Query {} procedures elapsed {}", (Object)database.getProcedureMapping().size(), (Object)stopwatch);
        }
        if (!DbType.OBMYSQL_323.isSubsequent(this.getDbType()) && this.isChecked(ObjectType.SEQUENCE)) {
            stopwatch.reset().start();
            database.getSequenceMapping().putAll(this.querySequenceMapping(schema));
            log.info("Query {} sequences elapsed {}", (Object)database.getSequenceMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObMySqlSchema querySchema() {
        String sql = this.sqlMapper.getSql("getSchema");
        Object[] args = new Object[]{this.getSchemaName()};
        try (Connection conn = this.getSessionManager().getPooledBizConnection();){
            ObMySqlSchema obMySqlSchema = JdbcExecutor.query(conn, sql, args, rs -> {
                ObMySqlSchema schema = new ObMySqlSchema(this.getGlobal(), this.getDbType(), this.getSchemaName());
                if (rs.next()) {
                    schema.setCatalogName(rs.getString("CATALOG_NAME"));
                    schema.setDefaultCollationName(rs.getString("DEFAULT_COLLATION_NAME"));
                    schema.setDefaultCharacterSetName(rs.getString("DEFAULT_CHARACTER_SET_NAME"));
                    return schema;
                }
                return null;
            });
            return obMySqlSchema;
        }
        catch (Exception e) {
            throw new DatabaseAccessException(e);
        }
    }

    public List<ObMySqlDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        if (!this.getSessionManager().isSupportSys() && this.isPrior40()) {
            log.warn("cannot fetch dependencies, skip topology check");
            return Lists.newArrayList();
        }
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName()};
        ResultsHandler handler = rs -> {
            ArrayList<ObMySqlDependency> dependencies = new ArrayList<ObMySqlDependency>();
            while (rs.next()) {
                ObMySqlDependency dependency = new ObMySqlDependency((ObMySqlSchema)schema);
                dependency.setObjType(rs.getString("OBJ_TYPE"));
                dependency.setObjName(rs.getString("OBJ_NAME"));
                dependency.setRefObjType(rs.getString("REF_TYPE"));
                dependency.setRefObjName(rs.getString("REF_NAME"));
                dependency.setRefObjOwner(rs.getString("REF_OWNER"));
                if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                    log.warn("ObjType: {} RefObjType: {}", (Object)dependency.getObjType(), (Object)dependency.getRefObjType());
                    continue;
                }
                dependencies.add(dependency);
            }
            return dependencies;
        };
        if (this.isPrior40()) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    public Map<String, ObMySqlTableGroup> queryTableGroupMapping(AbstractSchema schema) throws SQLException {
        return this.isPrior40() ? this.queryTableGroupMappingV3(schema) : this.queryTableGroupMappingV4(schema);
    }

    public Map<String, ObMySqlTableGroup> queryTableGroupMappingV3(AbstractSchema schema) throws SQLException {
        if (!this.sessionManager.isSupportSys() && this.isPrior40()) {
            log.warn("The tablegroups of schema: {} maybe lost", (Object)schema.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        String sql = this.bindings(ObjectType.TABLE_GROUP, this.getSqlMapper().getSql("getTableGroups"));
        Map<String, ObMySqlTableGroup> tableGroupMap = this.jdbcTemplate.queryMapFromSysTable(sql, null, rs -> {
            LinkedHashMap<String, ObMySqlTableGroup> tempTableGroupMap = new LinkedHashMap<String, ObMySqlTableGroup>();
            while (rs.next()) {
                ObMySqlTableGroup tableGroup = new ObMySqlTableGroup((ObMySqlSchema)schema);
                tableGroup.setTableGroupId(rs.getLong("tablegroup_id"));
                tableGroup.setObjectName(rs.getString("tablegroup_name"));
                tableGroup.setPrimaryZone(rs.getString("primary_zone"));
                tableGroup.setComment(rs.getString("comment"));
                if (DbType.OBMYSQL_22.isPriorFrom(this.getDbType())) {
                    tableGroup.setLocality(rs.getString("locality"));
                    tableGroup.setBinding(rs.getString("binding"));
                    tableGroup.setPartLevel(rs.getInt("part_level"));
                    if (DbType.OBMYSQL_2271.isPrior(this.getDbType())) {
                        tableGroup.setIsSubPartTemplate(rs.getInt("is_sub_part_template"));
                    }
                    TableGroupPartition groupPartition = new TableGroupPartition(schema);
                    groupPartition.setPartitionType(rs.getString("part_func_type"));
                    groupPartition.setPartitionColumnNum(rs.getInt("part_func_expr_num"));
                    groupPartition.setPartitionCount(rs.getInt("part_num"));
                    tableGroup.setTableGroupPartition(groupPartition);
                    TableGroupSubPartition groupSubPartition = new TableGroupSubPartition(schema);
                    groupSubPartition.setSubPartitionType(rs.getString("sub_part_func_type"));
                    groupSubPartition.setSubPartitionCount(rs.getInt("sub_part_num"));
                    groupSubPartition.setSubPartitionColumnNum(rs.getInt("sub_part_func_expr_num"));
                    groupPartition.setTableGroupSubPartition(groupSubPartition);
                }
                tempTableGroupMap.putIfAbsent(tableGroup.getObjectName(), tableGroup);
            }
            return tempTableGroupMap;
        });
        if (MapUtils.isEmpty(tableGroupMap)) {
            log.warn("No tablegroups was found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        for (ObMySqlTableGroup tableGroup : tableGroupMap.values()) {
            if (tableGroup.getPartLevel() < 1) continue;
            this.queryTabGroupPartitionsV3(tableGroup);
            if (tableGroup.getPartLevel() != 2) continue;
            if (tableGroup.getIsSubPartTemplate() == 0) {
                this.queryTabGroupSubPartitionsV3(tableGroup);
                continue;
            }
            this.queryTabGroupSubPartTemplates(tableGroup);
        }
        return tableGroupMap;
    }

    private Map<String, ObMySqlTableGroup> queryTableGroupMappingV4(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE_GROUP, this.getSqlMapper().getSql("getTableGroups"));
        Map<String, ObMySqlTableGroup> tableGroupMap = this.jdbcTemplate.queryMap(sql, null, rs -> {
            LinkedHashMap<String, ObMySqlTableGroup> tempTableGroupMap = new LinkedHashMap<String, ObMySqlTableGroup>();
            while (rs.next()) {
                ObMySqlTableGroup tableGroup = new ObMySqlTableGroup((ObMySqlSchema)schema);
                tableGroup.setObjectName(rs.getString("TABLEGROUP_NAME"));
                tableGroup.setIsSubPartTemplate(0);
                TableGroupPartition partition = new TableGroupPartition(schema);
                partition.setPartitionType(rs.getString("PARTITIONING_TYPE"));
                partition.setPartitionColumnNum(rs.getInt("PARTITIONING_KEY_COUNT"));
                partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                if (StringUtils.isNotBlank(partition.getPartitionType())) {
                    tableGroup.setPartLevel(1);
                }
                tableGroup.setTableGroupPartition(partition);
                TableGroupSubPartition subPartition = new TableGroupSubPartition(schema);
                subPartition.setSubPartitionType(rs.getString("SUBPARTITIONING_TYPE"));
                subPartition.setSubPartitionColumnNum(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                subPartition.setSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                partition.setTableGroupSubPartition(subPartition);
                if (StringUtils.isNotBlank(subPartition.getSubPartitionType())) {
                    tableGroup.setPartLevel(2);
                }
                tempTableGroupMap.putIfAbsent(tableGroup.getObjectName(), tableGroup);
            }
            return tempTableGroupMap;
        });
        if (MapUtils.isEmpty(tableGroupMap)) {
            log.warn("No tablegroup is found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        for (ObMySqlTableGroup tableGroup : tableGroupMap.values()) {
            if (tableGroup.getPartLevel() < 1) continue;
            this.queryTabGroupPartitionsV4(tableGroup);
            if (tableGroup.getPartLevel() != 2) continue;
            this.queryTabGroupSubPartitionsV4(tableGroup);
        }
        return tableGroupMap;
    }

    private void queryTabGroupPartitionsV3(ObMySqlTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupPartitions");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            TableGroupPartition partition = tableGroup.getTableGroupPartition();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(rs.getString("part_name"));
                item.setPartitionPosition(rs.getInt("part_id"));
                item.setHighValue(rs.getString(partition.getJdbcFieldName()));
                partition.getPartitionItems().add(item);
            }
            return null;
        });
    }

    private void queryTabGroupPartitionsV4(ObMySqlTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupPartitions");
        Object[] args = new Object[]{tableGroup.getObjectName()};
        this.jdbcTemplate.query(sql, args, rs -> {
            TableGroupPartition partition = tableGroup.getTableGroupPartition();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(rs.getString("PARTITION_NAME"));
                item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                item.setHighValue(rs.getString("HIGH_VALUE"));
                partition.getPartitionItems().add(item);
            }
            return null;
        });
    }

    private void queryTabGroupSubPartitionsV3(ObMySqlTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartitions");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
            Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
            while (rs.next()) {
                int partId = rs.getInt("part_id");
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(rs.getString("sub_part_name"));
                item.setPartitionPosition(partId);
                item.setHighValue(rs.getString(subPartition.getJdbcFieldName()));
                map.computeIfAbsent(partId, v -> new ArrayList()).add(item);
            }
            return null;
        });
    }

    private void queryTabGroupSubPartitionsV4(ObMySqlTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartitions");
        Object[] args = new Object[]{tableGroup.getObjectName()};
        this.jdbcTemplate.query(sql, args, rs -> {
            TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
            Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
            while (rs.next()) {
                int partId = rs.getInt("PARTITION_POSITION");
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(rs.getString("SUBPARTITION_NAME"));
                item.setPartitionPosition(partId);
                item.setHighValue(rs.getString("HIGH_VALUE"));
                map.computeIfAbsent(partId, v -> new ArrayList()).add(item);
            }
            return null;
        });
    }

    private void queryTabGroupSubPartTemplates(ObMySqlTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartTemplates");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionTemplate template = new ObOracleTablePartition.OracleTablePartitionTemplate();
                template.setSubPartitionName(rs.getString("sub_part_name"));
                template.setHighBound(rs.getString(subPartition.getJdbcFieldName()));
                subPartition.getSubPartitionTemplates().add(template);
            }
            return null;
        });
    }

    public Map<String, ObMySqlTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.BASE_TABLE.getName()};
        Map<String, ObMySqlTable> tableMap = this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObMySqlTable> tableMapping = new LinkedHashMap<String, ObMySqlTable>();
            while (rs.next()) {
                ObMySqlTable table = new ObMySqlTable((ObMySqlSchema)schema);
                table.setObjectName(rs.getString("TABLE_NAME"));
                table.setRowFormat(rs.getString("ROW_FORMAT"));
                table.setEngine(rs.getString("ENGINE"));
                table.setAutoIncrement(rs.getLong("AUTO_INCREMENT"));
                table.setCreateOptions(rs.getString("CREATE_OPTIONS"));
                table.setTableCollation(rs.getString("TABLE_COLLATION"));
                table.setTableComment(rs.getString("TABLE_COMMENT"));
                table.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                tableMapping.put(table.getObjectName(), table);
            }
            return tableMapping;
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables was found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        int thread = Math.min(this.configure.getInnerThread(), ExecutorTemplate.DEFAULT_POOL_SIZE);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(thread, thread, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100000), new NamedThreadFactory("schema-dumper-"));
        ExecutorTemplate<Object> template = new ExecutorTemplate<Object>(executor);
        Collection tables = tableMap.values();
        AtomicInteger total = new AtomicInteger(tables.size());
        for (ObMySqlTable table : tables) {
            template.submit(() -> {
                ObMySqlTablePartition partition;
                table.getColumnMapping().putAll(this.queryColumnMapping(table));
                table.setPrimaryKey(this.queryPrimaryKey(table));
                table.getUniqueMapping().putAll(this.queryUniqueMapping(table));
                table.getForeignMapping().putAll(this.queryForeignMapping(table));
                table.getIndexMapping().putAll(this.queryIndexMapping(table));
                if (DbType.OBMYSQL_323.isPriorFrom(this.getDbType())) {
                    table.getCheckMapping().putAll(this.queryCheckMapping(table));
                }
                if (schema.getGlobal().isWithExtra()) {
                    table.setTableGroupName(this.queryTableGroup(table));
                }
                if ((partition = this.queryTablePartition(table)) != null) {
                    partition.setColumnSet(table.getColumnMapping().keySet());
                    table.setTablePartition(partition);
                }
                total.decrementAndGet();
                log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total);
                return null;
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, ObMySqlColumn> queryColumnMapping(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        Map<String, ObMySqlColumn> columnMap = this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObMySqlSchema schema = (ObMySqlSchema)table.getSchema();
            LinkedHashMap<String, ObMySqlColumn> columnMapping = new LinkedHashMap<String, ObMySqlColumn>();
            while (rs.next()) {
                ObMySqlColumn column = new ObMySqlColumn(schema);
                column.setObjectName(table.getObjectName());
                column.setColumnName(rs.getString("COLUMN_NAME"));
                column.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                column.setCollationName(rs.getString("COLLATION_NAME"));
                column.setColumnComment(rs.getString("COLUMN_COMMENT"));
                column.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                column.setColumnDefault(rs.getString("COLUMN_DEFAULT"));
                column.setColumnType(rs.getString("COLUMN_TYPE"));
                column.setNullable(rs.getString("IS_NULLABLE"));
                column.setExtra(rs.getString("EXTRA"));
                column.setDataType(rs.getString("DATA_TYPE"));
                column.setNumericScale(rs.getInt("NUMERIC_SCALE"));
                column.setNumericPrecision(rs.getInt("NUMERIC_PRECISION"));
                column.setDateTimePrecision(rs.getInt("DATETIME_PRECISION"));
                column.setCharacterOctetLength(rs.getLong("CHARACTER_OCTET_LENGTH"));
                column.setCharacterMaximumLength(rs.getLong("CHARACTER_MAXIMUM_LENGTH"));
                if (DbType.OBMYSQL_40.isPriorFrom(this.getDbType())) {
                    column.setGenerationExpression(rs.getString("GENERATION_EXPRESSION"));
                }
                columnMapping.put(column.getColumnName(), column);
            }
            return columnMapping;
        });
        if (this.getDbType().isMySqlType() && !this.getDbType().isPrior(DbType.OBMYSQL_4100)) {
            this.fillingGeometryColumns(table, columnMap);
        }
        if (!this.sessionManager.isSupportSys() && this.isPrior40()) {
            log.warn("Column extra maybe lost. Such as: zerofill, on update current_timestamp and etc");
            return columnMap;
        }
        if (this.isPrior40()) {
            return this.fillingColumnExtra(table, columnMap);
        }
        return columnMap;
    }

    private void fillingGeometryColumns(AbstractTable table, Map<String, ObMySqlColumn> columnMapping) throws SQLException {
        String sql = this.sqlMapper.getSql("getGeometryColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        this.jdbcTemplate.query(sql, args, rs -> {
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                ObMySqlColumn column = (ObMySqlColumn)columnMapping.get(columnName);
                if (column == null) continue;
                column.setSrsName(rs.getString("SRS_NAME"));
                column.setSrsId(rs.getInt("SRS_ID"));
                column.setGeometryTypeName(rs.getString("GEOMETRY_TYPE_NAME"));
            }
            return null;
        });
    }

    private Map<String, ObMySqlColumn> fillingColumnExtra(AbstractTable table, Map<String, ObMySqlColumn> columnMapping) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumnExtras");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            while (rs.next()) {
                int columnFlags;
                ObMySqlColumn column = (ObMySqlColumn)columnMapping.get(rs.getString("column_name"));
                if (column == null) continue;
                column.setPrevColumnId(rs.getInt("prev_column_id"));
                column.setZerofill(rs.getInt("zero_fill") == 1);
                column.setOnUpdateCurrentTimestamp(rs.getInt("on_update_current_timestamp") == 1);
                if (DbType.OBMYSQL_2210.isSubsequent(this.getDbType()) && "BIT".equalsIgnoreCase(column.getDataType())) {
                    column.setBitDefaultVal(rs.getString("cur_default_value"));
                }
                if (((columnFlags = rs.getInt("column_flags")) & 1) == 0 && (columnFlags & 2) == 0) continue;
                String columnDefault = column.getColumnDefault();
                if (columnDefault == null) {
                    columnDefault = rs.getString("orig_default_value");
                }
                column.setColumnDefault(null);
                column.setGenerationExpression(columnDefault);
                if ((columnFlags & 2) != 0) {
                    column.setExtra("STORED GENERATED");
                    continue;
                }
                if ((columnFlags & 1) == 0) continue;
                column.setExtra("VIRTUAL GENERATED");
            }
            return null;
        });
        if (DbType.OBMYSQL_2210.isSubsequentFrom(this.getDbType())) {
            return columnMapping.entrySet().stream().sorted((e1, e2) -> {
                long prev = ((ObMySqlColumn)e1.getValue()).getOrdinalPosition() + (long)((ObMySqlColumn)e1.getValue()).getPrevColumnId();
                long next = ((ObMySqlColumn)e2.getValue()).getOrdinalPosition() + (long)((ObMySqlColumn)e2.getValue()).getPrevColumnId();
                return (int)(prev - next);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
        }
        return columnMapping;
    }

    @Override
    public ObMySqlTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        return this.isPrior40() ? this.queryTablePartitionV3(table) : this.queryTablePartitionV4(table);
    }

    public ObMySqlTablePartition queryTablePartitionV3(AbstractTable table) throws SQLException {
        if (!this.sessionManager.isSupportSys() && this.isPrior40()) {
            log.error("Table partition of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return null;
        }
        ObMySqlTablePartition partition = this.queryTablePartitions(table);
        if (partition != null && partition.isCompositePartitioned()) {
            if (super.getDbType().isPrior(DbType.OBMYSQL_2271)) {
                this.queryTableSubPartitions(partition, this.sqlMapper.getSql("getTabSubPartitions"));
            } else if (!partition.isSubPartTemplate()) {
                this.queryTableSubPartitions(partition, this.sqlMapper.getSql("getTabSubPartitions"));
            } else {
                this.queryTableSubPartitions(partition, this.sqlMapper.getSql("getTabSubPartTemplates"));
            }
        }
        return partition;
    }

    private ObMySqlTablePartition queryTablePartitions(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            ObMySqlTablePartition partition = null;
            while (rs.next()) {
                if (partition == null) {
                    partition = new ObMySqlTablePartition((ObMySqlSchema)table.getSchema());
                    partition.setObjectName(table.getObjectName());
                    partition.setPartLevel(rs.getInt("part_level"));
                    partition.setPartitionMethod(rs.getString("partition_method"));
                    partition.setPartitionExpression(rs.getString("part_func_expr"));
                    partition.setSubPartitionMethod(rs.getString("subpartition_method"));
                    partition.setSubPartitionExpression(rs.getString("sub_part_func_expr"));
                    partition.setPartNum(rs.getInt("part_num"));
                    partition.setSubPartNum(rs.getInt("sub_part_num"));
                    partition.setSubPartTemplate(rs.getInt("is_sub_part_template") == 1);
                }
                String partName = rs.getString("part_name");
                String partMethod = partition.getPartitionMethod();
                ObMySqlTablePartition.MySqlPartitionItem item = new ObMySqlTablePartition.MySqlPartitionItem();
                item.setPartitionName(partName);
                item.setPartitionOrdinalPosition(rs.getInt("part_id"));
                if ("LIST".equals(partMethod) || "LIST COLUMNS".equals(partMethod)) {
                    item.setPartitionDescription(rs.getString("list_val"));
                } else if ("RANGE".equals(partMethod) || "RANGE COLUMNS".equals(partMethod)) {
                    item.setPartitionDescription(rs.getString("high_bound_val"));
                }
                partition.getTablePartitions().add(item);
            }
            return partition;
        });
    }

    private ObMySqlTablePartition queryTablePartitionV4(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, rs -> {
            ObMySqlTablePartition partition = null;
            LinkedHashMap<String, List> subPartMap = new LinkedHashMap<String, List>();
            while (rs.next()) {
                if (partition == null) {
                    partition = new ObMySqlTablePartition((ObMySqlSchema)table.getSchema());
                    partition.setObjectName(table.getObjectName());
                    partition.setPartitionMethod(rs.getString("PARTITION_METHOD"));
                    partition.setPartitionExpression(rs.getString("PARTITION_EXPRESSION"));
                    partition.setSubPartTemplate(rs.getBoolean("IS_TEMPLATE"));
                    partition.setPartLevel(1);
                }
                String partName = rs.getString("PARTITION_NAME");
                ObMySqlTablePartition.MySqlPartitionItem partItem = new ObMySqlTablePartition.MySqlPartitionItem();
                partItem.setPartitionName(partName);
                partItem.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                partItem.setPartitionComment(rs.getString("PARTITION_COMMENT"));
                partItem.setPartitionDescription(rs.getString("PARTITION_DESCRIPTION"));
                partItem.setPartitionOrdinalPosition(rs.getInt("PARTITION_ORDINAL_POSITION"));
                partition.getTablePartitions().add(partItem);
                String subPartitionName = rs.getString("SUBPARTITION_NAME");
                if (StringUtils.isNotBlank(subPartitionName)) {
                    partition.setPartLevel(2);
                    partition.setSubPartitionMethod(rs.getString("SUBPARTITION_METHOD"));
                    partition.setSubPartitionExpression(rs.getString("SUBPARTITION_EXPRESSION"));
                    List subPartItems = subPartMap.getOrDefault(String.valueOf(partItem.getPartitionOrdinalPosition()), new ArrayList());
                    ObMySqlTablePartition.MySqlPartitionItem subPartItem = new ObMySqlTablePartition.MySqlPartitionItem();
                    subPartItem.setSubPartitionName(subPartitionName);
                    subPartItem.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    subPartItem.setPartitionComment(rs.getString("PARTITION_COMMENT"));
                    subPartItem.setSubPartitionOrdinalPosition(rs.getInt("SUBPARTITION_ORDINAL_POSITION"));
                    subPartItem.setPartitionDescription(rs.getString("HIGH_VALUE"));
                    subPartItems.add(subPartItem);
                    subPartMap.putIfAbsent(String.valueOf(partItem.getPartitionOrdinalPosition()), subPartItems);
                }
                partition.getTableSubPartitionMapping().putAll(subPartMap);
            }
            return partition;
        });
    }

    private void queryTableSubPartitions(ObMySqlTablePartition partition, String sql) throws SQLException {
        String subPartMethod = partition.getSubPartitionMethod();
        Object[] args = new Object[]{this.getSchemaName(), partition.getObjectName()};
        this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            Map<String, List<ObMySqlTablePartition.MySqlPartitionItem>> subPartMap = partition.getTableSubPartitionMapping();
            while (rs.next()) {
                ObMySqlTablePartition.MySqlPartitionItem item = new ObMySqlTablePartition.MySqlPartitionItem();
                item.setSubPartitionName(rs.getString("sub_part_name"));
                item.setPartitionOrdinalPosition(rs.getInt("part_id"));
                item.setSubPartitionOrdinalPosition(rs.getInt("sub_part_id"));
                if ("LIST".equals(subPartMethod) || "LIST COLUMNS".equals(subPartMethod)) {
                    item.setPartitionDescription(rs.getString("list_val"));
                } else if ("RANGE".equals(subPartMethod) || "RANGE COLUMNS".equals(subPartMethod)) {
                    item.setPartitionDescription(rs.getString("high_bound_val"));
                }
                String partId = String.valueOf(item.getPartitionOrdinalPosition());
                subPartMap.computeIfAbsent(partId, v -> new ArrayList()).add(item);
            }
            return null;
        });
    }

    @Override
    public ObMySqlPrimaryKey queryPrimaryKey(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), ObjectType.PRIMARY.getName()};
        return this.jdbcTemplate.query(sql, args, rs -> {
            AbstractConstraint primary = null;
            ObMySqlSchema schema = (ObMySqlSchema)table.getSchema();
            while (rs.next()) {
                if (primary == null) {
                    primary = new ObMySqlPrimaryKey(schema);
                    primary.setObjectName(table.getObjectName());
                    primary.setConstraintName(rs.getString("CONSTRAINT_NAME"));
                    ((AbstractObMySqlConstraint)primary).setIndexComment(rs.getString("INDEX_COMMENT"));
                }
                primary.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION")));
            }
            return primary;
        });
    }

    public Map<String, ObMySqlUniqueKey> queryUniqueMapping(AbstractTable table) throws SQLException {
        Map<String, String> indexPartitionMap;
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), ObjectType.UNIQUE.getName()};
        Map<String, ObMySqlUniqueKey> uniqueMapping = this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObMySqlSchema schema = (ObMySqlSchema)table.getSchema();
            LinkedHashMap<String, ObMySqlUniqueKey> tempUniqueMapping = new LinkedHashMap<String, ObMySqlUniqueKey>();
            while (rs.next()) {
                String constName = rs.getString("CONSTRAINT_NAME");
                ObMySqlUniqueKey unique = tempUniqueMapping.getOrDefault(constName, new ObMySqlUniqueKey(schema));
                if (!tempUniqueMapping.containsKey(constName)) {
                    unique.setConstraintName(constName);
                    unique.setObjectName(table.getObjectName());
                    unique.setIndexComment(rs.getString("INDEX_COMMENT"));
                    tempUniqueMapping.put(unique.getConstraintName(), unique);
                }
                unique.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("ORDINAL_POSITION"), rs.getString("SUB_PART"), "ASC"));
            }
            return tempUniqueMapping;
        });
        if (!this.sessionManager.isSupportSys() && this.isPrior40()) {
            log.warn("Index partition of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return uniqueMapping;
        }
        if (this.isPrior40() && MapUtils.isNotEmpty(indexPartitionMap = this.queryIndexPartitions(table.getObjectName()))) {
            for (Map.Entry<String, String> entry : indexPartitionMap.entrySet()) {
                ObMySqlUniqueKey unique = uniqueMapping.get(entry.getKey());
                if (unique == null) continue;
                unique.setIndexType(entry.getValue());
            }
        }
        return uniqueMapping;
    }

    protected Map<String, ObMySqlCheck> queryCheckMapping(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObMySqlSchema schema = (ObMySqlSchema)table.getSchema();
            LinkedHashMap<String, ObMySqlCheck> checkMapping = new LinkedHashMap<String, ObMySqlCheck>();
            while (rs.next()) {
                String constName = rs.getString("CONSTRAINT_NAME");
                ObMySqlCheck check = checkMapping.getOrDefault(constName, new ObMySqlCheck(schema));
                check.setObjectName(table.getObjectName());
                check.setConstraintName(constName);
                check.setCheckClause(rs.getString("CHECK_CLAUSE"));
                checkMapping.put(check.getConstraintName(), check);
            }
            return checkMapping;
        });
    }

    public String queryTableGroup(AbstractTable table) throws SQLException {
        return this.isPrior40() ? this.queryTableGroupV3(table) : this.queryTableGroupV4(table);
    }

    public String queryTableGroupV3(AbstractTable table) throws SQLException {
        if (!this.sessionManager.isSupportSys()) {
            log.warn("Tablegroup of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return "";
        }
        String sql = this.sqlMapper.getSql("getTableGroup");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryFromSysTable(sql, args, rs -> rs.next() ? rs.getString("TABLEGROUP_NAME") : "");
    }

    public String queryTableGroupV4(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTableGroup");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, rs -> rs.next() ? rs.getString("TABLEGROUP_NAME") : "");
    }

    public Map<String, ObMySqlIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        return this.isPrior40() ? this.queryIndexMappingV3(table) : this.queryIndexMappingV4(table);
    }

    public Map<String, ObMySqlIndex> queryIndexes(AbstractTable table) throws SQLException {
        Map<String, String> indexPartitionMap;
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        Map<String, ObMySqlIndex> indexMapping = this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObMySqlSchema schema = (ObMySqlSchema)table.getSchema();
            LinkedHashMap<String, ObMySqlIndex> tempIndexMapping = new LinkedHashMap<String, ObMySqlIndex>();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                ObMySqlIndex index = tempIndexMapping.getOrDefault(indexName, new ObMySqlIndex(schema));
                if (!tempIndexMapping.containsKey(indexName)) {
                    index.setIndexName(indexName);
                    index.setObjectName(table.getObjectName());
                    index.setIndexSchema(rs.getString("INDEX_SCHEMA"));
                    index.setNonunique(rs.getInt("NON_UNIQUE"));
                    index.setIndexType(rs.getString("INDEX_TYPE"));
                    index.setIndexComment(rs.getString("INDEX_COMMENT"));
                    index.setVisible(rs.getString("IS_VISIBLE"));
                    tempIndexMapping.put(index.getIndexName(), index);
                }
                index.getIndexColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("SEQ_IN_INDEX"), rs.getString("SUB_PART"), rs.getString("COLLATION")));
            }
            return tempIndexMapping;
        });
        if (!this.sessionManager.isSupportSys() && this.isPrior40()) {
            log.warn("Index partition of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return indexMapping;
        }
        if (this.isPrior40() && MapUtils.isNotEmpty(indexPartitionMap = this.queryIndexPartitions(table.getObjectName()))) {
            for (Map.Entry<String, String> entry : indexPartitionMap.entrySet()) {
                ObMySqlIndex index = indexMapping.get(entry.getKey());
                if (index == null) continue;
                index.setIndexType(entry.getValue());
            }
        }
        return indexMapping;
    }

    private Map<String, ObMySqlIndex> queryIndexMappingV3(AbstractTable table) throws SQLException {
        Map<String, ObMySqlIndex> indexMapping = this.queryIndexes(table);
        if (!this.sessionManager.isSupportSys()) {
            log.warn("Index partition of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return indexMapping;
        }
        Map<String, String> indexPartitionMap = this.queryIndexPartitions(table.getObjectName());
        if (MapUtils.isNotEmpty(indexPartitionMap)) {
            for (Map.Entry<String, String> entry : indexPartitionMap.entrySet()) {
                ObMySqlIndex index = indexMapping.get(entry.getKey());
                if (index == null) continue;
                index.setIndexType(entry.getValue());
            }
        }
        return indexMapping;
    }

    public Map<String, ObMySqlIndex> queryIndexMappingV4(AbstractTable table) throws SQLException {
        Map<String, ObMySqlIndex> indexMapping = this.queryIndexes(table);
        Map<String, ObMySqlIndexPartition> indexPartitionMapping = this.queryPartIndexMap(table);
        for (Map.Entry<String, ObMySqlIndexPartition> entry : indexPartitionMapping.entrySet()) {
            ObMySqlIndex index;
            String indexName = entry.getKey();
            ObMySqlIndexPartition indexPartition = entry.getValue();
            if ("GLOBAL".equals(indexPartition.getLocality())) {
                String subPartitioningType;
                indexPartition.getIndexPartitions().addAll(this.queryIndPartitions(indexName));
                Integer partitioningKeyCount = indexPartition.getPartitioningKeyCount();
                if (partitioningKeyCount != null && partitioningKeyCount > 0) {
                    indexPartition.getIndexPartitionColumns().addAll(this.queryIndPartKeyColumns(indexName));
                }
                if ((subPartitioningType = indexPartition.getSubPartitioningType()) != null && !"NONE".equals(subPartitioningType)) {
                    indexPartition.getIndexSubPartitionMapping().putAll(this.queryIndSubPartitionMapping(indexName));
                    Integer subPartitioningKeyCountInteger = indexPartition.getSubPartitioningKeyCount();
                    if (subPartitioningKeyCountInteger != null && subPartitioningKeyCountInteger > 0) {
                        indexPartition.getIndexSubPartitionColumns().addAll(this.queryIndSubPartKeyColumns(indexName));
                    }
                }
            }
            if ((index = indexMapping.get(indexName)) == null) continue;
            index.setIndexPartition(indexPartition);
        }
        return indexMapping;
    }

    private Map<String, String> queryIndexPartitions(String tableName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartitions");
        Object[] args = new Object[]{this.getSchemaName(), tableName};
        return this.jdbcTemplate.queryMapFromSysTable(sql, args, rs -> {
            HashMap<String, String> indexPartitionMap = new HashMap<String, String>(16);
            while (rs.next()) {
                String indexName = rs.getString("index_name");
                indexName = indexName.substring("__idx_".length());
                indexName = indexName.substring(indexName.indexOf(95) + 1);
                indexPartitionMap.putIfAbsent(indexName, rs.getString("index_type"));
            }
            return indexPartitionMap;
        });
    }

    private Map<String, ObMySqlIndexPartition> queryPartIndexMap(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObMySqlSchema schema = (ObMySqlSchema)table.getSchema();
            LinkedHashMap<String, ObMySqlIndexPartition> partIndexMapping = new LinkedHashMap<String, ObMySqlIndexPartition>();
            while (rs.next()) {
                ObMySqlIndexPartition partition = new ObMySqlIndexPartition(schema);
                partition.setObjectName(table.getObjectName());
                partition.setPartitioningType(rs.getString("PARTITIONING_TYPE"));
                partition.setSubPartitioningType(rs.getString("SUBPARTITIONING_TYPE"));
                partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                partition.setDefSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                partition.setPartitioningKeyCount(rs.getInt("PARTITIONING_KEY_COUNT"));
                partition.setSubPartitioningKeyCount(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                partition.setLocality(rs.getString("LOCALITY"));
                partition.setAlignment(rs.getString("ALIGNMENT"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    partition.setDefTablespaceName(rs.getString("DEF_TABLESPACE_NAME"));
                }
                partIndexMapping.put(rs.getString("INDEX_NAME"), partition);
            }
            return partIndexMapping;
        });
    }

    private List<AbstractIndexPartition.IndexPartitionItem> queryIndPartitions(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartitions");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryList(sql, args, rs -> {
            ArrayList<AbstractIndexPartition.IndexPartitionItem> items = new ArrayList<AbstractIndexPartition.IndexPartitionItem>();
            while (rs.next()) {
                AbstractIndexPartition.IndexPartitionItem item = new AbstractIndexPartition.IndexPartitionItem();
                item.setLogging(rs.getString("LOGGING"));
                item.setInterval(rs.getString("INTERVAL"));
                item.setComposite(rs.getString("COMPOSITE"));
                item.setHighValue(rs.getString("HIGH_VALUE"));
                item.setParameters(rs.getString("PARAMETERS"));
                item.setCompression(rs.getString("COMPRESSION"));
                item.setPartitionName(rs.getString("PARTITION_NAME"));
                item.setDomidxOpstatus(rs.getString("DOMIDX_OPSTATUS"));
                item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                item.setSubPartitionCount(rs.getInt("SUBPARTITION_COUNT"));
                item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                }
                items.add(item);
            }
            return items;
        });
    }

    private List<AbstractIndexPartition.IndexPartitionColumn> queryIndPartKeyColumns(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryList(sql, args, rs -> {
            ArrayList<AbstractIndexPartition.IndexPartitionColumn> columns = new ArrayList<AbstractIndexPartition.IndexPartitionColumn>();
            while (rs.next()) {
                AbstractIndexPartition.IndexPartitionColumn column = new AbstractIndexPartition.IndexPartitionColumn();
                column.setName(indexName);
                column.setColumnName(rs.getString("COLUMN_NAME"));
                column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                columns.add(column);
            }
            return columns;
        });
    }

    private Map<String, List<AbstractIndexPartition.IndexPartitionItem>> queryIndSubPartitionMapping(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartitions");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, List> subPartMapping = new LinkedHashMap<String, List>();
            while (rs.next()) {
                String partName = rs.getString("PARTITION_NAME");
                AbstractIndexPartition.IndexPartitionItem item = new AbstractIndexPartition.IndexPartitionItem();
                item.setPartitionName(partName);
                item.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                item.setHighValue(rs.getString("HIGH_VALUE"));
                item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                item.setSubPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                item.setLogging(rs.getString("LOGGING"));
                item.setCompression(rs.getString("COMPRESSION"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                }
                subPartMapping.computeIfAbsent(partName, v -> new ArrayList()).add(item);
            }
            return subPartMapping;
        });
    }

    private List<AbstractIndexPartition.IndexPartitionColumn> queryIndSubPartKeyColumns(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        return this.jdbcTemplate.queryList(sql, args, rs -> {
            ArrayList<AbstractIndexPartition.IndexPartitionColumn> columns = new ArrayList<AbstractIndexPartition.IndexPartitionColumn>();
            while (rs.next()) {
                AbstractIndexPartition.IndexPartitionColumn column = new AbstractIndexPartition.IndexPartitionColumn();
                column.setName(indexName);
                column.setColumnName(rs.getString("COLUNM_NAME"));
                column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                columns.add(column);
            }
            return columns;
        });
    }

    public Map<String, ObMySqlView> queryViewMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObMySqlView> viewMap = new LinkedHashMap<String, ObMySqlView>();
            while (rs.next()) {
                ObMySqlView view = new ObMySqlView((ObMySqlSchema)schema);
                view.setObjectName(rs.getString("TABLE_NAME"));
                view.setCheckOption(rs.getString("CHECK_OPTION"));
                view.setText(rs.getString("VIEW_DEFINITION"));
                viewMap.put(view.getObjectName(), view);
            }
            return viewMap;
        });
    }

    public Map<String, ObMySqlForeignKey> queryForeignMapping(AbstractTable table) throws SQLException {
        if (!this.sessionManager.isSupportSys() && this.isPrior40()) {
            log.error("Foreign keys of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return Maps.newLinkedHashMap();
        }
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        ResultMapHandler handler = rs -> {
            ObMySqlSchema schema = (ObMySqlSchema)table.getSchema();
            LinkedHashMap<String, ObMySqlForeignKey> foreignMap = new LinkedHashMap<String, ObMySqlForeignKey>();
            int index = 0;
            while (rs.next()) {
                int pos;
                String constName = rs.getString("CONSTRAINT_NAME");
                ObMySqlForeignKey foreign = foreignMap.getOrDefault(constName, new ObMySqlForeignKey(schema));
                if (!foreignMap.containsKey(constName)) {
                    foreign.setConstraintName(constName);
                    foreign.setObjectName(table.getObjectName());
                    foreign.setDeleteRule(rs.getString("DELETE_RULE"));
                    foreign.setUpdateRule(rs.getString("UPDATE_RULE"));
                    foreign.setRefTableOwner(rs.getString("REFERENCED_TABLE_SCHEMA"));
                    foreign.setRefTableName(rs.getString("REFERENCED_TABLE_NAME"));
                    foreignMap.put(foreign.getConstraintName(), foreign);
                }
                if ((pos = rs.getInt("ORDINAL_POSITION")) == -1) {
                    pos = index++;
                }
                foreign.getForeignColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), pos));
                foreign.getReferencedColumns().add(new KeyColumn(rs.getString("REFERENCED_COLUMN_NAME"), pos));
            }
            return foreignMap;
        };
        if (this.isPrior40()) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    public Map<String, ObMySqlFunction> queryFunctionMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.FUNCTION, this.sqlMapper.getSql("getRoutines"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.FUNCTION.name()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObMySqlFunction> functionMap = new LinkedHashMap<String, ObMySqlFunction>();
            LinkedHashMap<String, ObMySqlRoutine> routineMap = new LinkedHashMap<String, ObMySqlRoutine>();
            while (rs.next()) {
                String routineName = rs.getString("ROUTINE_NAME");
                ObMySqlRoutine routine = routineMap.getOrDefault(routineName, new ObMySqlRoutine());
                routine.setRoutineName(routineName);
                routine.setRoutineType(rs.getString("ROUTINE_TYPE"));
                routine.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                routine.setCollationName(rs.getString("COLLATION_NAME"));
                routine.setRoutineDefinition(rs.getString("ROUTINE_DEFINITION"));
                routine.setIsDeterministic(rs.getString("IS_DETERMINISTIC"));
                routine.setSecurityType(rs.getString("SECURITY_TYPE"));
                routine.setDefiner(rs.getString("DEFINER"));
                routine.setComment(rs.getString("ROUTINE_COMMENT"));
                ObMySqlRoutine.RoutineParam routineParam = new ObMySqlRoutine.RoutineParam();
                String parameterName = rs.getString("PARAMETER_NAME");
                if (StringUtils.isBlank(parameterName)) {
                    routine.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                } else {
                    routineParam.setParameterName(rs.getString("PARAMETER_NAME"));
                    routineParam.setParameterMode(rs.getString("PARAMETER_MODE"));
                    routineParam.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                    routine.getParameters().add(routineParam);
                }
                routineMap.put(routineName, routine);
            }
            for (ObMySqlRoutine routine : routineMap.values()) {
                ObMySqlFunction function = new ObMySqlFunction((ObMySqlSchema)schema, routine);
                function.setObjectName(routine.getRoutineName());
                functionMap.put(function.getObjectName(), function);
            }
            return functionMap;
        });
    }

    public Map<String, ObMySqlProcedure> queryProcedureMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PROCEDURE, this.sqlMapper.getSql("getRoutines"));
        Object[] args = new Object[]{this.getSchemaName(), ObjectType.PROCEDURE.name()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObMySqlProcedure> procedureMap = new LinkedHashMap<String, ObMySqlProcedure>();
            LinkedHashMap<String, ObMySqlRoutine> routineMap = new LinkedHashMap<String, ObMySqlRoutine>();
            while (rs.next()) {
                String routineName = rs.getString("ROUTINE_NAME");
                ObMySqlRoutine routine = routineMap.getOrDefault(routineName, new ObMySqlRoutine());
                routine.setRoutineName(routineName);
                routine.setRoutineType(rs.getString("ROUTINE_TYPE"));
                routine.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                routine.setCollationName(rs.getString("COLLATION_NAME"));
                routine.setRoutineDefinition(rs.getString("ROUTINE_DEFINITION"));
                routine.setIsDeterministic(rs.getString("IS_DETERMINISTIC"));
                routine.setSecurityType(rs.getString("SECURITY_TYPE"));
                routine.setDefiner(rs.getString("DEFINER"));
                routine.setComment(rs.getString("ROUTINE_COMMENT"));
                ObMySqlRoutine.RoutineParam routineParam = new ObMySqlRoutine.RoutineParam();
                String parameterName = rs.getString("PARAMETER_NAME");
                if (StringUtils.isBlank(parameterName)) {
                    routine.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                } else {
                    routineParam.setParameterName(rs.getString("PARAMETER_NAME"));
                    routineParam.setParameterMode(rs.getString("PARAMETER_MODE"));
                    routineParam.setDtdIdentifier(rs.getString("PARAM_IDENTIFIER"));
                    routine.getParameters().add(routineParam);
                }
                routineMap.put(routineName, routine);
            }
            for (ObMySqlRoutine routine : routineMap.values()) {
                ObMySqlProcedure procedure = new ObMySqlProcedure((ObMySqlSchema)schema, routine);
                procedure.setObjectName(routine.getRoutineName());
                procedureMap.put(procedure.getObjectName(), procedure);
            }
            return procedureMap;
        });
    }

    public Map<String, ObMySqlSequence> querySequenceMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.SEQUENCE, this.sqlMapper.getSql("getSequences"));
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObMySqlSequence> sequenceMap = new LinkedHashMap<String, ObMySqlSequence>();
            while (rs.next()) {
                ObMySqlSequence sequence = new ObMySqlSequence((ObMySqlSchema)schema);
                sequence.setObjectName(rs.getString("sequence_name"));
                sequence.setMinValue(rs.getBigDecimal("min_value"));
                sequence.setMaxValue(rs.getBigDecimal("max_value"));
                sequence.setIncrement(rs.getBigDecimal("increment_by"));
                sequence.setCycle(rs.getString("cycle_flag"));
                sequence.setOrder(rs.getString("order_flag"));
                sequence.setCache(rs.getBigDecimal("cache_size"));
                sequence.setStart(rs.getBigDecimal("start_with"));
                sequenceMap.put(sequence.getObjectName(), sequence);
            }
            return sequenceMap;
        });
    }

    private boolean isPrior40() {
        return this.getDbType().isMySqlType() && this.getDbType().isPrior(DbType.OBMYSQL_40);
    }
}

