/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.accessor;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.common.constants.SqlConst;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.concurrent.NamedThreadFactory;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.jdbc.ResultHandler;
import com.oceanbase.tools.loaddump.jdbc.ResultMapHandler;
import com.oceanbase.tools.loaddump.jdbc.ResultsHandler;
import com.oceanbase.tools.loaddump.schema.AbstractConstraint;
import com.oceanbase.tools.loaddump.schema.AbstractIndexPartition;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.AbstractTable;
import com.oceanbase.tools.loaddump.schema.TableGroupPartition;
import com.oceanbase.tools.loaddump.schema.TableGroupSubPartition;
import com.oceanbase.tools.loaddump.schema.accessor.AbstractMetadataAccessor;
import com.oceanbase.tools.loaddump.schema.base.KeyColumn;
import com.oceanbase.tools.loaddump.schema.oboracle.AbstractObOracleConstraint;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleCheck;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleColumn;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleDatabase;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleDependency;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleForeignKey;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleFunction;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleIndex;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleIndexPartition;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOraclePackage;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOraclePackageBody;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOraclePrimaryKey;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleProcedure;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSchema;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSequence;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleSynonym;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTable;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTableGroup;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTablePartition;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTablespace;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTrigger;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleType;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleTypeBody;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleUniqueKey;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleView;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleMetadataAccessor
extends AbstractMetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(ObOracleMetadataAccessor.class);

    public ObOracleMetadataAccessor(Configure configure) {
        super(configure);
    }

    @Override
    public ObOracleDatabase queryMetadata() throws SQLException {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        ObOracleSchema schema = this.querySchema();
        ObOracleDatabase database = new ObOracleDatabase(schema);
        if (schema == null) {
            log.error("Schema: {} was not found", (Object)this.getSchemaName());
            return database;
        }
        stopwatch.reset().start();
        database.getDependencies().addAll(this.queryDependencies(schema));
        super.checkReference(database);
        log.info("Query {} dependencies elapsed {}", (Object)database.getDependencies().size(), (Object)stopwatch);
        if (DbType.OBORACLE_22.isPrior(this.getDbType()) && this.isChecked(ObjectType.TABLESPACE)) {
            stopwatch.reset().start();
            database.getTablespaceMapping().putAll(this.queryTablespaceMapping(schema));
            log.info("Query {} tablespaces elapsed {}", (Object)database.getTablespaceMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE_GROUP)) {
            stopwatch.reset().start();
            database.getTableGroupMapping().putAll(this.queryTableGroupMapping(schema));
            log.info("Query {} tablegroups elapsed {}", (Object)database.getTableGroupMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.TABLE)) {
            stopwatch.reset().start();
            database.getTableMapping().putAll(this.queryTableMapping(schema));
            log.info("Query {} tables elapsed {}", (Object)database.getTableMapping().size(), (Object)stopwatch);
        }
        if (this.isChecked(ObjectType.VIEW)) {
            stopwatch.reset().start();
            database.getViewMapping().putAll(this.queryViewMapping(schema));
            log.info("Query {} views elapsed {}", (Object)database.getViewMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && (this.isChecked(ObjectType.SYNONYM) || this.isChecked(ObjectType.PUBLIC_SYNONYM))) {
            stopwatch.reset().start();
            database.getSynonymMapping().putAll(this.querySynonymMapping(schema));
            log.info("Query {} synonyms elapsed {}", (Object)database.getSynonymMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && this.isChecked(ObjectType.SEQUENCE)) {
            stopwatch.reset().start();
            database.getSequenceMapping().putAll(this.querySequenceMapping(schema));
            log.info("Query {} sequences elapsed {}", (Object)database.getSequenceMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && this.isChecked(ObjectType.TRIGGER)) {
            stopwatch.reset().start();
            database.getTriggerMapping().putAll(this.queryTriggerMapping(schema));
            log.info("Query {} triggers elapsed {}", (Object)database.getTriggerMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && this.isChecked(ObjectType.FUNCTION)) {
            stopwatch.reset().start();
            database.getFunctionMapping().putAll(this.queryFunctionMapping(schema));
            log.info("Query {} functions elapsed {}", (Object)database.getFunctionMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2220.isPrior(this.getDbType()) && this.isChecked(ObjectType.PROCEDURE)) {
            stopwatch.reset().start();
            database.getProcedureMapping().putAll(this.queryProcedureMapping(schema));
            log.info("Query {} procedures elapsed {}", (Object)database.getProcedureMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2250.isPrior(this.getDbType()) && this.isChecked(ObjectType.TYPE)) {
            stopwatch.reset().start();
            database.getTypeMapping().putAll(this.queryTypeMappingByGetDdl(schema));
            log.info("Query {} types elapsed {}", (Object)database.getTypeMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2250.isPrior(this.getDbType()) && this.isChecked(ObjectType.PACKAGE)) {
            stopwatch.reset().start();
            database.getPackageMapping().putAll(this.queryPackageMapping(schema));
            log.info("Query {} packages elapsed {}", (Object)database.getPackageMapping().size(), (Object)stopwatch);
        }
        if (DbType.OBORACLE_2250.isPrior(this.getDbType()) && this.isChecked(ObjectType.PACKAGE_BODY)) {
            stopwatch.reset().start();
            database.getPackageBodyMapping().putAll(this.queryPackageBodyMapping(schema));
            log.info("Query {} package bodies elapsed {}", (Object)database.getPackageBodyMapping().size(), (Object)stopwatch);
        }
        return database;
    }

    @Override
    public ObOracleSchema querySchema() {
        return new ObOracleSchema(this.getGlobal(), this.getDbType(), this.getSchemaName());
    }

    public Collection<ObOracleDependency> queryDependencies(AbstractSchema schema) throws SQLException {
        return super.getDbType().isPrior(DbType.OBORACLE_40) ? this.queryDependenciesV3(schema) : this.queryDependenciesV4(schema);
    }

    public Collection<ObOracleDependency> queryDependenciesV3(AbstractSchema schema) throws SQLException {
        if (!this.sessionManager.isSupportSys()) {
            log.warn("cannot fetch dependencies, skip topology check");
            return Lists.newArrayList();
        }
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName()};
        return this.jdbcTemplate.queryListFromSysTable(sql, args, rs -> {
            ObOracleSchema target = (ObOracleSchema)schema;
            ArrayList<ObOracleDependency> dependencies = new ArrayList<ObOracleDependency>();
            while (rs.next()) {
                ObOracleDependency dependency = new ObOracleDependency(target);
                dependency.setObjType(rs.getString("OBJ_TYPE"));
                dependency.setObjName(rs.getString("OBJ_NAME"));
                dependency.setDepType(rs.getString("DEP_TYPE"));
                dependency.setRefObjType(rs.getString("REF_TYPE"));
                dependency.setRefObjName(rs.getString("REF_NAME"));
                dependency.setRefObjOwner(rs.getString("REF_OWNER"));
                dependency.setRefLinkName(rs.getString("REF_LINK_NAME"));
                if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                    log.warn("ObjType: " + dependency.getObjType() + " RefObjType: " + dependency.getRefObjType());
                    continue;
                }
                dependencies.add(dependency);
            }
            return dependencies;
        });
    }

    public List<ObOracleDependency> queryDependenciesV4(AbstractSchema schema) throws SQLException {
        String sql = this.sqlMapper.getSql("getDependencies");
        Object[] args = new Object[]{this.getSchemaName(), this.getSchemaName()};
        return this.jdbcTemplate.queryList(sql, args, rs -> {
            ObOracleSchema target = (ObOracleSchema)schema;
            ArrayList<ObOracleDependency> dependencies = new ArrayList<ObOracleDependency>();
            while (rs.next()) {
                ObOracleDependency dependency = new ObOracleDependency(target);
                dependency.setObjType(rs.getString("OBJ_TYPE"));
                dependency.setObjName(rs.getString("OBJ_NAME"));
                dependency.setDepType(rs.getString("DEP_TYPE"));
                dependency.setRefObjType(rs.getString("REF_TYPE"));
                dependency.setRefObjName(rs.getString("REF_NAME"));
                dependency.setRefObjOwner(rs.getString("REF_OWNER"));
                dependency.setRefLinkName(rs.getString("REF_LINK_NAME"));
                if (dependency.getObjType() == null || dependency.getRefObjType() == null) {
                    log.warn("ObjType: " + dependency.getObjType() + " RefObjType: " + dependency.getRefObjType());
                    continue;
                }
                dependencies.add(dependency);
            }
            return dependencies;
        });
    }

    public Map<String, ObOracleTablespace> queryTablespaceMapping(AbstractSchema schema) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTablespaces");
        return this.jdbcTemplate.queryMap(sql, null, rs -> {
            LinkedHashMap<String, ObOracleTablespace> tablespaceMap = new LinkedHashMap<String, ObOracleTablespace>();
            while (rs.next()) {
                ObOracleTablespace tablespace = new ObOracleTablespace((ObOracleSchema)schema);
                tablespace.setObjectName(rs.getString("TABLESPACE_NAME"));
                tablespaceMap.put(tablespace.getObjectName(), tablespace);
            }
            return tablespaceMap;
        });
    }

    public Map<String, ObOracleTableGroup> queryTableGroupMapping(AbstractSchema schema) throws SQLException {
        return super.getDbType().isPrior(DbType.OBORACLE_40) ? this.queryTableGroupMappingV3(schema) : this.queryTableGroupMappingV4(schema);
    }

    public Map<String, ObOracleTableGroup> queryTableGroupMappingV3(AbstractSchema schema) throws SQLException {
        if (!this.sessionManager.isSupportSys()) {
            log.warn("The tablegroups of schema: {} maybe lost", (Object)schema.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        boolean isPrevious227 = !DbType.OBORACLE_2271.isPrior(this.getDbType());
        String sql = this.bindings(ObjectType.TABLE_GROUP, this.getSqlMapper().getSql("getTableGroups"));
        Map<String, ObOracleTableGroup> tableGroupMap = this.jdbcTemplate.queryMapFromSysTable(sql, null, rs -> {
            LinkedHashMap<String, ObOracleTableGroup> tempTableGroupMap = new LinkedHashMap<String, ObOracleTableGroup>();
            while (rs.next()) {
                ObOracleTableGroup tableGroup = new ObOracleTableGroup((ObOracleSchema)schema);
                tableGroup.setObjectName(rs.getString("tablegroup_name"));
                tableGroup.setLocality(rs.getString("locality"));
                tableGroup.setPrimaryZone(rs.getString("primary_zone"));
                tableGroup.setBinding(rs.getString("binding"));
                tableGroup.setComment(rs.getString("comment"));
                tableGroup.setIsSubPartTemplate(isPrevious227 ? 1 : rs.getInt("is_sub_part_template"));
                tableGroup.setPartLevel(rs.getInt("part_level"));
                tableGroup.setTableGroupId(rs.getLong("tablegroup_id"));
                TableGroupPartition groupPartition = new TableGroupPartition(schema);
                groupPartition.setPartitionType(rs.getString("part_func_type"));
                groupPartition.setPartitionColumnNum(rs.getInt("part_func_expr_num"));
                groupPartition.setPartitionCount(rs.getInt("part_num"));
                tableGroup.setTableGroupPartition(groupPartition);
                TableGroupSubPartition groupSubPartition = new TableGroupSubPartition(schema);
                groupSubPartition.setSubPartitionType(rs.getString("sub_part_func_type"));
                groupSubPartition.setSubPartitionCount(rs.getInt("sub_part_num"));
                groupSubPartition.setSubPartitionColumnNum(rs.getInt("sub_part_func_expr_num"));
                groupPartition.setTableGroupSubPartition(groupSubPartition);
                tempTableGroupMap.putIfAbsent(tableGroup.getObjectName(), tableGroup);
            }
            return tempTableGroupMap;
        });
        if (MapUtils.isEmpty(tableGroupMap)) {
            log.warn("No tablegroups was found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        for (ObOracleTableGroup tableGroup : tableGroupMap.values()) {
            if (tableGroup.getPartLevel() < 1) continue;
            this.queryTabGroupPartitionsV3(tableGroup);
            if (tableGroup.getPartLevel() != 2) continue;
            if (tableGroup.getIsSubPartTemplate() == 0) {
                this.queryTabGroupSubPartitionsV3(tableGroup);
                continue;
            }
            this.queryTabGroupSubPartTemplates(tableGroup);
        }
        return tableGroupMap;
    }

    private Map<String, ObOracleTableGroup> queryTableGroupMappingV4(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE_GROUP, this.getSqlMapper().getSql("getTableGroups"));
        Map<String, ObOracleTableGroup> tableGroupMap = this.jdbcTemplate.queryMap(sql, null, rs -> {
            LinkedHashMap<String, ObOracleTableGroup> tempTableGroupMap = new LinkedHashMap<String, ObOracleTableGroup>();
            while (rs.next()) {
                ObOracleTableGroup tableGroup = new ObOracleTableGroup((ObOracleSchema)schema);
                tableGroup.setObjectName(rs.getString("TABLEGROUP_NAME"));
                tableGroup.setIsSubPartTemplate(0);
                TableGroupPartition partition = new TableGroupPartition(schema);
                partition.setPartitionType(rs.getString("PARTITIONING_TYPE"));
                partition.setPartitionColumnNum(rs.getInt("PARTITIONING_KEY_COUNT"));
                partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                if (StringUtils.isNotBlank(partition.getPartitionType())) {
                    tableGroup.setPartLevel(1);
                }
                tableGroup.setTableGroupPartition(partition);
                TableGroupSubPartition subPartition = new TableGroupSubPartition(schema);
                subPartition.setSubPartitionType(rs.getString("SUBPARTITIONING_TYPE"));
                subPartition.setSubPartitionColumnNum(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                subPartition.setSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                partition.setTableGroupSubPartition(subPartition);
                if (StringUtils.isNotBlank(subPartition.getSubPartitionType())) {
                    tableGroup.setPartLevel(2);
                }
                tempTableGroupMap.putIfAbsent(tableGroup.getObjectName(), tableGroup);
            }
            return tempTableGroupMap;
        });
        if (MapUtils.isEmpty(tableGroupMap)) {
            log.warn("No tablegroup is found in the schema [ {} ]", (Object)this.getSchemaName());
            return Maps.newLinkedHashMap();
        }
        for (ObOracleTableGroup tableGroup : tableGroupMap.values()) {
            if (tableGroup.getPartLevel() < 1) continue;
            this.queryTabGroupPartitionsV4(tableGroup);
            if (tableGroup.getPartLevel() != 2) continue;
            this.queryTabGroupSubPartitionsV4(tableGroup);
        }
        return tableGroupMap;
    }

    private void queryTabGroupPartitionsV3(ObOracleTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupPartitions");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            TableGroupPartition partition = tableGroup.getTableGroupPartition();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(rs.getString("part_name"));
                item.setPartitionPosition(rs.getInt("part_id"));
                item.setHighValue(rs.getString(partition.getJdbcFieldName()));
                partition.getPartitionItems().add(item);
            }
            return null;
        });
    }

    private void queryTabGroupPartitionsV4(ObOracleTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupPartitions");
        Object[] args = new Object[]{tableGroup.getObjectName()};
        this.jdbcTemplate.query(sql, args, rs -> {
            TableGroupPartition partition = tableGroup.getTableGroupPartition();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(rs.getString("PARTITION_NAME"));
                item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                item.setHighValue(rs.getString("HIGH_VALUE"));
                partition.getPartitionItems().add(item);
            }
            return null;
        });
    }

    private void queryTabGroupSubPartitionsV3(ObOracleTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartitions");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
            Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
            while (rs.next()) {
                int partId = rs.getInt("part_id");
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(rs.getString("sub_part_name"));
                item.setPartitionPosition(partId);
                item.setHighValue(rs.getString(subPartition.getJdbcFieldName()));
                map.computeIfAbsent(partId, v -> new ArrayList()).add(item);
            }
            return null;
        });
    }

    private void queryTabGroupSubPartitionsV4(ObOracleTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartitions");
        Object[] args = new Object[]{tableGroup.getObjectName()};
        this.jdbcTemplate.query(sql, args, rs -> {
            TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
            Map<Integer, List<ObOracleTablePartition.OracleTablePartitionItem>> map = subPartition.getSubPartitionItemMapping();
            while (rs.next()) {
                int partId = rs.getInt("PARTITION_POSITION");
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(rs.getString("SUBPARTITION_NAME"));
                item.setPartitionPosition(partId);
                item.setHighValue(rs.getString("HIGH_VALUE"));
                map.computeIfAbsent(partId, v -> new ArrayList()).add(item);
            }
            return null;
        });
    }

    private void queryTabGroupSubPartTemplates(ObOracleTableGroup tableGroup) throws SQLException {
        String sql = this.getSqlMapper().getSql("getTabGroupSubPartTemplates");
        Object[] args = new Object[]{tableGroup.getTableGroupId()};
        this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
            TableGroupSubPartition subPartition = tableGroup.getTableGroupSubPartition();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionTemplate template = new ObOracleTablePartition.OracleTablePartitionTemplate();
                template.setSubPartitionName(rs.getString("sub_part_name"));
                template.setHighBound(rs.getString(subPartition.getJdbcFieldName()));
                subPartition.getSubPartitionTemplates().add(template);
            }
            return null;
        });
    }

    public Map<String, ObOracleTable> queryTableMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TABLE, this.sqlMapper.getSql("getTables"));
        Object[] args = new Object[]{this.getSchemaName(), "VALID", ObjectType.TABLE.name()};
        Map<String, ObOracleTable> tableMap = this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObOracleTable> tempTableMap = new LinkedHashMap<String, ObOracleTable>();
            while (rs.next()) {
                ObOracleTable table = new ObOracleTable((ObOracleSchema)schema);
                table.setObjectName(rs.getString("TABLE_NAME"));
                table.setClusterName(rs.getString("CLUSTER_NAME"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    table.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                }
                String partitioned = Objects.equals(rs.getString("TEMPORARY"), "Y") ? "NO" : rs.getString("PARTITIONED");
                table.setPartitioned(partitioned);
                table.setTemporary(rs.getString("TEMPORARY"));
                table.setDuration(rs.getString("DURATION"));
                table.setRowMovement(rs.getString("ROW_MOVEMENT"));
                table.setCompression(rs.getString("COMPRESSION"));
                table.setCompressFor(rs.getString("COMPRESS_FOR"));
                table.setDropped(rs.getString("DROPPED"));
                table.setTableType(ObjectType.TABLE.name());
                table.setTableComment(rs.getString("COMMENTS"));
                tempTableMap.put(table.getObjectName(), table);
            }
            return tempTableMap;
        });
        if (MapUtils.isEmpty(tableMap)) {
            log.warn("No tables were found in the schema [ {} ]", (Object)this.getSchemaName());
            return tableMap;
        }
        int thread = Math.min(this.configure.getInnerThread(), ExecutorTemplate.DEFAULT_POOL_SIZE);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(thread, thread, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100000), new NamedThreadFactory("schema-dumper-"));
        ExecutorTemplate<Object> template = new ExecutorTemplate<Object>(executor);
        Collection<ObOracleTable> tables = tableMap.values();
        AtomicInteger total = new AtomicInteger(tables.size());
        for (ObOracleTable table : tables) {
            template.submit(() -> {
                table.getColumnMapping().putAll(this.queryColumnMapping(table));
                table.setPrimaryKey(this.queryPrimaryKey(table));
                table.getUniqueMapping().putAll(this.queryUniqueMapping(table));
                if ("YES".equals(table.getPartitioned())) {
                    table.setTablePartition(this.queryTablePartition(table));
                }
                if (DbType.OBORACLE_22.isPrior(this.getDbType())) {
                    table.getCheckMapping().putAll(this.queryCheckMapping(table));
                }
                table.getIndexMapping().putAll(this.queryIndexMapping(table));
                if (DbType.OBORACLE_22.isPrior(this.getDbType())) {
                    table.getForeignMapping().putAll(this.queryForeignMapping(table));
                }
                if (schema.getGlobal().isWithExtra()) {
                    table.setTableGroupName(this.queryTableGroup(table));
                }
                total.decrementAndGet();
                log.info("Query table: \"{}\" attr finished. Remain: {}", (Object)table.getObjectName(), (Object)total);
                return null;
            });
        }
        template.waitForResult();
        return tableMap;
    }

    public Map<String, ObOracleColumn> queryColumnMapping(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getColumns");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObOracleSchema schema = (ObOracleSchema)table.getSchema();
            LinkedHashMap<String, ObOracleColumn> columnMapping = new LinkedHashMap<String, ObOracleColumn>();
            while (rs.next()) {
                String columnDefault;
                ObOracleColumn column = new ObOracleColumn(schema);
                column.setObjectName(table.getObjectName());
                column.setColumnName(rs.getString("COLUMN_NAME"));
                column.setDataType(rs.getString("DATA_TYPE"));
                column.setOrdinalPosition(rs.getInt("COLUMN_ID"));
                column.setColumnDefault(rs.getString("DATA_DEFAULT"));
                column.setNullable(rs.getString("NULLABLE"));
                column.setColumnComment(rs.getString("COMMENTS"));
                column.setDataLength(rs.getLong("DATA_LENGTH"));
                column.setDataPrecision(rs.getInt("DATA_PRECISION"));
                column.setDataScale(rs.getInt("DATA_SCALE"));
                column.setDefaultLength(rs.getInt("DEFAULT_LENGTH"));
                column.setCharacterSetName(rs.getString("CHARACTER_SET_NAME"));
                column.setCharColDeclLength(rs.getInt("CHAR_COL_DECL_LENGTH"));
                column.setCharLength(rs.getLong("CHAR_LENGTH"));
                column.setCharUsed(rs.getString("CHAR_USED"));
                column.setHiddenColumn(rs.getString("HIDDEN_COLUMN"));
                column.setVirtualColumn(rs.getString("VIRTUAL_COLUMN"));
                if (DbType.OBORACLE_2250.isSubsequent(this.getDbType()) && (columnDefault = column.getColumnDefault()) != null && columnDefault.matches("\\([\\s\\S]+\\)")) {
                    column.setVirtualColumn("YES");
                }
                columnMapping.put(column.getColumnName(), column);
            }
            return columnMapping;
        });
    }

    @Override
    public ObOraclePrimaryKey queryPrimaryKey(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), SqlConst.PRI_TYPE};
        return this.jdbcTemplate.query(sql, args, rs -> {
            AbstractConstraint primary = null;
            ObOracleSchema schema = (ObOracleSchema)table.getSchema();
            while (rs.next()) {
                if (primary == null) {
                    primary = new ObOraclePrimaryKey(schema);
                    primary.setObjectName(table.getObjectName());
                    primary.setConstraintName(rs.getString("CONSTRAINT_NAME"));
                    ((AbstractObOracleConstraint)primary).setDeferrable(rs.getString("DEFERRABLE"));
                    ((AbstractObOracleConstraint)primary).setDeferred(rs.getString("DEFERRED"));
                    ((AbstractObOracleConstraint)primary).setValidated(rs.getString("VALIDATED"));
                    ((AbstractObOracleConstraint)primary).setGenerated(rs.getString("GENERATED"));
                    ((AbstractObOracleConstraint)primary).setRely(rs.getString("RELY"));
                    ((AbstractObOracleConstraint)primary).setIndexOwner(rs.getString("INDEX_OWNER"));
                    ((AbstractObOracleConstraint)primary).setIndexName(rs.getString("INDEX_NAME"));
                    ((AbstractObOracleConstraint)primary).setIndexType(rs.getString("INDEX_TYPE"));
                    ((AbstractObOracleConstraint)primary).setInvalid(rs.getString("INVALID"));
                    ((AbstractObOracleConstraint)primary).setViewRelated(rs.getString("VIEW_RELATED"));
                }
                primary.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("POSITION")));
            }
            return primary;
        });
    }

    public Map<String, ObOracleForeignKey> queryForeignMapping(AbstractTable table) throws SQLException {
        return super.getDbType().isPrior(DbType.OBORACLE_40) ? this.queryForeignMappingV3(table) : this.queryForeignMappingV4(table);
    }

    public Map<String, ObOracleForeignKey> queryForeignMappingV3(AbstractTable table) throws SQLException {
        if (!this.sessionManager.isSupportSys()) {
            log.error("Foreign keys of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return Maps.newLinkedHashMap();
        }
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMapFromSysTable(sql, args, rs -> {
            ObOracleSchema schema = (ObOracleSchema)table.getSchema();
            LinkedHashMap<String, ObOracleForeignKey> foreignMapping = new LinkedHashMap<String, ObOracleForeignKey>();
            int index = 0;
            while (rs.next()) {
                Integer pos;
                String constName = rs.getString("CONSTRAINT_NAME");
                ObOracleForeignKey foreign = foreignMapping.getOrDefault(constName, new ObOracleForeignKey(schema));
                if (!foreignMapping.containsKey(constName)) {
                    foreign.setObjectName(table.getObjectName());
                    foreign.setConstraintName(constName);
                    foreign.setTableName(table.getObjectName());
                    foreign.setDeleteRule(rs.getString("DELETE_RULE"));
                    foreign.setRefTableOwner(rs.getString("R_OWNER"));
                    foreign.setRefTableName(rs.getString("R_TABLE_NAME"));
                    foreignMapping.put(foreign.getConstraintName(), foreign);
                }
                if ((pos = Integer.valueOf(rs.getInt("POSITION"))) == null || pos == -1) {
                    pos = index++;
                }
                foreign.getForeignColumns().add(new KeyColumn(rs.getString("F_COLUMN_NAME"), pos));
                foreign.getReferencedColumns().add(new KeyColumn(rs.getString("R_COLUMN_NAME"), pos));
            }
            return foreignMapping;
        });
    }

    public Map<String, ObOracleForeignKey> queryForeignMappingV4(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getForeignKeys");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObOracleSchema schema = (ObOracleSchema)table.getSchema();
            LinkedHashMap<String, ObOracleForeignKey> foreignMapping = new LinkedHashMap<String, ObOracleForeignKey>();
            int index = 0;
            while (rs.next()) {
                Integer pos;
                String constName = rs.getString("CONSTRAINT_NAME");
                ObOracleForeignKey foreign = foreignMapping.getOrDefault(constName, new ObOracleForeignKey(schema));
                if (!foreignMapping.containsKey(constName)) {
                    foreign.setObjectName(table.getObjectName());
                    foreign.setConstraintName(constName);
                    foreign.setTableName(table.getObjectName());
                    foreign.setDeleteRule(rs.getString("DELETE_RULE"));
                    foreign.setRefTableOwner(rs.getString("R_OWNER"));
                    foreign.setRefTableName(rs.getString("R_TABLE_NAME"));
                    foreignMapping.put(foreign.getConstraintName(), foreign);
                }
                if ((pos = Integer.valueOf(rs.getInt("POSITION"))) == null || pos == -1) {
                    pos = index++;
                }
                foreign.getForeignColumns().add(new KeyColumn(rs.getString("F_COLUMN_NAME"), pos));
                foreign.getReferencedColumns().add(new KeyColumn(rs.getString("R_COLUMN_NAME"), pos));
            }
            return foreignMapping;
        });
    }

    public Map<String, ObOracleUniqueKey> queryUniqueMapping(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPrimaryKey");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "U"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObOracleSchema schema = (ObOracleSchema)table.getSchema();
            LinkedHashMap<String, ObOracleUniqueKey> uniqueMap = new LinkedHashMap<String, ObOracleUniqueKey>();
            while (rs.next()) {
                String constName = rs.getString("CONSTRAINT_NAME");
                ObOracleUniqueKey unique = uniqueMap.getOrDefault(constName, new ObOracleUniqueKey(schema));
                if (!uniqueMap.containsKey(constName)) {
                    unique.setObjectName(table.getObjectName());
                    unique.setConstraintName(constName);
                    unique.setStatus(rs.getString("STATUS"));
                    unique.setDeferrable(rs.getString("DEFERRABLE"));
                    unique.setDeferred(rs.getString("DEFERRED"));
                    unique.setValidated(rs.getString("VALIDATED"));
                    unique.setGenerated(rs.getString("GENERATED"));
                    unique.setRely(rs.getString("RELY"));
                    unique.setIndexOwner(rs.getString("INDEX_OWNER"));
                    unique.setIndexName(rs.getString("INDEX_NAME"));
                    unique.setInvalid(rs.getString("INVALID"));
                    unique.setViewRelated(rs.getString("VIEW_RELATED"));
                    uniqueMap.put(constName, unique);
                }
                unique.getConstraintColumns().add(new KeyColumn(rs.getString("COLUMN_NAME"), rs.getInt("POSITION")));
            }
            return uniqueMap;
        });
    }

    private Map<String, ObOracleCheck> queryCheckMapping(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getChecks");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName(), "C"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObOracleSchema schema = (ObOracleSchema)table.getSchema();
            LinkedHashMap<String, ObOracleCheck> checkMap = new LinkedHashMap<String, ObOracleCheck>();
            Map<String, ObOracleColumn> columnMapping = ((ObOracleTable)table).getColumnMapping();
            while (rs.next()) {
                String searchCondition = rs.getString("SEARCH_CONDITION");
                if (StringUtils.contains(searchCondition, "IS NOT NULL")) {
                    int index = searchCondition.indexOf(" ");
                    String columnName = searchCondition.substring(0, index);
                    ObOracleColumn column = columnMapping.get(columnName = columnName.replace("\"", "").trim());
                    if (column != null && "N".equals(column.getNullable())) continue;
                }
                String constName = rs.getString("CONSTRAINT_NAME");
                ObOracleCheck check = checkMap.getOrDefault(constName, new ObOracleCheck(schema));
                if (checkMap.containsKey(constName)) continue;
                check.setObjectName(table.getObjectName());
                check.setConstraintName(constName);
                check.setSearchCondition(searchCondition);
                check.setStatus(rs.getString("STATUS"));
                check.setDeferrable(rs.getString("DEFERRABLE"));
                check.setDeferred(rs.getString("DEFERRED"));
                check.setValidated(rs.getString("VALIDATED"));
                check.setGenerated(rs.getString("GENERATED"));
                check.setRely(rs.getString("RELY"));
                check.setInvalid(rs.getString("INVALID"));
                check.setViewRelated(rs.getString("VIEW_RELATED"));
                checkMap.put(check.getConstraintName(), check);
            }
            return checkMap;
        });
    }

    public String queryTableGroup(AbstractTable table) throws SQLException {
        return super.getDbType().isPrior(DbType.OBORACLE_40) ? this.queryTableGroupV3(table) : this.queryTableGroupV4(table);
    }

    public String queryTableGroupV3(AbstractTable table) throws SQLException {
        if (!this.sessionManager.isSupportSys()) {
            log.warn("Tablegroup of table: {} maybe lost", (Object)table.getSchemaObjectName());
            return "";
        }
        String sql = this.sqlMapper.getSql("getTableGroup");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.queryFromSysTable(sql, args, rs -> rs.next() ? rs.getString("TABLEGROUP_NAME") : "");
    }

    public String queryTableGroupV4(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getTableGroup");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        return this.jdbcTemplate.query(sql, args, rs -> rs.next() ? rs.getString("TABLEGROUP_NAME") : "");
    }

    @Override
    public ObOracleTablePartition queryTablePartition(AbstractTable table) throws SQLException {
        String subParitioningType;
        Integer defSubPartitionCount;
        ObOracleTablePartition tablePartition = this.queryPartTable(table);
        if (tablePartition == null) {
            return null;
        }
        Integer partitionCount = tablePartition.getPartitionCount();
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        if (partitionCount != null && partitionCount > 0) {
            tablePartition.getTablePartitions().addAll(this.queryTabPartitions(table, args));
            String partitioningType = tablePartition.getPartitioningType();
            boolean hasPartitioningKeys = true;
            tablePartition.setPartitioningKeyCount(Math.max(tablePartition.getPartitioningKeyCount(), 1));
            if (!"REFERENCE".equals(partitioningType) && hasPartitioningKeys) {
                tablePartition.getTablePartitionColumns().addAll(this.queryTabPartKeyColumns(table, args));
            }
        }
        if ((defSubPartitionCount = tablePartition.getDefSubPartitionCount()) != null && (subParitioningType = tablePartition.getSubPartitioningType()) != null && !"NONE".equals(subParitioningType)) {
            boolean hasSubPartitioningKeys = true;
            tablePartition.setSubPartitioningKeyCount(Math.max(tablePartition.getSubPartitioningKeyCount(), 1));
            if (!"REFERENCE".equals(subParitioningType) && hasSubPartitioningKeys) {
                tablePartition.getTableSubPartitionColumns().addAll(this.queryTabSubPartKeyColumns(table, args));
            }
            tablePartition.getTablePartitionTemplates().addAll(this.queryTableSubPartTemplates(args));
            if (CollectionUtils.isNotEmpty(tablePartition.getTablePartitionTemplates())) {
                return tablePartition;
            }
            tablePartition.getTableSubPartitionMapping().putAll(this.queryTabSubPartitionMapping(table, args));
        }
        return tablePartition;
    }

    private ObOracleTablePartition queryPartTable(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartTable");
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), table.getObjectName(), "VALID"} : new Object[]{this.getSchemaName(), table.getObjectName(), "%VALID"};
        ResultHandler<ObOracleTablePartition> handler = rs -> {
            ObOracleTablePartition partition = null;
            if (rs.next()) {
                partition = new ObOracleTablePartition((ObOracleSchema)table.getSchema());
                partition.setObjectName(table.getObjectName());
                partition.setPartitioningType(rs.getString("PARTITIONING_TYPE"));
                partition.setSubPartitioningType(rs.getString("SUBPARTITIONING_TYPE"));
                partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                partition.setDefSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                partition.setPartitioningKeyCount(rs.getInt("PARTITIONING_KEY_COUNT"));
                partition.setSubPartitioningKeyCount(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                partition.setDefCompression(rs.getString("COMPRESSION"));
                partition.setDefCompressFor(rs.getString("COMPRESS_FOR"));
                partition.setInterval(rs.getString("INTERVAL"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    partition.setDefTablespaceName(rs.getString("DEF_TABLESPACE_NAME"));
                }
            }
            return partition;
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.query(sql, args, handler);
    }

    private List<ObOracleTablePartition.OracleTablePartitionTemplate> queryTableSubPartTemplates(Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartTemplates");
        ResultsHandler handler = rs -> {
            ArrayList<ObOracleTablePartition.OracleTablePartitionTemplate> templates = new ArrayList<ObOracleTablePartition.OracleTablePartitionTemplate>();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionTemplate template = new ObOracleTablePartition.OracleTablePartitionTemplate();
                template.setHighBound(rs.getString("HIGH_BOUND"));
                template.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                template.setSubPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    template.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                }
                templates.add(template);
            }
            return templates;
        };
        if (DbType.OBORACLE_2250.isSubsequentFrom(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    private List<ObOracleTablePartition.OracleTablePartitionItem> queryTabPartitions(AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartitions");
        ResultsHandler handler = rs -> {
            ArrayList<ObOracleTablePartition.OracleTablePartitionItem> partitions = new ArrayList<ObOracleTablePartition.OracleTablePartitionItem>();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setTableName(table.getObjectName());
                item.setLogging(rs.getString("LOGGING"));
                item.setInterval(rs.getString("INTERVAL"));
                item.setComposite(rs.getString("COMPOSITE"));
                item.setHighValue(rs.getString("HIGH_VALUE"));
                item.setCompression(rs.getString("COMPRESSION"));
                item.setCompressFor(rs.getString("COMPRESS_FOR"));
                item.setPartitionName(rs.getString("PARTITION_NAME"));
                item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                item.setSubPartitionCount(rs.getInt("SUBPARTITION_COUNT"));
                item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                item.setParentTablePartition(rs.getString("PARENT_TABLE_PARTITION"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                }
                partitions.add(item);
            }
            return partitions;
        };
        if (DbType.OBORACLE_2250.isSubsequentFrom(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    private Map<String, List<ObOracleTablePartition.OracleTablePartitionItem>> queryTabSubPartitionMapping(AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartitions");
        ResultMapHandler handler = rs -> {
            LinkedHashMap<String, List> subPartMapping = new LinkedHashMap<String, List>();
            while (rs.next()) {
                String partName = rs.getString("PARTITION_NAME");
                List items = subPartMapping.getOrDefault(partName, new ArrayList());
                if (!subPartMapping.containsKey(partName)) {
                    subPartMapping.put(partName, items);
                }
                ObOracleTablePartition.OracleTablePartitionItem item = new ObOracleTablePartition.OracleTablePartitionItem();
                item.setPartitionName(partName);
                item.setTableName(table.getObjectName());
                item.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                item.setHighValue(rs.getString("HIGH_VALUE"));
                item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                item.setPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                }
                item.setLogging(rs.getString("LOGGING"));
                item.setCompression(rs.getString("COMPRESSION"));
                item.setCompressFor(rs.getString("COMPRESS_FOR"));
                item.setInterval(rs.getString("INTERVAL"));
                items.add(item);
            }
            return subPartMapping;
        };
        if (DbType.OBORACLE_2250.isSubsequentFrom(this.getDbType())) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    private List<ObOracleTablePartition.OracleTablePartitionColumn> queryTabPartKeyColumns(AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabPartKeyColumns");
        ResultsHandler handler = rs -> {
            ArrayList<ObOracleTablePartition.OracleTablePartitionColumn> columns = new ArrayList<ObOracleTablePartition.OracleTablePartitionColumn>();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionColumn column = new ObOracleTablePartition.OracleTablePartitionColumn();
                column.setName(table.getObjectName());
                try {
                    column.setColumnName(rs.getString("COLUNM_NAME"));
                }
                catch (SQLException e) {
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                }
                column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                columns.add(column);
            }
            return columns;
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    private List<ObOracleTablePartition.OracleTablePartitionColumn> queryTabSubPartKeyColumns(AbstractTable table, Object[] args) throws SQLException {
        String sql = this.sqlMapper.getSql("getTabSubPartKeyColumns");
        ResultsHandler handler = rs -> {
            ArrayList<ObOracleTablePartition.OracleTablePartitionColumn> columns = new ArrayList<ObOracleTablePartition.OracleTablePartitionColumn>();
            while (rs.next()) {
                ObOracleTablePartition.OracleTablePartitionColumn column = new ObOracleTablePartition.OracleTablePartitionColumn();
                column.setName(table.getObjectName());
                try {
                    column.setColumnName(rs.getString("COLUNM_NAME"));
                }
                catch (SQLException e) {
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                }
                column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                columns.add(column);
            }
            return columns;
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    public Map<String, ObOracleIndex> queryIndexMapping(AbstractTable table) throws SQLException {
        Map<String, ObOracleIndex> indexMapping = this.queryIndexes(table);
        if (MapUtils.isEmpty(indexMapping)) {
            return indexMapping;
        }
        if (DbType.OBORACLE_2250.isSubsequent(this.getDbType())) {
            this.queryIndexExprFromVirtualTable(indexMapping);
        }
        boolean isPartitioned = indexMapping.values().stream().filter(e -> e != null).anyMatch(e -> "YES".equals(e.getPartitioned()));
        if (DbType.OBORACLE_2250.isPrior(this.getDbType()) && !isPartitioned) {
            return indexMapping;
        }
        Map<String, ObOracleIndexPartition> indexPartitionMapping = this.queryPartIndexMap(table);
        for (Map.Entry<String, ObOracleIndexPartition> entry : indexPartitionMapping.entrySet()) {
            ObOracleIndex index;
            String indexName = entry.getKey();
            ObOracleIndexPartition indexPartition = entry.getValue();
            if ("GLOBAL".equals(indexPartition.getLocality())) {
                String subParitioningType;
                indexPartition.getIndexPartitions().addAll(this.queryIndPartitions(indexName));
                Integer partitioningKeyCount = indexPartition.getPartitioningKeyCount();
                if (partitioningKeyCount != null && partitioningKeyCount > 0) {
                    indexPartition.getIndexPartitionColumns().addAll(this.queryIndPartKeyColumns(indexName));
                }
                if ((subParitioningType = indexPartition.getSubPartitioningType()) != null && !"NONE".equals(subParitioningType)) {
                    indexPartition.getIndexSubPartitionMapping().putAll(this.queryIndSubPartitionMapping(indexName));
                    Integer subPartitioningKeyCountInteger = indexPartition.getSubPartitioningKeyCount();
                    if (subPartitioningKeyCountInteger != null && subPartitioningKeyCountInteger > 0) {
                        indexPartition.getIndexSubPartitionColumns().addAll(this.queryIndSubPartKeyColumns(indexName));
                    }
                }
            }
            if ((index = indexMapping.get(indexName)) == null) continue;
            index.setIndexPartition(indexPartition);
        }
        return indexMapping;
    }

    Map<String, ObOracleIndex> queryIndexes(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexes");
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), table.getObjectName(), table.getTableType(), "VALID", this.getSchemaName()} : new Object[]{this.getSchemaName(), table.getObjectName(), table.getTableType(), "%VALID", this.getSchemaName()};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            ObOracleSchema schema = (ObOracleSchema)table.getSchema();
            LinkedHashMap<String, ObOracleIndex> indexMap = new LinkedHashMap<String, ObOracleIndex>();
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                String funcIdxStatus = rs.getString("FUNCIDX_STATUS");
                String domIdxStatus = rs.getString("DOMIDX_STATUS");
                String domIdxOpstatus = rs.getString("DOMIDX_OPSTATUS");
                ObOracleIndex index = indexMap.getOrDefault(indexName, new ObOracleIndex(schema));
                if (!indexMap.containsKey(indexName)) {
                    index.setIndexName(indexName);
                    index.setObjectName(table.getObjectName());
                    index.setIndexSchema(rs.getString("OWNER"));
                    index.setIndexType(rs.getString("INDEX_TYPE"));
                    index.setUniqueness(rs.getString("UNIQUENESS"));
                    index.setCompression(rs.getString("COMPRESSION"));
                    index.setPrefixLength(rs.getInt("PREFIX_LENGTH"));
                    if (this.isChecked(ObjectType.TABLESPACE)) {
                        index.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                    }
                    index.setIncludeColumn(rs.getString("INCLUDE_COLUMN"));
                    index.setLogging(rs.getString("LOGGING"));
                    index.setPartitioned(rs.getString("PARTITIONED"));
                    index.setTemporary(rs.getString("TEMPORARY"));
                    index.setGenerated(rs.getString("GENERATED"));
                    index.setSecondary(rs.getString("SECONDARY"));
                    index.setParameters(rs.getString("PARAMETERS"));
                    index.setDomIdxStatus(domIdxStatus);
                    index.setDomIdxOpStatus(domIdxOpstatus);
                    index.setFuncIdxStatus(funcIdxStatus);
                    index.setJoinIndex(rs.getString("JOIN_INDEX"));
                    index.setIotRedundantPkeyElim(rs.getString("IOT_REDUNDANT_PKEY_ELIM"));
                    index.setDropped(rs.getString("DROPPED"));
                    index.setVisibility(rs.getString("VISIBILITY"));
                    index.setDomIdxManagement(rs.getString("DOMIDX_MANAGEMENT"));
                    indexMap.putIfAbsent(indexName, index);
                }
                String columnName = rs.getString("COLUMN_NAME");
                String descend = rs.getString("DESCEND");
                Integer columnPosition = rs.getInt("C_COLUMN_POSITION");
                if (DbType.OBORACLE_2250.isSubsequent(this.getDbType())) {
                    index.getIndexColumns().add(new KeyColumn(columnName, columnPosition, descend));
                    continue;
                }
                String columnExpr = rs.getString("COLUMN_EXPRESSION");
                if (funcIdxStatus != null && columnExpr != null) {
                    KeyColumn col = new KeyColumn(columnExpr, columnPosition, descend);
                    col.setExpression(true);
                    index.getIndexColumns().add(col);
                    continue;
                }
                index.getIndexColumns().add(new KeyColumn(columnName, columnPosition, descend));
            }
            return indexMap;
        });
    }

    private void queryIndexExprFromVirtualTable(Map<String, ObOracleIndex> indexMap) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndexExpr");
        for (ObOracleIndex index : indexMap.values()) {
            Object[] args = new Object[]{index.getIndexSchema(), index.getIndexName()};
            this.jdbcTemplate.queryFromSysTable(sql, args, rs -> {
                block0: while (rs.next()) {
                    String columnExpr = rs.getString("COLUMN_EXPRESSION");
                    if (columnExpr == null) continue;
                    for (KeyColumn col : index.getIndexColumns()) {
                        String colName = col.getColumnName();
                        if (colName != null && !colName.equals(rs.getString("COLUMN_NAME"))) continue;
                        col.setExpression(true);
                        col.setColumnName(columnExpr);
                        continue block0;
                    }
                }
                return null;
            });
        }
    }

    private Map<String, ObOracleIndexPartition> queryPartIndexMap(AbstractTable table) throws SQLException {
        String sql = this.sqlMapper.getSql("getPartIndexes");
        Object[] args = new Object[]{this.getSchemaName(), table.getObjectName()};
        ResultMapHandler handler = rs -> {
            ObOracleSchema schema = (ObOracleSchema)table.getSchema();
            LinkedHashMap<String, ObOracleIndexPartition> partIndexMapping = new LinkedHashMap<String, ObOracleIndexPartition>();
            while (rs.next()) {
                ObOracleIndexPartition partition = new ObOracleIndexPartition(schema);
                partition.setPartitioningType(rs.getString("PARTITIONING_TYPE"));
                partition.setSubPartitioningType(rs.getString("SUBPARTITIONING_TYPE"));
                partition.setPartitionCount(rs.getInt("PARTITION_COUNT"));
                partition.setDefSubPartitionCount(rs.getInt("DEF_SUBPARTITION_COUNT"));
                partition.setPartitioningKeyCount(rs.getInt("PARTITIONING_KEY_COUNT"));
                partition.setSubPartitioningKeyCount(rs.getInt("SUBPARTITIONING_KEY_COUNT"));
                partition.setLocality(rs.getString("LOCALITY"));
                partition.setAlignment(rs.getString("ALIGNMENT"));
                partition.setInterval(rs.getString("INTERVAL"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    partition.setDefTablespaceName(rs.getString("DEF_TABLESPACE_NAME"));
                }
                partIndexMapping.put(rs.getString("INDEX_NAME"), partition);
            }
            return partIndexMapping;
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    private Collection<AbstractIndexPartition.IndexPartitionItem> queryIndPartitions(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartitions");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultsHandler handler = rs -> {
            ArrayList<AbstractIndexPartition.IndexPartitionItem> items = new ArrayList<AbstractIndexPartition.IndexPartitionItem>();
            while (rs.next()) {
                AbstractIndexPartition.IndexPartitionItem item = new AbstractIndexPartition.IndexPartitionItem();
                item.setLogging(rs.getString("LOGGING"));
                item.setInterval(rs.getString("INTERVAL"));
                item.setComposite(rs.getString("COMPOSITE"));
                item.setHighValue(rs.getString("HIGH_VALUE"));
                item.setParameters(rs.getString("PARAMETERS"));
                item.setCompression(rs.getString("COMPRESSION"));
                item.setPartitionName(rs.getString("PARTITION_NAME"));
                item.setDomidxOpstatus(rs.getString("DOMIDX_OPSTATUS"));
                item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                item.setSubPartitionCount(rs.getInt("SUBPARTITION_COUNT"));
                item.setPartitionPosition(rs.getInt("PARTITION_POSITION"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                }
                items.add(item);
            }
            return items;
        };
        if (DbType.OBORACLE_40.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    private List<AbstractIndexPartition.IndexPartitionColumn> queryIndPartKeyColumns(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultsHandler handler = rs -> {
            ArrayList<AbstractIndexPartition.IndexPartitionColumn> columns = new ArrayList<AbstractIndexPartition.IndexPartitionColumn>();
            while (rs.next()) {
                AbstractIndexPartition.IndexPartitionColumn column = new AbstractIndexPartition.IndexPartitionColumn();
                column.setName(indexName);
                try {
                    column.setColumnName(rs.getString("COLUNM_NAME"));
                }
                catch (SQLException e) {
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                }
                column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                columns.add(column);
            }
            return columns;
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    Map<String, List<AbstractIndexPartition.IndexPartitionItem>> queryIndSubPartitionMapping(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartitions");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultMapHandler handler = rs -> {
            LinkedHashMap<String, List> subPartMapping = new LinkedHashMap<String, List>();
            while (rs.next()) {
                String partName = rs.getString("PARTITION_NAME");
                List items = subPartMapping.getOrDefault(partName, new ArrayList());
                AbstractIndexPartition.IndexPartitionItem item = new AbstractIndexPartition.IndexPartitionItem();
                item.setPartitionName(partName);
                item.setSubPartitionName(rs.getString("SUBPARTITION_NAME"));
                item.setHighValue(rs.getString("HIGH_VALUE"));
                item.setHighValueLength(rs.getInt("HIGH_VALUE_LENGTH"));
                item.setSubPartitionPosition(rs.getInt("SUBPARTITION_POSITION"));
                item.setLogging(rs.getString("LOGGING"));
                item.setCompression(rs.getString("COMPRESSION"));
                item.setInterval(rs.getString("INTERVAL"));
                if (this.isChecked(ObjectType.TABLESPACE)) {
                    item.setTablespaceName(rs.getString("TABLESPACE_NAME"));
                }
                items.add(item);
                subPartMapping.putIfAbsent(partName, items);
            }
            return subPartMapping;
        };
        if (DbType.OBORACLE_2250.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryMapFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryMap(sql, args, handler);
    }

    private List<AbstractIndexPartition.IndexPartitionColumn> queryIndSubPartKeyColumns(String indexName) throws SQLException {
        String sql = this.sqlMapper.getSql("getIndSubPartKeyColumns");
        Object[] args = new Object[]{this.getSchemaName(), indexName};
        ResultsHandler handler = rs -> {
            ArrayList<AbstractIndexPartition.IndexPartitionColumn> columns = new ArrayList<AbstractIndexPartition.IndexPartitionColumn>();
            while (rs.next()) {
                AbstractIndexPartition.IndexPartitionColumn column = new AbstractIndexPartition.IndexPartitionColumn();
                column.setName(indexName);
                try {
                    column.setColumnName(rs.getString("COLUNM_NAME"));
                }
                catch (SQLException e) {
                    column.setColumnName(rs.getString("COLUMN_NAME"));
                }
                column.setColumnPosition(rs.getInt("COLUMN_POSITION"));
                columns.add(column);
            }
            return columns;
        };
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.jdbcTemplate.queryListFromSysTable(sql, args, handler);
        }
        return this.jdbcTemplate.queryList(sql, args, handler);
    }

    public Map<String, ObOracleView> queryViewMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.VIEW, this.sqlMapper.getSql("getViews"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), "%VALID"};
        ObOracleSchema target = (ObOracleSchema)schema;
        if (DbType.OBORACLE_22.isSubsequent(this.getDbType())) {
            return this.queryViewMappingFromVirtual(target, sql, args);
        }
        Map<String, ObOracleView> viewMap = this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObOracleView> tempViewMap = new LinkedHashMap<String, ObOracleView>();
            while (rs.next()) {
                ObOracleView view = new ObOracleView(target);
                view.setText(rs.getString("TEXT"));
                view.setObjectName(rs.getString("VIEW_NAME"));
                view.setTextLength(rs.getInt("TEXT_LENGTH"));
                view.setOidTextLength(rs.getInt("OID_TEXT_LENGTH"));
                view.setOidText(rs.getString("OID_TEXT"));
                view.setViewType(rs.getString("VIEW_TYPE"));
                view.setSuperViewName(rs.getString("SUPERVIEW_NAME"));
                view.setEditioningView(rs.getString("EDITIONING_VIEW"));
                view.setReadOnly(rs.getString("READ_ONLY"));
                tempViewMap.put(view.getObjectName(), view);
            }
            return tempViewMap;
        });
        if (MapUtils.isEmpty(viewMap)) {
            log.warn("No views were found in the schema [ " + this.getSchemaName() + " ]");
            return viewMap;
        }
        AtomicInteger total = new AtomicInteger(viewMap.size());
        ExecutorTemplate<Object> template = new ExecutorTemplate<Object>("schema-dumper-", this.configure.getInnerThread());
        for (ObOracleView view : viewMap.values()) {
            template.submit(() -> {
                ObOracleTable table = new ObOracleTable(target);
                table.setObjectName(view.getObjectName());
                view.getColumnMapping().putAll(this.queryColumnMapping(table));
                view.setPrimaryKey(this.queryPrimaryKey(table));
                view.getUniqueMapping().putAll(this.queryUniqueMapping(table));
                total.decrementAndGet();
                log.info("Query view: \"{}\" attr finished. Remain: {}", (Object)view.getObjectName(), (Object)total);
                return null;
            });
        }
        template.waitForResult();
        return viewMap;
    }

    private Map<String, ObOracleView> queryViewMappingFromVirtual(ObOracleSchema schema, String sql, Object[] args) throws SQLException {
        return this.jdbcTemplate.queryMapFromSysTable(sql, args, rs -> {
            LinkedHashMap<String, ObOracleView> viewMap = new LinkedHashMap<String, ObOracleView>();
            while (rs.next()) {
                ObOracleView view = new ObOracleView(schema);
                view.setText(rs.getString("TEXT"));
                view.setObjectName(rs.getString("VIEW_NAME"));
                viewMap.put(view.getObjectName(), view);
            }
            return viewMap;
        });
    }

    public Map<String, ObOracleFunction> queryFunctionMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.FUNCTION, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "FUNCTION", "VALID"} : new Object[]{this.getSchemaName(), "FUNCTION", "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
            while (rs.next()) {
                String objectName = rs.getString("NAME");
                StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                sb.append(rs.getString("TEXT"));
                builderMap.putIfAbsent(objectName, sb);
            }
            LinkedHashMap<String, ObOracleFunction> functionMap = new LinkedHashMap<String, ObOracleFunction>();
            for (Map.Entry entry : builderMap.entrySet()) {
                ObOracleFunction function = new ObOracleFunction((ObOracleSchema)schema);
                function.setObjectName((String)entry.getKey());
                function.setText(String.valueOf(entry.getValue()).trim());
                functionMap.put(function.getObjectName(), function);
            }
            builderMap.clear();
            return functionMap;
        });
    }

    public Map<String, ObOracleProcedure> queryProcedureMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PROCEDURE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PROCEDURE", "VALID"} : new Object[]{this.getSchemaName(), "PROCEDURE", "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
            while (rs.next()) {
                String objectName = rs.getString("NAME");
                StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                sb.append(rs.getString("TEXT"));
                builderMap.putIfAbsent(objectName, sb);
            }
            LinkedHashMap<String, ObOracleProcedure> procedureMap = new LinkedHashMap<String, ObOracleProcedure>();
            for (Map.Entry entry : builderMap.entrySet()) {
                ObOracleProcedure procedure = new ObOracleProcedure((ObOracleSchema)schema);
                procedure.setObjectName((String)entry.getKey());
                procedure.setText(String.valueOf(entry.getValue()).trim());
                procedureMap.put(procedure.getObjectName(), procedure);
            }
            builderMap.clear();
            return procedureMap;
        });
    }

    public Map<String, ObOracleTrigger> queryTriggerMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TRIGGER, this.sqlMapper.getSql("getTriggers"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "ENABLED"} : new Object[]{this.getSchemaName(), "%ABLED"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObOracleTrigger> triggerMap = new LinkedHashMap<String, ObOracleTrigger>();
            while (rs.next()) {
                String objectName = rs.getString("NAME");
                if (!StringUtils.isNotBlank(objectName) || triggerMap.containsKey(objectName)) continue;
                ObOracleTrigger trigger = new ObOracleTrigger((ObOracleSchema)schema);
                trigger.setObjectName(objectName);
                trigger.setText(rs.getString("TEXT").trim());
                trigger.setStatus(rs.getString("STATUS"));
                triggerMap.put(objectName, trigger);
            }
            return triggerMap;
        });
    }

    public Map<String, ObOracleSequence> querySequenceMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.SEQUENCE, this.sqlMapper.getSql("getSequences"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObOracleSequence> sequenceMap = new LinkedHashMap<String, ObOracleSequence>();
            while (rs.next()) {
                ObOracleSequence sequence = new ObOracleSequence((ObOracleSchema)schema);
                sequence.setObjectName(rs.getString("SEQUENCE_NAME"));
                sequence.setMinValue(rs.getBigDecimal("MIN_VALUE"));
                sequence.setMaxValue(rs.getBigDecimal("MAX_VALUE"));
                sequence.setIncrement(rs.getBigDecimal("INCREMENT_BY"));
                sequence.setCycle(rs.getString("CYCLE_FLAG"));
                sequence.setOrder(rs.getString("ORDER_FLAG"));
                sequence.setCache(rs.getBigDecimal("CACHE_SIZE"));
                sequence.setStart(rs.getBigDecimal("LAST_NUMBER"));
                sequenceMap.put(sequence.getObjectName(), sequence);
            }
            return sequenceMap;
        });
    }

    public Map<String, ObOracleSynonym> querySynonymMapping(AbstractSchema schema) throws SQLException {
        String sql = null;
        sql = this.isChecked(ObjectType.PUBLIC_SYNONYM) ? this.bindings(ObjectType.PUBLIC_SYNONYM, this.sqlMapper.getSql("getSynonyms")) : this.bindings(ObjectType.SYNONYM, this.sqlMapper.getSql("getSynonyms"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), this.getSchemaName(), "VALID"} : new Object[]{this.getSchemaName(), this.getSchemaName(), "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, ObOracleSynonym> synonymMap = new LinkedHashMap<String, ObOracleSynonym>();
            while (rs.next()) {
                ObOracleSynonym synonym = new ObOracleSynonym((ObOracleSchema)schema);
                synonym.setOwner(rs.getString("OWNER"));
                synonym.setTableOwner(rs.getString("TABLE_OWNER"));
                synonym.setTableName(rs.getString("TABLE_NAME"));
                synonym.setDbLink(rs.getString("DB_LINK"));
                String synonymName = rs.getString("SYNONYM_NAME");
                if ("PUBLIC".equalsIgnoreCase(synonym.getOwner()) || "__public".equalsIgnoreCase(synonym.getOwner())) {
                    synonymName = synonymName + "__used_for_distinct_public";
                }
                synonym.setObjectName(synonymName);
                synonymMap.put(synonym.getObjectName(), synonym);
            }
            return synonymMap;
        });
    }

    public Map<String, ObOracleType> queryTypeMappingByGetDdl(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TYPE, this.sqlMapper.getSql("getTypes"));
        LinkedHashMap<String, ObOracleType> typeMap = new LinkedHashMap<String, ObOracleType>();
        for (String typeName : this.getConfigure().getWhiteListMap().get((Object)ObjectType.TYPE)) {
            Object[] args = new Object[]{typeName, this.getSchemaName()};
            String typeGrammar = this.jdbcTemplate.query(sql, args, rs -> {
                if (rs.next()) {
                    String grammar = rs.getString(1);
                    if (StringUtils.isEmpty(grammar)) {
                        return grammar;
                    }
                    int index = grammar.toLowerCase().indexOf("create or replace type body");
                    if (index > 0 && grammar.charAt(index - 2) == ')') {
                        StringBuilder sb = new StringBuilder(grammar.length() + 20);
                        sb.append(grammar, 0, index);
                        sb.append("$$").append("\n").append("DELIMITER ").append("$$").append("\n");
                        sb.append(grammar.substring(index));
                        return sb.toString();
                    }
                    return grammar;
                }
                return null;
            });
            ObOracleType type = new ObOracleType((ObOracleSchema)schema);
            type.setObjectName(typeName);
            type.setText(typeGrammar);
            typeMap.put(type.getObjectName(), type);
        }
        return typeMap;
    }

    public Map<String, ObOracleType> queryTypeMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TYPE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "TYPE", "VALID"} : new Object[]{this.getSchemaName(), "TYPE", "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
            while (rs.next()) {
                String objectName = rs.getString("NAME");
                StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                sb.append(rs.getString("TEXT"));
                builderMap.putIfAbsent(objectName, sb);
            }
            LinkedHashMap<String, ObOracleType> typeMap = new LinkedHashMap<String, ObOracleType>();
            for (Map.Entry entry : builderMap.entrySet()) {
                ObOracleType type = new ObOracleType((ObOracleSchema)schema);
                type.setObjectName((String)entry.getKey());
                type.setText(String.valueOf(entry.getValue()).trim());
                typeMap.put(type.getObjectName(), type);
            }
            builderMap.clear();
            return typeMap;
        });
    }

    public Map<String, ObOracleTypeBody> queryTypeBodyMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.TYPE_BODY, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "TYPE BODY", "VALID"} : new Object[]{this.getSchemaName(), "TYPE BODY", "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
            while (rs.next()) {
                String objectName = rs.getString("NAME");
                StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                sb.append(rs.getString("TEXT"));
                builderMap.putIfAbsent(objectName, sb);
            }
            LinkedHashMap<String, ObOracleTypeBody> typeMap = new LinkedHashMap<String, ObOracleTypeBody>();
            for (Map.Entry entry : builderMap.entrySet()) {
                ObOracleTypeBody type = new ObOracleTypeBody((ObOracleSchema)schema);
                type.setObjectName((String)entry.getKey());
                type.setText(String.valueOf(entry.getValue()).trim());
                typeMap.put(type.getObjectName(), type);
            }
            builderMap.clear();
            return typeMap;
        });
    }

    public Map<String, ObOraclePackage> queryPackageMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PACKAGE, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PACKAGE", "VALID"} : new Object[]{this.getSchemaName(), "PACKAGE", "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
            while (rs.next()) {
                String objectName = rs.getString("NAME");
                StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                sb.append(rs.getString("TEXT"));
                builderMap.putIfAbsent(objectName, sb);
            }
            LinkedHashMap<String, ObOraclePackage> packagieMap = new LinkedHashMap<String, ObOraclePackage>();
            for (Map.Entry entry : builderMap.entrySet()) {
                ObOraclePackage packagie = new ObOraclePackage((ObOracleSchema)schema);
                packagie.setObjectName((String)entry.getKey());
                packagie.setText(String.valueOf(entry.getValue()).trim());
                packagieMap.put(packagie.getObjectName(), packagie);
            }
            builderMap.clear();
            return packagieMap;
        });
    }

    public Map<String, ObOraclePackageBody> queryPackageBodyMapping(AbstractSchema schema) throws SQLException {
        String sql = this.bindings(ObjectType.PACKAGE_BODY, this.sqlMapper.getSql("getSource"));
        Object[] args = null;
        args = super.getGlobal().isValidOnly() ? new Object[]{this.getSchemaName(), "PACKAGE BODY", "VALID"} : new Object[]{this.getSchemaName(), "PACKAGE BODY", "%VALID"};
        return this.jdbcTemplate.queryMap(sql, args, rs -> {
            LinkedHashMap<String, StringBuilder> builderMap = new LinkedHashMap<String, StringBuilder>();
            while (rs.next()) {
                String objectName = rs.getString("NAME");
                StringBuilder sb = builderMap.getOrDefault(objectName, new StringBuilder());
                sb.append(rs.getString("TEXT"));
                builderMap.putIfAbsent(objectName, sb);
            }
            LinkedHashMap<String, ObOraclePackageBody> packageBodyMap = new LinkedHashMap<String, ObOraclePackageBody>();
            for (Map.Entry entry : builderMap.entrySet()) {
                ObOraclePackageBody packageBody = new ObOraclePackageBody((ObOracleSchema)schema);
                packageBody.setObjectName((String)entry.getKey());
                packageBody.setText(String.valueOf(entry.getValue()).trim());
                packageBodyMap.put(packageBody.getObjectName(), packageBody);
            }
            builderMap.clear();
            return packageBodyMap;
        });
    }
}

