/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractColumn;
import com.oceanbase.tools.loaddump.schema.AbstractSchema;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObMySqlColumn
extends AbstractColumn {
    private static final Logger log = LoggerFactory.getLogger(ObMySqlColumn.class);
    protected static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    private static final String BAD_SCALE = "-1";
    private static final Set<String> CHARACTER_DATA_TYPES = Sets.newHashSet((Object[])new String[]{"char", "varchar", "tinytext", "text", "mediumtext", "longtext", "enum", "set", "CHAR", "VARCHAR", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "ENUM", "SET"});
    private boolean defaultUdt = false;
    private Long characterMaximumLength;
    private Long characterOctetLength;
    private Integer numericPrecision;
    private Integer numericScale;
    private Integer dateTimePrecision;
    private String characterSetName;
    private String collationName;
    private String columnType;
    private String columnKey;
    private String extra;
    private String privileges;
    private String generationExpression;
    private String bitDefaultVal;
    private int prevColumnId;
    private boolean zerofill;
    private boolean onUpdateCurrentTimestamp;
    private String srsName;
    private Integer srsId;
    private String geometryTypeName;

    public ObMySqlColumn(AbstractSchema schema) {
        super(schema);
    }

    @Override
    public ObMySqlSchema getSchema() {
        return (ObMySqlSchema)super.getSchema();
    }

    public void setSchema(ObMySqlSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String originExpr;
        String originCollation;
        String columnType = this.getColumnType().trim().toLowerCase(Locale.getDefault());
        String originCharset = this.getCharacterSetName();
        if ("utf8".equalsIgnoreCase(originCharset)) {
            this.setCharacterSetName("utf8mb4");
        }
        if (StringUtils.startsWithIgnoreCase(originCollation = this.getCollationName(), "utf8")) {
            String targetCollation = originCollation.replace("utf8_", "utf8mb4_");
            if (StringUtils.startsWithIgnoreCase(targetCollation, "utf8mb4_") && StringUtils.endsWithIgnoreCase(targetCollation, "_ai_ci")) {
                this.setCollationName("utf8mb4_general_ci");
            } else {
                this.setCollationName(targetCollation);
            }
        }
        if ("FLOAT".equalsIgnoreCase(this.getDataType())) {
            int endIndex = columnType.indexOf(44);
            if (columnType.contains(BAD_SCALE) && endIndex > -1) {
                this.setColumnType(columnType.substring(0, endIndex) + ")");
            }
        }
        if (this.isZerofill() && !this.getColumnType().contains("zerofill")) {
            this.setColumnType(this.getColumnType() + " zerofill");
        }
        if (this.isOnUpdateCurrentTimestamp()) {
            StringBuilder sb = new StringBuilder();
            sb.append("on update current_timestamp");
            int beginIndex = columnType.indexOf(40);
            int endIndex = columnType.indexOf(41);
            if (beginIndex > -1 && endIndex > beginIndex) {
                sb.append("(").append(columnType.substring(beginIndex + 1, endIndex)).append(")");
            }
            this.setExtra(sb.toString());
        }
        String extra = this.getExtra();
        String expr = this.getGenerationExpression();
        if (StringUtils.isNotBlank(expr) && StringUtils.notEqualsIgnoreCase(originExpr = expr, expr = expr.replace("\\'", "'").replace("\\\\", "\\"))) {
            this.setGenerationExpression(expr);
        }
        if ("INVISIBLE".equalsIgnoreCase(extra) && StringUtils.isBlank(expr)) {
            this.setExtra(null);
        }
        return this.buildGrammarInternal();
    }

    public StringBuilder buildGrammarInternal() {
        String columnComment;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getWrappedName()).append(" ");
        String columnType = this.getColumnType();
        if (columnType == null) {
            Integer datetimePrecision;
            sb.append(this.getDataType());
            String dataType = this.getDataType().toUpperCase(Locale.getDefault());
            Integer numericScale = this.getNumericScale();
            Integer numericPrecision = this.getNumericPrecision();
            if ("DECIMAL".equals(dataType)) {
                sb.append("(").append(numericPrecision);
                if (numericScale != null && numericScale > 0) {
                    sb.append(",").append(numericScale);
                }
                sb.append(")");
            } else if ("FLOAT".equals(dataType) || "DOUBLE".equals(dataType)) {
                if (numericScale != null && numericScale > 0) {
                    sb.append("(").append(numericPrecision).append(",").append(numericScale).append(")");
                }
            } else if (("TIME".equals(dataType) || "DATETIME".equals(dataType) || "TIMESTAMP".equals(dataType)) && (datetimePrecision = this.getDateTimePrecision()) != null && datetimePrecision > 0) {
                sb.append("(").append(datetimePrecision).append(")");
            }
        } else {
            sb.append(columnType);
        }
        if (CHARACTER_DATA_TYPES.contains(this.getDataType())) {
            String collationName;
            String characterSet = this.getCharacterSetName();
            if (StringUtils.isNotBlank(characterSet)) {
                sb.append(" character set ").append(characterSet);
            }
            if ((collationName = this.getCollationName()) != null && !collationName.equalsIgnoreCase(characterSet)) {
                sb.append(" collate ").append(collationName);
            }
        }
        String extra = this.getExtra();
        String expr = this.getGenerationExpression();
        if (StringUtils.isNotBlank(expr)) {
            sb.append(" GENERATED ALWAYS AS ");
            sb.append("(").append(expr).append(")");
            if ("STORED GENERATED".equals(extra)) {
                sb.append(" STORED");
            } else if ("VIRTUAL GENERATED".equals(extra)) {
                sb.append(" VIRTUAL");
            }
        }
        if ("NO".equals(this.getNullable())) {
            sb.append(" not null");
        }
        if (this.srsId != null) {
            sb.append(" /*!80003 SRID ").append(this.srsId).append("*/");
        }
        sb.append((CharSequence)this.buildDefaultValue());
        if (StringUtils.isNotBlank(extra) && StringUtils.isBlank(expr) && StringUtils.isNotBlank(extra = extra.trim())) {
            sb.append(" ").append(extra);
        }
        if (StringUtils.isNotBlank(columnComment = this.getColumnComment())) {
            sb.append(" comment '").append(columnComment.replace("'", "''")).append("'");
        }
        return sb;
    }

    protected StringBuilder buildDefaultValue() {
        StringBuilder sb = new StringBuilder();
        String columnDefault = super.getColumnDefault();
        boolean isGenerated = this.isColumnDefaultGenerated();
        if (!isGenerated && columnDefault != null) {
            sb.append(" default ");
            if (this.isBuiltinFunction(columnDefault)) {
                if (CURRENT_TIMESTAMP.equalsIgnoreCase(columnDefault)) {
                    String columnType = this.getColumnType();
                    int beginIndex = columnType.indexOf(40);
                    int endIndex = columnType.indexOf(41);
                    if (beginIndex > -1 && endIndex > beginIndex) {
                        String precision = columnType.substring(beginIndex + 1, endIndex);
                        columnDefault = columnDefault + "(" + precision + ")";
                    }
                }
                sb.append(columnDefault);
            } else if (this.isColumnDefaultGenerated()) {
                sb.append("(").append(columnDefault.replace("'", "''")).append(")");
            } else if ("BIT".equalsIgnoreCase(this.getDataType())) {
                if (!DbType.OBMYSQL_211.isSubsequent(this.getOriginDbType())) {
                    sb.append(columnDefault);
                } else {
                    String fixedValue = this.getBitDefaultVal();
                    if (fixedValue != null) {
                        try {
                            fixedValue = Integer.toBinaryString(Integer.parseInt(fixedValue));
                            sb.append("b'").append(fixedValue).append("'");
                        }
                        catch (Exception ex) {
                            log.error("Convert column [{}] to binary value failed. Reason: {}", (Object)this.getColumnName(), (Object)ExceptionUtils.getRootCauseMessage(ex));
                        }
                    }
                }
            } else {
                sb.append("'").append(columnDefault.replace("'", "''")).append("'");
            }
        }
        if (columnDefault != null && columnDefault.contains("--")) {
            sb.append("\n");
        }
        return sb;
    }

    protected boolean isBuiltinFunction(String columnDefault) {
        return columnDefault == null || !JdbcType.isStringType(this.getDataType()) && columnDefault.trim().toUpperCase(Locale.getDefault()).startsWith(CURRENT_TIMESTAMP);
    }

    protected boolean isColumnDefaultGenerated() {
        String extra = this.getExtra();
        return StringUtils.isNotBlank(this.getGenerationExpression()) || StringUtils.isNotBlank(extra) && extra.toUpperCase(Locale.getDefault()).contains("DEFAULT_GENERATED");
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    public String toString() {
        return "ObMySqlColumn(defaultUdt=" + this.isDefaultUdt() + ", characterMaximumLength=" + this.getCharacterMaximumLength() + ", characterOctetLength=" + this.getCharacterOctetLength() + ", numericPrecision=" + this.getNumericPrecision() + ", numericScale=" + this.getNumericScale() + ", dateTimePrecision=" + this.getDateTimePrecision() + ", characterSetName=" + this.getCharacterSetName() + ", collationName=" + this.getCollationName() + ", columnType=" + this.getColumnType() + ", columnKey=" + this.getColumnKey() + ", extra=" + this.getExtra() + ", privileges=" + this.getPrivileges() + ", generationExpression=" + this.getGenerationExpression() + ", bitDefaultVal=" + this.getBitDefaultVal() + ", prevColumnId=" + this.getPrevColumnId() + ", zerofill=" + this.isZerofill() + ", onUpdateCurrentTimestamp=" + this.isOnUpdateCurrentTimestamp() + ", srsName=" + this.getSrsName() + ", srsId=" + this.getSrsId() + ", geometryTypeName=" + this.getGeometryTypeName() + ")";
    }

    public ObMySqlColumn() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlColumn)) {
            return false;
        }
        ObMySqlColumn other = (ObMySqlColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDefaultUdt() != other.isDefaultUdt()) {
            return false;
        }
        if (this.getPrevColumnId() != other.getPrevColumnId()) {
            return false;
        }
        if (this.isZerofill() != other.isZerofill()) {
            return false;
        }
        if (this.isOnUpdateCurrentTimestamp() != other.isOnUpdateCurrentTimestamp()) {
            return false;
        }
        Long this$characterMaximumLength = this.getCharacterMaximumLength();
        Long other$characterMaximumLength = other.getCharacterMaximumLength();
        if (this$characterMaximumLength == null ? other$characterMaximumLength != null : !((Object)this$characterMaximumLength).equals(other$characterMaximumLength)) {
            return false;
        }
        Long this$characterOctetLength = this.getCharacterOctetLength();
        Long other$characterOctetLength = other.getCharacterOctetLength();
        if (this$characterOctetLength == null ? other$characterOctetLength != null : !((Object)this$characterOctetLength).equals(other$characterOctetLength)) {
            return false;
        }
        Integer this$numericPrecision = this.getNumericPrecision();
        Integer other$numericPrecision = other.getNumericPrecision();
        if (this$numericPrecision == null ? other$numericPrecision != null : !((Object)this$numericPrecision).equals(other$numericPrecision)) {
            return false;
        }
        Integer this$numericScale = this.getNumericScale();
        Integer other$numericScale = other.getNumericScale();
        if (this$numericScale == null ? other$numericScale != null : !((Object)this$numericScale).equals(other$numericScale)) {
            return false;
        }
        Integer this$dateTimePrecision = this.getDateTimePrecision();
        Integer other$dateTimePrecision = other.getDateTimePrecision();
        if (this$dateTimePrecision == null ? other$dateTimePrecision != null : !((Object)this$dateTimePrecision).equals(other$dateTimePrecision)) {
            return false;
        }
        Integer this$srsId = this.getSrsId();
        Integer other$srsId = other.getSrsId();
        if (this$srsId == null ? other$srsId != null : !((Object)this$srsId).equals(other$srsId)) {
            return false;
        }
        String this$characterSetName = this.getCharacterSetName();
        String other$characterSetName = other.getCharacterSetName();
        if (this$characterSetName == null ? other$characterSetName != null : !this$characterSetName.equals(other$characterSetName)) {
            return false;
        }
        String this$collationName = this.getCollationName();
        String other$collationName = other.getCollationName();
        if (this$collationName == null ? other$collationName != null : !this$collationName.equals(other$collationName)) {
            return false;
        }
        String this$columnType = this.getColumnType();
        String other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
            return false;
        }
        String this$columnKey = this.getColumnKey();
        String other$columnKey = other.getColumnKey();
        if (this$columnKey == null ? other$columnKey != null : !this$columnKey.equals(other$columnKey)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        String this$privileges = this.getPrivileges();
        String other$privileges = other.getPrivileges();
        if (this$privileges == null ? other$privileges != null : !this$privileges.equals(other$privileges)) {
            return false;
        }
        String this$generationExpression = this.getGenerationExpression();
        String other$generationExpression = other.getGenerationExpression();
        if (this$generationExpression == null ? other$generationExpression != null : !this$generationExpression.equals(other$generationExpression)) {
            return false;
        }
        String this$bitDefaultVal = this.getBitDefaultVal();
        String other$bitDefaultVal = other.getBitDefaultVal();
        if (this$bitDefaultVal == null ? other$bitDefaultVal != null : !this$bitDefaultVal.equals(other$bitDefaultVal)) {
            return false;
        }
        String this$srsName = this.getSrsName();
        String other$srsName = other.getSrsName();
        if (this$srsName == null ? other$srsName != null : !this$srsName.equals(other$srsName)) {
            return false;
        }
        String this$geometryTypeName = this.getGeometryTypeName();
        String other$geometryTypeName = other.getGeometryTypeName();
        return !(this$geometryTypeName == null ? other$geometryTypeName != null : !this$geometryTypeName.equals(other$geometryTypeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlColumn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDefaultUdt() ? 79 : 97);
        result = result * 59 + this.getPrevColumnId();
        result = result * 59 + (this.isZerofill() ? 79 : 97);
        result = result * 59 + (this.isOnUpdateCurrentTimestamp() ? 79 : 97);
        Long $characterMaximumLength = this.getCharacterMaximumLength();
        result = result * 59 + ($characterMaximumLength == null ? 43 : ((Object)$characterMaximumLength).hashCode());
        Long $characterOctetLength = this.getCharacterOctetLength();
        result = result * 59 + ($characterOctetLength == null ? 43 : ((Object)$characterOctetLength).hashCode());
        Integer $numericPrecision = this.getNumericPrecision();
        result = result * 59 + ($numericPrecision == null ? 43 : ((Object)$numericPrecision).hashCode());
        Integer $numericScale = this.getNumericScale();
        result = result * 59 + ($numericScale == null ? 43 : ((Object)$numericScale).hashCode());
        Integer $dateTimePrecision = this.getDateTimePrecision();
        result = result * 59 + ($dateTimePrecision == null ? 43 : ((Object)$dateTimePrecision).hashCode());
        Integer $srsId = this.getSrsId();
        result = result * 59 + ($srsId == null ? 43 : ((Object)$srsId).hashCode());
        String $characterSetName = this.getCharacterSetName();
        result = result * 59 + ($characterSetName == null ? 43 : $characterSetName.hashCode());
        String $collationName = this.getCollationName();
        result = result * 59 + ($collationName == null ? 43 : $collationName.hashCode());
        String $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
        String $columnKey = this.getColumnKey();
        result = result * 59 + ($columnKey == null ? 43 : $columnKey.hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        String $privileges = this.getPrivileges();
        result = result * 59 + ($privileges == null ? 43 : $privileges.hashCode());
        String $generationExpression = this.getGenerationExpression();
        result = result * 59 + ($generationExpression == null ? 43 : $generationExpression.hashCode());
        String $bitDefaultVal = this.getBitDefaultVal();
        result = result * 59 + ($bitDefaultVal == null ? 43 : $bitDefaultVal.hashCode());
        String $srsName = this.getSrsName();
        result = result * 59 + ($srsName == null ? 43 : $srsName.hashCode());
        String $geometryTypeName = this.getGeometryTypeName();
        result = result * 59 + ($geometryTypeName == null ? 43 : $geometryTypeName.hashCode());
        return result;
    }

    public boolean isDefaultUdt() {
        return this.defaultUdt;
    }

    public void setDefaultUdt(boolean defaultUdt) {
        this.defaultUdt = defaultUdt;
    }

    public Long getCharacterMaximumLength() {
        return this.characterMaximumLength;
    }

    public void setCharacterMaximumLength(Long characterMaximumLength) {
        this.characterMaximumLength = characterMaximumLength;
    }

    public Long getCharacterOctetLength() {
        return this.characterOctetLength;
    }

    public void setCharacterOctetLength(Long characterOctetLength) {
        this.characterOctetLength = characterOctetLength;
    }

    public Integer getNumericPrecision() {
        return this.numericPrecision;
    }

    public void setNumericPrecision(Integer numericPrecision) {
        this.numericPrecision = numericPrecision;
    }

    public Integer getNumericScale() {
        return this.numericScale;
    }

    public void setNumericScale(Integer numericScale) {
        this.numericScale = numericScale;
    }

    public Integer getDateTimePrecision() {
        return this.dateTimePrecision;
    }

    public void setDateTimePrecision(Integer dateTimePrecision) {
        this.dateTimePrecision = dateTimePrecision;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public void setColumnKey(String columnKey) {
        this.columnKey = columnKey;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(String privileges) {
        this.privileges = privileges;
    }

    public String getGenerationExpression() {
        return this.generationExpression;
    }

    public void setGenerationExpression(String generationExpression) {
        this.generationExpression = generationExpression;
    }

    public String getBitDefaultVal() {
        return this.bitDefaultVal;
    }

    public void setBitDefaultVal(String bitDefaultVal) {
        this.bitDefaultVal = bitDefaultVal;
    }

    public int getPrevColumnId() {
        return this.prevColumnId;
    }

    public void setPrevColumnId(int prevColumnId) {
        this.prevColumnId = prevColumnId;
    }

    public boolean isZerofill() {
        return this.zerofill;
    }

    public void setZerofill(boolean zerofill) {
        this.zerofill = zerofill;
    }

    public boolean isOnUpdateCurrentTimestamp() {
        return this.onUpdateCurrentTimestamp;
    }

    public void setOnUpdateCurrentTimestamp(boolean onUpdateCurrentTimestamp) {
        this.onUpdateCurrentTimestamp = onUpdateCurrentTimestamp;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public Integer getSrsId() {
        return this.srsId;
    }

    public void setSrsId(Integer srsId) {
        this.srsId = srsId;
    }

    public String getGeometryTypeName() {
        return this.geometryTypeName;
    }

    public void setGeometryTypeName(String geometryTypeName) {
        this.geometryTypeName = geometryTypeName;
    }
}

