/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.schema.obmysql;

import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.exception.UnsupportedGrammarException;
import com.oceanbase.tools.loaddump.schema.AbstractTablePartition;
import com.oceanbase.tools.loaddump.schema.obmysql.ObMySqlSchema;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

public class ObMySqlTablePartition
extends AbstractTablePartition {
    public static final int PART_LEVEL_1 = new Integer(1);
    public static final int PART_LEVEL_2 = new Integer(2);
    private static final Set<String> SUPPORTED_PARTITION_METHODS = Sets.newHashSet();
    private final Collection<MySqlPartitionItem> tablePartitions = new LinkedHashSet<MySqlPartitionItem>();
    private final Map<String, List<MySqlPartitionItem>> tableSubPartitionMapping = new LinkedHashMap<String, List<MySqlPartitionItem>>();
    private String partitionMethod;
    private String partitionExpression;
    private String subPartitionMethod;
    private String subPartitionExpression;
    private Set<String> columnSet;
    private int partNum;
    private int subPartNum;
    private int partLevel;
    private boolean subPartTemplate;

    public ObMySqlTablePartition(ObMySqlSchema schema) {
        super(schema);
    }

    @Override
    public ObMySqlSchema getSchema() {
        return (ObMySqlSchema)super.getSchema();
    }

    public void setSchema(ObMySqlSchema schema) {
        super.setSchema(schema);
    }

    @Override
    public String getQuotaCharacter() {
        return "`";
    }

    @Override
    public StringBuilder buildGrammar() throws UnsupportedGrammarException {
        String partMethod = this.getPartTypeMapping().get(this.getPartitionMethod());
        this.checkPartitionMethod(partMethod);
        String originPartMethod = partMethod;
        if ("LINEAR KEY".equals(partMethod)) {
            partMethod = "KEY";
        } else if ("LINEAR HASH".equals(partMethod)) {
            partMethod = "HASH";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("PARTITION BY ").append(partMethod);
        sb.append((CharSequence)this.enclose(this.getPartitionExpression()));
        Collection<MySqlPartitionItem> partitionItems = this.getTablePartitions();
        boolean isCompositePartitioned = this.isCompositePartitioned();
        boolean isPrior2271 = super.getDbType().isPrior(DbType.OBMYSQL_2271);
        boolean isKeyHashPart = partMethod.contains("KEY") || partMethod.contains("HASH");
        DbType originDbType = this.getOriginDbType();
        boolean isOriginPrior2271 = DbType.OBMYSQL_14.getType().equals(originDbType.getType()) && DbType.OBMYSQL_2271.isSubsequent(originDbType);
        boolean isOriginSubsequent40 = DbType.OBMYSQL_14.getType().equals(originDbType.getType()) && DbType.OBMYSQL_40.isPriorFrom(originDbType);
        Map<String, String> partFormatMap = super.getTablePartTemplateMapping();
        partFormatMap.put("LIST", partFormatMap.get("LIST COLUMNS"));
        String partFormat = partFormatMap.get(partMethod);
        StringBuilder prev = new StringBuilder();
        StringBuilder post = new StringBuilder();
        if (StringUtils.notEqualsIgnoreCase(originPartMethod, partMethod)) {
            prev.append("partition by ").append(originPartMethod);
            post.append("partition by ").append(partMethod);
        }
        String subPartMethod = super.getPartTypeMapping().get(this.getSubPartitionMethod());
        if (isCompositePartitioned) {
            String originSubPartMethod = subPartMethod;
            if ("LINEAR KEY".equals(subPartMethod)) {
                subPartMethod = "KEY";
            } else if ("LINEAR HASH".equals(subPartMethod)) {
                subPartMethod = "HASH";
            }
            if (StringUtils.notEquals(originSubPartMethod, subPartMethod)) {
                prev.append(" ... subpartition by ").append(originSubPartMethod);
                post.append(" ... subpartition by ").append(subPartMethod);
            }
        }
        Map<String, String> subPartFormatMap = super.getTableSubPartTemplateMapping();
        subPartFormatMap.put("LIST", subPartFormatMap.get("LIST COLUMNS"));
        String subPartFormat = subPartFormatMap.get(subPartMethod);
        Map<String, List<MySqlPartitionItem>> subPartMap = this.getTableSubPartitionMapping();
        boolean isKeyHashSubPart = false;
        boolean isSubPartitionsN = false;
        if (isCompositePartitioned) {
            boolean bl = isKeyHashSubPart = subPartMethod.contains("KEY") || subPartMethod.contains("HASH");
            if (StringUtils.isNotBlank(subPartMethod)) {
                this.checkPartitionMethod(subPartMethod);
                sb.append("\n").append("SUBPARTITION BY ").append(subPartMethod);
                sb.append((CharSequence)this.enclose(this.getSubPartitionExpression()));
            }
            if (isOriginPrior2271 && isKeyHashSubPart) {
                this.setSubPartTemplate(false);
            }
            if (isKeyHashSubPart && (isPrior2271 || !this.isSubPartTemplate() && this.withEqualSubPartCount())) {
                sb.append("\n").append("SUBPARTITIONS ");
                if (MapUtils.isEmpty(subPartMap) && this.getSubPartNum() > 0) {
                    sb.append(this.getSubPartNum());
                } else {
                    sb.append(subPartMap.values().iterator().next().size());
                }
                isSubPartitionsN = true;
            }
            if (!isSubPartitionsN && (!isPrior2271 && this.isSubPartTemplate() || isPrior2271 && !isKeyHashSubPart || isOriginPrior2271 && this.isSubPartTemplate())) {
                String partId = String.valueOf("-1");
                if (isOriginSubsequent40) {
                    partId = String.valueOf("1");
                }
                List<MySqlPartitionItem> subPartItems = subPartMap.get(partId);
                sb.append("\n").append("SUBPARTITION TEMPLATE (");
                Iterator<MySqlPartitionItem> subPartIter = subPartItems.iterator();
                while (subPartIter.hasNext()) {
                    MySqlPartitionItem subPartItem = subPartIter.next();
                    String subPartName = subPartItem.getSubPartitionName();
                    int index = subPartName.indexOf(115);
                    if (index != -1) {
                        subPartName = subPartName.substring(index + 1);
                    }
                    String subPartDesc = subPartItem.getPartitionDescription();
                    sb.append("\n\t");
                    if (isKeyHashSubPart) {
                        sb.append(String.format(subPartFormat, this.wrap(subPartName)));
                    } else {
                        sb.append(String.format(subPartFormat, this.wrap(subPartName), subPartDesc));
                    }
                    if (!subPartIter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n").append(")");
            }
        }
        boolean isNoneSubPartTemplate = !isPrior2271 || !isKeyHashSubPart;
        sb.append("\n").append("(");
        boolean isSubPartDefined = MapUtils.isNotEmpty(subPartMap) & !subPartMap.containsKey("-1");
        Iterator<MySqlPartitionItem> partIter = partitionItems.iterator();
        while (partIter.hasNext()) {
            MySqlPartitionItem partItem = partIter.next();
            String partName = partItem.getPartitionName();
            String partId = String.valueOf(partItem.getPartitionOrdinalPosition());
            sb.append("\n\t");
            if (isKeyHashPart) {
                sb.append(String.format(partFormat, this.wrap(partName)));
            } else {
                String partDesc = partItem.getPartitionDescription();
                sb.append(String.format(partFormat, this.wrap(partName), partDesc));
            }
            if (isCompositePartitioned && !this.isSubPartTemplate() && isNoneSubPartTemplate && isSubPartDefined && !isSubPartitionsN) {
                List<MySqlPartitionItem> subPartItems = subPartMap.get(partId);
                sb.append("\n\t").append("(");
                Iterator<MySqlPartitionItem> subPartIter = subPartItems.iterator();
                while (subPartIter.hasNext()) {
                    MySqlPartitionItem subPartItem = subPartIter.next();
                    String subPartName = this.wrap(subPartItem.getSubPartitionName());
                    sb.append("\n\t\t");
                    if (isKeyHashSubPart) {
                        sb.append(String.format(subPartFormat, this.wrap(subPartName)));
                    } else {
                        String subPartDesc = subPartItem.getPartitionDescription();
                        sb.append(String.format(subPartFormat, this.wrap(subPartName), subPartDesc));
                    }
                    if (!subPartIter.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n\t").append(")");
            }
            if (!partIter.hasNext()) continue;
            sb.append(",");
        }
        return sb.append("\n").append(")");
    }

    public boolean isCompositePartitioned() {
        return this.getPartLevel() > PART_LEVEL_1 || StringUtils.isNotBlank(this.getSubPartitionMethod()) && StringUtils.isNotBlank(this.getSubPartitionExpression());
    }

    private boolean withEqualSubPartCount() {
        Map<String, List<MySqlPartitionItem>> subPartMap = this.getTableSubPartitionMapping();
        if (MapUtils.isEmpty(subPartMap)) {
            return false;
        }
        int count = subPartMap.values().iterator().next().size();
        for (List<MySqlPartitionItem> items : subPartMap.values()) {
            if (items.size() == count) continue;
            return false;
        }
        return true;
    }

    private void checkPartitionMethod(String partitionMethod) throws UnsupportedGrammarException {
        if (!SUPPORTED_PARTITION_METHODS.contains(partitionMethod)) {
            throw new UnsupportedGrammarException(this.getOriginSchemaObjectName(), "The table partition type: " + partitionMethod + " is unsupported");
        }
    }

    @Override
    public String toString() {
        return "ObMySqlTablePartition(tablePartitions=" + this.getTablePartitions() + ", tableSubPartitionMapping=" + this.getTableSubPartitionMapping() + ", partitionMethod=" + this.getPartitionMethod() + ", partitionExpression=" + this.getPartitionExpression() + ", subPartitionMethod=" + this.getSubPartitionMethod() + ", subPartitionExpression=" + this.getSubPartitionExpression() + ", columnSet=" + this.getColumnSet() + ", partNum=" + this.getPartNum() + ", subPartNum=" + this.getSubPartNum() + ", partLevel=" + this.getPartLevel() + ", subPartTemplate=" + this.isSubPartTemplate() + ")";
    }

    public ObMySqlTablePartition() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObMySqlTablePartition)) {
            return false;
        }
        ObMySqlTablePartition other = (ObMySqlTablePartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPartNum() != other.getPartNum()) {
            return false;
        }
        if (this.getSubPartNum() != other.getSubPartNum()) {
            return false;
        }
        if (this.getPartLevel() != other.getPartLevel()) {
            return false;
        }
        if (this.isSubPartTemplate() != other.isSubPartTemplate()) {
            return false;
        }
        Collection<MySqlPartitionItem> this$tablePartitions = this.getTablePartitions();
        Collection<MySqlPartitionItem> other$tablePartitions = other.getTablePartitions();
        if (this$tablePartitions == null ? other$tablePartitions != null : !((Object)this$tablePartitions).equals(other$tablePartitions)) {
            return false;
        }
        Map<String, List<MySqlPartitionItem>> this$tableSubPartitionMapping = this.getTableSubPartitionMapping();
        Map<String, List<MySqlPartitionItem>> other$tableSubPartitionMapping = other.getTableSubPartitionMapping();
        if (this$tableSubPartitionMapping == null ? other$tableSubPartitionMapping != null : !((Object)this$tableSubPartitionMapping).equals(other$tableSubPartitionMapping)) {
            return false;
        }
        String this$partitionMethod = this.getPartitionMethod();
        String other$partitionMethod = other.getPartitionMethod();
        if (this$partitionMethod == null ? other$partitionMethod != null : !this$partitionMethod.equals(other$partitionMethod)) {
            return false;
        }
        String this$partitionExpression = this.getPartitionExpression();
        String other$partitionExpression = other.getPartitionExpression();
        if (this$partitionExpression == null ? other$partitionExpression != null : !this$partitionExpression.equals(other$partitionExpression)) {
            return false;
        }
        String this$subPartitionMethod = this.getSubPartitionMethod();
        String other$subPartitionMethod = other.getSubPartitionMethod();
        if (this$subPartitionMethod == null ? other$subPartitionMethod != null : !this$subPartitionMethod.equals(other$subPartitionMethod)) {
            return false;
        }
        String this$subPartitionExpression = this.getSubPartitionExpression();
        String other$subPartitionExpression = other.getSubPartitionExpression();
        if (this$subPartitionExpression == null ? other$subPartitionExpression != null : !this$subPartitionExpression.equals(other$subPartitionExpression)) {
            return false;
        }
        Set<String> this$columnSet = this.getColumnSet();
        Set<String> other$columnSet = other.getColumnSet();
        return !(this$columnSet == null ? other$columnSet != null : !((Object)this$columnSet).equals(other$columnSet));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObMySqlTablePartition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPartNum();
        result = result * 59 + this.getSubPartNum();
        result = result * 59 + this.getPartLevel();
        result = result * 59 + (this.isSubPartTemplate() ? 79 : 97);
        Collection<MySqlPartitionItem> $tablePartitions = this.getTablePartitions();
        result = result * 59 + ($tablePartitions == null ? 43 : ((Object)$tablePartitions).hashCode());
        Map<String, List<MySqlPartitionItem>> $tableSubPartitionMapping = this.getTableSubPartitionMapping();
        result = result * 59 + ($tableSubPartitionMapping == null ? 43 : ((Object)$tableSubPartitionMapping).hashCode());
        String $partitionMethod = this.getPartitionMethod();
        result = result * 59 + ($partitionMethod == null ? 43 : $partitionMethod.hashCode());
        String $partitionExpression = this.getPartitionExpression();
        result = result * 59 + ($partitionExpression == null ? 43 : $partitionExpression.hashCode());
        String $subPartitionMethod = this.getSubPartitionMethod();
        result = result * 59 + ($subPartitionMethod == null ? 43 : $subPartitionMethod.hashCode());
        String $subPartitionExpression = this.getSubPartitionExpression();
        result = result * 59 + ($subPartitionExpression == null ? 43 : $subPartitionExpression.hashCode());
        Set<String> $columnSet = this.getColumnSet();
        result = result * 59 + ($columnSet == null ? 43 : ((Object)$columnSet).hashCode());
        return result;
    }

    public Collection<MySqlPartitionItem> getTablePartitions() {
        return this.tablePartitions;
    }

    public Map<String, List<MySqlPartitionItem>> getTableSubPartitionMapping() {
        return this.tableSubPartitionMapping;
    }

    public String getPartitionMethod() {
        return this.partitionMethod;
    }

    public void setPartitionMethod(String partitionMethod) {
        this.partitionMethod = partitionMethod;
    }

    public String getPartitionExpression() {
        return this.partitionExpression;
    }

    public void setPartitionExpression(String partitionExpression) {
        this.partitionExpression = partitionExpression;
    }

    public String getSubPartitionMethod() {
        return this.subPartitionMethod;
    }

    public void setSubPartitionMethod(String subPartitionMethod) {
        this.subPartitionMethod = subPartitionMethod;
    }

    public String getSubPartitionExpression() {
        return this.subPartitionExpression;
    }

    public void setSubPartitionExpression(String subPartitionExpression) {
        this.subPartitionExpression = subPartitionExpression;
    }

    public Set<String> getColumnSet() {
        return this.columnSet;
    }

    public void setColumnSet(Set<String> columnSet) {
        this.columnSet = columnSet;
    }

    public int getPartNum() {
        return this.partNum;
    }

    public void setPartNum(int partNum) {
        this.partNum = partNum;
    }

    public int getSubPartNum() {
        return this.subPartNum;
    }

    public void setSubPartNum(int subPartNum) {
        this.subPartNum = subPartNum;
    }

    public int getPartLevel() {
        return this.partLevel;
    }

    public void setPartLevel(int partLevel) {
        this.partLevel = partLevel;
    }

    public boolean isSubPartTemplate() {
        return this.subPartTemplate;
    }

    public void setSubPartTemplate(boolean subPartTemplate) {
        this.subPartTemplate = subPartTemplate;
    }

    static {
        SUPPORTED_PARTITION_METHODS.add("KEY");
        SUPPORTED_PARTITION_METHODS.add("LINEAR KEY");
        SUPPORTED_PARTITION_METHODS.add("HASH");
        SUPPORTED_PARTITION_METHODS.add("LINEAR HASH");
        SUPPORTED_PARTITION_METHODS.add("LIST");
        SUPPORTED_PARTITION_METHODS.add("LIST COLUMNS");
        SUPPORTED_PARTITION_METHODS.add("RANGE");
        SUPPORTED_PARTITION_METHODS.add("RANGE COLUMNS");
    }

    public static class MySqlPartitionItem {
        private String partitionName;
        private String subPartitionName;
        private Integer partitionOrdinalPosition;
        private Integer subPartitionOrdinalPosition;
        private String partitionDescription;
        private String partitionComment;
        private String tablespaceName;

        public int hashCode() {
            return Objects.hash(this.getPartitionName(), this.getPartitionOrdinalPosition(), this.getSubPartitionName(), this.getSubPartitionOrdinalPosition(), this.getPartitionDescription(), this.getPartitionComment());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MySqlPartitionItem)) {
                return false;
            }
            MySqlPartitionItem other = (MySqlPartitionItem)obj;
            return Objects.equals(this.getPartitionName(), other.getPartitionName()) && Objects.equals(this.getPartitionOrdinalPosition(), other.getPartitionOrdinalPosition()) && Objects.equals(this.getSubPartitionName(), other.getSubPartitionName()) && Objects.equals(this.getSubPartitionOrdinalPosition(), other.getSubPartitionOrdinalPosition()) && Objects.equals(this.getPartitionDescription(), other.getPartitionDescription()) && Objects.equals(this.getPartitionComment(), other.getPartitionComment());
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public void setPartitionName(String partitionName) {
            this.partitionName = partitionName;
        }

        public String getSubPartitionName() {
            return this.subPartitionName;
        }

        public void setSubPartitionName(String subPartitionName) {
            this.subPartitionName = subPartitionName;
        }

        public Integer getPartitionOrdinalPosition() {
            return this.partitionOrdinalPosition;
        }

        public void setPartitionOrdinalPosition(Integer partitionOrdinalPosition) {
            this.partitionOrdinalPosition = partitionOrdinalPosition;
        }

        public Integer getSubPartitionOrdinalPosition() {
            return this.subPartitionOrdinalPosition;
        }

        public void setSubPartitionOrdinalPosition(Integer subPartitionOrdinalPosition) {
            this.subPartitionOrdinalPosition = subPartitionOrdinalPosition;
        }

        public String getPartitionDescription() {
            return this.partitionDescription;
        }

        public void setPartitionDescription(String partitionDescription) {
            this.partitionDescription = partitionDescription;
        }

        public String getPartitionComment() {
            return this.partitionComment;
        }

        public void setPartitionComment(String partitionComment) {
            this.partitionComment = partitionComment;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public void setTablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
        }
    }
}

