/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.ObPartIdCalculator;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.parser.record.Record;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);

    public static Long calculatePartitionId(TableInfo tableInfo, ObPartIdCalculator calculator, Record record) {
        TableEntry tableEntry = calculator.getTableEntry();
        if (calculator.isPublicCloud() || tableEntry == null || tableEntry.isNonPartitionTable()) {
            return 0L;
        }
        try {
            Long partitionId;
            int fieldIndex;
            int metaIndex;
            ObTablePart tablePart = tableEntry.getTablePart();
            Object[] objects = new Object[record.size()];
            if (tablePart.getLevel().getIndex() > ObPartLevel.LEVEL_ZERO.getIndex()) {
                for (ObPartColumn partColumn : tablePart.getPartColumns()) {
                    metaIndex = partColumn.getColumnIndex();
                    fieldIndex = tableInfo.getLogicOffset(partColumn.getColumnName());
                    objects[metaIndex] = record.getValues().get(fieldIndex);
                }
            }
            if (tablePart.getLevel().getIndex() >= ObPartLevel.LEVEL_TWO.getIndex()) {
                for (ObPartColumn subPartColumn : tablePart.getSubPartColumns()) {
                    metaIndex = subPartColumn.getColumnIndex();
                    fieldIndex = tableInfo.getLogicOffset(subPartColumn.getColumnName());
                    objects[metaIndex] = record.getValues().get(fieldIndex);
                }
            }
            return (partitionId = calculator.calculatePartId(objects)) == null ? Long.MIN_VALUE : partitionId;
        }
        catch (Exception e) {
            log.warn("Calculate partition id failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            return Long.MIN_VALUE;
        }
    }

    public static List<String> toCaseInsensitiveNamesList(ServerMode serverMode, Collection<String> tableNames) {
        if (CollectionUtils.isEmpty(tableNames)) {
            return Lists.newArrayList();
        }
        return tableNames.stream().map(e -> DBUtils.extractObjectName(e.trim(), serverMode)).collect(Collectors.toList());
    }

    public static Collection<String> toCaseInsensitiveCollections(ServerMode serverMode, Collection<String> tableNames, Supplier<Collection<String>> collectionFactory) {
        if (CollectionUtils.isEmpty(tableNames)) {
            return collectionFactory.get();
        }
        return tableNames.stream().map(e -> DBUtils.extractObjectName(e.trim(), serverMode)).collect(Collectors.toCollection(collectionFactory));
    }

    public static String extractObjectName(String objectName, ServerMode serverMode) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(objectName), (Object)"Input object name is null");
        String trimmedName = objectName.trim();
        char c1 = trimmedName.charAt(0);
        char cn = trimmedName.charAt(trimmedName.length() - 1);
        if (c1 == '`' && cn == '`' || c1 == '[' && cn == ']' || c1 == '\"' && cn == '\"') {
            return trimmedName.substring(1, trimmedName.length() - 1);
        }
        return serverMode == null ? trimmedName : serverMode.toCaseSensitiveName(trimmedName);
    }

    public static List<Set<String>> splitObjectNames(Collection<String> objectNames, ServerMode serverMode) {
        ArrayList<Set<String>> groupList = new ArrayList<Set<String>>(2);
        groupList.add(objectNames.stream().filter(e -> e.contains("*")).map(e -> "^" + e.replaceAll("\\*", ".*") + "$").collect(Collectors.toSet()));
        groupList.add(objectNames.stream().filter(e -> !e.contains("*")).collect(Collectors.toSet()));
        return groupList;
    }

    public static String wrapWhereClause(String whereClause) {
        return StringUtils.isBlank(whereClause) ? null : "(" + whereClause + ")";
    }
}

