/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.concurrent.ExecutorTemplate;
import com.oceanbase.tools.loaddump.divider.CsvFileDivider;
import com.oceanbase.tools.loaddump.divider.SqlFileDivider;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvRecordParser;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import com.oceanbase.tools.loaddump.utils.ArrayUtils;
import com.oceanbase.tools.loaddump.utils.CharUtils;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils
extends org.apache.commons.io.FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final String DEFAULT_LINE_SEPARATOR = System.lineSeparator();
    private static final boolean IS_NEWLINE_ON_WINDOWS = "\r\n".equals(DEFAULT_LINE_SEPARATOR);
    static final String[] STORAGE_CAPACITY_UNIT = new String[]{" B", " KB", " MB", " GB", " TB", " PB", " EB"};

    private FileUtils() {
    }

    public static String getSimpleFileName(String filePath) {
        int index = filePath.lastIndexOf(File.separatorChar);
        return index > 0 ? filePath.substring(index + 1) : filePath;
    }

    public static String getFileNameWithoutSuffix(String filePath) {
        String fileName = FileUtils.getSimpleFileName(filePath);
        int index = fileName.lastIndexOf(46);
        return index > 0 ? fileName.substring(0, index) : fileName;
    }

    public static String getFilePathWithoutSuffix(String filePath) {
        int index = filePath.lastIndexOf(46);
        return index > 0 ? filePath.substring(0, index) : filePath;
    }

    public static String getFileNameWithoutSuffix(File file) {
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        return index > 0 ? fileName.substring(0, index) : fileName;
    }

    public static String getParentDirectoryName(String filePath) {
        int index = filePath.lastIndexOf(File.separatorChar);
        return index >= 0 ? filePath.substring(0, index) : filePath;
    }

    public static long getSize(String filePath) {
        return FileUtils.getSize(new File(filePath));
    }

    /*
     * Exception decompiling
     */
    public static long getSize(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean mkdir(String path, String name) {
        File file = new File(path);
        String dirName = path + File.separator + name;
        if (file.isFile()) {
            String parentDir = FileUtils.getParentDirectoryName(path);
            dirName = parentDir + File.separator + name;
        }
        return !(file = new File(dirName)).exists() && file.mkdir();
    }

    public static void checkValidFile(File file) {
        Preconditions.checkArgument((boolean)file.exists(), (String)"File: \"%s\" is not exists", (Object)file.getAbsolutePath());
        Preconditions.checkArgument((!file.isHidden() ? 1 : 0) != 0, (String)"File: \"%s\" is hidden", (Object)file.getAbsolutePath());
        Preconditions.checkArgument((boolean)file.canRead(), (String)"File: \"%s\" cannot be read", (Object)file.getAbsolutePath());
        Preconditions.checkArgument((boolean)file.isFile(), (String)"File: \"%s\" is not a file", (Object)file.getAbsolutePath());
    }

    public static void checkValidDirectory(File dir) {
        Preconditions.checkArgument((boolean)dir.exists(), (String)"Dir: \"%s\" is not exists", (Object)dir.getAbsolutePath());
        Preconditions.checkArgument((!dir.isHidden() ? 1 : 0) != 0, (String)"Dir: \"%s\" is hidden", (Object)dir.getAbsolutePath());
        Preconditions.checkArgument((boolean)dir.canRead(), (String)"Dir: \"%s\" cannot be read", (Object)dir.getAbsolutePath());
        Preconditions.checkArgument((boolean)dir.isDirectory(), (String)"Dir: \"%s\" is not a directory", (Object)dir.getAbsolutePath());
    }

    public static void checkValidLocalPath(File file) {
        Preconditions.checkArgument((boolean)file.exists(), (String)"File: \"%s\" is not exists", (Object)file.getAbsolutePath());
        Preconditions.checkArgument((!file.isHidden() ? 1 : 0) != 0, (String)"File: \"%s\" is hidden", (Object)file.getAbsolutePath());
        Preconditions.checkArgument((boolean)file.canRead(), (String)"File: \"%s\" cannot be read", (Object)file.getAbsolutePath());
    }

    public static String toPath(String ... args) {
        String parent = args[0].trim();
        if (parent.endsWith(File.separator) && args.length > 1) {
            parent = parent.substring(0, parent.length() - File.separator.length());
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(parent);
        for (int i = 1; i < args.length; ++i) {
            String part = args[i];
            if (!part.startsWith(File.separator)) {
                part = File.separator + part;
            } else if (part.endsWith(File.separator)) {
                part = part.substring(0, part.length() - File.separator.length());
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static boolean isDirEmpty(String dirPath) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(dirPath), (Object)"Input directory is null");
        File dir = new File(dirPath);
        return CollectionUtils.isEmpty((Collection)FileUtils.listFiles((File)dir, (IOFileFilter)HiddenFileFilter.VISIBLE, (IOFileFilter)EmptyFileFilter.NOT_EMPTY));
    }

    public static List<SubFile> splitSqlFileSafely(ResourceV2 resource, long blockSize) throws Exception {
        return new SqlFileDivider(resource, blockSize).divideFile();
    }

    public static List<SubFile> splitCsvFileSafely(ResourceV2 resource, long blockSize, CsvFormat csvFormat) throws Exception {
        return new CsvFileDivider(resource, blockSize, csvFormat).divideFile();
    }

    public static List<SubFile> splitTxtFileUnsafely(ResourceV2 resource, long blockSize, DataFormat dataFormat, boolean skipHeader, boolean skipFooter, String lineSeparator) throws Exception {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"Input resource is null");
        String table = resource.getObjectName();
        String path = resource.getPath();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(table), (Object)"Input table is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(path), (Object)("Input file path is null. Table: " + table));
        Preconditions.checkArgument((blockSize >= 1L ? 1 : 0) != 0, (Object)("Invalid block size: " + blockSize + ". Table: " + table));
        try (RandomAccessFile raf = new RandomAccessFile(new File(path), "r");){
            long length = raf.length();
            if (length <= blockSize) {
                SubFile subFile = new SubFile(resource, 0, 0L, length, dataFormat);
                subFile.setSkipHeader(skipHeader);
                subFile.setSkipFooter(skipFooter);
                ArrayList arrayList = Lists.newArrayList((Object[])new SubFile[]{subFile});
                return arrayList;
            }
            ArrayList<SubFile> subFiles = new ArrayList<SubFile>();
            int index = 1;
            long startPos = 0L;
            long nextPos = 0L;
            while ((nextPos = blockSize + startPos) < length) {
                raf.seek(nextPos);
                int ch = -1;
                while ((ch = raf.read()) != -1) {
                    if (!FileUtils.isEndOfLineForCut(ch, raf, length, lineSeparator)) continue;
                    long currPos = raf.getFilePointer();
                    subFiles.add(new SubFile(resource, index++, startPos, currPos, dataFormat));
                    startPos = currPos;
                    break;
                }
                if (ch != -1) continue;
                break;
            }
            if (startPos < length) {
                subFiles.add(new SubFile(resource, index++, startPos, length, dataFormat));
            }
            if (!subFiles.isEmpty()) {
                ((SubFile)subFiles.get(0)).setSkipHeader(skipHeader);
                ((SubFile)subFiles.get(subFiles.size() - 1)).setSkipFooter(skipFooter);
            }
            log.info("File: \"{}\" has been splitted into {} copies", (Object)path, (Object)subFiles.size());
            ArrayList<SubFile> arrayList = subFiles;
            return arrayList;
        }
    }

    public static List<SubFile> splitCsvFileUnsafely(ResourceV2 resource, long blockSize, CsvFormat csvFormat) throws Exception {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"Input resource is null");
        String table = resource.getObjectName();
        String path = resource.getPath();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(table), (Object)"Input table is null");
        Preconditions.checkArgument((csvFormat != null ? 1 : 0) != 0, (Object)("Input CsvFormat is null. Table: " + table));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(path), (Object)("Input file path is null. Table: " + table));
        Preconditions.checkArgument((blockSize >= 1L ? 1 : 0) != 0, (Object)("Invalid block size: " + blockSize + ". Table: " + table));
        if (!csvFormat.getSkipHeaderRecord() && ArrayUtils.isEmpty(csvFormat.getHeader())) {
            throw new IllegalArgumentException("The header of CSVFormat is null");
        }
        try (RandomAccessFile raf = new RandomAccessFile(new File(path), "r");){
            long length;
            ArrayList<String> headers = new ArrayList<String>();
            if (csvFormat.getSkipHeaderRecord()) {
                try (CsvRecordParser parser = csvFormat.parse(new FileReader(path));){
                    headers.addAll(parser.getHeaderNames());
                }
            } else if (csvFormat.getHeader() != null) {
                headers.addAll(Lists.newArrayList((Object[])csvFormat.getHeader()));
            }
            if ((length = raf.length()) <= blockSize) {
                SubFile subFile = new SubFile(resource, 0, 0L, length, DataFormat.CSV);
                subFile.setHeaders(headers);
                if (log.isDebugEnabled()) {
                    log.debug("File: \"{}\" has not been splitted. {} < {}", new Object[]{path, length, blockSize});
                }
                ArrayList arrayList = Lists.newArrayList((Object[])new SubFile[]{subFile});
                return arrayList;
            }
            char escapeChar = csvFormat.getEscapeCharacter().charValue();
            ArrayList<SubFile> subFiles = new ArrayList<SubFile>();
            int index = 1;
            long startPos = 0L;
            long nextPos = 0L;
            while ((nextPos = startPos + blockSize) < length) {
                raf.seek(nextPos);
                char c = '\uffffffff';
                while ((c = raf.read()) != '\uffffffff') {
                    if (!FileUtils.isEndOfLine(c, raf, length)) continue;
                    long currPos = raf.getFilePointer();
                    raf.seek(currPos - 1L);
                    c = raf.read();
                    if (c != escapeChar) {
                        SubFile subFile = new SubFile(resource, index++, startPos, currPos, DataFormat.CSV);
                        subFile.setHeaders(headers);
                        subFiles.add(subFile);
                        startPos = currPos;
                        break;
                    }
                    raf.seek(currPos);
                }
                if (c != -1) continue;
                break;
            }
            if (startPos < length) {
                SubFile subFile = new SubFile(resource, index++, startPos, length, DataFormat.CSV);
                subFile.setHeaders(headers);
                subFiles.add(subFile);
            }
            log.info("File: \"{}\" has been splitted into {} copies", (Object)path, (Object)subFiles.size());
            ArrayList<SubFile> arrayList = subFiles;
            return arrayList;
        }
    }

    public static List<SubFile> splitSqlFileUnsafely(ResourceV2 resource, long blockSize) throws Exception {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"Input resource is null");
        String table = resource.getObjectName();
        String path = resource.getPath();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(table), (Object)"Input table is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(path), (Object)("Input file path is null. Table: " + table));
        Preconditions.checkArgument((blockSize >= 1L ? 1 : 0) != 0, (Object)("Invalid block size: " + blockSize + ". Table: " + table));
        try (RandomAccessFile raf = new RandomAccessFile(new File(path), "r");){
            long length = raf.length();
            if (length <= blockSize) {
                log.debug("File: \"{}\" has not been splitted. {} < {}", new Object[]{path, length, blockSize});
                ArrayList arrayList = Lists.newArrayList((Object[])new SubFile[]{new SubFile(resource, 0, 0L, length, DataFormat.SQL)});
                return arrayList;
            }
            ArrayList<SubFile> subFiles = new ArrayList<SubFile>();
            int index = 1;
            long startPos = 0L;
            long nextPos = 0L;
            while ((nextPos = blockSize + startPos) < length) {
                raf.seek(nextPos);
                int ch = -1;
                while ((ch = raf.read()) != -1) {
                    if (ch != 41) continue;
                    long currPos = 0L;
                    int sm = -1;
                    while ((sm = raf.read()) != -1 && CharUtils.isWhitespace(sm)) {
                    }
                    if (sm != 59) continue;
                    int nl = -1;
                    while ((nl = raf.read()) != -1) {
                        if (nl != 13 && nl != 10) continue;
                        currPos = raf.getFilePointer();
                        break;
                    }
                    if (nl != 13 && nl != 10) continue;
                    StringBuilder token = new StringBuilder(6);
                    int temp = -1;
                    int range = 6;
                    while (range > 0 && (temp = raf.read()) != -1) {
                        if (CharUtils.isWhitespace(temp)) continue;
                        token.append((char)temp);
                        --range;
                    }
                    if (!"insert".equalsIgnoreCase(token.toString())) continue;
                    subFiles.add(new SubFile(resource, index++, startPos, currPos, DataFormat.SQL));
                    startPos = currPos;
                    break;
                }
                if (ch != -1) continue;
                break;
            }
            if (startPos < length) {
                subFiles.add(new SubFile(resource, index++, startPos, length, DataFormat.SQL));
            }
            log.info("File: \"{}\" has been splitted into {} copies", (Object)path, (Object)subFiles.size());
            ArrayList<SubFile> arrayList = subFiles;
            return arrayList;
        }
    }

    static boolean isEndOfLine(int ch, RandomAccessFile raf, long length) throws Exception {
        long currPos = raf.getFilePointer();
        if (currPos < length) {
            raf.seek(currPos + 1L);
            if (ch == 13 && raf.read() == 10) {
                ch = raf.read();
            }
            raf.seek(currPos);
        }
        return ch == 13 || ch == 10;
    }

    static boolean isEndOfLineForCut(int ch, RandomAccessFile raf, long length, String lineSplitter) throws Exception {
        if (ch != lineSplitter.charAt(0)) {
            return false;
        }
        long currPos = raf.getFilePointer();
        if (currPos < length) {
            for (int i = 1; i <= lineSplitter.length() - 1; ++i) {
                char nextChar = (char)raf.read();
                if (lineSplitter.charAt(i) == nextChar) continue;
                raf.seek(currPos);
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getTableName(String fileName) {
        if (StringUtils.isNotBlank(fileName) && fileName.startsWith(".")) {
            return null;
        }
        int dotCount = StringUtils.countMatches(fileName, '.');
        if (dotCount < 0) {
            return null;
        }
        if (dotCount < 4) {
            fileName = fileName.substring(0, fileName.indexOf(46));
        } else {
            int endIndex;
            int tempCount = 0;
            for (endIndex = fileName.length() - 1; endIndex > 0; --endIndex) {
                if (fileName.charAt(endIndex) == '.') {
                    ++tempCount;
                }
                if (tempCount == 3) break;
            }
            fileName = fileName.substring(0, endIndex);
        }
        int identicalIndex = fileName.indexOf("_ob_identical_");
        if (identicalIndex > 0) {
            fileName = fileName.substring(0, identicalIndex);
        }
        return fileName;
    }

    public static Map<String, List<File>> groupByName(Set<String> tableSet, String path, String fileSuffix) {
        String extension = fileSuffix.startsWith(".") ? fileSuffix.substring(1) : fileSuffix;
        Collection files = FileUtils.listFiles((File)new File(path), (String[])new String[]{extension}, (boolean)true);
        HashMap<String, List<File>> fileGroup = new HashMap<String, List<File>>(16);
        for (File file : files) {
            String fileName = FileUtils.getTableName(file.getName());
            if (!CollectionUtils.isEmpty(tableSet) && !tableSet.contains(fileName)) continue;
            fileGroup.computeIfAbsent(fileName, v -> new ArrayList()).add(file);
        }
        fileGroup.values().forEach(s -> s.sort((o1, o2) -> (int)(o2.length() - o1.length())));
        return fileGroup;
    }

    public static void mergeFiles(Map<String, List<File>> fileGroup, String outputDir, String fileName, String fileSuffix, DataFormat dataFormat) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        OptionalLong ol = fileGroup.values().stream().flatMap(Collection::stream).mapToLong(FileUtils::getSize).max();
        long maxFileSize = ol.orElseThrow(() -> new RuntimeException("No record files are found"));
        File file = new File(outputDir);
        Preconditions.checkState((file.exists() || file.mkdirs() ? 1 : 0) != 0, (String)"Creating target path :\"%s\" failed", (Object)outputDir);
        long usableSpace = file.getUsableSpace();
        if (usableSpace < 1L) {
            Optional<File> opf = Arrays.stream(File.listRoots()).filter(r -> file.getAbsolutePath().startsWith(r.getAbsolutePath())).findFirst();
            usableSpace = opf.orElseThrow(() -> new RuntimeException("Root dir is found")).getUsableSpace();
        }
        Preconditions.checkState((usableSpace > maxFileSize ? 1 : 0) != 0, (Object)("Disk space is insufficient. (" + usableSpace + "<" + maxFileSize + ")"));
        List<Object> existsFileNames = Lists.newArrayList();
        if (file.exists()) {
            String extension = fileSuffix.startsWith(".") ? fileSuffix.substring(1) : fileSuffix;
            Collection exists = FileUtils.listFiles((File)file, (String[])new String[]{extension}, (boolean)true);
            existsFileNames = exists.stream().map(File::getName).collect(Collectors.toList());
        }
        AtomicLong identicalNo = new AtomicLong(1L);
        HashMap<String, List<File>> merged = new HashMap<String, List<File>>();
        for (Map.Entry<String, List<File>> entry : fileGroup.entrySet()) {
            String string = entry.getKey();
            if (fileGroup.size() > 1 || StringUtils.isBlank(fileName)) {
                fileName = string + fileSuffix;
            }
            File outputFile = new File(FileUtils.toPath(outputDir, fileName));
            for (String string2 : existsFileNames) {
                if (!string2.equalsIgnoreCase(fileName)) continue;
                fileName = fileName.replace(fileSuffix, "_ob_identical_" + identicalNo.getAndIncrement() + fileSuffix);
                outputFile = new File(FileUtils.toPath(outputDir, fileName));
                log.warn("A similar file: \"{}\" exists, use another name: \"{}\"", (Object)string2, (Object)fileName);
                break;
            }
            merged.put(outputFile.getAbsolutePath(), entry.getValue());
        }
        ExecutorTemplate<Integer> template = new ExecutorTemplate<Integer>("merge-file-fragments-thread", Runtime.getRuntime().availableProcessors());
        for (Map.Entry entry : merged.entrySet()) {
            if (DataFormat.PAR.equals((Object)dataFormat)) {
                template.submit(() -> FileUtils.transformParquetFrom(new File((String)entry.getKey()), (List)entry.getValue()));
                continue;
            }
            if (DataFormat.ORC.equals((Object)dataFormat)) {
                template.submit(() -> FileUtils.transformOrcFrom(new File((String)entry.getKey()), (List)entry.getValue()));
                continue;
            }
            template.submit(() -> FileUtils.transformFrom(new File((String)entry.getKey()), (List)entry.getValue()));
        }
        List list = template.waitForResult();
        int n = list.stream().mapToInt(Integer::intValue).sum();
        log.info("Merge data files for {} tables finished. Elapsed: {}", (Object)n, (Object)stopwatch);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int transformFrom(File outputFile, List<File> subFiles) {
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(subFiles), (Object)"Input files are null");
        Stopwatch stopWatch = Stopwatch.createStarted();
        boolean result = subFiles.get(0).renameTo(outputFile);
        try (FileOutputStream fos = new FileOutputStream(outputFile, true);){
            try (FileChannel to = fos.getChannel();){
                int index;
                long pos = to.size();
                int n = index = result ? 1 : 0;
                while (index < subFiles.size()) {
                    File file = subFiles.get(index);
                    String dataPath = file.getAbsolutePath();
                    try (FileInputStream fis = new FileInputStream(file);
                         FileChannel from = fis.getChannel();){
                        long size = from.size();
                        pos += to.transferFrom(from, pos, size);
                        try {
                            FileUtils.forceDelete((File)file);
                        }
                        catch (Exception e) {
                            log.warn("Delete \"{}\" failed. Error: {}", (Object)dataPath, (Object)ExceptionUtils.getRootCauseMessage(e));
                        }
                        log.debug("Merge \"{}\" to \"{}\" finished. Size: {}", new Object[]{dataPath, outputFile.getAbsolutePath(), size});
                    }
                    ++index;
                }
            }
            log.info("Merge {} data files into \"{}\" finished. Elapsed: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), stopWatch});
            int n = 1;
            return n;
        }
        catch (Exception e) {
            log.error("Merge {} data files into \"{}\" failed. Error: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), e.toString()});
            return 0;
        }
    }

    public static String getFileSuffix(File file) {
        String fileExt = FileUtils.getFileExtension(file);
        return StringUtils.isEmpty(fileExt) ? "" : "." + fileExt;
    }

    public static String getFileExtension(File file) {
        String filename = file.getName();
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex != 1 && dotIndex != 0 && dotIndex != -1) {
            return filename.substring(filename.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static List<String> listFileNames(File dir, String[] extensions) {
        Preconditions.checkArgument((boolean)dir.isDirectory(), (Object)"not a directory");
        ArrayList<String> fileNames = new ArrayList<String>();
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return fileNames;
        }
        for (File f : listOfFiles) {
            if (!f.isFile() || !ArrayUtils.contains((Object[])extensions, (Object)FileUtils.getFileExtension(f))) continue;
            fileNames.add(f.getName());
        }
        return fileNames;
    }

    public static boolean isValidFilePath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return !FileUtils.isValidDirPath(path);
    }

    public static boolean isValidDirPath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return path.trim().endsWith(File.separator);
    }

    public static boolean exists(String path) {
        if ((path = path.trim()).startsWith("file://")) {
            path = path.substring("file://".length());
        }
        return new File(path).exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int transformOrcFrom(File outputFile, List<File> subFiles) {
        TypeDescription schema;
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(subFiles), (Object)"Input files are empty");
        Stopwatch stopWatch = Stopwatch.createStarted();
        try (Reader schemaReader = OrcFile.createReader((Path)new Path(subFiles.get(0).getAbsolutePath()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)new Configuration()));){
            schema = schemaReader.getSchema();
        }
        catch (IOException e) {
            log.error("Merge {} data files into \"{}\" failed. Error: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), e.toString()});
            return 0;
        }
        OrcFile.WriterOptions option = OrcFile.writerOptions((Configuration)new Configuration()).setSchema(schema).overwrite(true);
        try (Writer writer = OrcFile.createWriter((Path)new Path(outputFile.getAbsolutePath()), (OrcFile.WriterOptions)option);){
            for (File file : subFiles) {
                Reader reader = OrcFile.createReader((Path)new Path(file.getAbsolutePath()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)new Configuration()));
                Throwable throwable2 = null;
                try {
                    VectorizedRowBatch batch = reader.getSchema().createRowBatch();
                    RecordReader rows = reader.rows();
                    while (rows.nextBatch(batch)) {
                        if (batch == null) continue;
                        writer.addRowBatch(batch);
                    }
                    rows.close();
                    try {
                        FileUtils.forceDelete((File)file);
                    }
                    catch (IOException e) {
                        log.warn("Delete \"{}\" failed. Error: {}", (Object)file, (Object)ExceptionUtils.getRootCauseMessage(e));
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable2 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            log.info("Merge {} data files into \"{}\" finished. Elapsed: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), stopWatch});
            int n = 1;
            return n;
        }
        catch (Exception e) {
            log.error("Merge {} data files into \"{}\" failed. Error: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), e.toString()});
            return 0;
        }
    }

    public static int transformParquetFrom(File outputFile, List<File> subFiles) {
        MessageType schema;
        boolean result;
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(subFiles), (Object)"Input files are empty");
        Stopwatch stopWatch = Stopwatch.createStarted();
        if (subFiles.size() == 1 && (result = subFiles.get(0).renameTo(outputFile))) {
            log.info("Merge {} data files into \"{}\" finished. Elapsed: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), stopWatch});
            return 1;
        }
        try {
            ParquetFileReader schemaReader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)new Path(subFiles.get(0).getAbsolutePath()), (Configuration)new Configuration()));
            Object object = null;
            try {
                schema = schemaReader.getFooter().getFileMetaData().getSchema();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (schemaReader != null) {
                    if (object != null) {
                        try {
                            schemaReader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        schemaReader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Merge {} data files into \"{}\" failed. Error: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), e.toString()});
            return 0;
        }
        try {
            ParquetFileWriter writer = new ParquetFileWriter((OutputFile)HadoopOutputFile.fromPath((Path)new Path(outputFile.getAbsolutePath()), (Configuration)new Configuration()), schema, ParquetFileWriter.Mode.OVERWRITE, 0x800000L, 0, 64, Integer.MAX_VALUE, true);
            writer.start();
            for (File file : subFiles) {
                writer.appendFile((InputFile)HadoopInputFile.fromPath((Path)new Path(file.getAbsolutePath()), (Configuration)new Configuration()));
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    log.warn("Delete \"{}\" failed. Error: {}", (Object)file, (Object)ExceptionUtils.getRootCauseMessage(e));
                }
            }
            writer.end(new HashMap(0));
            log.info("Merge {} data files into \"{}\" finished. Elapsed: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), stopWatch});
            return 1;
        }
        catch (IOException e) {
            log.error("Merge {} data files into \"{}\" failed. Error: {}", new Object[]{subFiles.size(), outputFile.getAbsolutePath(), e.toString()});
            return 0;
        }
    }

    public static boolean isLikelyDirectory(String input) {
        if (input.contains("\n") || input.contains("\r") || input.contains("\t")) {
            throw new IllegalArgumentException("Not a valid path");
        }
        if (input.matches(".*\\.[a-zA-Z0-9]+$")) {
            return false;
        }
        if (input.endsWith(File.separator)) {
            return true;
        }
        if (input.contains(File.separator)) {
            String lastSegment = input.substring(input.lastIndexOf("/") + 1);
            return !lastSegment.contains(".");
        }
        return true;
    }

    public static String byteCountToDisplaySize(double size) {
        int unitIndex = 0;
        while (size > 1024.0) {
            size /= 1024.0;
            ++unitIndex;
        }
        return new BigDecimal(size).setScale(2, RoundingMode.HALF_UP).doubleValue() + STORAGE_CAPACITY_UNIT[unitIndex];
    }

    public static String getFileExtension(Path p) {
        String filename = p.getName();
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex != 1 && dotIndex != 0 && dotIndex != -1) {
            return filename.substring(filename.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static Iterator<FileStatus> listFiles(final FileSystem fs, final Path f, final boolean recursive) throws IOException {
        return new Iterator<FileStatus>(){
            private Stack<Iterator<FileStatus>> itors = new Stack();
            private Iterator<FileStatus> curItor = Arrays.stream(fs.listStatus(f)).iterator();
            private FileStatus curFile;

            @Override
            public boolean hasNext() {
                while (this.curFile == null) {
                    if (this.curItor.hasNext()) {
                        this.handleFileStat(this.curItor.next());
                        continue;
                    }
                    if (!this.itors.empty()) {
                        this.curItor = this.itors.pop();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            private void handleFileStat(FileStatus stat) {
                if (stat.isFile()) {
                    this.curFile = stat;
                } else if (recursive) {
                    try {
                        FileStatus[] statusList = fs.listStatus(stat.getPath());
                        Iterator newDirItor = Arrays.stream(statusList).iterator();
                        this.itors.push(this.curItor);
                        this.curItor = newDirItor;
                    }
                    catch (FileNotFoundException ignored) {
                        throw new IllegalStateException("Directory " + stat.getPath() + " deleted while attempting for recursive listing");
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error executing fs.listStatus.", e);
                    }
                }
            }

            @Override
            public FileStatus next() {
                if (this.hasNext()) {
                    FileStatus result = this.curFile;
                    this.curFile = null;
                    return result;
                }
                throw new NoSuchElementException("No more entry in " + f);
            }
        };
    }

    public static boolean isDirEmpty(FileSystem fs, FileStatus fileStatus) throws IOException {
        Preconditions.checkArgument((boolean)fileStatus.isDirectory());
        return fs.listStatus(fileStatus.getPath()).length == 0;
    }
}

