/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.utils;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static void sleep(TimeUnit timeUnit, long timeout) {
        try {
            timeUnit.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String formatMilliseconds(long milliseconds) {
        Preconditions.checkArgument((milliseconds >= 0L ? 1 : 0) != 0, (Object)"Milliseconds must be a positive number");
        if (milliseconds == 0L) {
            return "0ms";
        }
        long days = TimeUnit.MILLISECONDS.toDays(milliseconds);
        long hours = TimeUnit.MILLISECONDS.toHours(milliseconds) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(milliseconds) % 60L;
        long millisecondsFraction = milliseconds % 1000L;
        StringBuilder formattedTime = new StringBuilder();
        if (days > 0L) {
            formattedTime.append(days).append("d ");
        }
        if (hours > 0L) {
            formattedTime.append(hours).append("h ");
        }
        if (minutes > 0L) {
            formattedTime.append(minutes).append("min ");
        }
        if (seconds > 0L) {
            formattedTime.append(String.format("%.2f", (double)seconds + (double)millisecondsFraction * 1.0 / 1000.0)).append("s");
        } else if (millisecondsFraction > 0L) {
            formattedTime.append(millisecondsFraction).append("ms");
        }
        return formattedTime.toString().trim();
    }
}

