/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.vmoption;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;

public final class JavaOpts {
    private static final String BACKUP_RESTORE_MODE = "cbs";
    public static boolean isDebugable = false;
    public static boolean isBackupRestoreMode = false;
    public static boolean isDryRunMode = false;
    public static boolean isRebalanceImport = false;
    public static boolean isDisableMemoryCheck = false;
    public static int writeMemoryBuffer = 0;
    public static Boolean enableParallelWrite = false;
    public static Boolean skipTableNameCheck = false;
    public static String uploadBufferType;
    public static String uploadBufferSize;
    public static String uploadActiveBlocks;
    public static Boolean uploadDisableChunkedEncoding;
    public static Boolean sqlMonitorEnabled;
    public static int slowSqlThreshold;

    private JavaOpts() {
    }

    public static boolean isMultiTask() {
        return StringUtils.isNotBlank((CharSequence)ThreadContext.get((String)"task.workspace"));
    }

    public static List<String> getSourceTables() {
        if (!isBackupRestoreMode) {
            return null;
        }
        String sourceTables = System.getProperty("sourceTable");
        Preconditions.checkArgument((boolean)com.oceanbase.tools.loaddump.utils.StringUtils.isNotBlank(sourceTables), (Object)"-DsourceTable is missing when it run in restore mode");
        return Stream.of(sourceTables.split(",")).collect(Collectors.toList());
    }

    static {
        uploadDisableChunkedEncoding = false;
        isDebugable = System.getProperties().containsKey("debug");
        isBackupRestoreMode = BACKUP_RESTORE_MODE.equalsIgnoreCase(System.getProperty("run.mode"));
        isDryRunMode = Boolean.getBoolean("dry.run");
        isRebalanceImport = Boolean.getBoolean("rebalance.import");
        isDisableMemoryCheck = Boolean.getBoolean("disable.memory.check");
        writeMemoryBuffer = Integer.getInteger("write.memory.buffer", 0);
        enableParallelWrite = Boolean.getBoolean("enable.parallel.write");
        skipTableNameCheck = Boolean.getBoolean("skip.tableName.check");
        uploadBufferType = System.getProperty("upload.buffer.type", "disk");
        uploadBufferSize = System.getProperty("upload.buffer.size", "67108864");
        uploadActiveBlocks = System.getProperty("upload.active.blocks", "2");
        uploadDisableChunkedEncoding = Boolean.getBoolean("upload.disable.chunked.encoding");
        sqlMonitorEnabled = Boolean.getBoolean("sqlMonitor.enabled");
        slowSqlThreshold = Integer.getInteger("sqlMonitor.slowSql.threshold", 3000);
    }
}

