/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.fs;

import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFsWriter
extends AbstractRollingFileWriterV2 {
    private static final Logger log = LoggerFactory.getLogger(AbstractFsWriter.class);
    protected final FileSystem fs;
    private final boolean retainEmpty;

    public AbstractFsWriter(String filePath, String fileName, String fileSuffix, boolean retainEmptyFile, long blockSize, int blockRow, int participant, StorageConfig storageConfig, boolean enableParallelWrite) {
        super(filePath, fileName, fileSuffix, blockSize, blockRow, participant, storageConfig, enableParallelWrite);
        this.fs = storageConfig.getFileSystem();
        this.retainEmpty = retainEmptyFile;
    }

    @Override
    public void init() throws Exception {
        if (this.retainEmpty) {
            try {
                this.createEmptyInternal();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create file: " + this.currentFilePath, e);
            }
        }
    }

    @Override
    protected abstract void createEmptyInternal() throws Exception;

    @Override
    protected void rollover() throws Exception {
        Path originFilePath;
        if (!this.enableParallelWrite && this.sequenceNo == 0 && this.fs.exists(originFilePath = new Path(this.currentFilePath))) {
            this.currentFilePath = this.assembleSeqFilePath();
            Path currentPath = new Path(this.currentFilePath);
            if (this.fs.exists(currentPath)) {
                this.fs.delete(currentPath, false);
            }
            this.fs.rename(originFilePath, currentPath);
        }
        super.rollover();
    }

    @Override
    public void close() throws Exception {
        if (this.currentBlockRowCnt > 0L || this.retainEmpty) {
            log.info("Dump data to \"{}\" finished.", (Object)this.currentFilePath);
        }
    }

    protected Path getFsPath() {
        return new Path(this.currentFilePath);
    }
}

