/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.fs;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.writer.file.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.writer.file.fs.AbstractFsWriter;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileWriterV2
extends AbstractFsWriter {
    private static final Logger log = LoggerFactory.getLogger(ParquetFileWriterV2.class);
    private final Configuration conf;
    private final MessageType schema;
    private ParquetWriter<Group> writer;

    public ParquetFileWriterV2(MessageType schema, String filePath, String fileName, String fileSuffix, boolean retainEmptyFile, long blockSize, int blockRow, int participant, StorageConfig storageConfig, boolean enableParallelWrite) {
        super(filePath, fileName, fileSuffix, retainEmptyFile, blockSize, blockRow, participant, storageConfig, enableParallelWrite);
        this.schema = schema;
        this.conf = storageConfig.getFsConf();
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        if (this.writer == null) {
            this.writer = this.createParquetWriter();
        }
        long byteSize = 0L;
        SimpleGroup group = new SimpleGroup((GroupType)this.schema);
        String[] row = (String[])line;
        for (int i = 0; i < this.schema.getFieldCount(); ++i) {
            String value = row[i];
            if (value == null) continue;
            this.addValues((Group)group, i, value);
            byteSize += (long)value.getBytes().length;
        }
        this.writer.write((Object)group);
        return byteSize;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.closed = true;
        }
        super.close();
    }

    @Override
    protected void rollover() throws Exception {
        super.rollover();
        this.writer.close();
        this.writer = null;
    }

    @Override
    protected void createEmptyInternal() throws Exception {
        this.writer = this.createParquetWriter();
    }

    private void addValues(Group group, int colIdx, String value) {
        Type type = (Type)this.schema.getFields().get(colIdx);
        switch (type.asPrimitiveType().getPrimitiveTypeName()) {
            case INT32: {
                group.add(colIdx, Integer.parseInt(value));
                break;
            }
            case INT64: {
                group.add(colIdx, Long.parseLong(value));
                break;
            }
            case BOOLEAN: {
                group.add(colIdx, Boolean.parseBoolean(value));
                break;
            }
            case DOUBLE: {
                group.add(colIdx, Double.parseDouble(value));
                break;
            }
            default: {
                group.add(colIdx, value);
            }
        }
    }

    private ParquetWriter<Group> createParquetWriter() throws Exception {
        Path p = this.getFsPath();
        if (!this.fs.exists(p)) {
            this.fs.create(p).close();
        }
        return ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)p).withType(this.schema).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0)).withBloomFilterEnabled(false)).withConf(this.conf)).withCompressionCodec(this.getCompressionCodecName())).withDictionaryEncoding(true)).withPageWriteChecksumEnabled(false)).build();
    }

    private CompressionCodecName getCompressionCodecName() {
        switch (this.storageConfig.getCompressor().getCompressAlgo()) {
            case GZIP: 
            case ZLIB: {
                return CompressionCodecName.GZIP;
            }
            case SNAPPY: {
                return CompressionCodecName.SNAPPY;
            }
        }
        return CompressionCodecName.ZSTD;
    }

    public static class Builder
    extends AbstractRollingFileWriterV2.Builder {
        private MessageType schema;

        public Builder() {
            this.fileSuffix = DataFormat.PAR.getDefaultFileSuffix();
        }

        public Builder columnTypeMap(String schemaName, Map<String, Object> colTypeMap) {
            Types.MessageTypeBuilder mtb = Types.buildMessage();
            colTypeMap.forEach((columnName, columnType) -> {
                Types.GroupBuilder cfr_ignored_0 = (Types.GroupBuilder)mtb.addField(Builder.getMappedPrimitiveType(columnName, columnType));
            });
            this.schema = mtb.named(schemaName);
            return this;
        }

        static Type getMappedPrimitiveType(String columnName, Object columnType) {
            String dataType = columnType.toString();
            int index = (dataType = dataType.trim().toLowerCase(Locale.getDefault())).indexOf("unsigned");
            switch (dataType = index > -1 ? dataType.substring(0, index).trim() : dataType) {
                case "int": 
                case "integer": 
                case "tinyint": 
                case "smallint": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named(columnName);
                }
                case "bigint": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named(columnName);
                }
                case "float": 
                case "double": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named(columnName);
                }
                case "bool": 
                case "boolean": {
                    return (Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named(columnName);
                }
            }
            return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(columnName);
        }

        @Override
        protected ParquetFileWriterV2 construct() throws Exception {
            return new ParquetFileWriterV2(this.schema, this.filePath, this.fileName, this.fileSuffix, this.retainEmptyFile, this.blockSize, this.blockRow, this.participant, this.storageConfig, this.enableParallelWrite);
        }
    }
}

