/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.writer.file.fs;

import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.writer.file.fs.FlatFileWriterV2;

public class SqlFileWriter
extends FlatFileWriterV2 {
    private static final String COMMIT_STMT = "commit;" + System.lineSeparator();
    private int commitSize;

    protected SqlFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding, boolean retainEmptyFile, long blockSize, int blockRow, int participant, int commitSize, StorageConfig storageConfig, boolean enableParallelWrite) {
        super(filePath, fileName, fileSuffix, fileEncoding, retainEmptyFile, blockSize, blockRow, participant, storageConfig, enableParallelWrite);
        this.commitSize = commitSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Object line) throws Exception {
        this.lock.lock();
        try {
            long byteSize = super.write(line);
            if (this.currentBlockRowCnt % (long)this.commitSize == 0L) {
                this.writeInternal(COMMIT_STMT);
            }
            long l = byteSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public static class Builder
    extends FlatFileWriterV2.Builder {
        int commitSize;

        public Builder commitSize(int commitSize) {
            this.commitSize = commitSize;
            return this;
        }

        @Override
        protected SqlFileWriter construct() throws Exception {
            return new SqlFileWriter(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.retainEmptyFile, this.blockSize, this.blockRow, this.participant, this.commitSize, this.storageConfig, this.enableParallelWrite);
        }
    }
}

