/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.algo.hash.bin;

import com.oceanbase.partition.calculator.algo.hash.MurmurHash;
import com.oceanbase.partition.calculator.constants.Constants;
import java.math.BigInteger;

public class ObHashSortBin {
    private static final String MOD_VALUE_INT = "18446744073709551616";

    public static BigInteger obHashSortBin(String str, BigInteger n1, BigInteger n2, boolean isSubFromV3) {
        return ObHashSortBin.obHashSortBin(str.getBytes(), str.getBytes().length, n1, n2, isSubFromV3);
    }

    public static BigInteger obHashSortBin(byte[] s, int len, BigInteger n1, BigInteger n2, boolean isSubFromV3) {
        if (isSubFromV3) {
            n1 = MurmurHash.hash64(s, len, n1);
            return n1;
        }
        return ObHashSortBin.obHashSortBinBigInt(s, len, n1, n2);
    }

    private static BigInteger obHashSortBinBigInt(byte[] s, int len, BigInteger n1, BigInteger n2) {
        for (int i = 0; i < len; ++i) {
            BigInteger temp1 = BigInteger.valueOf(ObHashSortBin.toUnsignedInt(n1) & 0x3FL).add(n2);
            temp1 = ObHashSortBin.multiply(temp1, BigInteger.valueOf(s[i]));
            n1 = ObHashSortBin.xor(n1, temp1.add(n1.shiftLeft(8)));
            n2 = n2.add(Constants.BIGINTEGER_3);
        }
        return n1;
    }

    private static BigInteger multiply(BigInteger left, BigInteger right) {
        BigInteger res = left.multiply(right);
        return res.compareTo(Constants.LONG_MOD_VALUE) >= 0 ? res.mod(Constants.LONG_MOD_VALUE) : res;
    }

    private static BigInteger xor(BigInteger left, BigInteger right) {
        BigInteger res = left.xor(right);
        return res.compareTo(Constants.LONG_MOD_VALUE) > 0 ? res.mod(Constants.LONG_MOD_VALUE) : res;
    }

    private static long toUnsignedInt(BigInteger bigInteger) {
        return Math.floorMod(bigInteger.longValue(), Long.valueOf(MOD_VALUE_INT));
    }
}

