/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.algo.hash.gbk;

import com.alibaba.druid.util.MySqlUtils;
import com.oceanbase.partition.calculator.algo.hash.MurmurHash;
import com.oceanbase.partition.calculator.constants.Constants;
import com.oceanbase.utils.BigIntegerUtils;
import java.math.BigInteger;

public class ObHashSortGbk {
    private static final int HASH_BUFFER_LENGTH = 128;
    private static final byte[] sort_order_gbk = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 92, 93, 91, 94, 95, 96, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 123, 124, 125, 89, 127, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1};

    public static BigInteger obHashSortGbkSimple(String str, BigInteger n1, BigInteger n2, boolean calcEndSpace, boolean isSubFromV3) {
        byte[] bytes = str.getBytes(MySqlUtils.GBK);
        return ObHashSortGbk.obHashSortGbkSimple(bytes, bytes.length, n1, n2, calcEndSpace, isSubFromV3);
    }

    public static BigInteger obHashSortGbkSimple(byte[] s, int len, BigInteger n1, BigInteger n2, boolean calcEndSpace, boolean isSubFromV3) {
        if (calcEndSpace) {
            while (len > 0 && s[len - 1] == 32) {
                --len;
            }
        }
        int end = len;
        int length = 0;
        if (isSubFromV3) {
            byte[] data = new byte[128];
            int key = 0;
            int usignedKey = 0;
            while (key < end) {
                length = Math.min(end - key, 128);
                int i = 0;
                while (i < length) {
                    usignedKey = (s[key] + 256) % 256;
                    data[i] = sort_order_gbk[usignedKey];
                    ++i;
                    ++key;
                }
                n1 = MurmurHash.hash64(data, length, n1);
            }
            return n1;
        }
        return ObHashSortGbk.obHashSortGbkSimple(s, len, n1, n2);
    }

    public static BigInteger obHashSortGbkSimple(byte[] s, int len, BigInteger n1, BigInteger n2) {
        for (int i = 0; i < len; ++i) {
            BigInteger temp1 = BigIntegerUtils.toUnsignedInt(n1).and(Constants.BIGINTEGER_63).add(n2);
            temp1 = BigIntegerUtils.multiply(temp1, BigInteger.valueOf(s[i]));
            n1 = BigIntegerUtils.xor(n1, temp1.add(n1.shiftLeft(8)));
            n2 = n2.add(Constants.BIGINTEGER_3);
        }
        return n1;
    }

    public static BigInteger obHashSortGbkMbBin(String str, BigInteger n1, BigInteger n2, boolean calcEndSpace, boolean isSubFromV3) {
        byte[] bytes = str.getBytes(MySqlUtils.GBK);
        return ObHashSortGbk.obHashSortGbkMbBin(bytes, bytes.length, n1, n2, calcEndSpace, isSubFromV3);
    }

    public static BigInteger obHashSortGbkMbBin(byte[] s, int len, BigInteger n1, BigInteger n2, boolean calcEndSpace, boolean isSubFromV3) {
        if (calcEndSpace) {
            while (len > 0 && s[len - 1] == 32) {
                --len;
            }
        }
        if (isSubFromV3) {
            return MurmurHash.hash64(s, len, n1);
        }
        return ObHashSortGbk.obHashSortGbkSimple(s, len, n1, n2);
    }
}

