/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.enums;

import com.oceanbase.partition.calculator.enums.datatype.ObCharType;
import com.oceanbase.partition.calculator.enums.datatype.ObDataType;
import com.oceanbase.partition.calculator.enums.datatype.ObDateTimeType;
import com.oceanbase.partition.calculator.enums.datatype.ObDateType;
import com.oceanbase.partition.calculator.enums.datatype.ObIntType;
import com.oceanbase.partition.calculator.enums.datatype.ObIntervalDsType;
import com.oceanbase.partition.calculator.enums.datatype.ObIntervalYmType;
import com.oceanbase.partition.calculator.enums.datatype.ObMaxValueType;
import com.oceanbase.partition.calculator.enums.datatype.ObNumberType;
import com.oceanbase.partition.calculator.enums.datatype.ObTimestampLtzType;
import com.oceanbase.partition.calculator.enums.datatype.ObTimestampType;
import com.oceanbase.partition.calculator.enums.datatype.ObTimestampTzType;
import com.oceanbase.partition.calculator.enums.datatype.ObUnknownType;

public enum ObObjType {
    LONG("LONG", ObIntType.getInstance()),
    DATE("DATE", ObDateType.getInstance()),
    STRING("STRING", ObCharType.getInstance()),
    NUMBER("NUMBER", ObNumberType.getInstance()),
    DATETIME("DATETIME", ObDateTimeType.getInstance()),
    TIMESTAMP("TIMESTAMP", ObTimestampType.getInstance()),
    TIMESTAMPTZ("TIMESTAMPTZ", ObTimestampTzType.getInstance()),
    TIMESTAMPLTZ("TIMESTAMPLTZ", ObTimestampLtzType.getInstance()),
    INTERVALYM("INTERVALYM", ObIntervalYmType.getInstance()),
    INTERVALDS("INTERVALDS", ObIntervalDsType.getInstance()),
    MAXVALUE("MAXVALUE", ObMaxValueType.getInstance()),
    UNKNOWN("UNKNOWN", ObUnknownType.getInstance());

    private final String name;
    private final ObDataType obDataType;

    private ObObjType(String name, ObDataType obDataType) {
        this.name = name;
        this.obDataType = obDataType;
    }

    public static ObObjType getObObjType(int dataType) {
        for (ObObjType obObjType : ObObjType.values()) {
            if (!obObjType.getObDataType().match(dataType)) continue;
            return obObjType;
        }
        return UNKNOWN;
    }

    public String getName() {
        return this.name;
    }

    public ObDataType getObDataType() {
        return this.obDataType;
    }
}

