/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.enums;

import com.oceanbase.partition.calculator.enums.ObPartFuncType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public enum ObPartFuncTypeOld implements ObPartFuncType
{
    HASH("HASH", 0L),
    KEY("KEY", 1L),
    KEY_IMPLICIT("KEY_IMPLICIT", 2L),
    RANGE("RANGE", 3L),
    RANGE_COLUMNS("RANGE_COLUMNS", 4L),
    LIST("LIST", 5L),
    KEY_V2("KEY_V2", 6L),
    LIST_COLUMNS("LIST_COLUMNS", 7L),
    HASH_V2("HASH_V2", 8L),
    KEY_V3("KEY_V3", 9L),
    KEY_IMPLICIT_V2("KEY_IMPLICIT_V2", 10L),
    UNKNOWN("UNKNOWN", 11L);

    private static final Map<Long, ObPartFuncTypeOld> INDEX_MAPPING;
    private static final Map<String, ObPartFuncTypeOld> NAME_MAPPING;
    private String name = "";
    private long index = -1L;

    private ObPartFuncTypeOld(String name, long index) {
        this.name = name;
        this.index = index;
    }

    public static ObPartFuncTypeOld getObPartFuncType(long index) {
        return INDEX_MAPPING.getOrDefault(index, UNKNOWN);
    }

    public static ObPartFuncTypeOld getObPartFuncType(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String upper = name.toUpperCase(Locale.getDefault());
        return NAME_MAPPING.getOrDefault(upper, UNKNOWN);
    }

    @Override
    public boolean isRangePart() {
        return this.index == RANGE.getIndex() || this.index == RANGE_COLUMNS.getIndex();
    }

    @Override
    public boolean isHashPart() {
        return this.index == HASH.getIndex() || this.index == HASH_V2.getIndex();
    }

    @Override
    public boolean isKeyPart() {
        return this.index == KEY.getIndex() || this.index == KEY_V2.getIndex() || this.index == KEY_V3.getIndex() || this.index == KEY_IMPLICIT.getIndex() || this.index == KEY_IMPLICIT_V2.getIndex();
    }

    @Override
    public boolean isListPart() {
        return this.index == LIST.getIndex() || this.index == LIST_COLUMNS.getIndex();
    }

    public String getName() {
        return this.name;
    }

    public long getIndex() {
        return this.index;
    }

    static {
        INDEX_MAPPING = new HashMap<Long, ObPartFuncTypeOld>(9);
        NAME_MAPPING = new HashMap<String, ObPartFuncTypeOld>(9);
        for (ObPartFuncTypeOld obPartFuncTyp : ObPartFuncTypeOld.values()) {
            NAME_MAPPING.putIfAbsent(obPartFuncTyp.getName(), obPartFuncTyp);
            INDEX_MAPPING.putIfAbsent(obPartFuncTyp.getIndex(), obPartFuncTyp);
        }
    }
}

