/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.enums;

import com.oceanbase.partition.calculator.model.Version;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public final class ObServerMode {
    private final String mode;
    private final Version version;

    private ObServerMode(String mode, String version) {
        this.mode = mode;
        this.version = new Version(version);
    }

    public static ObServerMode fromMySql(String version) {
        return new ObServerMode("OBMYSQL", version);
    }

    public static ObServerMode fromOracle(String version) {
        return new ObServerMode("OBORACLE", version);
    }

    public static ObServerMode from(String mode, String version) {
        if (StringUtils.isBlank((CharSequence)mode)) {
            throw new IllegalArgumentException("input mode is null");
        }
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("input version is null");
        }
        String lowerCase = mode.toLowerCase(Locale.getDefault());
        return lowerCase.contains("oracle") ? ObServerMode.fromOracle(version) : ObServerMode.fromMySql(version);
    }

    public boolean isOracleMode() {
        return "ORACLE".equalsIgnoreCase(this.getMode()) || "OBORACLE".equalsIgnoreCase(this.getMode());
    }

    public boolean isSubsequentFrom(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("null version");
        }
        Version ver = new Version(version);
        return this.getVersion().equals(ver) || this.getVersion().isNewerThan(ver);
    }

    public String getMode() {
        return this.mode;
    }

    public Version getVersion() {
        return this.version;
    }
}

