/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.enums;

import com.alibaba.druid.sql.visitor.functions.Function;
import com.alibaba.druid.sql.visitor.functions.Instr;
import com.alibaba.druid.sql.visitor.functions.Lcase;
import com.alibaba.druid.sql.visitor.functions.Length;
import com.alibaba.druid.sql.visitor.functions.Lpad;
import com.alibaba.druid.sql.visitor.functions.Ltrim;
import com.alibaba.druid.sql.visitor.functions.Substring;
import com.alibaba.druid.sql.visitor.functions.ToChar;
import com.alibaba.druid.sql.visitor.functions.Trim;
import com.alibaba.druid.sql.visitor.functions.Ucase;
import com.oceanbase.partition.calculator.function.mysql.ToDays;
import com.oceanbase.partition.calculator.function.mysql.UnixTimestamp;
import com.oceanbase.partition.calculator.function.mysql.Year;
import com.oceanbase.partition.calculator.function.oracle.ToDate;
import com.oceanbase.partition.calculator.function.oracle.ToTimestamp;
import org.apache.commons.lang3.StringUtils;

public enum SqlFunctions {
    YEAR("year", Year.instance),
    INSTR("insert", (Function)Instr.instance),
    LCASE("lower", (Function)Lcase.instance),
    LENGTH("length", (Function)Length.instance),
    LPAD("lpad", (Function)Lpad.instance),
    LTRIM("ltrim", (Function)Ltrim.instance),
    SUBSTR("substr", (Function)Substring.instance),
    SUBSTRING("substring", (Function)Substring.instance),
    TOCHAR("to_char", (Function)ToChar.instance),
    TODATE("to_date", (Function)ToDate.instance),
    TOTIMESTAMP("to_timestamp", (Function)ToTimestamp.instance),
    TRIM("trim", (Function)Trim.instance),
    UCASE("upper", (Function)Ucase.instance),
    TODAYS("to_days", ToDays.instance),
    UNIX_TIMESTAMP("unix_timestamp", UnixTimestamp.instance);

    private String name;
    private Function function;

    private SqlFunctions(String name, Function function) {
        this.name = name;
        this.function = function;
    }

    public static Function getByName(String methodName) {
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new IllegalArgumentException("input method name is null");
        }
        for (SqlFunctions function : SqlFunctions.values()) {
            if (!function.getName().equalsIgnoreCase(methodName)) continue;
            return function.getFunction();
        }
        throw new UnsupportedOperationException("function is unsupported by the name: [" + methodName + "]");
    }

    public String getName() {
        return this.name;
    }

    public Function getFunction() {
        return this.function;
    }
}

