/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.helper;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.partition.calculator.ObPartIdCalculator;
import com.oceanbase.partition.calculator.enums.ObCollationType;
import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.calculator.enums.ObPartFuncType;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeOld;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.calculator.helper.TableEntryHelperFor4;
import com.oceanbase.partition.calculator.model.ObCmpKV;
import com.oceanbase.partition.calculator.model.ObReplicaType;
import com.oceanbase.partition.calculator.model.ObServerAddr;
import com.oceanbase.partition.calculator.model.ObServerRole;
import com.oceanbase.partition.calculator.model.ObTableTypeEnum;
import com.oceanbase.partition.calculator.model.PartitionLocation;
import com.oceanbase.partition.calculator.model.ReplicaLocation;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import com.oceanbase.partition.calculator.visitor.ObRefColumnVisitor;
import com.oceanbase.partition.metadata.desc.ObHashPartDesc;
import com.oceanbase.partition.metadata.desc.ObKeyPartDesc;
import com.oceanbase.partition.metadata.desc.ObListPartDesc;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.partition.metadata.desc.ObPartDesc;
import com.oceanbase.partition.metadata.desc.ObPartItem;
import com.oceanbase.partition.metadata.desc.ObRangePartDesc;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEntryHelper {
    private static final Logger log = LoggerFactory.getLogger(TableEntryHelper.class);
    static final String PROXY_PLAIN_SCHEMA_SQL = "select svr_ip, sql_port, table_id, table_type, role, part_num, replica_num, schema_version, spare1 from oceanbase.__all_virtual_proxy_schema where tenant_name=? and database_name=? and table_name=? and partition_id=0 order by role asc";
    static final String PROXY_PART_INFO_SQL = "select part_level, part_num, part_type, part_space, part_expr, part_range_type, part_interval_bin, interval_start_bin, sub_part_num, sub_part_type, sub_part_space, sub_part_range_type,def_sub_part_interval_bin,def_sub_interval_start_bin, sub_part_expr, part_key_name, part_key_type,part_key_idx, part_key_level, part_key_extra, spare1 from oceanbase.__all_virtual_proxy_partition_info where table_id=? group by part_key_level,part_key_name order by part_key_level,part_key_idx";
    static final String PROXY_PART_LEADER_LOCATION_SQL = "select svr_ip, sql_port, table_id, table_type, role, partition_id, part_num, replica_num, schema_version, spare1 from oceanbase.__all_virtual_proxy_schema where tenant_name=? and database_name=? and table_name=? and partition_id in ({0}) and role=1 order by role asc";
    private static final String PROXY_PARTITION_SQL = "select part_id,part_name,high_bound_val from oceanbase.__all_virtual_proxy_partition where table_id=?";
    private static final String PART_ADAPTIVE_SQL_V1 = "select part_id,part_name from oceanbase.__all_part where table_id=?";
    private static final String PART_ADAPTIVE_SQL_V2 = "select part_id,part_name from oceanbase.__all_virtual_part where table_id=?";
    private static final String PROXY_SUB_PARTITION_SQL = "select part_id,sub_part_id,part_name,high_bound_val from oceanbase.__all_virtual_proxy_sub_partition where table_id=?";
    private static final String SUB_PART_ADAPTIVE_SQL_V1 = "select sub_part_num from oceanbase.__all_table where table_id=?";
    private static final String SUB_PART_ADAPTIVE_SQL_V2 = "select sub_part_num from oceanbase.__all_virtual_table where table_id=?";
    private static final String CHECK_UNIT_PRIAMARYZONE_COUNT = "select count(*) from gv$unit as a join __all_tenant as b on a.tenant_name=b.tenant_name where a.zone=substring_index(b.primary_zone, \";\", 1) and a.tenant_name=''{0}''";
    private static final String CHECK_LEADER_COUNT = "select count(*) from gv$unit as a join __all_tenant as b on a.tenant_name=b.tenant_name where a.zone=substring_index(b.primary_zone, \";\", 1) and a.tenant_name=''{0}''";
    private static final String CHECK_LEADER_ADDRESS = "select a.svr_ip, c.inner_port from gv$unit as a join __all_server as c join __all_tenant as b on a.svr_ip=c.svr_ip and a.svr_port=c.svr_port and a.tenant_name=b.tenant_name where a.zone=substring_index(b.primary_zone, \";\", 1) and a.tenant_name=''{0}''";
    private static LocationState locationState = new LocationState(false, null);

    public static TableEntry queryTableEntry(DruidDataSource ds, TableEntryKey key) throws Exception {
        return TableEntryHelper.queryTableEntry(ds, key, false);
    }

    public static TableEntry queryTableEntry(DruidDataSource ds, TableEntryKey key, boolean isSubsequentFromV4) throws Exception {
        try (DruidPooledConnection conn = ds.getConnection(60000L);){
            TableEntry tableEntry = isSubsequentFromV4 ? TableEntryHelperFor4.queryTableEntry((Connection)conn, key) : TableEntryHelper.queryTableEntry((Connection)conn, key);
            return tableEntry;
        }
    }

    /*
     * Exception decompiling
     */
    public static TableEntry queryTableEntry(Connection conn, TableEntryKey key) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<Long, String> queryLeaderLocationMap(Connection conn, TableEntry entry, List<Long> partIds) throws Exception {
        return TableEntryHelper.queryLeaderLocationMap(conn, entry, partIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Map<Long, String> queryLeaderLocationMap(Connection conn, TableEntry entry, List<Long> partIds, boolean subsequent4) throws Exception {
        Stopwatch clock;
        if (CollectionUtils.isEmpty(partIds)) {
            return new HashMap<Long, String>(0);
        }
        String table = entry.getTableName();
        if (!locationState.isInit()) {
            Class<TableEntryHelper> clazz = TableEntryHelper.class;
            // MONITORENTER : com.oceanbase.partition.calculator.helper.TableEntryHelper.class
            if (!locationState.isInit()) {
                clock = Stopwatch.createStarted();
                if (TableEntryHelper.isOneUnitWithNonRandomPrimaryZone(conn, entry, subsequent4)) {
                    Map<Long, String> partLeaderMap = TableEntryHelper.queryPartLocationForOneUnit(conn, entry, partIds, subsequent4);
                    locationState.setInit(true);
                    if (CollectionUtils.isNotEmpty(partLeaderMap.values())) {
                        locationState.setLeader(partLeaderMap.values().iterator().next());
                    }
                    log.info("Query the leader location \"{}\" in one unit finished. Elapsed: {}", (Object)table, (Object)clock);
                    if (partLeaderMap.size() == partIds.size()) {
                        // MONITOREXIT : clazz
                        return partLeaderMap;
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (locationState.isOneUnitWithNonRandomPrimaryZone()) {
            return partIds.stream().collect(Collectors.toMap(p -> p, p -> locationState.getLeader()));
        }
        List partitionedPartitionIds = Lists.newArrayList();
        if (partIds.size() <= 200) {
            partitionedPartitionIds.add(Lists.newArrayList(partIds));
        } else {
            partitionedPartitionIds = Lists.partition((List)Lists.newArrayList(partIds), (int)200);
        }
        clock = Stopwatch.createStarted();
        HashMap<Long, String> partLeaderLocationMap = new HashMap<Long, String>();
        Iterator iterator = partitionedPartitionIds.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                log.info("Query the leader location \"{}\" in multi unit finished. Elapsed: {}", (Object)table, (Object)clock);
                if (!MapUtils.isEmpty(partLeaderLocationMap)) return partLeaderLocationMap;
                throw new IllegalStateException("The leader location of table: \"" + table + "\" is not exists.");
            }
            List partitionIds = (List)iterator.next();
            HashSet partitionIdSet = Sets.newHashSet((Iterable)partitionIds);
            partLeaderLocationMap.putAll(TableEntryHelper.queryPartLocationForMultiUnit(conn, entry, partitionIdSet, subsequent4));
        }
    }

    static Map<Long, String> queryPartLocationForOneUnit(Connection conn, TableEntry tableEntry, List<Long> partIds, boolean subsequent4) {
        if (subsequent4) {
            return TableEntryHelperFor4.queryPartLocationForOneUnit(conn, tableEntry, partIds);
        }
        int retryTimes = 0;
        boolean hasValidReplica = false;
        HashMap<Long, PartitionLocation> locationMap = new HashMap<Long, PartitionLocation>();
        String table = tableEntry.getTableName();
        String sql = MessageFormat.format(CHECK_LEADER_ADDRESS, tableEntry.getTenantName());
        while (!hasValidReplica && retryTimes < 5) {
            try {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            ReplicaLocation replica = new ReplicaLocation();
                            replica.setRole(ObServerRole.LEADER);
                            replica.setReplicaType(ObReplicaType.UNKNOWN);
                            replica.setAddr(new ObServerAddr(rs.getString("svr_ip"), rs.getLong("inner_port")));
                            if (!replica.isValid()) {
                                log.warn("Ignore the invalid replica: {}, table: {}, part: [{}]", new Object[]{replica, table, partIds});
                                continue;
                            }
                            hasValidReplica = true;
                            for (Long partId : partIds) {
                                PartitionLocation location = new PartitionLocation();
                                location.addReplica(replica);
                                location.setPartId(partId);
                                locationMap.putIfAbsent(partId, location);
                            }
                        }
                        if (hasValidReplica) continue;
                        Thread.sleep((new Random().nextInt(100) + 10) * (2 << ++retryTimes));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
            catch (Exception e) {
                log.warn("Failed to get partition location. table: {}, part: [{}]", new Object[]{table, partIds, e});
            }
        }
        if (!hasValidReplica) {
            throw new IllegalStateException("No valid replicas were found after retry " + retryTimes + " times. table: \"" + table + "\", part: [" + partIds + "]");
        }
        if (retryTimes > 0) {
            log.info("Retry {} times to get partition location. Table: {}, Part: [{}]", new Object[]{retryTimes, table, partIds});
        }
        if (MapUtils.isEmpty(locationMap)) {
            return new HashMap<Long, String>(0);
        }
        return locationMap.values().stream().filter(PartitionLocation::existLeader).collect(Collectors.toMap(PartitionLocation::getPartId, PartitionLocation::getLeaderAddress, (k1, k2) -> k2));
    }

    static Map<Long, String> queryPartLocationForMultiUnit(Connection conn, TableEntry entry, Set<Long> partIds, boolean subsequent4) {
        if (subsequent4) {
            return TableEntryHelperFor4.queryPartLocationForMultiUnit(conn, entry, partIds);
        }
        int retryTimes = 0;
        boolean hasValidReplica = false;
        String table = entry.getTableName();
        String args = partIds.stream().map(e -> "'" + e + "'").collect(Collectors.joining(","));
        String sql = MessageFormat.format(PROXY_PART_LEADER_LOCATION_SQL, args);
        HashMap<Long, PartitionLocation> locationMap = new HashMap<Long, PartitionLocation>();
        while (!hasValidReplica && retryTimes < 5) {
            try {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    pstmt.setString(1, entry.getTenantName());
                    pstmt.setString(2, entry.getDatabaseName());
                    pstmt.setString(3, entry.getTableName());
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            Long partId = rs.getLong("partition_id");
                            ReplicaLocation replica = new ReplicaLocation();
                            replica.setRole(ObServerRole.getRole(rs.getInt("role")));
                            replica.setReplicaType(ObReplicaType.getObReplicaType(rs.getInt("spare1")));
                            replica.setAddr(new ObServerAddr(rs.getString("svr_ip"), rs.getLong("sql_port")));
                            if (!replica.isValid()) {
                                log.warn("Ignore the invalid replica: {}, table: {}, part: [{}]", new Object[]{replica, table, args});
                                continue;
                            }
                            PartitionLocation location = locationMap.getOrDefault(partId, new PartitionLocation());
                            location.addReplica(replica);
                            location.setPartId(partId);
                            location.setSchemaVersion(rs.getLong("schema_version"));
                            locationMap.putIfAbsent(partId, location);
                            hasValidReplica = true;
                        }
                        if (hasValidReplica) continue;
                        Thread.sleep((new Random().nextInt(100) + 10) * (2 << ++retryTimes));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
            catch (Exception e2) {
                log.warn("Query leader location failed. table: {}, part: [{}]", new Object[]{table, args, e2});
            }
        }
        if (!hasValidReplica) {
            throw new IllegalStateException("No valid replicas were found after retry " + retryTimes + " times. table: \"" + table + "\", part: [" + args + "]");
        }
        if (retryTimes > 0) {
            log.info("Retry {} times to get partition location. Table: {}, Part: [{}]", new Object[]{retryTimes, table, args});
        }
        if (MapUtils.isEmpty(locationMap)) {
            return new HashMap<Long, String>(0);
        }
        return locationMap.values().stream().filter(PartitionLocation::existLeader).collect(Collectors.toMap(PartitionLocation::getPartId, PartitionLocation::getLeaderAddress, (k1, k2) -> k2));
    }

    /*
     * Exception decompiling
     */
    static boolean isOneUnitWithNonRandomPrimaryZone(Connection conn, TableEntry entry, boolean subsequent4) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void queryTablePart(Connection conn, TableEntry entry) throws Exception {
        try (PreparedStatement pstmt = conn.prepareStatement(PROXY_PART_INFO_SQL);){
            pstmt.setLong(1, entry.getTableId());
            try (ResultSet rs = pstmt.executeQuery();){
                entry.setTablePart(TableEntryHelper.extractTablePart(entry, rs, false));
            }
        }
    }

    static void queryPartMeta(Connection conn, TableEntry entry, ObPartFuncTypeOld partType) throws Exception {
        try (PreparedStatement pstmt = conn.prepareStatement(PROXY_PARTITION_SQL);){
            pstmt.setLong(1, entry.getTableId());
            try (ResultSet rs = pstmt.executeQuery();){
                if (partType.isRangePart()) {
                    List<ObCmpKV<ObPartItem, Long>> bounds = TableEntryHelper.extractRangePart(rs, entry);
                    ((ObRangePartDesc)entry.getTablePart().getPartDesc()).setBounds(bounds);
                    if (bounds == null) {
                        log.error("Failed to get range partition. Table: {}", (Object)entry.getTableName());
                    }
                } else if (partType.isListPart()) {
                    Map<ObPartItem, Long> maps = TableEntryHelper.extractListPart(rs, entry);
                    ((ObListPartDesc)entry.getTablePart().getPartDesc()).setMaps(maps);
                    if (maps == null) {
                        log.error("Failed to get list partition. Table: {}", (Object)entry.getTableName());
                    }
                } else if (partType.isKeyPart() || partType.isHashPart()) {
                    TableEntryHelper.extractKeyHashPart(rs, entry);
                    if (MapUtils.isEmpty(entry.getTablePart().getPartDesc().getPartNameIdMap())) {
                        TableEntryHelper.doAdaptForKeyHashPart(conn, entry, false);
                        log.warn("Adapte to table: \"{}\" as the part name id map is empty", (Object)entry.getTableName());
                    }
                } else {
                    log.warn("Unknown partition type: {}", (Object)partType);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to query partition metadata, Table Entry: {}", (Object)entry, (Object)e);
        }
    }

    static void querySubPartMeta(Connection conn, TableEntry entry, ObPartFuncTypeOld subPartType) throws Exception {
        try (PreparedStatement pstmt = conn.prepareStatement(PROXY_SUB_PARTITION_SQL);){
            pstmt.setLong(1, entry.getTableId());
            try (ResultSet rs = pstmt.executeQuery();){
                if (subPartType.isRangePart()) {
                    List<ObCmpKV<ObPartItem, Long>> bounds = TableEntryHelper.extractRangeSubPart(rs, entry);
                    ((ObRangePartDesc)entry.getTablePart().getSubPartDesc()).setBounds(bounds);
                    if (bounds == null) {
                        log.error("Failed to get range subpartition. Table: {}", (Object)entry.getTableName());
                    }
                } else if (subPartType.isListPart()) {
                    Map<ObPartItem, Long> maps = TableEntryHelper.extractListSubPart(rs, entry);
                    ((ObListPartDesc)entry.getTablePart().getSubPartDesc()).setMaps(maps);
                    if (maps == null) {
                        log.error("Failed to get list subpartition. Table: {}", (Object)entry.getTableName());
                    }
                } else if (subPartType.isKeyPart() || subPartType.isHashPart()) {
                    TableEntryHelper.extractKeyHashSubPart(rs, entry);
                    if (MapUtils.isEmpty(entry.getTablePart().getSubPartDesc().getPartNameIdMap())) {
                        entry.setUseTemplate(true);
                        TableEntryHelper.doAdaptForKeyHashPart(conn, entry, true);
                        log.warn("Adapte to table: \"{}\" as the sub part name id map is empty", (Object)entry.getTableName());
                    }
                } else {
                    log.warn("Unknown sub partition type: {}", (Object)subPartType);
                }
            }
            catch (Exception e) {
                log.error("Failed to get sub partition. Table: {}", (Object)entry.getTableName(), (Object)e);
            }
        }
    }

    static List<PartitionLocation> queryPartLocations(Connection conn, TableEntryKey key, String ids) {
        int retryTimes = 0;
        boolean hasValidReplica = false;
        String table = key.getTableName();
        String sql = MessageFormat.format(PROXY_PART_LEADER_LOCATION_SQL, ids);
        ArrayList<PartitionLocation> partitionLocations = new ArrayList<PartitionLocation>();
        while (!hasValidReplica && retryTimes < 5) {
            try {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    pstmt.setString(1, key.getTenantName());
                    pstmt.setString(2, key.getSchemaName());
                    pstmt.setString(3, table);
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        HashMap<Long, PartitionLocation> locationMap = new HashMap<Long, PartitionLocation>();
                        while (rs.next()) {
                            Long partId = rs.getLong("partition_id");
                            PartitionLocation partitionLocation = locationMap.getOrDefault(partId, new PartitionLocation());
                            ReplicaLocation replica = new ReplicaLocation();
                            replica.setRole(ObServerRole.getRole(rs.getInt("role")));
                            replica.setReplicaType(ObReplicaType.getObReplicaType(rs.getInt("spare1")));
                            replica.setAddr(new ObServerAddr(rs.getString("svr_ip"), rs.getLong("sql_port")));
                            if (!replica.isValid()) {
                                log.warn("Ignore the invalid replica: {}, table: {}, part: {}", new Object[]{replica, table, partId});
                                continue;
                            }
                            hasValidReplica = true;
                            partitionLocation.addReplica(replica);
                            partitionLocation.setPartId(partId);
                            partitionLocation.setSchemaVersion(rs.getLong("schema_version"));
                            locationMap.putIfAbsent(partId, partitionLocation);
                        }
                        partitionLocations.addAll(locationMap.values());
                        Thread.sleep((new Random().nextInt(100) + 10) * (2 << ++retryTimes));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
            catch (Exception e) {
                log.warn("Failed to get partition location. table: {}, part: [{}]", new Object[]{table, ids, e});
            }
        }
        if (!hasValidReplica) {
            throw new IllegalStateException("No valid replicas were found after retry " + retryTimes + " times. table: \"" + key.getTableName() + "\", part: [" + ids + "]");
        }
        if (retryTimes > 0) {
            log.debug("Retry {} times to get partition location. Table: {}, Part: [{}]", new Object[]{retryTimes, table, ids});
        }
        return partitionLocations;
    }

    static TableEntry extractTableEntry(ResultSet rs, TableEntryKey key) throws Exception {
        boolean hasRecord = false;
        TableEntry tableEntry = new TableEntry();
        tableEntry.setClusterName(key.getClusterName());
        tableEntry.setTenantName(key.getTenantName());
        tableEntry.setDatabaseName(key.getSchemaName());
        tableEntry.setTableName(key.getTableName());
        tableEntry.setServerMode(key.getServerMode());
        ArrayList<ReplicaLocation> replicas = new ArrayList<ReplicaLocation>(3);
        while (rs.next()) {
            Long port;
            String ip;
            ObServerAddr serverAddr;
            hasRecord = true;
            tableEntry.setTableId(rs.getLong("table_id"));
            tableEntry.setReplicaNum(rs.getLong("replica_num"));
            tableEntry.setPartitionNum(rs.getLong("part_num"));
            tableEntry.setSchemaVersion(rs.getLong("schema_version"));
            Integer tableTypeId = rs.getInt("table_type");
            if (tableTypeId != null) {
                tableEntry.setTableType(ObTableTypeEnum.getObTableTypeEnum(tableTypeId));
            }
            if ((serverAddr = TableEntryHelper.buildServerAddr(ip = rs.getString("svr_ip"), port = Long.valueOf(rs.getLong("sql_port")))) == null) continue;
            ReplicaLocation replica = new ReplicaLocation();
            replica.setAddr(serverAddr);
            replica.setRole(ObServerRole.getRole(rs.getInt("role")));
            replica.setReplicaType(ObReplicaType.getObReplicaType(rs.getInt("spare1")));
            if (!replica.isValid()) {
                log.warn("Ignore the invalid replica: {}, key: {}", (Object)replica, (Object)key);
                continue;
            }
            replicas.add(replica);
        }
        if (CollectionUtils.isNotEmpty(replicas)) {
            PartitionLocation partition = new PartitionLocation();
            partition.setReplicas(replicas);
            partition.setSchemaVersion(tableEntry.getSchemaVersion());
            tableEntry.setVirtualTableEntry(false);
            tableEntry.setReplicaNum(tableEntry.getReplicaNum());
            tableEntry.setPartitionNum(tableEntry.getPartitionNum());
            tableEntry.setPartitionLocation(partition);
            tableEntry.setSchemaVersion(tableEntry.getSchemaVersion());
        } else {
            tableEntry.setVirtualTableEntry(hasRecord);
        }
        if (!tableEntry.isValid()) {
            log.error("Invalid table entry: {} ", (Object)tableEntry);
            return null;
        }
        return hasRecord ? tableEntry : null;
    }

    static ObTablePart extractTablePart(TableEntry entry, ResultSet rs, boolean subsequentV4) throws Exception {
        ObPartDesc subPartDesc;
        boolean isFirstRow = true;
        ObTablePart tablePart = new ObTablePart();
        while (rs.next()) {
            ObRefColumnVisitor refColumnVisitor;
            SQLExpr sqlExpr;
            String defaultValue;
            Long collationType;
            int partKeyType;
            Long partKeyLevel;
            if (isFirstRow) {
                tablePart.setLevel(ObPartLevel.getObPartitionLevel(rs.getLong("part_level")));
                if (tablePart.getLevel().getIndex() >= ObPartLevel.LEVEL_ONE.getIndex()) {
                    tablePart.setPartDesc(TableEntryHelper.extractPartDesc(entry, rs, ObPartLevel.LEVEL_ONE, subsequentV4));
                }
                if (tablePart.getLevel().getIndex() == ObPartLevel.LEVEL_TWO.getIndex()) {
                    tablePart.setSubPartDesc(TableEntryHelper.extractPartDesc(entry, rs, ObPartLevel.LEVEL_TWO, subsequentV4));
                }
                isFirstRow = false;
            }
            if ((partKeyLevel = Long.valueOf(rs.getLong("part_key_level"))).longValue() == ObPartLevel.LEVEL_ONE.getIndex()) {
                ObPartColumn partColumn = new ObPartColumn();
                partColumn.setColumnName(rs.getString("part_key_name"));
                partColumn.setColumnIndex(rs.getInt("part_key_idx"));
                partKeyType = rs.getInt("part_key_type");
                partColumn.setObjType(ObObjType.getObObjType(partKeyType));
                partColumn.setCharType(partKeyType == 23 || partKeyType == 44);
                partColumn.setNStringType(partKeyType == 43);
                collationType = rs.getLong("spare1");
                partColumn.setCollationType(ObCollationType.getObCollationType(collationType));
                partColumn.setVarcharType(partColumn.isNStringType() || partKeyType == 22 && collationType != 63L);
                defaultValue = rs.getString("part_key_extra");
                if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                    defaultValue = defaultValue.replaceAll("[`\"]", "");
                    sqlExpr = SQLUtils.toSQLExpr((String)("(" + defaultValue + ")"));
                    partColumn.setColumnExpr(sqlExpr);
                    refColumnVisitor = new ObRefColumnVisitor();
                    sqlExpr.accept((SQLASTVisitor)refColumnVisitor);
                    refColumnVisitor.getRefColumns().forEach(e -> tablePart.addRefPartColumn(new ObPartColumn((String)e)));
                }
                tablePart.addPartColumn(partColumn);
            }
            if (partKeyLevel.longValue() != ObPartLevel.LEVEL_TWO.getIndex()) continue;
            ObPartColumn subPartColumn = new ObPartColumn();
            subPartColumn.setColumnName(rs.getString("part_key_name"));
            subPartColumn.setColumnIndex(rs.getInt("part_key_idx"));
            partKeyType = rs.getInt("part_key_type");
            subPartColumn.setObjType(ObObjType.getObObjType(partKeyType));
            subPartColumn.setCharType(partKeyType == 23 || partKeyType == 44);
            subPartColumn.setNStringType(partKeyType == 43);
            collationType = rs.getLong("spare1");
            subPartColumn.setCollationType(ObCollationType.getObCollationType(collationType));
            subPartColumn.setVarcharType(subPartColumn.isNStringType() || partKeyType == 22 && collationType != 63L);
            defaultValue = rs.getString("part_key_extra");
            if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                defaultValue = defaultValue.replaceAll("[`\"]", "");
                sqlExpr = SQLUtils.toSQLExpr((String)("(" + defaultValue + ")"));
                subPartColumn.setColumnExpr(sqlExpr);
                refColumnVisitor = new ObRefColumnVisitor();
                sqlExpr.accept((SQLASTVisitor)refColumnVisitor);
                refColumnVisitor.getRefColumns().forEach(e -> tablePart.addRefSubPartColumn(new ObPartColumn((String)e)));
            }
            tablePart.addSubPartColumn(subPartColumn);
        }
        ObPartDesc partDesc = tablePart.getPartDesc();
        if (partDesc != null) {
            TableEntryHelper.setPartDescProperty(partDesc, tablePart.getPartColumns());
        }
        if ((subPartDesc = tablePart.getSubPartDesc()) != null) {
            TableEntryHelper.setPartDescProperty(subPartDesc, tablePart.getSubPartColumns());
        }
        return tablePart;
    }

    static void extractKeyHashPart(ResultSet rs, TableEntry entry) throws Exception {
        TableEntryHelper.extractKeyHashPart(rs, entry, false);
    }

    static Map<ObPartItem, Long> extractListPart(ResultSet rs, TableEntry entry) throws Exception {
        return TableEntryHelper.extractListPart(rs, entry, false);
    }

    static List<ObCmpKV<ObPartItem, Long>> extractRangePart(ResultSet rs, TableEntry entry) throws Exception {
        return TableEntryHelper.extractRangePart(rs, entry, false);
    }

    static Map<ObPartItem, Long> extractListSubPart(ResultSet rs, TableEntry entry) throws Exception {
        return TableEntryHelper.extractListPart(rs, entry, true);
    }

    static List<ObCmpKV<ObPartItem, Long>> extractRangeSubPart(ResultSet rs, TableEntry entry) throws Exception {
        return TableEntryHelper.extractRangePart(rs, entry, true);
    }

    static void extractKeyHashSubPart(ResultSet rs, TableEntry entry) throws Exception {
        TableEntryHelper.extractKeyHashPart(rs, entry, true);
    }

    static Map<ObPartItem, Long> extractListPart(ResultSet rs, TableEntry entry, boolean isSubPart) throws Exception {
        ObTablePart tablePart = entry.getTablePart();
        String fieldName = isSubPart ? "sub_part_id" : "part_id";
        ObPartDesc partDesc = isSubPart ? tablePart.getSubPartDesc() : tablePart.getPartDesc();
        LinkedHashMap<ObPartItem, Long> maps = new LinkedHashMap<ObPartItem, Long>();
        LinkedHashMap<String, Long> partNameIdMap = new LinkedHashMap<String, Long>();
        HashMap<Long, List<String>> partIdSubNamesMap = new HashMap<Long, List<String>>();
        List<ObObjType> types = ((ObListPartDesc)partDesc).getTypes();
        while (rs.next()) {
            String highBoundVal;
            Long firstPartId = rs.getLong("part_id");
            Map subMap = null;
            if (isSubPart) {
                boolean useTemplate = firstPartId == -1L;
                entry.setUseTemplate(useTemplate);
                partDesc.setUseTemplate(useTemplate);
                subMap = useTemplate ? subMap : (Map)((ObListPartDesc)partDesc).getSubMaps().getOrDefault(firstPartId, new HashMap());
            }
            String string = highBoundVal = (highBoundVal = rs.getString("high_bound_val")) == null ? "" : highBoundVal.trim();
            if (highBoundVal.length() < 1) {
                log.warn("Bad high_bound_val: [{}], table: {}", (Object)highBoundVal, (Object)entry.getTableName());
            }
            if (highBoundVal.startsWith("(") && highBoundVal.endsWith(")")) {
                highBoundVal = highBoundVal.substring(1, highBoundVal.length() - 1);
            }
            String[] highBoundArray = null;
            highBoundArray = highBoundVal.contains("),(") ? highBoundVal.split("\\),\\(") : (types.size() == 1 ? highBoundVal.split(",") : new String[]{highBoundVal});
            Long partId = rs.getLong(fieldName);
            ObPartItem key = ObPartDesc.DEFAULT_PART_ITEM;
            for (String highBound : highBoundArray) {
                String partName = rs.getString("part_name");
                if (!"default".equalsIgnoreCase(highBound)) {
                    key = ObPartItem.getObPartItem(types, highBound);
                }
                if (!entry.isUseTemplate()) {
                    List subPartNames = partIdSubNamesMap.getOrDefault(firstPartId, new ArrayList());
                    subPartNames.add(partName);
                    partIdSubNamesMap.putIfAbsent(firstPartId, subPartNames);
                    key.setFirstPartId(firstPartId);
                    if (subMap != null) {
                        subMap.put(key, partId);
                    }
                }
                maps.put(key, partId);
                partNameIdMap.put(partName, partId);
            }
            ((ObListPartDesc)partDesc).getSubMaps().putIfAbsent(firstPartId, subMap);
        }
        partDesc.setPartNameIdMap(partNameIdMap);
        partDesc.setPartIdSubNamesMap(partIdSubNamesMap);
        return maps;
    }

    static List<ObCmpKV<ObPartItem, Long>> extractRangePart(ResultSet rs, TableEntry entry, boolean isSubPart) throws Exception {
        ObTablePart tablePart = entry.getTablePart();
        String fieldName = isSubPart ? "sub_part_id" : "part_id";
        ObPartDesc partDesc = isSubPart ? tablePart.getSubPartDesc() : tablePart.getPartDesc();
        HashMap<String, Long> partNameIdMap = new HashMap<String, Long>();
        HashMap<Long, List<String>> partIdSubNamesMap = new HashMap<Long, List<String>>();
        ArrayList<ObCmpKV<ObPartItem, Long>> bounds = new ArrayList<ObCmpKV<ObPartItem, Long>>();
        List<ObObjType> types = ((ObRangePartDesc)partDesc).getTypes();
        while (rs.next()) {
            Long firstPartId = rs.getLong("part_id");
            Long partId = rs.getLong(fieldName);
            String partName = rs.getString("part_name");
            ObPartItem item = ObPartItem.getObPartItem(types, rs.getString("high_bound_val"));
            if (isSubPart) {
                boolean useTemplate = firstPartId == -1L;
                entry.setUseTemplate(useTemplate);
                partDesc.setUseTemplate(useTemplate);
                item.setFirstPartId(firstPartId);
                if (!entry.isUseTemplate()) {
                    List subPartNames = partIdSubNamesMap.getOrDefault(firstPartId, new ArrayList());
                    subPartNames.add(partName);
                    partIdSubNamesMap.putIfAbsent(firstPartId, subPartNames);
                    List subList = ((ObRangePartDesc)partDesc).getSubBoundsMap().getOrDefault(firstPartId, new ArrayList());
                    subList.add(new ObCmpKV<ObPartItem, Long>(item, partId));
                    ((ObRangePartDesc)partDesc).getSubBoundsMap().putIfAbsent(firstPartId, subList);
                }
            }
            partNameIdMap.put(partName, partId);
            bounds.add(new ObCmpKV<ObPartItem, Long>(item, partId));
        }
        partDesc.setPartNameIdMap(partNameIdMap);
        partDesc.setPartIdSubNamesMap(partIdSubNamesMap);
        if (!isSubPart || entry.isUseTemplate()) {
            Collections.sort(bounds);
        } else {
            Map<Long, List<ObCmpKV<ObPartItem, Long>>> sortedMap = ((ObRangePartDesc)partDesc).getSubBoundsMap();
            for (Long firstPartId : sortedMap.keySet()) {
                Collections.sort(sortedMap.get(firstPartId));
            }
            ((ObRangePartDesc)partDesc).setSubBoundsMap(sortedMap);
        }
        return bounds;
    }

    static void extractKeyHashPart(ResultSet rs, TableEntry entry, boolean isSubPart) throws Exception {
        ObTablePart tablePart = entry.getTablePart();
        String fieldName = isSubPart ? "sub_part_id" : "part_id";
        ObPartDesc partDesc = isSubPart ? tablePart.getSubPartDesc() : tablePart.getPartDesc();
        HashMap<String, Long> partNameIdMap = new HashMap<String, Long>();
        HashMap<Long, List<String>> partIdSubNamesMap = new HashMap<Long, List<String>>();
        while (rs.next()) {
            Long firstPartId = rs.getLong("part_id");
            if (isSubPart) {
                boolean useTemplate = firstPartId == -1L;
                entry.setUseTemplate(useTemplate);
                partDesc.setUseTemplate(useTemplate);
            }
            Long partId = rs.getLong(fieldName);
            String partName = rs.getString("part_name");
            partNameIdMap.put(partName, partId);
            if (entry.isUseTemplate()) continue;
            List subPartNames = partIdSubNamesMap.getOrDefault(firstPartId, new ArrayList());
            subPartNames.add(partName);
            partIdSubNamesMap.putIfAbsent(firstPartId, subPartNames);
        }
        partDesc.setPartNameIdMap(partNameIdMap);
        partDesc.setPartIdSubNamesMap(partIdSubNamesMap);
    }

    static void doAdaptForKeyHashPart(Connection conn, TableEntry entry, boolean isSubPart) throws Exception {
        String sql = null;
        boolean isObserver22 = entry.getServerMode().isSubsequentFrom("2.2");
        if (isSubPart) {
            HashMap<String, Long> partNameIdMap = new HashMap<String, Long>();
            sql = isObserver22 ? SUB_PART_ADAPTIVE_SQL_V2 : SUB_PART_ADAPTIVE_SQL_V1;
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setLong(1, entry.getTableId());
                try (ResultSet rs = pstmt.executeQuery();){
                    while (rs.next()) {
                        int subPartNum = rs.getInt("sub_part_num");
                        for (int i = 0; i < subPartNum; ++i) {
                            partNameIdMap.put("p" + i, Long.valueOf(i));
                        }
                    }
                }
            }
            entry.getTablePart().getSubPartDesc().setPartNameIdMap(partNameIdMap);
            return;
        }
        sql = isObserver22 ? PART_ADAPTIVE_SQL_V2 : PART_ADAPTIVE_SQL_V1;
        try (PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setLong(1, entry.getTableId());
            try (ResultSet rs = pstmt.executeQuery();){
                TableEntryHelper.extractKeyHashPart(rs, entry, isSubPart);
            }
        }
    }

    static List<ObObjType> parseListPartTypes(List<ObPartColumn> partColumns) {
        if (CollectionUtils.isEmpty(partColumns)) {
            return Lists.newArrayList();
        }
        return partColumns.stream().map(c -> c.getObjType()).collect(Collectors.toList());
    }

    static void setPartDescProperty(ObPartDesc partDesc, List<ObPartColumn> partColumns) {
        if (partDesc == null || partColumns == null) {
            return;
        }
        ObPartFuncType obPartFuncType = partDesc.getPartFuncType();
        if (obPartFuncType.isKeyPart()) {
            String partExpr = partDesc.getPartExpr();
            if (StringUtils.isBlank((CharSequence)partExpr)) {
                partDesc.setPartExpr(partColumns.stream().map(c -> c.getColumnName()).collect(Collectors.joining(",")));
            }
            ((ObKeyPartDesc)partDesc).setPartColumns(partColumns);
        } else if (obPartFuncType.isHashPart()) {
            ObHashPartDesc hashPartDesc = (ObHashPartDesc)partDesc;
            if (CollectionUtils.isEmpty(hashPartDesc.getPartColumns())) {
                hashPartDesc.setPartColumns(partColumns);
            }
        } else if (obPartFuncType.isListPart()) {
            ((ObListPartDesc)partDesc).setTypes(TableEntryHelper.parseListPartTypes(partColumns));
        }
    }

    static ObPartDesc extractPartDesc(TableEntry entry, ResultSet rs, ObPartLevel level, boolean subsequentV4) throws Exception {
        String tableName = entry.getTableName();
        String partLevelPrefix = level == ObPartLevel.LEVEL_TWO ? "sub_" : "";
        ObPartFuncType partType = ObPartFuncType.getObPartFuncType(rs.getLong(partLevelPrefix + "part_type"), subsequentV4);
        String partExpr = rs.getString(partLevelPrefix + "part_expr").replaceAll("[\"`]", "");
        if (partType.isRangePart()) {
            ObRangePartDesc rangePartDesc = new ObRangePartDesc(subsequentV4);
            rangePartDesc.setTableName(tableName);
            rangePartDesc.setPartExpr(partExpr);
            rangePartDesc.setPartFuncType(partType);
            String rangeType = rs.getString(partLevelPrefix + "part_range_type");
            rangePartDesc.setTypes(Arrays.stream(rangeType.split(",")).map(t -> ObObjType.getObObjType(Integer.valueOf(t.trim()))).collect(Collectors.toList()));
            return rangePartDesc;
        }
        if (partType.isHashPart()) {
            ObHashPartDesc hashPartDesc = new ObHashPartDesc(entry.getServerMode(), subsequentV4);
            hashPartDesc.setTableName(tableName);
            hashPartDesc.setPartExpr(partExpr);
            hashPartDesc.setPartFuncType(partType);
            if (!subsequentV4 || StringUtils.isEmpty((CharSequence)partLevelPrefix)) {
                hashPartDesc.setPartNum(rs.getInt(partLevelPrefix + "part_num"));
            }
            hashPartDesc.setPartSpace(rs.getInt(partLevelPrefix + "part_space"));
            hashPartDesc.setPartNameIdMap(TableEntryHelper.buildDefaultPartNameIdMap(hashPartDesc.getPartNum()));
            return hashPartDesc;
        }
        if (partType.isKeyPart()) {
            ObKeyPartDesc keyPartDesc = new ObKeyPartDesc(entry.getServerMode(), subsequentV4);
            keyPartDesc.setTableName(tableName);
            keyPartDesc.setPartExpr(partExpr);
            keyPartDesc.setPartFuncType(partType);
            if (!subsequentV4 || StringUtils.isEmpty((CharSequence)partLevelPrefix)) {
                keyPartDesc.setPartNum(rs.getInt(partLevelPrefix + "part_num"));
            }
            keyPartDesc.setPartSpace(rs.getInt(partLevelPrefix + "part_space"));
            keyPartDesc.setPartNameIdMap(TableEntryHelper.buildDefaultPartNameIdMap(keyPartDesc.getPartNum()));
            return keyPartDesc;
        }
        if (partType.isListPart()) {
            ObListPartDesc listPartDesc = new ObListPartDesc(subsequentV4);
            listPartDesc.setTableName(tableName);
            listPartDesc.setPartExpr(partExpr);
            listPartDesc.setPartFuncType(partType);
            return listPartDesc;
        }
        log.error("Unsupported {}part type: {}", (Object)(level == ObPartLevel.LEVEL_TWO ? "sub " : ""), (Object)partType);
        return null;
    }

    static ObServerAddr buildServerAddr(String ip, Long port) {
        if (CommonUtils.isIpValid(ip) && port > 0L) {
            return new ObServerAddr(ip, port);
        }
        if (CommonUtils.isVirtualAddr(ip, port)) {
            log.info("Invalid observer address: [{}:{}] was found", (Object)ip, (Object)port);
        } else {
            log.error("Invalid observer address: [{}:{}] was found", (Object)ip, (Object)port);
        }
        return null;
    }

    static Map<String, Long> buildDefaultPartNameIdMap(int partNum) {
        return Stream.iterate(0L, i -> i + 1L).limit(partNum).collect(Collectors.toMap(i -> "p" + i, i -> i, (k1, k2) -> k2));
    }

    static Map<Long, Set<String>> buildPartIdNameMap(TableEntry tableEntry) {
        return TableEntryHelper.buildPartIdNameMap(tableEntry, false);
    }

    static Map<Long, Set<String>> buildPartIdNameMap(TableEntry tableEntry, boolean isSubsequentV4) {
        if (tableEntry.isNonPartitionTable()) {
            HashMap<Long, Set<String>> partitionMap = new HashMap<Long, Set<String>>(1);
            partitionMap.put(0L, Sets.newHashSet((Object[])new String[]{""}));
            return partitionMap;
        }
        String table = tableEntry.getTableName();
        ObTablePart tablePart = tableEntry.getTablePart();
        ObPartDesc partDesc = tablePart.getPartDesc();
        if (partDesc == null) {
            HashMap<Long, Set<String>> partitionMap = new HashMap<Long, Set<String>>(1);
            partitionMap.put(0L, Sets.newHashSet((Object[])new String[]{""}));
            log.error("The partition desc is null for table: \"{}\", please check it now....", (Object)table);
            return partitionMap;
        }
        HashMap<Long, Set<String>> partIdNameMap = new HashMap<Long, Set<String>>();
        Map<String, Long> partNameIdMap = partDesc.getPartNameIdMap();
        if (!tablePart.isSubPartitioned()) {
            if (isSubsequentV4) {
                for (Map.Entry<String, Long> e : partNameIdMap.entrySet()) {
                    Long tabletId = tablePart.getPartIdTabletIdMap().get(e.getValue());
                    Set<String> partNames = partIdNameMap.getOrDefault(tabletId, Sets.newHashSet());
                    partNames.add(e.getKey());
                    partIdNameMap.putIfAbsent(tabletId, partNames);
                }
                return partIdNameMap;
            }
            for (Map.Entry<String, Long> e : partNameIdMap.entrySet()) {
                Set<String> partNames = partIdNameMap.getOrDefault(e.getValue(), Sets.newHashSet());
                partNames.add(e.getKey());
                partIdNameMap.putIfAbsent(e.getValue(), partNames);
            }
            return partIdNameMap;
        }
        ObPartDesc subPartDesc = tablePart.getSubPartDesc();
        if (subPartDesc == null) {
            log.error("The subpartition desc is null for table: \"{}\", please check it now....", (Object)table);
            return partIdNameMap;
        }
        Map<String, Long> subPartNameIdMap = subPartDesc.getPartNameIdMap();
        if (tableEntry.isUseTemplate()) {
            for (Map.Entry<String, Long> se : partNameIdMap.entrySet()) {
                for (Map.Entry<String, Long> spe : subPartNameIdMap.entrySet()) {
                    Long partId = ObPartIdCalculator.generatePartId(se.getValue(), spe.getValue());
                    Set<String> partNames = partIdNameMap.getOrDefault(partId, Sets.newHashSet());
                    String partName = se.getKey() + "s" + spe.getKey();
                    partNames.add(partName);
                    partIdNameMap.putIfAbsent(partId, partNames);
                }
            }
        } else if (isSubsequentV4) {
            for (Map.Entry<String, Long> se : subPartNameIdMap.entrySet()) {
                Long tabletId = tablePart.getPartIdTabletIdMap().get(se.getValue());
                Set<String> subPartNames = partIdNameMap.getOrDefault(tabletId, Sets.newHashSet());
                subPartNames.add(se.getKey());
                partIdNameMap.putIfAbsent(tabletId, subPartNames);
            }
        } else {
            for (Map.Entry<String, Long> se : partNameIdMap.entrySet()) {
                List<String> subPartNames = subPartDesc.getPartIdSubNamesMap().get(se.getValue());
                for (String subPartName : subPartNames) {
                    Long partId = ObPartIdCalculator.generatePartId(se.getValue(), subPartNameIdMap.get(subPartName));
                    Set<String> partNames = partIdNameMap.getOrDefault(partId, Sets.newHashSet());
                    partNames.add(subPartName);
                    partIdNameMap.putIfAbsent(partId, partNames);
                }
            }
        }
        return partIdNameMap;
    }

    static class LocationState {
        private boolean init;
        private String leader;

        public boolean isOneUnitWithNonRandomPrimaryZone() {
            return this.init && StringUtils.isNotBlank((CharSequence)this.leader);
        }

        public boolean isInit() {
            return this.init;
        }

        public String getLeader() {
            return this.leader;
        }

        public void setInit(boolean init) {
            this.init = init;
        }

        public void setLeader(String leader) {
            this.leader = leader;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocationState)) {
                return false;
            }
            LocationState other = (LocationState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isInit() != other.isInit()) {
                return false;
            }
            String this$leader = this.getLeader();
            String other$leader = other.getLeader();
            return !(this$leader == null ? other$leader != null : !this$leader.equals(other$leader));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LocationState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isInit() ? 79 : 97);
            String $leader = this.getLeader();
            result = result * 59 + ($leader == null ? 43 : $leader.hashCode());
            return result;
        }

        public String toString() {
            return "TableEntryHelper.LocationState(init=" + this.isInit() + ", leader=" + this.getLeader() + ")";
        }

        public LocationState(boolean init, String leader) {
            this.init = init;
            this.leader = leader;
        }
    }
}

