/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.helper;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeV4;
import com.oceanbase.partition.calculator.helper.TableEntryHelper;
import com.oceanbase.partition.calculator.model.ObCmpKV;
import com.oceanbase.partition.calculator.model.ObReplicaType;
import com.oceanbase.partition.calculator.model.ObServerAddr;
import com.oceanbase.partition.calculator.model.ObServerRole;
import com.oceanbase.partition.calculator.model.PartitionLocation;
import com.oceanbase.partition.calculator.model.ReplicaLocation;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.partition.calculator.visitor.ObPartEvalVisitor;
import com.oceanbase.partition.metadata.desc.ObListPartDesc;
import com.oceanbase.partition.metadata.desc.ObPartDesc;
import com.oceanbase.partition.metadata.desc.ObPartItem;
import com.oceanbase.partition.metadata.desc.ObRangePartDesc;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEntryHelperFor4 {
    private static final Logger log = LoggerFactory.getLogger(TableEntryHelperFor4.class);
    static final String PROXY_PART_INFO_SQL_ORACLE = "select part_level,part_num,part_type,part_space,part_expr,part_range_type,part_interval_bin,interval_start_bin,sub_part_type,sub_part_space,sub_part_range_type,def_sub_part_interval_bin,def_sub_interval_start_bin,sub_part_expr,part_key_name,part_key_type,part_key_idx,part_key_level,part_key_extra,spare1 from SYS.all_virtual_proxy_partition_info where tenant_name=? and table_id=? order by part_key_level,part_key_name";
    static final String PROXY_PART_INFO_SQL_MYSQL = "select part_level,part_num,part_type,part_space,part_expr,part_range_type,part_interval_bin,interval_start_bin,sub_part_type,sub_part_space,sub_part_range_type,def_sub_part_interval_bin,def_sub_interval_start_bin,sub_part_expr,part_key_name,part_key_type,part_key_idx,part_key_level,part_key_extra,spare1 from oceanbase.__all_virtual_proxy_partition_info where tenant_name=? and table_id=? order by part_key_level,part_key_name";
    static final String PROXY_PART_LEADER_LOCATION_SQL_ORACLE = "select svr_ip,sql_port,table_id,table_type,role,tablet_id,part_num,replica_num,schema_version,replica_type from SYS.all_virtual_proxy_schema where tenant_name=? and database_name=? and table_name=? and tablet_id in ({0}) and role=1 order by role asc";
    static final String PROXY_PART_LEADER_LOCATION_SQL_MYSQL = "select svr_ip,sql_port,table_id,table_type,role,tablet_id,part_num,replica_num,schema_version,replica_type from oceanbase.__all_virtual_proxy_schema where tenant_name=? and database_name=? and table_name=? and tablet_id in ({0}) and role=1 order by role asc";
    private static final String PROXY_PARTITION_SQL_ORACLE = "select part_id,tablet_id,part_name,sub_part_num,high_bound_val,part_position from SYS.all_virtual_proxy_partition where tenant_name=? and table_id=? order by part_id asc";
    private static final String PROXY_PARTITION_SQL_MYSQL = "select part_id,tablet_id,part_name,sub_part_num,high_bound_val,part_position from oceanbase.__all_virtual_proxy_partition where tenant_name=? and table_id=? order by part_id asc";
    private static final String PROXY_SUB_PARTITION_SQL_ORACLE = "select part_id,sub_part_id,sub_part_position,tablet_id,part_name,high_bound_val from SYS.all_virtual_proxy_sub_partition where tenant_name=? and table_id=?";
    private static final String PROXY_SUB_PARTITION_SQL_MYSQL = "select part_id,sub_part_id,sub_part_position,tablet_id,part_name,high_bound_val from oceanbase.__all_virtual_proxy_sub_partition where tenant_name=? and table_id=?";
    private static final String CHECK_LEADER_COUNT_ORACLE = "select count(zone) from SYS.DBA_OB_LS_LOCATIONS where role = 'LEADER'";
    private static final String CHECK_LEADER_COUNT_MYSQL = "select count(zone) from oceanbase.DBA_OB_LS_LOCATIONS where role = 'LEADER'";
    private static final String CHECK_LEADER_ADDRESS_ORACLE = "select svr_ip,sql_port from SYS.DBA_OB_LS_LOCATIONS where role = 'LEADER'";
    private static final String CHECK_LEADER_ADDRESS_MYSQL = "select svr_ip,sql_port from oceanbase.DBA_OB_LS_LOCATIONS where role = 'LEADER'";
    private static final String PROXY_PLAIN_SCHEMA_SQL_ORACLE = "select svr_ip,sql_port,table_id,table_type,role,part_num,replica_num,schema_version,spare1 from SYS.all_virtual_proxy_schema where tenant_name = ? and database_name = ? and table_name = ? and TABLET_ID = 0 order by role asc";
    private static final String PROXY_PLAIN_SCHEMA_SQL_MYSQL = "select svr_ip,sql_port,table_id,table_type,role,part_num,replica_num,schema_version,spare1 from oceanbase.__all_virtual_proxy_schema where tenant_name = ? and database_name = ? and table_name = ? and TABLET_ID = 0 order by role asc";

    static void queryTablePart(Connection conn, TableEntry entry) throws Exception {
        String PROXY_PART_INFO_SQL = entry.getServerMode().isOracleMode() ? PROXY_PART_INFO_SQL_ORACLE : PROXY_PART_INFO_SQL_MYSQL;
        try (PreparedStatement pstmt = conn.prepareStatement(PROXY_PART_INFO_SQL);){
            pstmt.setString(1, entry.getTenantName());
            pstmt.setLong(2, entry.getTableId());
            try (ResultSet rs = pstmt.executeQuery();){
                entry.setTablePart(TableEntryHelper.extractTablePart(entry, rs, true));
            }
        }
    }

    static void queryPartMeta(Connection conn, TableEntry entry, ObPartFuncTypeV4 partType) throws Exception {
        String proxyPartitionSql = entry.getServerMode().isOracleMode() ? PROXY_PARTITION_SQL_ORACLE : PROXY_PARTITION_SQL_MYSQL;
        try (PreparedStatement pstmt = conn.prepareStatement(proxyPartitionSql);){
            pstmt.setString(1, entry.getTenantName());
            pstmt.setLong(2, entry.getTableId());
            try (ResultSet rs = pstmt.executeQuery();){
                if (partType.isRangePart()) {
                    List<ObCmpKV<ObPartItem, Long>> bounds = TableEntryHelperFor4.extractRangePart(rs, entry);
                    ((ObRangePartDesc)entry.getTablePart().getPartDesc()).setBounds(bounds);
                    if (bounds == null) {
                        log.error("Failed to get range partition. Table: {}", (Object)entry.getTableName());
                    }
                } else if (partType.isListPart()) {
                    Map<ObPartItem, Long> maps = TableEntryHelperFor4.extractListPart(rs, entry);
                    ((ObListPartDesc)entry.getTablePart().getPartDesc()).setMaps(maps);
                    if (maps == null) {
                        log.error("Failed to get list partition. Table: {}", (Object)entry.getTableName());
                    }
                } else if (partType.isKeyPart() || partType.isHashPart()) {
                    TableEntryHelperFor4.extractKeyHashPart(rs, entry);
                    if (MapUtils.isEmpty(entry.getTablePart().getPartDesc().getPartNameIdMap())) {
                        log.error("Failed to get key/hash subpartition. Table: {}", (Object)entry.getTableName());
                    }
                } else {
                    log.warn("Unknown partition type: {}", (Object)partType);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to query partition metadata, Table Entry: {}", (Object)entry, (Object)e);
        }
    }

    static void querySubPartMeta(Connection conn, TableEntry entry, ObPartFuncTypeV4 subPartType) throws Exception {
        String proxySubPartitionSql = entry.getServerMode().isOracleMode() ? PROXY_SUB_PARTITION_SQL_ORACLE : PROXY_SUB_PARTITION_SQL_MYSQL;
        try (PreparedStatement pstmt = conn.prepareStatement(proxySubPartitionSql);){
            pstmt.setString(1, entry.getTenantName());
            pstmt.setLong(2, entry.getTableId());
            try (ResultSet rs = pstmt.executeQuery();){
                if (subPartType.isRangePart()) {
                    List<ObCmpKV<ObPartItem, Long>> bounds = TableEntryHelperFor4.extractRangeSubPart(rs, entry);
                    ((ObRangePartDesc)entry.getTablePart().getSubPartDesc()).setBounds(bounds);
                    if (bounds == null) {
                        log.error("Failed to get range subpartition. Table: {}", (Object)entry.getTableName());
                    }
                } else if (subPartType.isListPart()) {
                    Map<ObPartItem, Long> maps = TableEntryHelperFor4.extractListSubPart(rs, entry);
                    ((ObListPartDesc)entry.getTablePart().getSubPartDesc()).setMaps(maps);
                    if (maps == null) {
                        log.error("Failed to get list subpartition. Table: {}", (Object)entry.getTableName());
                    }
                } else if (subPartType.isKeyPart() || subPartType.isHashPart()) {
                    TableEntryHelperFor4.extractKeyHashSubPart(rs, entry);
                    if (MapUtils.isEmpty(entry.getTablePart().getSubPartDesc().getPartNameIdMap())) {
                        log.error("Failed to get key/hash subpartition. Table: {}", (Object)entry.getTableName());
                    }
                } else {
                    log.warn("Unknown sub partition type: {}", (Object)subPartType);
                }
            }
            catch (Exception e) {
                log.error("Failed to get sub partition. Table: {}", (Object)entry.getTableName(), (Object)e);
            }
        }
    }

    private static void extractKeyHashPart(ResultSet rs, TableEntry entry) throws Exception {
        TableEntryHelperFor4.extractKeyHashPart(rs, entry, false);
    }

    static void extractKeyHashSubPart(ResultSet rs, TableEntry entry) throws Exception {
        TableEntryHelperFor4.extractKeyHashPart(rs, entry, true);
    }

    static void extractKeyHashPart(ResultSet rs, TableEntry entry, boolean isSubPart) throws Exception {
        ObTablePart tablePart = entry.getTablePart();
        String fieldName = isSubPart ? "sub_part_id" : "part_id";
        String position = isSubPart ? "sub_part_position" : "part_position";
        ObPartDesc partDesc = isSubPart ? tablePart.getSubPartDesc() : tablePart.getPartDesc();
        HashMap<Long, List<String>> partIdSubNamesMap = new HashMap<Long, List<String>>();
        HashMap<String, Long> partNameIdMap = new HashMap<String, Long>();
        Map<Long, Long> partIdTabletIdMap = entry.getTablePart().getPartIdTabletIdMap();
        Long partId = null;
        while (rs.next()) {
            partId = rs.getLong("part_id");
            String partName = rs.getString("part_name");
            Long partitionedId = rs.getLong(fieldName);
            Long partPosition = rs.getLong(position);
            partDesc.getPartPositionIdMap().put(partPosition, partitionedId);
            if (isSubPart) {
                entry.setUseTemplate(partId == -1L);
                List subPartList = partIdSubNamesMap.getOrDefault(partId, new ArrayList());
                subPartList.add(partName);
                partIdSubNamesMap.putIfAbsent(partId, subPartList);
            }
            partDesc.setPartPosition(rs.getLong(fieldName));
            Long tabletId = rs.getLong("tablet_id");
            partNameIdMap.put(partName, partitionedId);
            partIdTabletIdMap.put(partitionedId, tabletId);
        }
        partDesc.setPartNameIdMap(partNameIdMap);
        partDesc.setPartIdSubNamesMap(partIdSubNamesMap);
        entry.getTablePart().setPartIdTabletIdMap(partIdTabletIdMap);
    }

    private static Map<ObPartItem, Long> extractListPart(ResultSet rs, TableEntry entry) throws Exception {
        return TableEntryHelperFor4.extractListPart(rs, entry, false);
    }

    static Map<ObPartItem, Long> extractListSubPart(ResultSet rs, TableEntry entry) throws Exception {
        return TableEntryHelperFor4.extractListPart(rs, entry, true);
    }

    static Map<ObPartItem, Long> extractListPart(ResultSet rs, TableEntry entry, boolean isSubPart) throws Exception {
        ObTablePart tablePart = entry.getTablePart();
        String fieldName = isSubPart ? "sub_part_id" : "part_id";
        ObPartDesc partDesc = isSubPart ? tablePart.getSubPartDesc() : tablePart.getPartDesc();
        LinkedHashMap<ObPartItem, Long> maps = new LinkedHashMap<ObPartItem, Long>();
        LinkedHashMap<String, Long> partNameIdMap = new LinkedHashMap<String, Long>();
        HashMap<Long, List<String>> partIdSubNamesMap = new HashMap<Long, List<String>>();
        Map<Long, Long> partIdTabletIdMap = entry.getTablePart().getPartIdTabletIdMap();
        List<ObObjType> types = ((ObListPartDesc)partDesc).getTypes();
        boolean isOracleMode = entry.getServerMode().isOracleMode();
        while (rs.next()) {
            Long firstPartId = rs.getLong("part_id");
            Map map = null;
            if (isSubPart) {
                map = ((ObListPartDesc)partDesc).getSubMaps().getOrDefault(firstPartId, new HashMap());
            }
            Long tabletId = rs.getLong("tablet_id");
            Long partitionId = rs.getLong(fieldName);
            String partName = rs.getString("part_name").toLowerCase(Locale.getDefault());
            partNameIdMap.put(partName, partitionId);
            partIdTabletIdMap.put(partitionId, tabletId);
            String highBoundVal = rs.getString("high_bound_val");
            String string = highBoundVal = highBoundVal == null ? "" : highBoundVal.trim();
            if (highBoundVal.length() < 1) {
                log.warn("Bad high_bound_val: [{}], table: {}", (Object)highBoundVal, (Object)entry.getTableName());
            }
            if (highBoundVal.startsWith("(") && highBoundVal.endsWith(")")) {
                highBoundVal = highBoundVal.substring(1, highBoundVal.length() - 1);
            }
            String[] highBoundArray = null;
            List<Object> highBoundList = null;
            boolean isListColumns = false;
            if (highBoundVal.contains("),(")) {
                highBoundArray = highBoundVal.split("\\),\\(");
                isListColumns = true;
            } else if (isOracleMode) {
                highBoundList = TableEntryHelperFor4.parseHighBoundVal("(" + highBoundVal + ")");
                highBoundArray = new String[highBoundList.size()];
                highBoundArray = highBoundList.stream().map(Object::toString).collect(Collectors.toList()).toArray(highBoundArray);
            } else {
                highBoundArray = highBoundVal.split(",");
            }
            ObPartItem key = ObPartDesc.DEFAULT_PART_ITEM;
            for (String highBound : highBoundArray) {
                if (!"default".equalsIgnoreCase(highBound)) {
                    key = isOracleMode && isListColumns ? ObPartItem.getObPartItem(types, TableEntryHelperFor4.parseHighBoundVal("(" + highBound + ")")) : ObPartItem.getObPartItem(types, highBound);
                }
                maps.put(key, partitionId);
                if (!isSubPart) continue;
                map.put(key, partitionId);
                List subPartNames = partIdSubNamesMap.getOrDefault(firstPartId, new ArrayList());
                subPartNames.add(partName);
                partIdSubNamesMap.putIfAbsent(firstPartId, subPartNames);
            }
            ((ObListPartDesc)partDesc).getSubMaps().putIfAbsent(firstPartId, map);
        }
        partDesc.setPartNameIdMap(partNameIdMap);
        partDesc.setPartIdSubNamesMap(partIdSubNamesMap);
        entry.getTablePart().setPartIdTabletIdMap(partIdTabletIdMap);
        return maps;
    }

    private static List<ObCmpKV<ObPartItem, Long>> extractRangePart(ResultSet rs, TableEntry entry) throws Exception {
        return TableEntryHelperFor4.extractRangePart(rs, entry, false);
    }

    static List<ObCmpKV<ObPartItem, Long>> extractRangeSubPart(ResultSet rs, TableEntry entry) throws Exception {
        return TableEntryHelperFor4.extractRangePart(rs, entry, true);
    }

    static List<ObCmpKV<ObPartItem, Long>> extractRangePart(ResultSet rs, TableEntry entry, boolean isSubPart) throws Exception {
        ObTablePart tablePart = entry.getTablePart();
        String fieldName = isSubPart ? "sub_part_id" : "part_id";
        ObPartDesc partDesc = isSubPart ? tablePart.getSubPartDesc() : tablePart.getPartDesc();
        HashMap<String, Long> partNameIdMap = new HashMap<String, Long>();
        HashMap<Long, List<String>> partIdSubNamesMap = new HashMap<Long, List<String>>();
        ArrayList<ObCmpKV<ObPartItem, Long>> bounds = new ArrayList<ObCmpKV<ObPartItem, Long>>();
        Map<Long, Long> partIdTabletIdMap = entry.getTablePart().getPartIdTabletIdMap();
        List<ObObjType> types = ((ObRangePartDesc)partDesc).getTypes();
        boolean isOracleMode = entry.getServerMode().isOracleMode();
        while (rs.next()) {
            Long tabletId = rs.getLong("tablet_id");
            String partName = rs.getString("part_name").toLowerCase(Locale.getDefault());
            Long partitionId = rs.getLong(fieldName);
            ObPartItem item = null;
            String highBoundValString = rs.getString("high_bound_val");
            if (isOracleMode) {
                List<Object> highBoundVal = TableEntryHelperFor4.parseHighBoundVal("(" + highBoundValString + ")");
                item = ObPartItem.getObPartItem(types, highBoundVal);
            } else {
                item = ObPartItem.getObPartItem(types, highBoundValString);
            }
            if (isSubPart) {
                Long firstPartId = rs.getLong("part_id");
                item.setFirstPartId(firstPartId);
                List subList = ((ObRangePartDesc)partDesc).getSubBoundsMap().getOrDefault(firstPartId, new ArrayList());
                subList.add(new ObCmpKV<ObPartItem, Long>(item, partitionId));
                ((ObRangePartDesc)partDesc).getSubBoundsMap().putIfAbsent(firstPartId, subList);
                List subPartNames = partIdSubNamesMap.getOrDefault(firstPartId, new ArrayList());
                subPartNames.add(partName);
                partIdSubNamesMap.putIfAbsent(firstPartId, subPartNames);
            }
            partIdTabletIdMap.put(partitionId, tabletId);
            partNameIdMap.put(partName, partitionId);
            bounds.add(new ObCmpKV<ObPartItem, Long>(item, partitionId));
        }
        partDesc.setPartNameIdMap(partNameIdMap);
        partDesc.setPartIdSubNamesMap(partIdSubNamesMap);
        if (!isSubPart) {
            Collections.sort(bounds);
        }
        return bounds;
    }

    private static List<String> parseHighBoundVal(Connection conn, String highBoundVal) throws SQLException {
        char[] charArray = highBoundVal.toCharArray();
        StringBuilder sb = new StringBuilder();
        StringBuilder highBoundValString = new StringBuilder(highBoundVal.length());
        int columnNumbers = 0;
        for (int i = 0; i < charArray.length; ++i) {
            char cur = charArray[i];
            if (cur == ',' && i - 1 >= 0 && charArray[i - 1] != '\'' && i + 1 < charArray.length && charArray[i + 1] != '\'') {
                String value = sb.toString();
                if (value.equalsIgnoreCase(ObObjType.MAXVALUE.getName())) {
                    highBoundValString.append('\'').append(value).append('\'');
                } else {
                    highBoundValString.append(value);
                }
                ++columnNumbers;
                highBoundValString.append(',');
                sb.setLength(0);
                continue;
            }
            sb.append(cur);
        }
        if (sb.length() != 0) {
            String value = sb.toString();
            if (value.equalsIgnoreCase(ObObjType.MAXVALUE.getName())) {
                highBoundValString.append('\'').append(value).append('\'');
            } else {
                highBoundValString.append(value);
            }
            ++columnNumbers;
        }
        String sql = "select " + highBoundValString.toString() + " from dual";
        ArrayList<String> bounds = new ArrayList<String>();
        try (PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                for (int idx = 1; idx <= columnNumbers; ++idx) {
                    bounds.add(rs.getString(idx));
                }
            }
        }
        return bounds;
    }

    private static List<String> parseHighBoundVal3(Connection conn, String highBoundVal) throws SQLException {
        SQLExpr sqlExpr = SQLUtils.toSQLExpr((String)("(" + highBoundVal + ")"), (DbType)DbType.oceanbase_oracle);
        StringBuilder highBoundValString = new StringBuilder();
        List children = sqlExpr.getChildren();
        int columnNumbers = children.size();
        for (int i = 0; i < columnNumbers; ++i) {
            SQLObject sqlObject = (SQLObject)children.get(i);
            String str = sqlObject.toString();
            if (str.equalsIgnoreCase("MAXVALUE")) {
                highBoundValString.append('\'').append(str).append('\'');
            } else {
                highBoundValString.append(str);
            }
            if (i >= children.size() - 1) continue;
            highBoundValString.append(',');
        }
        String sql = "select " + highBoundValString.toString() + " from dual";
        ArrayList<String> bounds = new ArrayList<String>();
        try (PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                for (int idx = 1; idx <= columnNumbers; ++idx) {
                    bounds.add(rs.getString(idx));
                }
            }
        }
        return bounds;
    }

    private static List<Object> parseHighBoundVal(String highBoundValString) throws Exception {
        SQLExpr sqlExpr = SQLUtils.toSQLExpr((String)highBoundValString);
        ArrayList<Object> output = new ArrayList<Object>();
        TableEntryHelperFor4.resolveExpr(output, sqlExpr);
        return output;
    }

    private static void resolveExpr(List<Object> payload, SQLExpr sqlExpr) throws Exception {
        if (sqlExpr instanceof SQLListExpr) {
            List items = ((SQLListExpr)sqlExpr).getItems();
            for (SQLExpr item : items) {
                TableEntryHelperFor4.resolveExpr(payload, item);
            }
        } else {
            ObPartEvalVisitor obPartEvalVisitor = new ObPartEvalVisitor();
            sqlExpr.accept((SQLASTVisitor)obPartEvalVisitor);
            payload.add(sqlExpr.getAttributes().get("eval.value"));
        }
    }

    /*
     * Exception decompiling
     */
    static boolean isOneUnitWithNonRandomPrimaryZone(Connection conn, boolean isOracle) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static Map<Long, String> queryPartLocationForOneUnit(Connection conn, TableEntry tableEntry, List<Long> partIds) {
        int retryTimes = 0;
        boolean hasValidReplica = false;
        HashMap<Long, PartitionLocation> locationMap = new HashMap<Long, PartitionLocation>();
        String table = tableEntry.getTableName();
        while (!hasValidReplica && retryTimes < 5) {
            String CHECK_LEADER_ADDRESS = tableEntry.getServerMode().isOracleMode() ? CHECK_LEADER_ADDRESS_ORACLE : CHECK_LEADER_ADDRESS_MYSQL;
            try {
                PreparedStatement pstmt = conn.prepareStatement(CHECK_LEADER_ADDRESS);
                Throwable throwable = null;
                try {
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            ReplicaLocation replica = new ReplicaLocation();
                            replica.setRole(ObServerRole.LEADER);
                            replica.setReplicaType(ObReplicaType.UNKNOWN);
                            replica.setAddr(new ObServerAddr(rs.getString("svr_ip"), rs.getLong("sql_port")));
                            if (!replica.isValid()) {
                                log.warn("Ignore the invalid replica: {}, table: {}, part: [{}]", new Object[]{replica, table, partIds});
                                continue;
                            }
                            hasValidReplica = true;
                            for (Long partId : partIds) {
                                PartitionLocation location = new PartitionLocation();
                                location.addReplica(replica);
                                location.setPartId(partId);
                                locationMap.putIfAbsent(partId, location);
                            }
                        }
                        if (hasValidReplica) continue;
                        Thread.sleep((new Random().nextInt(100) + 10) * (2 << ++retryTimes));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
            catch (Exception e) {
                log.warn("Failed to get partition location. table: {}, part: [{}]", new Object[]{table, partIds, e});
            }
        }
        if (!hasValidReplica) {
            throw new IllegalStateException("No valid replicas were found after retry " + retryTimes + " times. table: \"" + table + "\", part: [" + partIds + "]");
        }
        if (retryTimes > 0) {
            log.info("Retry {} times to get partition location. Table: {}, Part: [{}]", new Object[]{retryTimes, table, partIds});
        }
        if (MapUtils.isEmpty(locationMap)) {
            return new HashMap<Long, String>(0);
        }
        return locationMap.values().stream().filter(PartitionLocation::existLeader).collect(Collectors.toMap(PartitionLocation::getPartId, PartitionLocation::getLeaderAddress, (k1, k2) -> k2));
    }

    static Map<Long, String> queryPartLocationForMultiUnit(Connection conn, TableEntry entry, Set<Long> partIds) {
        String PROXY_PART_LEADER_LOCATION_SQL = entry.getServerMode().isOracleMode() ? PROXY_PART_LEADER_LOCATION_SQL_ORACLE : PROXY_PART_LEADER_LOCATION_SQL_MYSQL;
        int retryTimes = 0;
        boolean hasValidReplica = false;
        String table = entry.getTableName();
        String args = partIds.stream().map(e -> "'" + e + "'").collect(Collectors.joining(","));
        String sql = MessageFormat.format(PROXY_PART_LEADER_LOCATION_SQL, args);
        HashMap<Long, PartitionLocation> locationMap = new HashMap<Long, PartitionLocation>();
        while (!hasValidReplica && retryTimes < 5) {
            try {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    pstmt.setString(1, entry.getTenantName());
                    pstmt.setString(2, entry.getDatabaseName());
                    pstmt.setString(3, entry.getTableName());
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            Long partId = rs.getLong("tablet_id");
                            ReplicaLocation replica = new ReplicaLocation();
                            replica.setRole(ObServerRole.getRole(rs.getInt("role")));
                            replica.setReplicaType(ObReplicaType.getObReplicaType(rs.getInt("replica_type")));
                            replica.setAddr(new ObServerAddr(rs.getString("svr_ip"), rs.getLong("sql_port")));
                            if (!replica.isValid()) {
                                log.warn("Ignore the invalid replica: {}, table: {}, part: [{}]", new Object[]{replica, table, args});
                                continue;
                            }
                            PartitionLocation location = locationMap.getOrDefault(partId, new PartitionLocation());
                            location.addReplica(replica);
                            location.setPartId(partId);
                            location.setSchemaVersion(rs.getLong("schema_version"));
                            locationMap.putIfAbsent(partId, location);
                            hasValidReplica = true;
                        }
                        if (hasValidReplica) continue;
                        Thread.sleep((new Random().nextInt(100) + 10) * (2 << ++retryTimes));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
            catch (Exception e2) {
                log.warn("Query leader location failed. table: {}, part: [{}]", new Object[]{table, args, e2});
            }
        }
        if (!hasValidReplica) {
            throw new IllegalStateException("No valid replicas were found after retry " + retryTimes + " times. table: \"" + table + "\", part: [" + args + "]");
        }
        if (retryTimes > 0) {
            log.info("Retry {} times to get partition location. Table: {}, Part: [{}]", new Object[]{retryTimes, table, args});
        }
        if (MapUtils.isEmpty(locationMap)) {
            return new HashMap<Long, String>(0);
        }
        return locationMap.values().stream().filter(PartitionLocation::existLeader).collect(Collectors.toMap(PartitionLocation::getPartId, PartitionLocation::getLeaderAddress, (k1, k2) -> k2));
    }

    /*
     * Exception decompiling
     */
    public static TableEntry queryTableEntry(Connection conn, TableEntryKey key) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

