/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public final class ObReplicaType
extends Enum<ObReplicaType> {
    public static final /* enum */ ObReplicaType FULL;
    public static final /* enum */ ObReplicaType BACKUP;
    public static final /* enum */ ObReplicaType LOGONLY;
    public static final /* enum */ ObReplicaType READONLY;
    public static final /* enum */ ObReplicaType MEMONLY;
    public static final /* enum */ ObReplicaType UNKNOWN;
    public static final /* enum */ ObReplicaType INVALID;
    private static final Map<Integer, ObReplicaType> INDEX_MAPPING;
    private static final Map<String, ObReplicaType> NAME_MAPPING;
    private final String name;
    private final int index;
    private static final /* synthetic */ ObReplicaType[] $VALUES;

    public static ObReplicaType[] values() {
        return (ObReplicaType[])$VALUES.clone();
    }

    public static ObReplicaType valueOf(String name) {
        return Enum.valueOf(ObReplicaType.class, name);
    }

    private ObReplicaType(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public static ObReplicaType getObReplicaType(int index) {
        return INDEX_MAPPING.getOrDefault(index, INVALID);
    }

    public static ObReplicaType getObReplicaType(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String upper = name.toUpperCase(Locale.getDefault());
        return NAME_MAPPING.getOrDefault(upper, INVALID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObReplicaType [");
        sb.append("name: ").append(this.name);
        sb.append(", index: ").append(this.index);
        return sb.append("]").toString();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    static {
        ObReplicaType[] obReplicaTypes;
        FULL = new ObReplicaType("FULL", 0);
        BACKUP = new ObReplicaType("BACKUP", 1);
        LOGONLY = new ObReplicaType("LOGONLY", 5);
        READONLY = new ObReplicaType("READONLY", 16);
        MEMONLY = new ObReplicaType("MEMONLY", 20);
        UNKNOWN = new ObReplicaType("UNKNOWN", 512);
        INVALID = new ObReplicaType("INVALID", -1);
        $VALUES = new ObReplicaType[]{FULL, BACKUP, LOGONLY, READONLY, MEMONLY, UNKNOWN, INVALID};
        INDEX_MAPPING = new HashMap<Integer, ObReplicaType>(6);
        NAME_MAPPING = new HashMap<String, ObReplicaType>(6);
        for (ObReplicaType obReplicaType : obReplicaTypes = ObReplicaType.values()) {
            NAME_MAPPING.putIfAbsent(obReplicaType.getName(), obReplicaType);
            INDEX_MAPPING.putIfAbsent(obReplicaType.getIndex(), obReplicaType);
        }
    }
}

