/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import com.oceanbase.partition.calculator.utils.CommonUtils;
import java.io.Serializable;
import java.util.Objects;

public class ObServerAddr
implements Serializable,
Comparable<ObServerAddr> {
    private static final long serialVersionUID = 2642863009522856191L;
    private final String ip;
    private final Long port;

    public ObServerAddr(String ip, long port) {
        this(ip, (Long)port);
    }

    public ObServerAddr(String ip, Long port) {
        this.ip = ip;
        this.port = port;
    }

    public String getAddress() {
        return this.getIp() + ":" + this.getPort();
    }

    public boolean isValid() {
        return CommonUtils.isIpValid(this.getIp()) && this.getPort() > 0L;
    }

    public String toString() {
        return "ObServerAddr [" + this.getAddress() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.getIp(), this.getPort());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObServerAddr other = (ObServerAddr)obj;
        return Objects.deepEquals(this.getIp(), other.getIp()) && Objects.deepEquals(this.getPort(), other.getPort());
    }

    @Override
    public int compareTo(ObServerAddr other) {
        if (null == other || !this.isValid() || !other.isValid()) {
            return 0;
        }
        if (this.ip.compareTo(other.ip) > 0) {
            return 1;
        }
        if (this.ip.compareTo(other.ip) < 0) {
            return -1;
        }
        if (this.port > other.port) {
            return 1;
        }
        if (this.port < other.port) {
            return -1;
        }
        return 0;
    }

    public String getIp() {
        return this.ip;
    }

    public Long getPort() {
        return this.port;
    }
}

