/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import java.util.HashMap;
import java.util.Map;

public final class ObTableTypeEnum
extends Enum<ObTableTypeEnum> {
    public static final /* enum */ ObTableTypeEnum SYSTEM_TABLE;
    public static final /* enum */ ObTableTypeEnum SYSTEM_VIEW;
    public static final /* enum */ ObTableTypeEnum VIRTUAL_TABLE;
    public static final /* enum */ ObTableTypeEnum USER_TABLE;
    public static final /* enum */ ObTableTypeEnum USER_VIEW;
    public static final /* enum */ ObTableTypeEnum USER_INDEX;
    public static final /* enum */ ObTableTypeEnum TMP_TABLE;
    public static final /* enum */ ObTableTypeEnum MATERIALIZED_VIEW;
    public static final /* enum */ ObTableTypeEnum MAX_TABLE_TYPE;
    private static final Map<Integer, ObTableTypeEnum> INDEX_MAPPING;
    private final int id;
    private final String desc;
    private static final /* synthetic */ ObTableTypeEnum[] $VALUES;

    public static ObTableTypeEnum[] values() {
        return (ObTableTypeEnum[])$VALUES.clone();
    }

    public static ObTableTypeEnum valueOf(String name) {
        return Enum.valueOf(ObTableTypeEnum.class, name);
    }

    private ObTableTypeEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    public static ObTableTypeEnum getObTableTypeEnum(int index) {
        return INDEX_MAPPING.getOrDefault(index, MAX_TABLE_TYPE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObTableTypeEnum [");
        sb.append("id: ").append(this.getId());
        sb.append(", name: ").append(this.name());
        sb.append(", desc: ").append(this.getDesc());
        return sb.append("]").toString();
    }

    public int getId() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ObTableTypeEnum[] obTableTypeEnums;
        SYSTEM_TABLE = new ObTableTypeEnum(0, "system table, for example : __all_server");
        SYSTEM_VIEW = new ObTableTypeEnum(1, "system view, for example: v@sql_audit");
        VIRTUAL_TABLE = new ObTableTypeEnum(2, "virtual table, for example : __all_virtual_proxy_schema");
        USER_TABLE = new ObTableTypeEnum(3, "user defined table by ddl");
        USER_VIEW = new ObTableTypeEnum(4, "user defined view by ddl");
        USER_INDEX = new ObTableTypeEnum(5, "user index table");
        TMP_TABLE = new ObTableTypeEnum(6, "system temp table");
        MATERIALIZED_VIEW = new ObTableTypeEnum(7, "materialized view");
        MAX_TABLE_TYPE = new ObTableTypeEnum(8, "max table type, just for defence");
        $VALUES = new ObTableTypeEnum[]{SYSTEM_TABLE, SYSTEM_VIEW, VIRTUAL_TABLE, USER_TABLE, USER_VIEW, USER_INDEX, TMP_TABLE, MATERIALIZED_VIEW, MAX_TABLE_TYPE};
        INDEX_MAPPING = new HashMap<Integer, ObTableTypeEnum>(10);
        for (ObTableTypeEnum obTableTypeEnum : obTableTypeEnums = ObTableTypeEnum.values()) {
            INDEX_MAPPING.putIfAbsent(obTableTypeEnum.getId(), obTableTypeEnum);
        }
    }
}

