/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import com.google.common.collect.Sets;
import com.oceanbase.partition.calculator.enums.ObServerMode;
import com.oceanbase.partition.calculator.model.ObRouteEntry;
import com.oceanbase.partition.calculator.model.ObTableTypeEnum;
import com.oceanbase.partition.calculator.model.PartitionLocation;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.partition.calculator.model.TableLocation;
import com.oceanbase.partition.calculator.model.TenantLocation;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TableEntry
extends ObRouteEntry {
    private boolean useTemplate;
    private ObServerMode serverMode;
    private Long tableId = Long.MIN_VALUE;
    private Long replicaNum = Long.MIN_VALUE;
    private Long partitionNum = Long.MIN_VALUE;
    private Long schemaVersion;
    private boolean isVirtualTableEntry;
    private TableLocation tableLocation;
    private ObTablePart tablePart;
    private TableEntryKey tableEntryKey = new TableEntryKey();
    private ObTableTypeEnum tableType = ObTableTypeEnum.USER_TABLE;

    public static TableEntry allocBuildingEntry(TableEntryKey tableEntryKey) {
        TableEntry buildingEntry = new TableEntry();
        buildingEntry.setTableEntryKey(tableEntryKey);
        buildingEntry.setBuildingState();
        buildingEntry.setTableType(ObTableTypeEnum.USER_TABLE);
        return buildingEntry;
    }

    public boolean isPartitionTable() {
        return this.partitionNum > 1L;
    }

    public boolean isNonPartitionTable() {
        return !this.isPartitionTable();
    }

    public String getTenantName() {
        return this.tableEntryKey.getTenantName();
    }

    public void setTenantName(String tenantName) {
        this.tableEntryKey.setTenantName(tenantName);
    }

    public String getDatabaseName() {
        return this.tableEntryKey.getSchemaName();
    }

    public void setDatabaseName(String databaseName) {
        this.tableEntryKey.setSchemaName(databaseName);
    }

    public String getTableName() {
        return this.tableEntryKey.getTableName();
    }

    public void setTableName(String tableName) {
        this.tableEntryKey.setTableName(tableName);
    }

    public String getClusterName() {
        return this.tableEntryKey.getClusterName();
    }

    public void setClusterName(String clusterName) {
        this.tableEntryKey.setClusterName(clusterName);
    }

    public void setPartitionNum(Long partitionNum) {
        this.partitionNum = partitionNum;
    }

    public TenantLocation getTenantLocation() {
        if (this.tableLocation instanceof TenantLocation) {
            return (TenantLocation)this.tableLocation;
        }
        return null;
    }

    public PartitionLocation getPartitionLocation() {
        if (this.tableLocation instanceof PartitionLocation) {
            return (PartitionLocation)this.tableLocation;
        }
        return null;
    }

    public void setPartitionLocation(PartitionLocation partition) {
        this.tableLocation = partition;
    }

    public Map<Long, Set<String>> getPartIdNameMap() {
        if (this.isPartitionTable()) {
            return this.getTablePart().getPartIdNameMap();
        }
        HashMap<Long, Set<String>> partMap = new HashMap<Long, Set<String>>(1);
        partMap.put(0L, Sets.newHashSet());
        return partMap;
    }

    public boolean isValid() {
        TableEntryKey entryKey = this.getTableEntryKey();
        return entryKey != null && entryKey.isValid() && (this.isBuildingState() || this.isVirtualTableEntry() || this.getPartitionNum() > 0L && this.getReplicaNum() > 0L && (this.getPartitionLocation() != null && this.getPartitionLocation().isValid() || null != this.getTenantLocation() && this.getTenantLocation().isValid() && 1L == this.getPartitionNum() || null != this.getPartitionLocation() && this.getPartitionLocation().isValid() && this.getPartitionNum() > 1L));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTableEntryKey());
        sb.append(", TableId: ").append(this.getTableId());
        sb.append(", PartitionNum: ").append(this.getPartitionNum());
        sb.append(", ReplicaNum: ").append(this.getReplicaNum());
        sb.append(", SchemaVersion: ").append(this.getSchemaVersion());
        sb.append(", PartitionInfo: ").append(this.getTablePart());
        return sb.toString();
    }

    public boolean isUseTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    public ObServerMode getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(ObServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public Long getReplicaNum() {
        return this.replicaNum;
    }

    public void setReplicaNum(Long replicaNum) {
        this.replicaNum = replicaNum;
    }

    public Long getPartitionNum() {
        return this.partitionNum;
    }

    public Long getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(Long schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public boolean isVirtualTableEntry() {
        return this.isVirtualTableEntry;
    }

    public void setVirtualTableEntry(boolean isVirtualTableEntry) {
        this.isVirtualTableEntry = isVirtualTableEntry;
    }

    public TableLocation getTableLocation() {
        return this.tableLocation;
    }

    public void setTableLocation(TableLocation tableLocation) {
        this.tableLocation = tableLocation;
    }

    public ObTablePart getTablePart() {
        return this.tablePart;
    }

    public void setTablePart(ObTablePart tablePart) {
        this.tablePart = tablePart;
    }

    public TableEntryKey getTableEntryKey() {
        return this.tableEntryKey;
    }

    public void setTableEntryKey(TableEntryKey tableEntryKey) {
        this.tableEntryKey = tableEntryKey;
    }

    public ObTableTypeEnum getTableType() {
        return this.tableType;
    }

    public void setTableType(ObTableTypeEnum tableType) {
        this.tableType = tableType;
    }
}

