/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.struct;

import com.oceanbase.partition.calculator.algo.hash.MurmurHash;
import com.oceanbase.partition.calculator.struct.ObCommonStruct;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObNumber
extends ObCommonStruct
implements Comparable<ObNumber> {
    private static final Logger log = LoggerFactory.getLogger(ObNumber.class);
    private static final long serialVersionUID = 3990243913376970119L;
    private static final int EXP_ZERO = 64;
    private static final int MAX_STORE_LEN = 10;
    private static final long MAX_RANGE = 1000000000L;
    private static final int POSITIVE_EXP_BOUNDARY = 192;
    private static final int NEGATIVE_EXP_BOUNDARY = 64;
    private static final int DIGIT_LEN = 9;
    private static final int OB_MAX_NUMBER_PRECISION_INNER = 40;
    private static final int OB_MIN_NUMBER_SCALE = -84;
    private static final int OB_MAX_NUMBER_SCALE = 127;
    private static final int ORA_NUMBER_SCALE_UNKNOWN_YET = -85;
    private static final int PRECISION_UNKNOWN_YET = -1;
    private static final int OB_INVALID_INDEX = -1;
    private static final int POSITIVE = 1;
    private static final int NEGATIVE = 0;
    private static final long BASE = 1000000000L;
    private static final long MAX_VALUED_DIGIT = 999999999L;
    private static final long MAX_INTEGER_EXP = 14L;
    private static final int OB_INTEGER_PRECISION_OVERFLOW = -5088;
    private static final int OB_DECIMAL_PRECISION_OVERFLOW = -5089;
    private static final int OB_SUCCESS = 0;
    private static final int MAX_SCI_SIZE = 126;
    private static final int MIN_SCI_SIZE = -130;
    private static final int FLOATING_SCALE = 72;
    private static final int MAX_DECIMAL_EXP = 15;
    final long[] MAX_INTEGER = new long[]{0L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L};
    final long[] ROUND_POWS = new long[]{1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1000000000L};
    private boolean oracleMode;
    private int[] digits;
    private int length;
    private int sign;
    private long exponent;
    private BigDecimal value;
    private long[] POWS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L};

    public ObNumber(Object numberObj) {
        this(numberObj, false);
    }

    public ObNumber(Object numberObj, boolean oracleMode) {
        this.oracleMode = oracleMode;
        if (numberObj == null) {
            return;
        }
        if (numberObj instanceof BigDecimal) {
            this.value = (BigDecimal)numberObj;
            this.fill0(numberObj.toString());
        } else {
            String str = numberObj.toString();
            if (NumberUtils.isCreatable((String)str)) {
                this.value = NumberUtils.toScaledBigDecimal((String)str);
                this.fill0(str);
            } else {
                log.warn("Input number object: {} cannot be parsed", numberObj);
            }
        }
    }

    @Deprecated
    private void fill1(String numberStr) {
        int start;
        char[] chars = numberStr.toCharArray();
        BigDecimal bigDecimal = new BigDecimal(chars, 0, chars.length);
        int precision = bigDecimal.precision();
        int scale = bigDecimal.scale();
        long digitId = 0L;
        int step = 0;
        boolean hasIntegerPart = false;
        long exp = 0L;
        int currDigit = 0;
        int end = precision - scale;
        int integerLen = (precision - start - 1) / 9 + 1;
        this.length = 10;
        boolean isNegative = BigDecimal.ZERO.compareTo(bigDecimal) > 0;
        this.digits = new int[10];
        if (precision - scale > 0) {
            step = (end - start - 1) % 9 + 1;
            for (start = 0; start < end && digitId < (long)this.length; start += step, ++digitId) {
                this.digits[currDigit++] = this.atoiPositiveUnchecked(chars, start, step);
                step = 9;
            }
            exp = integerLen - 1;
            hasIntegerPart = true;
        }
        if (digitId < (long)this.length && end + 1 < chars.length) {
            int decimalEnd = chars.length;
            if (!hasIntegerPart) {
                for (start = end + 1; start != decimalEnd && chars[start] == '0'; ++start) {
                }
                int decimalZero = (start - end - 1) / 9 + 1;
                exp = -decimalZero;
                step = 9 - (start - end - 1) % 9;
            } else {
                step = 9;
            }
            while (start < decimalEnd && digitId < (long)this.length) {
                if (start + step < decimalEnd) {
                    this.digits[currDigit++] = this.atoiPositiveUnchecked(chars, start, step);
                } else {
                    this.digits[currDigit] = this.atoiPositiveUnchecked(chars, start, chars.length);
                    int n = currDigit++;
                    this.digits[n] = (int)((long)this.digits[n] * this.POWS[step - (decimalEnd - start)]);
                }
                start += step;
                ++digitId;
                step = 9;
            }
        }
        for (currDigit = (int)digitId - 1; currDigit >= 0 && 0 == this.digits[currDigit]; --currDigit) {
        }
        this.length = currDigit >= 0 ? currDigit + 1 : 0;
        this.sign = isNegative ? 0 : 1;
        this.exponent = 0x7FL & 64L + exp;
        if (this.sign == 0) {
            this.exponent = (0x7FL & (this.exponent ^ 0xFFFFFFFFFFFFFFFFL)) + 1L;
        }
        if (this.length == 0) {
            this.sign = 1;
            this.exponent = 0L;
        } else if (this.digits == null) {
            log.error("alloc digits fail");
        } else {
            boolean ret = this.roundScaleV3(this.isOracleMode() ? 130L : 72L, true, false);
            if (ret) {
                return;
            }
            log.warn("");
            if (this.expCheck() != 0) {
                log.warn("exponent precision check fail");
            }
        }
    }

    private void fill0(String numberStr) {
        char[] chars = numberStr.toCharArray();
        boolean hasSimple = chars[0] == '-' || chars[0] == '+';
        BigDecimal bigDecimal = new BigDecimal(chars, 0, chars.length);
        int precision = bigDecimal.abs().precision();
        int scale = bigDecimal.abs().scale();
        long digitId = 0L;
        int step = 0;
        boolean hasIntegerPart = false;
        int currDigit = 0;
        int start = hasSimple ? 1 : 0;
        int end = precision - scale + (hasSimple ? 1 : 0);
        long exp = 0L;
        this.length = 10;
        boolean isNegative = BigDecimal.ZERO.compareTo(bigDecimal) > 0;
        this.digits = new int[10];
        if (start < end) {
            int integerLen = (end - start - 1) / 9 + 1;
            step = (end - start - 1) % 9 + 1;
            for (int strPtr = start; strPtr < end && digitId < (long)this.length; strPtr += step, ++digitId) {
                this.digits[currDigit++] = this.atoiPositiveUnchecked(chars, strPtr, strPtr + step);
                step = 9;
            }
            exp = integerLen - 1;
            hasIntegerPart = true;
        }
        if (digitId < (long)this.length && end + 1 < chars.length) {
            int decimalEnd = chars.length;
            if (!hasIntegerPart) {
                for (start = end + 1; start != decimalEnd && chars[start] == '0'; ++start) {
                }
                int decimalZero = (start - end - 1) / 9 + 1;
                exp = -decimalZero;
                step = 9 - (start - end - 1) % 9;
            } else {
                step = 9;
            }
            while (start < decimalEnd && digitId < (long)this.length) {
                if (start + step < decimalEnd) {
                    this.digits[currDigit++] = this.atoiPositiveUnchecked(chars, start, step);
                } else {
                    this.digits[currDigit] = this.atoiPositiveUnchecked(chars, start, chars.length);
                    int n = currDigit++;
                    this.digits[n] = (int)((long)this.digits[n] * this.POWS[step - (decimalEnd - start)]);
                }
                start += step;
                ++digitId;
                step = 9;
            }
        }
        for (currDigit = (int)digitId - 1; currDigit >= 0 && 0 == this.digits[currDigit]; --currDigit) {
        }
        this.length = currDigit >= 0 ? currDigit + 1 : 0;
        this.sign = isNegative ? 0 : 1;
        this.exponent = 0x7FL & 64L + exp;
        if (this.sign == 0) {
            this.exponent = (0x7FL & (this.exponent ^ 0xFFFFFFFFFFFFFFFFL)) + 1L;
        }
        if (this.length == 0) {
            this.sign = 1;
            this.exponent = 0L;
        } else if (this.digits == null) {
            log.error("alloc digits fail");
        } else {
            boolean ret = this.roundScaleV3(this.isOracleMode() ? 130L : 72L, true, false);
            if (ret) {
                return;
            }
            log.warn("");
            if (this.expCheck() != 0) {
                log.warn("exponent precision check fail");
            }
        }
    }

    private int expCheck() {
        boolean ret;
        long exp = Math.abs(this.exponent - 64L);
        boolean bl = (this.sign == 0 ? 64L >= this.exponent : 64L <= this.exponent) && (this.isOracleMode() ? 14L <= exp : 14L < exp) ? true : (ret = false);
        if (ret) {
            return -5088;
        }
        boolean bl2 = 15L < exp && this.sign == 0 ? true : (ret = this.exponent > 0L && this.exponent < 64L);
        if (ret) {
            return -5089;
        }
        return 0;
    }

    private boolean roundScaleV3(long scale, boolean usingFloatingScale, boolean forOracleToChar) {
        return this.roundScaleV3(scale, usingFloatingScale, forOracleToChar, null, null);
    }

    private boolean roundScaleV3(long scale, boolean usingFloatingScale, boolean forOracleToChar, short[] resPrecision, short[] resScale) {
        long round;
        long roundLength;
        if (this.length == 0) {
            return true;
        }
        log.debug("Before round_scale_v3_");
        long digit0Len = this.getDigitLenV2(this.digits[0]);
        long exprValue = this.getDecodeExp();
        long integerLength = exprValue >= 0L ? exprValue + 1L : 0L;
        long validIntegerLength = (long)this.length > integerLength ? integerLength : (long)this.length;
        long integerConut = validIntegerLength > 0L ? digit0Len + (integerLength - 1L) * 9L : 0L;
        long validDecimalLength = (long)this.length > integerLength ? (long)this.length - integerLength : 0L;
        long decimalLength = validDecimalLength + (0L == integerLength && !usingFloatingScale ? -exprValue - 1L : 0L);
        long floatingScale = scale;
        if (this.isOracleMode()) {
            long decimalPrefixZeroCount = 0L == integerLength ? -exprValue - 1L + 9L - digit0Len : 0L;
            long validPrecision = 0L;
            validPrecision = forOracleToChar ? (long)(40 - (this.sign ^ 1) - (this.hasDecimal() ? (decimalPrefixZeroCount > 0L ? 2 : 1) : 0)) : 40L - (0L == integerConut ? decimalPrefixZeroCount : integerConut) % 2L;
            long rPrecision = 0L;
            long rScale = 0L;
            long decimalNonZeroCount = 0L;
            long tailDecimalZeroCount = 0L;
            if (validDecimalLength > 0L) {
                long ret = this.digits[this.length - 1];
                while (ret != 0L && ret % 10L == 0L) {
                    ret /= 10L;
                    ++tailDecimalZeroCount;
                }
                decimalNonZeroCount = 9L * validDecimalLength - (0L == integerLength ? 9L - digit0Len : 0L) - tailDecimalZeroCount;
            }
            long decimalCount = decimalLength * 9L - tailDecimalZeroCount;
            if (usingFloatingScale) {
                if (integerConut > 0L) {
                    floatingScale = validPrecision - integerConut;
                } else if (decimalNonZeroCount > validPrecision) {
                    floatingScale = Math.min(scale, decimalCount - decimalNonZeroCount + validPrecision);
                }
                rPrecision = -1L;
                rScale = -85L;
            } else if (integerConut > 0L) {
                if (scale > 0L) {
                    floatingScale = Math.min(validPrecision - integerConut, scale);
                    rPrecision = Math.min(validPrecision, integerConut + decimalCount);
                    rScale = floatingScale < 0L ? floatingScale : Math.min(floatingScale, decimalCount);
                } else {
                    rPrecision = Math.min(validPrecision, Math.max(integerConut + scale, 0L));
                    rScale = Math.min(integerConut - validPrecision, scale);
                }
            } else if (decimalNonZeroCount > validPrecision) {
                floatingScale = Math.min(scale, decimalCount - decimalNonZeroCount + validPrecision);
                rPrecision = scale > 0L ? Math.min(validPrecision, decimalNonZeroCount - (scale - decimalCount)) : 0L;
                rScale = floatingScale;
            }
            if (resPrecision != null && resScale != null) {
                if (usingFloatingScale || rPrecision <= validPrecision && rPrecision >= 0L && rScale <= 127L && rScale >= -84L) {
                    resPrecision[0] = (short)rPrecision;
                    resScale[0] = (short)rScale;
                } else {
                    log.warn("Got invalid precision or scale on oracle mode, use builded");
                }
            }
        } else if (usingFloatingScale && validIntegerLength > 0L) {
            floatingScale -= integerConut;
        }
        int digitId = -1;
        int powId = -1;
        if (floatingScale > 0L) {
            roundLength = floatingScale / 9L;
            if (roundLength < decimalLength) {
                if (decimalLength > validDecimalLength && roundLength < decimalLength - validDecimalLength) {
                    this.setZero();
                } else {
                    round = floatingScale - roundLength * 9L;
                    this.length = (int)((long)this.length - (decimalLength - (roundLength + 1L)));
                    digitId = this.digits.length - 1;
                    powId = (int)round;
                }
            }
        } else if (floatingScale < 0L) {
            round = (floatingScale = -floatingScale) - (roundLength = floatingScale / 9L) * 9L;
            long roundIntegerLength = roundLength + (long)(0L == round ? 0 : 1);
            if (integerLength < roundIntegerLength) {
                this.setZero();
            } else if (integerLength <= validIntegerLength || roundIntegerLength > integerLength - validIntegerLength) {
                this.length = (int)(integerLength - roundIntegerLength + 1L);
                digitId = this.length - 1;
                powId = (int)(9L - round);
            }
        } else if (decimalLength != 0L) {
            if (validIntegerLength > 0L) {
                this.length = (int)validIntegerLength;
                digitId = (int)validIntegerLength;
                powId = 0;
            } else {
                long digitRound = this.digits[0];
                if (digitRound >= 500000000L && this.getDecodeExp() == -1) {
                    this.setOne();
                } else {
                    this.setZero();
                }
            }
        }
        if (digitId != -1 && powId != -1) {
            long tmpDigit;
            long digitValue = this.digits[digitId];
            long tmpRoundPows = this.ROUND_POWS[powId];
            long residue = digitValue % tmpRoundPows;
            boolean needNormalize = false;
            if (residue >= tmpRoundPows / 2L) {
                needNormalize = (digitValue += this.ROUND_POWS[powId] - residue) == 1000000000L;
            } else if ((digitValue -= residue) == 0L) {
                for (tmpDigit = (long)(this.length - 1); tmpDigit >= 0L && 0 == this.digits[(int)tmpDigit]; --tmpDigit) {
                }
                if (tmpDigit < 0L) {
                    this.setZero();
                } else {
                    this.length = (int)(tmpDigit + 1L);
                }
            }
            if (needNormalize) {
                --digitId;
                while (digitId >= 0) {
                    tmpDigit = this.digits[digitId];
                    if (tmpDigit == 999999999L) {
                        --digitId;
                        continue;
                    }
                    ++tmpDigit;
                    break;
                }
                if (digitId < 0) {
                    this.digits[0] = 1;
                    this.length = 1;
                    this.exponent = 0 == this.sign ? --this.exponent : ++this.exponent;
                } else {
                    this.length = digitId + 1;
                }
            }
        }
        log.debug("Finish round precision");
        return true;
    }

    private void setOne() {
        if (this.digits == null) {
            log.error("Number digits is null");
            return;
        }
        this.length = 1;
        this.digits[0] = 1;
        this.exponent = 64L;
    }

    private void setZero() {
        this.length = 0;
        this.sign = 1;
        this.exponent = 0L;
    }

    private boolean hasDecimal() {
        int exp = this.getDecodeExp();
        return exp < 0 || exp + 1 < this.length;
    }

    private int getDecodeExp() {
        short se = (short)((long)((this.sign & 1) << 7) | this.exponent & 0x7FL);
        return this.sign == 1 ? se - 192 : 64 - se;
    }

    private long getDigitLenV2(long d) {
        long ret = 0L;
        if (d >= 1000000000L) {
            log.error("{} is out of range", (Object)d);
            return ret;
        }
        return this.obFastDigits10(d);
    }

    private long obFastDigits10(long d) {
        if (d < this.MAX_INTEGER[1]) {
            return 1L;
        }
        if (d < this.MAX_INTEGER[2]) {
            return 2L;
        }
        if (d < this.MAX_INTEGER[3]) {
            return 3L;
        }
        if (d < this.MAX_INTEGER[12]) {
            if (d < this.MAX_INTEGER[8]) {
                if (d < this.MAX_INTEGER[6]) {
                    if (d < this.MAX_INTEGER[4]) {
                        return 4L;
                    }
                    return d >= this.MAX_INTEGER[5] ? 6L : 5L;
                }
                return d >= this.MAX_INTEGER[7] ? 8L : 7L;
            }
            if (d < this.MAX_INTEGER[10]) {
                return d >= this.MAX_INTEGER[9] ? 10L : 9L;
            }
            return d >= this.MAX_INTEGER[11] ? 12L : 11L;
        }
        return 12L + this.obFastDigits10(d / this.MAX_INTEGER[12]);
    }

    private int atoiPositiveUnchecked(char[] chars, int i, int j) {
        int res = 0;
        while (i < j) {
            res = (res << 1) + (res << 3) + chars[i++] - 48;
        }
        return res;
    }

    public BigInteger murmurhash64AInternal(BigInteger hashSeed) {
        int sep = this.sign << 7 | (int)this.exponent;
        hashSeed = MurmurHash.hash64ByBigInt(new byte[]{(byte)sep}, 1, hashSeed);
        byte[] bytes = new byte[this.getLength() * 4];
        int descIdx = 0;
        for (int i = 0; i < this.getLength(); ++i) {
            byte[] temp = CommonUtils.intToByteArray(this.getDigits()[i]);
            System.arraycopy(temp, 0, bytes, descIdx, 4);
            descIdx = (i + 1) * 4;
        }
        hashSeed = MurmurHash.hash64ByBigInt(bytes, bytes.length, hashSeed);
        return hashSeed;
    }

    @Override
    public BigInteger murmurhash64A(BigInteger hashSeed) {
        int sep = this.sign << 7 | (int)this.exponent;
        hashSeed = MurmurHash.hash64ByBigInt(new byte[]{(byte)sep}, 1, hashSeed);
        byte[] bytes = new byte[this.getLength() * 4];
        int descIdx = 0;
        for (int i = 0; i < this.getLength(); ++i) {
            byte[] temp = CommonUtils.intToByteArray(this.getDigits()[i]);
            System.arraycopy(temp, 0, bytes, descIdx, 4);
            descIdx = (i + 1) * 4;
        }
        hashSeed = MurmurHash.hash64ByBigInt(bytes, bytes.length, hashSeed);
        return hashSeed;
    }

    @Override
    public int compareTo(ObNumber o) {
        return this.getValue().compareTo(o.getValue());
    }

    public boolean isOracleMode() {
        return this.oracleMode;
    }

    public int[] getDigits() {
        return this.digits;
    }

    public int getLength() {
        return this.length;
    }

    public int getSign() {
        return this.sign;
    }

    public long getExponent() {
        return this.exponent;
    }

    public BigDecimal getValue() {
        return this.value;
    }
}

