/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.utils;

import com.oceanbase.partition.calculator.constants.Constants;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final ThreadLocalRandom _RANDOM = ThreadLocalRandom.current();

    private CommonUtils() {
    }

    public static boolean isIpValid(String ip) {
        return StringUtils.isNotBlank((CharSequence)ip) && Constants.IP_PATTERN.matcher(ip).matches();
    }

    public static <T extends Comparable<? super T>> int upperBound(List<T> list, T key) {
        int first = 0;
        int len = list.size() - 1;
        int half = 0;
        int middle = 0;
        while (len > 0) {
            half = len >> 1;
            middle = first + half;
            Comparable temp = (Comparable)list.get(middle);
            if (temp.compareTo(key) > 0) {
                len = half;
                continue;
            }
            first = middle + 1;
            len = len - half - 1;
        }
        return first;
    }

    public static int randomInt(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("The min value: " + min + " is greater than max value: " + max);
        }
        if (min == max && max == 0) {
            return 0;
        }
        return _RANDOM.nextInt(max) % (max - min + 1) + min;
    }

    public static boolean isVirtualAddr(String ip, Long port) {
        return "0.0.0.0".equals(ip.trim()) && 0L == port;
    }

    public static byte[] shortToByteArray(short i) {
        return new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF)};
    }

    public static byte[] intToByteArray(int i) {
        return new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
    }

    public static byte[] longToByteArray(long l) {
        return new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
    }

    public static String trimTrailingWhitespace(String input) {
        int index;
        if (input == null || input.length() == 0) {
            return input;
        }
        int origin = index = input.length() - 1;
        while (index > -1 && Character.isWhitespace(input.charAt(index))) {
            --index;
        }
        return origin == index ? input : input.substring(0, index + 1);
    }

    public static long getCurrentTimeUs() {
        return System.currentTimeMillis() * 1000L;
    }

    public static java.sql.Date toDate(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            Date date = DateUtils.parseDate((String)value, (String[])Constants.DEFAULT_PARSE_PATTERNS);
            return new java.sql.Date(date.getTime());
        }
        catch (ParseException e) {
            log.warn("Parse date: {} failed. Error: {}", (Object)value, (Object)e.getMessage());
            return null;
        }
    }

    public static Timestamp toTimestamp(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            return Timestamp.valueOf(value);
        }
        catch (Exception e) {
            log.warn("Parse timestamp: {} failed. Error: {}", (Object)value, (Object)e.getMessage());
            return null;
        }
    }
}

