/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.utils;

import com.oceanbase.partition.calculator.algo.hash.MurmurHash;
import com.oceanbase.partition.calculator.algo.hash.bin.ObHashSortBin;
import com.oceanbase.partition.calculator.algo.hash.gbk.ObHashSortGbk;
import com.oceanbase.partition.calculator.algo.hash.utf16.ObHashSortUtf16;
import com.oceanbase.partition.calculator.algo.hash.utf8.ObHashSortUtf8mb4;
import com.oceanbase.partition.calculator.constants.Constants;
import com.oceanbase.partition.calculator.enums.ObCollationType;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;

public class ObHashUtils {
    private static final BigInteger DEFAULT_HASH_SEED = new BigInteger("c6a4a7935bd1e995", 16);

    public static BigInteger shortHash(int value, BigInteger hashCode) {
        return ObHashUtils.shortHashN((short)value, 2, hashCode);
    }

    public static BigInteger shortHashN(short value, int length, BigInteger hashCode) {
        return MurmurHash.hash64(CommonUtils.shortToByteArray(value), length, hashCode);
    }

    public static BigInteger intHash(int value, BigInteger hashCode) {
        return ObHashUtils.intHashN(value, 4, hashCode);
    }

    public static BigInteger intHashN(int value, int length, BigInteger hashCode) {
        return MurmurHash.hash64(CommonUtils.intToByteArray(value), length, hashCode);
    }

    public static BigInteger longHash(long value, BigInteger hashCode) {
        return ObHashUtils.longHashN(value, 8, hashCode);
    }

    public static BigInteger longHashN(long value, int length, BigInteger hashCode) {
        return MurmurHash.hash64(CommonUtils.longToByteArray(value), length, hashCode);
    }

    public static BigInteger dateHash(Date value, BigInteger hashCode) {
        return ObHashUtils.longHash(value.getTime(), hashCode);
    }

    public static BigInteger datetimeHash(Timestamp value, BigInteger hashCode) {
        return ObHashUtils.longHash(value.getTime() * 1000L, hashCode);
    }

    public static BigInteger varcharHash(String value, ObCollationType collationType, BigInteger hashCode, boolean calcEndSpace, boolean isSubFromV3) {
        if (value == null) {
            return Constants.BIGINTEGER_ZERO;
        }
        switch (collationType) {
            case CS_TYPE_BINARY: {
                return ObHashSortBin.obHashSortBin(value, hashCode, DEFAULT_HASH_SEED, isSubFromV3);
            }
            case CS_TYPE_UTF8MB4_BIN: {
                return ObHashSortUtf8mb4.obHashSortMbBin(value, hashCode, DEFAULT_HASH_SEED, isSubFromV3);
            }
            case CS_TYPE_UTF8MB4_GENERAL_CI: {
                return ObHashSortUtf8mb4.obHashSortUtf8Mb4(value, hashCode, DEFAULT_HASH_SEED, isSubFromV3);
            }
            case CS_TYPE_ANY: 
            case CS_TYPE_GBK_BIN: {
                return ObHashSortGbk.obHashSortGbkMbBin(value, hashCode, DEFAULT_HASH_SEED, calcEndSpace, isSubFromV3);
            }
            case CS_TYPE_GBK_CHINESE_CI: {
                return ObHashSortGbk.obHashSortGbkSimple(value, hashCode, DEFAULT_HASH_SEED, calcEndSpace, isSubFromV3);
            }
            case CS_TYPE_UTF16_BIN: {
                return ObHashSortUtf16.obHashSortUtf16Bin(value, hashCode, DEFAULT_HASH_SEED, calcEndSpace, isSubFromV3);
            }
            case CS_TYPE_UTF16_GENERAL_CI: {
                return ObHashSortUtf16.obHashSortUtf16(value, hashCode, DEFAULT_HASH_SEED, calcEndSpace, isSubFromV3);
            }
        }
        throw new IllegalArgumentException("Unsupported hash for collation type: " + (Object)((Object)collationType));
    }
}

