/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.druid.sql.ast.expr.SQLDoubleExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorImpl;
import com.alibaba.druid.sql.visitor.functions.Function;
import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.calculator.enums.SqlFunctions;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ObPartEvalVisitor
extends SQLEvalVisitorImpl {
    private Map<String, Object> columnValueMap;

    public ObPartEvalVisitor() {
        this.columnValueMap = new HashMap<String, Object>();
    }

    public ObPartEvalVisitor(Map<String, Object> columnValueMap) {
        super((List)Lists.newArrayList(columnValueMap.values()));
        this.columnValueMap = columnValueMap;
    }

    public boolean visit(SQLVariantRefExpr expr) {
        int varIndex = expr.getIndex();
        List parameters = super.getParameters();
        if (varIndex != -1 && parameters != null && varIndex < parameters.size()) {
            return this.setAttribute((SQLExpr)expr, parameters.get(varIndex));
        }
        return false;
    }

    public boolean visit(SQLDoubleExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLDecimalExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLCharExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLIntegerExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLNumberExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLTimestampExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLMethodInvokeExpr x) {
        String methodName = x.getMethodName().toLowerCase(Locale.getDefault());
        Function function = SqlFunctions.getByName(methodName);
        if (function == null) {
            throw new UnsupportedOperationException("Function `" + methodName + "` is unsupported");
        }
        return this.setAttribute((SQLExpr)x, function.eval((SQLEvalVisitor)this, x));
    }

    public boolean visit(SQLIdentifierExpr x) {
        String columnName = x.getName().toLowerCase(Locale.getDefault());
        if (!this.getColumnValueMap().containsKey(columnName)) {
            if ((columnName = columnName.toUpperCase(Locale.getDefault())).equalsIgnoreCase(ObObjType.MAXVALUE.getName())) {
                return this.setAttribute((SQLExpr)x, "MAXVALUE");
            }
            if (!this.getColumnValueMap().containsKey(columnName)) {
                throw new IllegalArgumentException("Column `" + columnName + "` is not exists");
            }
        }
        return this.setAttribute((SQLExpr)x, this.getColumnValueMap().get(columnName));
    }

    private boolean setAttribute(SQLExpr expr, Object result) {
        if (result == null) {
            result = SQLEvalVisitor.EVAL_VALUE_NULL;
        }
        expr.getAttributes().put("eval.value", result);
        return false;
    }

    public Map<String, Object> getColumnValueMap() {
        return this.columnValueMap;
    }
}

