/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.metadata.desc;

import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeOld;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeV4;
import com.oceanbase.partition.calculator.enums.ObServerMode;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import com.oceanbase.partition.metadata.desc.ObObject;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.partition.metadata.desc.ObPartDesc;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObHashPartDesc
extends ObPartDesc {
    private static final Logger log = LoggerFactory.getLogger(ObHashPartDesc.class);
    private final boolean oracleMode;
    private final boolean subsequentFromV3;
    private String tableName;
    private int partNum;
    private int partSpace;
    private List<ObPartColumn> partColumns;

    public ObHashPartDesc(ObServerMode serverMode, boolean subsequentFromV4) {
        super(subsequentFromV4);
        this.oracleMode = serverMode.isOracleMode();
        this.subsequentFromV3 = serverMode.isSubsequentFrom("3.0");
        if (subsequentFromV4) {
            super.setPartFuncType(ObPartFuncTypeV4.HASH);
            super.setPartPositionIdMap(new HashMap<Long, Long>());
        } else {
            super.setPartFuncType(ObPartFuncTypeOld.HASH);
        }
    }

    @Override
    public Long getRandomPartId() {
        log.debug("Return a random partition id for the table: \"{}\"", (Object)this.tableName);
        return this.partNum > 0 ? Long.valueOf(CommonUtils.randomInt(0, this.partNum)) : null;
    }

    @Override
    public Long getPartId(Object value) {
        return this.getPartId(Lists.newArrayList((Object[])new Object[]{value}));
    }

    @Override
    public Long getPartId(List<Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            log.warn("Input values are empty. table: {}", (Object)this.getTableName());
            return null;
        }
        try {
            if (this.isOracleMode()) {
                Long partPosition = this.getPartIdForOracleMode(values);
                return super.isSubsequentFromV4() ? this.getPartPositionIdMap().get(partPosition) : partPosition;
            }
            Long partPosition = this.getPartIdForMySqlMode(values);
            return super.isSubsequentFromV4() ? this.getPartPositionIdMap().get(partPosition) : partPosition;
        }
        catch (Exception e) {
            log.warn("Calculate partId failed. table: {}, values: {}", new Object[]{this.getTableName(), values, e});
            return null;
        }
    }

    @Override
    public Long getSubPartId(List<Object> values, Long firstPartId) {
        if (CollectionUtils.isEmpty(values)) {
            log.warn("Input values are empty. table: {}", (Object)this.getTableName());
            return null;
        }
        try {
            if (this.isOracleMode()) {
                Long partPosition = this.getPartIdForOracleMode(values, true, firstPartId);
                return super.isSubsequentFromV4() ? this.getPartPositionIdMap().get(partPosition) : partPosition;
            }
            Long partPosition = this.getPartIdForMySqlMode(values, true, firstPartId);
            return super.isSubsequentFromV4() ? this.getPartPositionIdMap().get(partPosition) : partPosition;
        }
        catch (Exception e) {
            log.warn("Calculate partId failed. table: {}, values: {}", new Object[]{this.getTableName(), values, e});
            return null;
        }
    }

    private Long getPartIdForMySqlMode(List<Object> values) {
        return this.getPartIdForMySqlMode(values, false, 0L);
    }

    private Long getPartIdForMySqlMode(List<Object> values, boolean isSubPart, long firstPartId) {
        if (values.size() > 1) {
            throw new IllegalArgumentException("At most one partition key for hash partition. table: " + this.getTableName());
        }
        Object value = values.get(0);
        if (value == null) {
            return null;
        }
        boolean subNoTemplate = isSubPart && !this.isUseTemplate();
        int partNum = this.getPartNum();
        if (subNoTemplate) {
            partNum = this.getPartIdSubNamesMap().get(firstPartId).size();
        }
        if (value instanceof Integer) {
            return this.hashingForMySqlMode((Integer)value, partNum);
        }
        if (value instanceof Long) {
            return this.hashingForMySqlMode((Long)value, partNum);
        }
        if (value instanceof String) {
            String string = String.valueOf(value);
            try {
                return this.hashingForMySqlMode(NumberUtils.createNumber((String)string), partNum);
            }
            catch (Exception e) {
                log.debug("Get hash value for mysql failed. Reason : {}", (Object)e.getMessage());
                return this.hashingForMySqlMode(string.hashCode(), partNum);
            }
        }
        if (value instanceof Float || value instanceof Double) {
            return this.hashingForMySqlMode(NumberUtils.createNumber((String)String.valueOf(value)), partNum);
        }
        return null;
    }

    private Long hashingForMySqlMode(Number value, int partNumber) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            if (BigDecimal.ZERO.compareTo(bd) == 0) {
                return null;
            }
            return Math.abs((long)(this.getPartSpace() << 28) | bd.divideAndRemainder(BigDecimal.valueOf(partNumber))[1].longValue());
        }
        Long hashValue = value.longValue();
        if (hashValue != 0L) {
            hashValue = Math.abs(hashValue);
            return (long)(this.getPartSpace() << 28) | hashValue % (long)partNumber;
        }
        return hashValue;
    }

    private Long getPartIdForOracleMode(List<Object> values) {
        return this.getPartIdForOracleMode(values, false, 0L);
    }

    private Long getPartIdForOracleMode(List<Object> values, boolean isSubPart, long firstPartId) {
        List<ObPartColumn> partColumns = this.getPartColumns();
        if (values == null || partColumns == null || values.size() != partColumns.size()) {
            log.warn("Invalid table: {}, columns: {}, values: {}", new Object[]{this.getTableName(), partColumns, values});
            return null;
        }
        boolean isSubFromV3 = this.isSubsequentFromV3();
        BigInteger hashValue = BigInteger.valueOf(0L);
        for (int i = 0; i < partColumns.size(); ++i) {
            ObObject targetObject;
            ObPartColumn partColumn = partColumns.get(i);
            Object value = values.get(i);
            if (value != null && partColumn.isCharType()) {
                value = CommonUtils.trimTrailingWhitespace(String.valueOf(value));
            }
            if ((targetObject = this.toObObject(value, partColumn)) == null) continue;
            boolean isNStringType = partColumn.isNStringType();
            boolean isVarcharType = partColumn.isVarcharType();
            hashValue = targetObject.hash(hashValue, isSubFromV3, isNStringType, isVarcharType, true);
        }
        long signedHashValue = Math.abs(hashValue.longValue());
        long partNum = isSubPart && !this.isUseTemplate() ? (long)this.getPartIdSubNamesMap().get(firstPartId).size() : (long)this.getPartNum();
        long n = (long)(Math.log(partNum) / Math.log(2.0));
        if (n > 64L) {
            log.warn("Result is too big, n: {}, part_num): {}, hash: {}", new Object[]{n, partNum, signedHashValue});
            return null;
        }
        long powN = 1L << (int)n;
        long partId = signedHashValue & powN - 1L;
        if (partId + powN < partNum && (signedHashValue & powN) == powN) {
            partId += powN;
        }
        log.debug("table: {}, hash: {}, partNum: {}, partId( or part position for oceanbase 4.0.0.0): {}", new Object[]{this.getTableName(), hashValue, partNum, partId});
        return Math.abs(partId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObHashPartDesc [ ");
        sb.append("PartType: ").append(this.getPartFuncType());
        sb.append(", PartExpr: ").append(this.getPartExpr());
        sb.append(", PartNum: ").append(this.getPartNum());
        sb.append(", PartSpace: ").append(this.getPartSpace());
        return sb.append(" ]").toString();
    }

    public boolean isOracleMode() {
        return this.oracleMode;
    }

    public boolean isSubsequentFromV3() {
        return this.subsequentFromV3;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getPartNum() {
        return this.partNum;
    }

    public void setPartNum(int partNum) {
        this.partNum = partNum;
    }

    public int getPartSpace() {
        return this.partSpace;
    }

    public void setPartSpace(int partSpace) {
        this.partSpace = partSpace;
    }

    public List<ObPartColumn> getPartColumns() {
        return this.partColumns;
    }

    public void setPartColumns(List<ObPartColumn> partColumns) {
        this.partColumns = partColumns;
    }
}

