/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.metadata.desc;

import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.constants.Constants;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeOld;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeV4;
import com.oceanbase.partition.calculator.enums.ObServerMode;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import com.oceanbase.partition.metadata.desc.ObObject;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.partition.metadata.desc.ObPartDesc;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObKeyPartDesc
extends ObPartDesc {
    private static final Logger log = LoggerFactory.getLogger(ObKeyPartDesc.class);
    private final boolean subsequentFromV3;
    private String tableName;
    private int partNum;
    private int partSpace;
    private List<ObPartColumn> partColumns;

    public ObKeyPartDesc(ObServerMode serverMode, boolean subsequentFromV4) {
        super(subsequentFromV4);
        this.subsequentFromV3 = serverMode.isSubsequentFrom("3.0");
        if (subsequentFromV4) {
            super.setPartFuncType(ObPartFuncTypeV4.KEY);
            super.setPartPositionIdMap(new HashMap<Long, Long>());
        } else {
            super.setPartFuncType(ObPartFuncTypeOld.KEY);
        }
    }

    @Override
    public Long getRandomPartId() {
        log.debug("Return a random partition id for the table: \"{}\"", (Object)this.tableName);
        return this.partNum > 0 ? Long.valueOf(CommonUtils.randomInt(0, this.partNum)) : null;
    }

    @Override
    public Long getPartId(Object value) {
        return this.getPartId(Lists.newArrayList((Object[])new Object[]{value}));
    }

    @Override
    public Long getPartId(List<Object> values) {
        List<ObPartColumn> partColumns = this.getPartColumns();
        if (values == null || partColumns == null) {
            log.warn("Invalid table: {}, columns: {}, values: {}", new Object[]{this.getTableName(), partColumns, values});
            return null;
        }
        boolean isSubFromV3 = this.isSubsequentFromV3();
        BigInteger hashValue = Constants.BIGINTEGER_ZERO;
        for (int i = 0; i < partColumns.size(); ++i) {
            ObObject targetObject;
            ObPartColumn partColumn = partColumns.get(i);
            Object value = values.get(i);
            if (value != null && partColumn.isCharType()) {
                value = CommonUtils.trimTrailingWhitespace(String.valueOf(value));
            }
            if ((targetObject = this.toObObject(value, partColumn)) == null) continue;
            boolean isNStringType = partColumn.isNStringType();
            hashValue = targetObject.hash(hashValue, isSubFromV3, isNStringType, false, false);
        }
        long longHashValue = Math.abs(hashValue.longValue()) % (long)this.getPartNum();
        Long partPosition = (long)(this.getPartSpace() << 28) | longHashValue;
        return this.isSubsequentFromV4() ? this.getPartPositionIdMap().get(partPosition) : partPosition;
    }

    @Override
    public Long getSubPartId(List<Object> values, Long firstPartId) {
        List<ObPartColumn> partColumns = this.getPartColumns();
        if (values == null || partColumns == null || values.size() != partColumns.size()) {
            log.warn("Invalid table: {}, columns: {}, values: {}", new Object[]{this.getTableName(), partColumns, values});
            return null;
        }
        boolean isSubFromV3 = this.isSubsequentFromV3();
        BigInteger hashValue = Constants.BIGINTEGER_ZERO;
        for (int i = 0; i < partColumns.size(); ++i) {
            ObObject targetObject;
            ObPartColumn partColumn = partColumns.get(i);
            Object value = values.get(i);
            if (value != null && partColumn.isCharType()) {
                value = CommonUtils.trimTrailingWhitespace(String.valueOf(value));
            }
            if ((targetObject = this.toObObject(value, partColumn)) == null) continue;
            boolean isNStringType = partColumn.isNStringType();
            hashValue = targetObject.hash(hashValue, isSubFromV3, isNStringType, false, false);
        }
        int partNum = this.isUseTemplate() ? this.getPartNum() : this.getPartIdSubNamesMap().get(firstPartId).size();
        long longHashValue = Math.abs(hashValue.longValue() % (long)partNum);
        Long partPosition = (long)(this.getPartSpace() << 28) | longHashValue;
        return this.isSubsequentFromV4() ? this.getPartPositionIdMap().get(partPosition) : partPosition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObKeyPartDesc [ ");
        sb.append(", PartType: ").append(this.getPartFuncType());
        sb.append(", PartNum: ").append(this.getPartNum());
        sb.append(", PartExpr: ").append(this.getPartExpr());
        sb.append(", PartSpace: ").append(this.getPartSpace());
        return sb.append(" ]").toString();
    }

    public boolean isSubsequentFromV3() {
        return this.subsequentFromV3;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getPartNum() {
        return this.partNum;
    }

    public void setPartNum(int partNum) {
        this.partNum = partNum;
    }

    public int getPartSpace() {
        return this.partSpace;
    }

    public void setPartSpace(int partSpace) {
        this.partSpace = partSpace;
    }

    public List<ObPartColumn> getPartColumns() {
        return this.partColumns;
    }

    public void setPartColumns(List<ObPartColumn> partColumns) {
        this.partColumns = partColumns;
    }
}

