/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.visitor.ObPartEvalVisitor;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.partition.metadata.desc.ObPartDesc;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObPartIdCalculator {
    private static final Logger log = LoggerFactory.getLogger(ObPartIdCalculator.class);
    private static final Long MASK = 0x1000000010000000L;
    private final Object monitor = new Object();
    private final Map<String, SQLExpr> exprCacheMap = new HashMap<String, SQLExpr>();
    private boolean publicCloud;
    private TableEntry tableEntry;
    private boolean subsequentFromV4;
    private Map<String, Object> refColumnValues = new HashMap<String, Object>();

    public ObPartIdCalculator(TableEntry tableEntry) {
        this(false, tableEntry);
    }

    public ObPartIdCalculator(boolean publicCloud, TableEntry tableEntry) {
        this(publicCloud, tableEntry, false);
    }

    public ObPartIdCalculator(boolean publicCloud, TableEntry tableEntry, boolean subsequentFromV4) {
        this.publicCloud = publicCloud;
        this.tableEntry = tableEntry;
        this.subsequentFromV4 = subsequentFromV4;
    }

    public static Long generatePartId(Long partId, Long subPartId) {
        if (partId == null) {
            return null;
        }
        if (subPartId == null) {
            return partId;
        }
        return partId << 32 | subPartId | MASK;
    }

    public void addRefColumn(String refColumnName, Object refColumnValue) {
        this.refColumnValues.put(refColumnName.toLowerCase(), refColumnValue);
    }

    public Long calculatePartId(Object[] records) {
        boolean isSubPart;
        if (this.isPublicCloud() && !this.isSubsequentFromV4()) {
            return 0L;
        }
        if (ArrayUtils.isEmpty((Object[])records)) {
            throw new IllegalArgumentException("Input records is null");
        }
        String tableName = this.getTableEntry().getTableName();
        if (this.getTableEntry().isNonPartitionTable()) {
            log.debug("The table: \"{}\" is none-partitioned table. Return 0.", (Object)tableName);
            return 0L;
        }
        ObTablePart tablePart = this.getTableEntry().getTablePart();
        if (tablePart == null) {
            log.debug("The partitioned table: \"{}\" is without partition info.", (Object)tableName);
            return null;
        }
        Long partId = null;
        boolean bl = isSubPart = tablePart.getLevel().getIndex() == ObPartLevel.LEVEL_TWO.getIndex();
        if (tablePart.getLevel().getIndex() >= ObPartLevel.LEVEL_ONE.getIndex()) {
            partId = this.calculatePartId(tablePart.getPartDesc(), records);
        }
        Long subPartId = null;
        if (isSubPart) {
            subPartId = this.calculateSubPartId(tablePart.getSubPartDesc(), records, partId);
        }
        if (this.isSubsequentFromV4()) {
            Long tabletId = isSubPart ? tablePart.getPartIdTabletIdMap().get(subPartId) : tablePart.getPartIdTabletIdMap().get(partId);
            log.debug("Calculate the result tabletId: {} = (partId: {}, subPartId: {})", new Object[]{tabletId, partId, subPartId});
            return tabletId;
        }
        Long compositeId = ObPartIdCalculator.generatePartId(partId, subPartId);
        log.debug("Calculate the result compoisteId: {} = (partId: {}, subPartId: {})", new Object[]{compositeId, partId, subPartId});
        return compositeId;
    }

    private Long calculatePartId(ObPartDesc partDesc, Object[] records) {
        if (partDesc == null) {
            log.warn("Skip to calculate partition id. ObPartDesc is null.");
            return null;
        }
        String table = this.getTableEntry().getTableName();
        try {
            ObTablePart tablePart = this.getTableEntry().getTablePart();
            LinkedHashMap<String, Object> partColumnValues = this.extractColumnValues(tablePart.getPartColumns(), tablePart.getRefPartColumns(), records);
            ArrayList<Object> evalPartValues = new ArrayList<Object>(partColumnValues.size());
            try {
                this.evalValueExpr(this.toSqlExpr(partDesc.getPartExpr()), evalPartValues, partColumnValues);
            }
            catch (Exception e2) {
                if (log.isDebugEnabled()) {
                    log.debug("Extract partition column value failed. Reason : {}", (Object)e2.getMessage());
                }
                return partDesc.getRandomPartId();
            }
            Long partId = partDesc.getPartId(evalPartValues);
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("Calculate partition id");
                sb.append(partId == null ? " is null" : "").append(" for table: ");
                sb.append("\"").append(this.getTableEntry().getTableName()).append("\"");
                sb.append(" partition by ").append(partDesc.getPartFuncType()).append(" ( ");
                sb.append(partColumnValues.entrySet().stream().map(e -> (String)e.getKey() + " [" + e.getValue() + "]").collect(Collectors.joining(",")));
                log.debug(sb.append(" )").toString());
            }
            return partId == null ? partDesc.getRandomPartId() : partId;
        }
        catch (Exception ex) {
            log.warn("Calculate partition id for table: \"{}\" failed. Error: {}", (Object)table, (Object)ex.getMessage());
            return null;
        }
    }

    private Long calculateSubPartId(ObPartDesc subPartDesc, Object[] records, Long partId) {
        if (subPartDesc == null) {
            log.warn("Skip to calculate partition id. ObPartDesc is null.");
            return null;
        }
        String table = this.getTableEntry().getTableName();
        try {
            ObTablePart tablePart = this.getTableEntry().getTablePart();
            LinkedHashMap<String, Object> subPartColumnValues = this.extractColumnValues(tablePart.getSubPartColumns(), tablePart.getRefSubPartColumns(), records);
            ArrayList<Object> evalSubPartValues = new ArrayList<Object>(subPartColumnValues.size());
            try {
                this.evalValueExpr(this.toSqlExpr(subPartDesc.getPartExpr()), evalSubPartValues, subPartColumnValues);
            }
            catch (Exception e2) {
                if (log.isDebugEnabled()) {
                    log.debug("Calculate partition value failed. Reason : {}", (Object)e2.getMessage());
                }
                return 0L;
            }
            Long subPartId = subPartDesc.getSubPartId(evalSubPartValues, partId);
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("Calculate subpartition id");
                sb.append(subPartId == null ? " is null" : "").append(" for table: ");
                sb.append("\"").append(this.getTableEntry().getTableName()).append("\"");
                sb.append(" subpartition by ").append(subPartDesc.getPartFuncType()).append(" ( ");
                sb.append(subPartColumnValues.entrySet().stream().map(e -> (String)e.getKey() + " [" + e.getValue() + "]").collect(Collectors.joining(",")));
                log.debug(sb.append(" )").toString());
            }
            return subPartId == null ? 0L : subPartId;
        }
        catch (Exception ex) {
            log.warn("Calculate partition id for table: \"{}\" failed. Error: {}", (Object)table, (Object)ex.getMessage());
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLExpr toSqlExpr(String expr) {
        if (StringUtils.isBlank((CharSequence)expr)) {
            throw new IllegalArgumentException("input expr is null");
        }
        String trimed = expr.trim();
        if (!trimed.startsWith("(") || !trimed.endsWith(")")) {
            trimed = "(" + trimed + ")";
        }
        if (this.getExprCacheMap().containsKey(trimed)) {
            return this.getExprCacheMap().get(trimed);
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.getExprCacheMap().containsKey(trimed)) {
                return this.getExprCacheMap().get(trimed);
            }
            SQLExpr sqlExpr = SQLUtils.toSQLExpr((String)trimed);
            this.getExprCacheMap().putIfAbsent(trimed, sqlExpr);
            return sqlExpr;
        }
    }

    private LinkedHashMap<String, Object> extractColumnValues(List<ObPartColumn> columns, List<ObPartColumn> refColumns, Object[] records) {
        LinkedHashMap<String, Object> columnValueMap = new LinkedHashMap<String, Object>(columns.size());
        if (CollectionUtils.isEmpty(columns)) {
            return columnValueMap;
        }
        int recordSize = records.length;
        for (ObPartColumn column : columns) {
            int columnIndex = column.getColumnIndex();
            if (columnIndex >= recordSize) continue;
            columnValueMap.put(column.getColumnName(), records[columnIndex]);
        }
        for (ObPartColumn column : refColumns) {
            String columnName = column.getColumnName();
            if (!this.refColumnValues.containsKey(columnName)) continue;
            Object value = this.refColumnValues.get(columnName);
            columnValueMap.put(columnName, value);
        }
        return columnValueMap;
    }

    private void evalValueExpr(SQLExpr expr, List<Object> output, Map<String, Object> intput) {
        if (expr instanceof SQLListExpr) {
            List items = ((SQLListExpr)expr).getItems();
            for (SQLExpr item : items) {
                this.evalValueExpr(item, output, intput);
            }
        } else {
            ObPartEvalVisitor visitor = new ObPartEvalVisitor(intput, this.getTableEntry().getTablePart().getPartGeneratedColumnExprMap());
            expr.accept((SQLASTVisitor)visitor);
            output.add(expr.getAttributes().get("eval.value"));
        }
    }

    public Map<String, SQLExpr> getExprCacheMap() {
        return this.exprCacheMap;
    }

    public boolean isPublicCloud() {
        return this.publicCloud;
    }

    public TableEntry getTableEntry() {
        return this.tableEntry;
    }

    public boolean isSubsequentFromV4() {
        return this.subsequentFromV4;
    }

    public void setSubsequentFromV4(boolean subsequentFromV4) {
        this.subsequentFromV4 = subsequentFromV4;
    }
}

