/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.algo.hash.utf16;

import com.oceanbase.partition.calculator.algo.hash.MurmurHash;
import com.oceanbase.partition.calculator.algo.hash.utf8.ObHashSortUtf8mb4;
import com.oceanbase.partition.calculator.algo.hash.utf8.ObMbContext;
import com.oceanbase.partition.calculator.algo.hash.utf8.ObUnicaseInfo;
import com.oceanbase.partition.calculator.algo.hash.utf8.ObUnicaseInfoChar;
import com.oceanbase.partition.calculator.constants.Constants;
import com.oceanbase.utils.BigIntegerUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class ObHashSortUtf16 {
    private static final int HASH_BUFFER_LENGTH = 128;
    private static final int OB_CS_TOOSMALL2 = -102;
    private static final int OB_CS_TOOSMALL4 = -104;
    private static final int OB_CS_ILSEQ = 0;
    private static final int OB_CS_REPLACEMENT_CHARACTER = 65533;

    public static BigInteger obHashSortUtf16Bin(String str, BigInteger n1, BigInteger n2, boolean calcEndSpace, boolean isSubFromV3) {
        byte[] bytes2 = str.getBytes(StandardCharsets.UTF_16BE);
        return ObHashSortUtf16.obHashSortUtf16Bin(bytes2, bytes2.length, n1, n2, calcEndSpace, isSubFromV3);
    }

    public static BigInteger obHashSortUtf16Bin(byte[] s, int len, BigInteger n1, BigInteger n2, boolean calcEndSpace, boolean isSubFromV3) {
        if (calcEndSpace) {
            while (len > 0 && s[len - 1] == 32) {
                --len;
            }
        }
        if (isSubFromV3) {
            return MurmurHash.hash64ByBigInt(s, len, n1);
        }
        for (int i = 0; i < len; ++i) {
            BigInteger temp1 = BigIntegerUtils.toUnsignedInt(n1).and(Constants.BIGINTEGER_63).add(n2);
            temp1 = BigIntegerUtils.multiply(temp1, BigInteger.valueOf(s[i]));
            n1 = BigIntegerUtils.xor(n1, temp1.add(n1.shiftLeft(8)));
            n2 = n2.add(Constants.BIGINTEGER_3);
        }
        return n1;
    }

    public static BigInteger obHashSortUtf16(String str, BigInteger n1, BigInteger n2, boolean calcEndSpace, boolean isSubFromV3) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_16);
        return ObHashSortUtf16.obHashSortUtf16(bytes, bytes.length, n1, n2, calcEndSpace, isSubFromV3);
    }

    public static BigInteger obHashSortUtf16(byte[] s, int len, BigInteger n1, BigInteger n2, boolean calcEndSpace, boolean isSubFromV3) {
        int res;
        ObMbContext ctx = new ObMbContext();
        ctx.buf = s;
        ctx.n1 = n1;
        ctx.n2 = n2;
        ctx.start = 0;
        ctx.end = len;
        ObUnicaseInfo uniPlane = ObHashSortUtf8mb4.obUnicaseDefault;
        if (!calcEndSpace) {
            while (ctx.end > 1 && s[ctx.end - 1] == 32 && s[ctx.end - 2] == 0) {
                ctx.end -= 2;
            }
        }
        int length = 0;
        byte[] data = new byte[128];
        while (ctx.end > ctx.start && (res = ObHashSortUtf16.obUtf16Uni(ctx)) > 0) {
            ObHashSortUtf16.obToSortUtf16(uniPlane, ctx);
            if (isSubFromV3) {
                if (length > 126) {
                    ctx.n1 = MurmurHash.hash64ByBigInt(data, length, ctx.n1);
                    length = 0;
                }
                data[length++] = (byte)ctx.pwc.longValue();
                data[length++] = (byte)BigIntegerUtils.shiftRight(ctx.pwc, 8).longValue();
            } else {
                ctx.n1 = BigIntegerUtils.xor(ctx.n1, BigIntegerUtils.add(BigIntegerUtils.multiply(BigIntegerUtils.add(BigIntegerUtils.and(ctx.n1, Constants.BIGINTEGER_63), ctx.n2), BigIntegerUtils.and(ctx.pwc, Constants.BIGINTEGER_FF)), BigIntegerUtils.shiftLeft(ctx.n1, 8)));
                ctx.n2 = BigIntegerUtils.and(ctx.n2, Constants.BIGINTEGER_3);
                ctx.n1 = BigIntegerUtils.xor(ctx.n1, BigIntegerUtils.add(BigIntegerUtils.multiply(BigIntegerUtils.add(BigIntegerUtils.and(ctx.n1, Constants.BIGINTEGER_63), ctx.n2), BigIntegerUtils.shiftRight(ctx.pwc, 8)), BigIntegerUtils.shiftLeft(ctx.n1, 8)));
                ctx.n2 = BigIntegerUtils.and(ctx.n2, Constants.BIGINTEGER_3);
            }
            ctx.start += res;
        }
        if (isSubFromV3 && length > 0) {
            ctx.n1 = MurmurHash.hash64(data, length, ctx.n1);
        }
        return ctx.n1;
    }

    private static void obToSortUtf16(ObUnicaseInfo uniPlane, ObMbContext ctx) {
        if (ctx.pwc.compareTo(uniPlane.maxchar) <= 0) {
            ObUnicaseInfoChar[] page = uniPlane.page[BigIntegerUtils.shiftRight(ctx.pwc, 8).intValue()];
            if (page != null) {
                ctx.pwc = BigInteger.valueOf(page[BigIntegerUtils.and((BigInteger)ctx.pwc, (BigInteger)Constants.BIGINTEGER_FF).intValue()].sort);
            }
            return;
        }
        ctx.pwc = BigInteger.valueOf(65533L);
    }

    private static int obUtf16Uni(ObMbContext ctx) {
        if (ctx.end < 2) {
            return -102;
        }
        if (ObHashSortUtf16.obUtf16HighHead(ctx.buf[ctx.start])) {
            if (ctx.end < 4) {
                return -104;
            }
            if (ObHashSortUtf16.obUtf16LowHead(ctx.buf[ctx.start + 2])) {
                return 0;
            }
            ctx.pwc = BigInteger.valueOf(ObHashSortUtf16.obUtf16Wc4(ctx.buf[ctx.start], ctx.buf[ctx.start + 1], ctx.buf[ctx.start + 2], ctx.buf[ctx.start + 3]));
            return 4;
        }
        if (ObHashSortUtf16.obUtf16LowHead(ctx.buf[ctx.start])) {
            return 0;
        }
        ctx.pwc = BigInteger.valueOf(ObHashSortUtf16.obUtf16Wc2(ctx.buf[ctx.start], ctx.buf[ctx.start + 1]));
        return 2;
    }

    private static boolean obUtf16HighHead(int x) {
        return ((x + 256) % 256 & 0xFC) == 216;
    }

    private static boolean obUtf16LowHead(int x) {
        return ((x + 256) % 256 & 0xFC) == 220;
    }

    private static int obUtf16Wc4(byte s0, byte s1, byte s2, byte s3) {
        int i0 = ObHashSortUtf16.intToUnchar(ObHashSortUtf16.intToUnchar(s0 & 3) << 18);
        int i1 = ObHashSortUtf16.intToUnchar(s1 << 10);
        int i2 = ObHashSortUtf16.intToUnchar(ObHashSortUtf16.intToUnchar(s2 & 3) << 8);
        int i3 = ObHashSortUtf16.intToUnchar(s3 + 65536);
        return ObHashSortUtf16.intToUnchar(i0 + i1 + i2 + i3);
    }

    private static int obUtf16Wc2(byte s0, byte s1) {
        int b = ObHashSortUtf16.intToUnchar(ObHashSortUtf16.intToUnchar(s0 << 8) + s1);
        return ObHashSortUtf16.intToUnchar(b);
    }

    private static int intToUnchar(int b) {
        return (b + 256) % 256;
    }
}

