/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.enums;

import com.oceanbase.partition.calculator.enums.ObPartFuncType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public enum ObPartFuncTypeV4 implements ObPartFuncType
{
    HASH("HASH", 0L),
    KEY("KEY", 1L),
    KEY_IMPLICIT("KEY_IMPLICIT", 2L),
    RANGE("RANGE", 3L),
    RANGE_COLUMNS("RANGE_COLUMNS", 4L),
    LIST("LIST", 5L),
    LIST_COLUMNS("LIST_COLUMNS", 6L),
    INTERVAL("INTERVAL", 7L),
    MAX("MAX", 8L);

    private static final Map<Long, ObPartFuncTypeV4> INDEX_MAPPING;
    private static final Map<String, ObPartFuncTypeV4> NAME_MAPPING;
    private String name = "";
    private long index = -1L;

    private ObPartFuncTypeV4(String name, long index) {
        this.name = name;
        this.index = index;
    }

    public static ObPartFuncTypeV4 getObPartFuncType(long index) {
        return INDEX_MAPPING.getOrDefault(index, null);
    }

    public static ObPartFuncTypeV4 getObPartFuncType(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String upper = name.toUpperCase(Locale.getDefault());
        return NAME_MAPPING.getOrDefault(upper, null);
    }

    @Override
    public boolean isRangePart() {
        return this.index == RANGE.getIndex() || this.index == RANGE_COLUMNS.getIndex();
    }

    @Override
    public boolean isHashPart() {
        return this.index == HASH.getIndex();
    }

    @Override
    public boolean isKeyPart() {
        return this.index == KEY.getIndex() || this.index == KEY_IMPLICIT.getIndex();
    }

    @Override
    public boolean isListPart() {
        return this.index == LIST.getIndex() || this.index == LIST_COLUMNS.getIndex();
    }

    public String getName() {
        return this.name;
    }

    public long getIndex() {
        return this.index;
    }

    static {
        INDEX_MAPPING = new HashMap<Long, ObPartFuncTypeV4>(9);
        NAME_MAPPING = new HashMap<String, ObPartFuncTypeV4>(9);
        for (ObPartFuncTypeV4 obPartFuncTyp : ObPartFuncTypeV4.values()) {
            NAME_MAPPING.putIfAbsent(obPartFuncTyp.getName(), obPartFuncTyp);
            INDEX_MAPPING.putIfAbsent(obPartFuncTyp.getIndex(), obPartFuncTyp);
        }
    }
}

