/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.struct;

import com.oceanbase.partition.calculator.algo.hash.MurmurHash;
import com.oceanbase.partition.calculator.struct.ObCommonStruct;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObDecimalInt
extends ObCommonStruct {
    private static final Logger log = LoggerFactory.getLogger(ObDecimalInt.class);
    private static final long SIGN_BIT_MASK = 0x80000000L;
    private static final long UINT32_MAX = 0xFFFFFFFFL;
    private boolean isOracleMode;
    private BigInteger decimalInt = BigInteger.ZERO;
    private int intByte;
    private byte[] decimalIntBytes;

    public ObDecimalInt(Object numberObj, int precision, int scale, boolean isOracleMode) {
        if (precision > 155 || precision <= 0) {
            throw new IllegalArgumentException();
        }
        this.intByte = precision > 76 ? 64 : (precision > 38 ? 32 : (precision > 18 ? 16 : (precision > 9 ? 8 : 4)));
        this.isOracleMode = isOracleMode;
        if (numberObj instanceof BigDecimal) {
            this.fromBigDecimal((BigDecimal)numberObj, scale);
        } else if (numberObj instanceof BigInteger) {
            this.fromBigInteger((BigInteger)numberObj, scale);
        } else if (numberObj instanceof Long) {
            this.fromLong((Long)numberObj, scale);
        } else {
            this.fromString(numberObj.toString(), scale);
        }
        this.decimalIntBytes = new byte[this.intByte];
        boolean isNegative = this.decimalInt.compareTo(BigInteger.ZERO) < 0;
        byte[] bigEndiaBytes = this.decimalInt.toByteArray();
        int j = 0;
        for (int i = 0; i < this.intByte; ++i) {
            this.decimalIntBytes[this.intByte - i - 1] = i < this.intByte - bigEndiaBytes.length ? (byte)(isNegative ? 255 : 0) : bigEndiaBytes[j++];
        }
    }

    private void fromBigDecimal(BigDecimal originValue, int scale) {
        BigDecimal scaledDecimal = originValue.setScale(scale, RoundingMode.HALF_UP);
        this.decimalInt = scaledDecimal.movePointRight(scale).toBigIntegerExact();
    }

    private void fromBigInteger(BigInteger originValue, int scale) {
        this.decimalInt = originValue.shiftRight(scale);
    }

    private void fromLong(Long originValue, int scale) {
        this.decimalInt = BigInteger.valueOf(originValue).shiftRight(scale);
    }

    private void fromString(String originValue, int scale) {
        if (NumberUtils.isCreatable((String)originValue)) {
            this.fromBigDecimal(new BigDecimal(originValue), scale);
        } else {
            log.warn("Input ob decimal int: {} cannot be parsed", (Object)originValue);
        }
    }

    @Override
    public BigInteger murmurhash64A(BigInteger hashSeed) {
        if (!this.isOracleMode) {
            return MurmurHash.hash64ByBigInt(this.decimalIntBytes, this.intByte, hashSeed);
        }
        return this.decimalIntMurmurHash(hashSeed);
    }

    public BigInteger decimalIntMurmurHash(BigInteger hashSeed) {
        int last;
        block5: {
            long[] data;
            block4: {
                last = this.intByte / 4 - 1;
                if (last <= 0) {
                    return MurmurHash.hash64ByBigInt(this.decimalIntBytes, this.intByte, hashSeed);
                }
                data = new long[last + 1];
                int j = 0;
                for (int i = 0; i < this.decimalIntBytes.length - 3; i += 4) {
                    byte byte0 = this.decimalIntBytes[i];
                    byte byte1 = this.decimalIntBytes[i + 1];
                    byte byte2 = this.decimalIntBytes[i + 2];
                    byte byte3 = this.decimalIntBytes[i + 3];
                    long curLong = (((long)byte3 & 0xFFL) << 24) + (((long)byte2 & 0xFFL) << 16) + (((long)byte1 & 0xFFL) << 8) + ((long)byte0 & 0xFFL);
                    data[j++] = (0x100000000L + curLong) % 0x100000000L;
                }
                if (data[last] != 0xFFFFFFFFL) break block4;
                while (last > 0 && data[last] == 0xFFFFFFFFL && (data[last - 1] & 0x80000000L) != 0L) {
                    --last;
                }
                break block5;
            }
            if (data[last] != 0L) break block5;
            while (last > 0 && data[last] == 0L && (data[last - 1] & 0x80000000L) == 0L) {
                --last;
            }
        }
        return MurmurHash.hash64ByBigInt(this.decimalIntBytes, (last + 1) * 4, hashSeed);
    }
}

