/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.druid.sql.ast.expr.SQLDoubleExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorImpl;
import com.alibaba.druid.sql.visitor.functions.Function;
import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.calculator.enums.SqlFunctions;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ObPartEvalVisitor
extends SQLEvalVisitorImpl {
    private Map<String, Object> columnValueMap;
    private Map<String, SQLExpr> partColumnExprMap;

    public ObPartEvalVisitor() {
        this.columnValueMap = new HashMap<String, Object>();
        this.partColumnExprMap = new HashMap<String, SQLExpr>();
    }

    public ObPartEvalVisitor(Map<String, Object> columnValueMap, Map<String, SQLExpr> partColumnExprMap) {
        super((List)Lists.newArrayList(columnValueMap.values()));
        this.columnValueMap = columnValueMap;
        this.partColumnExprMap = partColumnExprMap;
    }

    public boolean visit(SQLVariantRefExpr expr) {
        int varIndex = expr.getIndex();
        List parameters = super.getParameters();
        if (varIndex != -1 && parameters != null && varIndex < parameters.size()) {
            return this.setAttribute((SQLExpr)expr, parameters.get(varIndex));
        }
        return false;
    }

    public boolean visit(SQLDoubleExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLDecimalExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLCharExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLIntegerExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLNumberExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLTimestampExpr x) {
        return this.setAttribute((SQLExpr)x, x.getValue());
    }

    public boolean visit(SQLMethodInvokeExpr x) {
        String methodName = x.getMethodName().toLowerCase(Locale.getDefault());
        Function function = SqlFunctions.getByName(methodName);
        if (function == null) {
            throw new UnsupportedOperationException("Function `" + methodName + "` is unsupported");
        }
        return this.setAttribute((SQLExpr)x, function.eval((SQLEvalVisitor)this, x));
    }

    public boolean visit(SQLIdentifierExpr x) {
        String name;
        String columnName = x.getName();
        if (this.partColumnExprMap.containsKey(columnName)) {
            SQLExpr sqlExpr = this.partColumnExprMap.get(columnName);
            sqlExpr.accept((SQLASTVisitor)this);
            return this.setAttribute((SQLExpr)x, sqlExpr.getAttributes().get("eval.value"));
        }
        if (!this.columnValueMap.containsKey(columnName) && columnName.equalsIgnoreCase(ObObjType.MAXVALUE.getName())) {
            return this.setAttribute((SQLExpr)x, "MAXVALUE");
        }
        for (Map.Entry<String, Object> entry : this.columnValueMap.entrySet()) {
            name = entry.getKey();
            if (!columnName.equalsIgnoreCase(name)) continue;
            return this.setAttribute((SQLExpr)x, this.columnValueMap.get(name));
        }
        for (Map.Entry<String, Object> entry : this.partColumnExprMap.entrySet()) {
            name = entry.getKey();
            if (!columnName.equalsIgnoreCase(name)) continue;
            SQLExpr sqlExpr = this.partColumnExprMap.get(name);
            sqlExpr.accept((SQLASTVisitor)this);
            return this.setAttribute((SQLExpr)x, sqlExpr.getAttributes().get("eval.value"));
        }
        throw new IllegalArgumentException("Column `" + columnName + "` is not exists");
    }

    private boolean setAttribute(SQLExpr expr, Object result) {
        if (result == null) {
            result = SQLEvalVisitor.EVAL_VALUE_NULL;
        }
        expr.getAttributes().put("eval.value", result);
        return false;
    }

    public Map<String, Object> getColumnValueMap() {
        return this.columnValueMap;
    }

    public void setPartColumnExprMap(Map<String, SQLExpr> partColumnExprMap) {
        this.partColumnExprMap = partColumnExprMap;
    }
}

