/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.metadata.desc;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.partition.metadata.desc.ObPartDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObTablePart {
    private ObPartLevel level = ObPartLevel.UNKNOWN;
    private ObPartDesc partDesc;
    private ObPartDesc subPartDesc;
    private List<ObPartColumn> partColumns = new ArrayList<ObPartColumn>(1);
    private List<ObPartColumn> refPartColumns;
    private List<ObPartColumn> subPartColumns = new ArrayList<ObPartColumn>(1);
    private List<ObPartColumn> refSubPartColumns;
    private Map<String, SQLExpr> partGeneratedColumnExprMap;
    private Map<Long, Set<String>> partIdNameMap;
    private Map<Long, Long> partIdTabletIdMap;

    public ObTablePart() {
        this.refPartColumns = new ArrayList<ObPartColumn>(1);
        this.refSubPartColumns = new ArrayList<ObPartColumn>(1);
        this.partGeneratedColumnExprMap = new HashMap<String, SQLExpr>();
        this.partIdTabletIdMap = new HashMap<Long, Long>(1);
    }

    public void addPartColumn(ObPartColumn column) {
        this.partColumns.add(column);
        if (column.getColumnExpr() != null) {
            this.partGeneratedColumnExprMap.putIfAbsent(column.getColumnName(), column.getColumnExpr());
        }
    }

    public void addRefPartColumn(ObPartColumn column) {
        this.refPartColumns.add(column);
    }

    public void addSubPartColumn(ObPartColumn column) {
        this.subPartColumns.add(column);
        if (column.getColumnExpr() != null) {
            this.partGeneratedColumnExprMap.putIfAbsent(column.getColumnName(), column.getColumnExpr());
        }
    }

    public void addRefSubPartColumn(ObPartColumn column) {
        this.refSubPartColumns.add(column);
    }

    public boolean isValid() {
        return (this.getSubPartDesc() != null || this.getLevel() != ObPartLevel.LEVEL_TWO) && this.getPartDesc() != null && this.getLevel().getIndex() >= ObPartLevel.LEVEL_ONE.getIndex();
    }

    public boolean isSubPartitioned() {
        return this.getLevel().getIndex() > ObPartLevel.LEVEL_ONE.getIndex();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObTablePart [ ");
        sb.append("PartLevel: ").append((Object)this.level);
        sb.append(", Part: ").append(this.partDesc);
        sb.append(", SubPart: ").append(this.subPartDesc);
        sb.append(", PartColumns: ").append(this.partColumns);
        sb.append(", SubPartColumns: ").append(this.subPartColumns);
        return sb.append(" ]").toString();
    }

    public ObPartLevel getLevel() {
        return this.level;
    }

    public void setLevel(ObPartLevel level) {
        this.level = level;
    }

    public ObPartDesc getPartDesc() {
        return this.partDesc;
    }

    public void setPartDesc(ObPartDesc partDesc) {
        this.partDesc = partDesc;
    }

    public ObPartDesc getSubPartDesc() {
        return this.subPartDesc;
    }

    public void setSubPartDesc(ObPartDesc subPartDesc) {
        this.subPartDesc = subPartDesc;
    }

    public List<ObPartColumn> getPartColumns() {
        return this.partColumns;
    }

    public void setPartColumns(List<ObPartColumn> partColumns) {
        this.partColumns = partColumns;
    }

    public List<ObPartColumn> getRefPartColumns() {
        return this.refPartColumns;
    }

    public void setRefPartColumns(List<ObPartColumn> refPartColumns) {
        this.refPartColumns = refPartColumns;
    }

    public List<ObPartColumn> getSubPartColumns() {
        return this.subPartColumns;
    }

    public void setSubPartColumns(List<ObPartColumn> subPartColumns) {
        this.subPartColumns = subPartColumns;
    }

    public List<ObPartColumn> getRefSubPartColumns() {
        return this.refSubPartColumns;
    }

    public void setRefSubPartColumns(List<ObPartColumn> refSubPartColumns) {
        this.refSubPartColumns = refSubPartColumns;
    }

    public Map<String, SQLExpr> getPartGeneratedColumnExprMap() {
        return this.partGeneratedColumnExprMap;
    }

    public Map<Long, Set<String>> getPartIdNameMap() {
        return this.partIdNameMap;
    }

    public void setPartIdNameMap(Map<Long, Set<String>> partIdNameMap) {
        this.partIdNameMap = partIdNameMap;
    }

    public Map<Long, Long> getPartIdTabletIdMap() {
        return this.partIdTabletIdMap;
    }

    public void setPartIdTabletIdMap(Map<Long, Long> partIdTabletIdMap) {
        this.partIdTabletIdMap = partIdTabletIdMap;
    }
}

