/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser;

import com.oceanbase.tools.sqlparser.FastFailErrorListener;
import com.oceanbase.tools.sqlparser.FastFailErrorStrategy;
import com.oceanbase.tools.sqlparser.SQLParser;
import com.oceanbase.tools.sqlparser.SyntaxErrorException;
import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.statement.Statement;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseSQLParser<T extends Lexer, V extends Parser>
implements SQLParser {
    protected abstract ParseTree doParse(V var1);

    protected abstract T getLexer(Reader var1) throws IOException;

    protected abstract V getParser(TokenStream var1);

    public ParseTree buildAst(Reader statementReader) {
        T lexer;
        if (statementReader == null) {
            throw new IllegalArgumentException("Input reader is null");
        }
        try {
            lexer = this.getLexer(statementReader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (lexer == null) {
            throw new IllegalArgumentException("Lexer can not be null");
        }
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new FastFailErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        V parser = this.getParser((TokenStream)tokens);
        if (parser == null) {
            throw new IllegalArgumentException("Parser can not be null");
        }
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new FastFailErrorListener());
        parser.setErrorHandler((ANTLRErrorStrategy)new FastFailErrorStrategy());
        return this.doParse(parser);
    }

    @Override
    public Statement parse(Reader statementReader) throws SyntaxErrorException {
        return this.buildStatement(this.buildAst(statementReader));
    }

    public Statement buildStatement(ParseTree root) {
        Set<Class<StatementFactory<Statement>>> classes;
        URI uri;
        String basePkg = this.getStatementFactoryBasePackage();
        if (StringUtils.isEmpty((CharSequence)basePkg)) {
            throw new IllegalStateException("Base package dir is empty, " + basePkg);
        }
        basePkg = basePkg.replace('.', '/');
        URL url = BaseSQLParser.class.getClassLoader().getResource(basePkg);
        if (url == null) {
            throw new IllegalStateException("Can not load package for path, " + basePkg);
        }
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            classes = this.loadClassesFromLocal(uri);
        } else if ("jar".equals(scheme)) {
            classes = this.loadClassesFromJar(url);
        } else {
            throw new IllegalArgumentException("UnSupported scheme " + scheme);
        }
        Optional<Class> optional = classes.stream().filter(clazz -> this.getSupportedParameters((Class<?>)clazz).stream().anyMatch(items -> {
            if (CollectionUtils.isEmpty((Collection)items)) {
                return false;
            }
            if (items.size() != 1) {
                return false;
            }
            return ((Class)items.get(0)).equals(root.getClass());
        })).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        Class clazz2 = optional.get();
        try {
            Constructor constructor = clazz2.getConstructor(root.getClass());
            return ((StatementFactory)constructor.newInstance(root)).generate();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private Set<Class<? extends StatementFactory<? extends Statement>>> loadClassesFromLocal(URI uri) {
        File[] files = new File(uri).listFiles();
        if (files == null) {
            return new HashSet<Class<? extends StatementFactory<? extends Statement>>>();
        }
        String basePkg = this.getStatementFactoryBasePackage();
        return Arrays.stream(files).filter(file -> file.getName().endsWith(".class")).map(file -> {
            try {
                String classPath = basePkg + "." + file.getName();
                return Class.forName(classPath.substring(0, classPath.indexOf(".class")));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }).filter(StatementFactory.class::isAssignableFrom).map(c -> c).collect(Collectors.toSet());
    }

    private Set<Class<? extends StatementFactory<? extends Statement>>> loadClassesFromJar(URL url) {
        JarFile jarFile;
        String entryName;
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            String string = entryName = connection.getEntryName() == null ? "" : connection.getEntryName();
            if (entryName.contains("!")) {
                entryName = entryName.replace("!", "");
            }
            jarFile = connection.getJarFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        LinkedList<String> targets = new LinkedList<String>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().startsWith(entryName) || zipEntry.isDirectory()) continue;
            targets.add(zipEntry.getName().substring(entryName.length() + 1));
        }
        String basePkg = this.getStatementFactoryBasePackage();
        return targets.stream().map(s -> {
            try {
                String classPath = basePkg + "." + s;
                return Class.forName(classPath.substring(0, classPath.indexOf(".class")));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }).filter(StatementFactory.class::isAssignableFrom).map(c -> c).collect(Collectors.toSet());
    }

    private List<List<Class<?>>> getSupportedParameters(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            return Collections.emptyList();
        }
        ArrayList types = new ArrayList();
        for (Constructor<?> constructor : constructors) {
            types.add(Arrays.stream(constructor.getParameters()).map(Parameter::getType).collect(Collectors.toList()));
        }
        return types;
    }

    protected abstract String getStatementFactoryBasePackage();
}

