/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLPartitionElementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLPartitionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLTableElementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLTableOptionsFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.alter.table.AlterTableAction;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnDefinition;
import com.oceanbase.tools.sqlparser.statement.createtable.ConstraintState;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineIndex;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionElement;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class MySQLAlterTableActionFactory
extends OBParserBaseVisitor<AlterTableAction>
implements StatementFactory<AlterTableAction> {
    private final ParserRuleContext parserRuleContext;

    public MySQLAlterTableActionFactory(@NonNull OBParser.Alter_table_actionContext alterTableActionContext) {
        if (alterTableActionContext == null) {
            throw new NullPointerException("alterTableActionContext is marked non-null but is null");
        }
        this.parserRuleContext = alterTableActionContext;
    }

    @Override
    public AlterTableAction generate() {
        return (AlterTableAction)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public AlterTableAction visitAlter_table_action(OBParser.Alter_table_actionContext ctx) {
        AlterTableAction alterTableAction = new AlterTableAction(ctx);
        if (ctx.table_option_list_space_seperated() != null) {
            alterTableAction.setTableOptions(new MySQLTableOptionsFactory(ctx.table_option_list_space_seperated()).generate());
            return alterTableAction;
        }
        if (ctx.RENAME() != null) {
            alterTableAction.setRenameToTable(this.getRelationFactor(ctx.relation_factor()));
            return alterTableAction;
        }
        if (ctx.CONVERT() != null && ctx.TO() != null) {
            alterTableAction.setCharset(ctx.charset_name().getText());
            if (ctx.collation() != null) {
                alterTableAction.setCollation(ctx.collation().collation_name().getText());
            }
            return alterTableAction;
        }
        return (AlterTableAction)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public AlterTableAction visitAlter_column_option(OBParser.Alter_column_optionContext ctx) {
        AlterTableAction alterTableAction = new AlterTableAction(ctx);
        if (ctx.ADD() != null) {
            ArrayList<ColumnDefinition> addColumns = new ArrayList<ColumnDefinition>();
            if (ctx.column_definition() != null) {
                addColumns.add((ColumnDefinition)new MySQLTableElementFactory(ctx.column_definition()).generate());
            } else {
                addColumns = ctx.column_definition_list().column_definition().stream().map(c -> (ColumnDefinition)new MySQLTableElementFactory((OBParser.Column_definitionContext)((Object)c)).generate()).collect(Collectors.toList());
            }
            alterTableAction.setAddColumns(addColumns);
        } else if (ctx.DROP() != null) {
            String option = null;
            if (ctx.CASCADE() != null) {
                option = ctx.CASCADE().getText();
            } else if (ctx.RESTRICT() != null) {
                option = ctx.RESTRICT().getText();
            }
            alterTableAction.setDropColumn(new MySQLColumnRefFactory(ctx.column_definition_ref()).generate(), option);
        } else if (ctx.MODIFY() != null) {
            ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
            columns.add((ColumnDefinition)new MySQLTableElementFactory(ctx.column_definition()).generate());
            alterTableAction.setModifyColumns(columns);
        } else if (ctx.CHANGE() != null) {
            ColumnReference colRef = new MySQLColumnRefFactory(ctx.column_definition_ref()).generate();
            ColumnDefinition colDef = (ColumnDefinition)new MySQLTableElementFactory(ctx.column_definition()).generate();
            alterTableAction.changeColumn(colRef, colDef);
        } else if (ctx.ALTER() != null) {
            ColumnReference colRef = new MySQLColumnRefFactory(ctx.column_definition_ref()).generate();
            OBParser.Alter_column_behaviorContext aCtx = ctx.alter_column_behavior();
            AlterTableAction.AlterColumnBehavior behavior = new AlterTableAction.AlterColumnBehavior(aCtx);
            if (aCtx.signed_literal() != null) {
                behavior.setDefaultValue(MySQLTableElementFactory.getSignedLiteral(aCtx.signed_literal()));
            }
            alterTableAction.alterColumnBehavior(colRef, behavior);
        }
        return alterTableAction;
    }

    @Override
    public AlterTableAction visitAlter_tablegroup_option(OBParser.Alter_tablegroup_optionContext ctx) {
        AlterTableAction alterTableAction = new AlterTableAction(ctx);
        alterTableAction.setDropTableGroup(true);
        return alterTableAction;
    }

    @Override
    public AlterTableAction visitAlter_index_option(OBParser.Alter_index_optionContext ctx) {
        AlterTableAction alterTableAction = new AlterTableAction(ctx);
        if (ctx.ADD() != null && ctx.out_of_line_index() != null) {
            alterTableAction.setAddIndex((OutOfLineIndex)new MySQLTableElementFactory(ctx.out_of_line_index()).generate());
        } else if (ctx.DROP() != null) {
            alterTableAction.setDropIndexName(ctx.index_name(0).getText());
        } else if (ctx.ALTER() != null && ctx.INDEX() != null) {
            String idxName = ctx.index_name(0).getText();
            if (ctx.visibility_option() != null) {
                alterTableAction.alterIndexVisibility(idxName, ctx.visibility_option().VISIBLE() != null);
            } else if (ctx.parallel_option().NOPARALLEL() != null) {
                alterTableAction.alterIndexNoParallel(idxName);
            } else {
                alterTableAction.alterIndexParallel(idxName, Integer.parseInt(ctx.parallel_option().INTNUM().getText()));
            }
        } else if (ctx.RENAME() != null) {
            alterTableAction.renameIndex(ctx.index_name(0).getText(), ctx.index_name(1).getText());
        }
        return alterTableAction;
    }

    @Override
    public AlterTableAction visitAlter_partition_option(OBParser.Alter_partition_optionContext ctx) {
        AlterTableAction alterTableAction = new AlterTableAction(ctx);
        if (ctx.DROP() != null) {
            List<String> names = this.getNames(ctx.drop_partition_name_list().name_list());
            if (ctx.PARTITION() != null) {
                alterTableAction.setDropPartitionNames(names);
            } else if (ctx.SUBPARTITION() != null) {
                alterTableAction.setDropSubPartitionNames(names);
            }
        } else if (ctx.TRUNCATE() != null) {
            List<String> names = this.getNames(ctx.name_list());
            if (ctx.PARTITION() != null) {
                alterTableAction.setTruncatePartitionNames(names);
            } else if (ctx.SUBPARTITION() != null) {
                alterTableAction.setTruncateSubPartitionNames(names);
            }
        } else if (ctx.ADD() != null && ctx.opt_partition_range_or_list() != null) {
            alterTableAction.setAddPartitionElements(this.getPartitionElements(ctx.opt_partition_range_or_list()));
        } else if (ctx.modify_partition_info() != null) {
            OBParser.Modify_partition_infoContext mCtx = ctx.modify_partition_info();
            if (mCtx.hash_partition_option() != null) {
                alterTableAction.setModifyPartition(new MySQLPartitionFactory(mCtx.hash_partition_option()).generate());
            } else if (mCtx.list_partition_option() != null) {
                alterTableAction.setModifyPartition(new MySQLPartitionFactory(mCtx.list_partition_option()).generate());
            } else if (mCtx.range_partition_option() != null) {
                alterTableAction.setModifyPartition(new MySQLPartitionFactory(mCtx.range_partition_option()).generate());
            } else if (mCtx.key_partition_option() != null) {
                alterTableAction.setModifyPartition(new MySQLPartitionFactory(mCtx.key_partition_option()).generate());
            }
        } else if (ctx.REORGANIZE() != null) {
            alterTableAction.reorganizePartition(this.getNames(ctx.name_list()), this.getPartitionElements(ctx.opt_partition_range_or_list()));
        }
        return alterTableAction;
    }

    @Override
    public AlterTableAction visitAlter_constraint_option(OBParser.Alter_constraint_optionContext ctx) {
        AlterTableAction action = new AlterTableAction(ctx);
        if (ctx.ADD() != null && ctx.out_of_line_constraint() != null) {
            action.setAddConstraint((OutOfLineConstraint)new MySQLTableElementFactory(ctx.out_of_line_constraint()).generate());
        } else if (ctx.DROP() != null) {
            if (ctx.PRIMARY() != null) {
                action.setDropPrimaryKey(true);
            } else if (ctx.FOREIGN() != null) {
                action.setDropForeignKeyName(ctx.index_name().getText());
            } else {
                List<String> names = ctx.name_list() != null ? this.getNames(ctx.name_list()) : Collections.singletonList(ctx.constraint_name().getText());
                action.setDropConstraintNames(names);
            }
        } else {
            ConstraintState state = new ConstraintState(ctx.check_state());
            state.setEnforced(ctx.check_state().NOT() == null);
            action.modifyConstraint(ctx.constraint_name().getText(), state);
        }
        return action;
    }

    private RelationFactor getRelationFactor(OBParser.Relation_factorContext ctx) {
        RelationFactor relationFactor = new RelationFactor((ParserRuleContext)ctx, MySQLFromReferenceFactory.getRelation(ctx));
        relationFactor.setSchema(MySQLFromReferenceFactory.getSchemaName(ctx));
        return relationFactor;
    }

    private List<String> getNames(OBParser.Name_listContext context) {
        ArrayList<String> list = new ArrayList<String>();
        if (context.NAME_OB() != null && context.name_list() == null) {
            list.add(context.NAME_OB().getText());
        } else if (context.NAME_OB() != null && context.name_list() != null) {
            list.addAll(this.getNames(context.name_list()));
            list.add(context.NAME_OB().getText());
        }
        return list;
    }

    private List<PartitionElement> getPartitionElements(OBParser.Opt_partition_range_or_listContext pCtx) {
        if (pCtx.opt_range_partition_list() != null) {
            return pCtx.opt_range_partition_list().range_partition_list().range_partition_element().stream().map(c -> new MySQLPartitionElementFactory((OBParser.Range_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        return pCtx.opt_list_partition_list().list_partition_list().list_partition_element().stream().map(c -> new MySQLPartitionElementFactory((OBParser.List_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
    }
}

