/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSelectBodyFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.JoinType;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.select.ExpressionReference;
import com.oceanbase.tools.sqlparser.statement.select.FlashBackType;
import com.oceanbase.tools.sqlparser.statement.select.FlashbackUsage;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.JoinCondition;
import com.oceanbase.tools.sqlparser.statement.select.JoinReference;
import com.oceanbase.tools.sqlparser.statement.select.NameReference;
import com.oceanbase.tools.sqlparser.statement.select.OnJoinCondition;
import com.oceanbase.tools.sqlparser.statement.select.PartitionType;
import com.oceanbase.tools.sqlparser.statement.select.PartitionUsage;
import com.oceanbase.tools.sqlparser.statement.select.UsingJoinCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLFromReferenceFactory
extends OBParserBaseVisitor<FromReference>
implements StatementFactory<FromReference> {
    private OBParser.Table_referenceContext tableReferenceContext;
    private OBParser.Tbl_nameContext tableNameContext;

    public MySQLFromReferenceFactory(@NonNull OBParser.Table_referenceContext tableReferenceContext) {
        if (tableReferenceContext == null) {
            throw new NullPointerException("tableReferenceContext is marked non-null but is null");
        }
        this.tableReferenceContext = tableReferenceContext;
    }

    public MySQLFromReferenceFactory(@NonNull OBParser.Tbl_nameContext tableNameContext) {
        if (tableNameContext == null) {
            throw new NullPointerException("tableNameContext is marked non-null but is null");
        }
        this.tableNameContext = tableNameContext;
    }

    @Override
    public FromReference generate() {
        if (this.tableReferenceContext != null) {
            return (FromReference)this.visit((ParseTree)this.tableReferenceContext);
        }
        return (FromReference)this.visit((ParseTree)this.tableNameContext);
    }

    @Override
    public FromReference visitTable_reference(OBParser.Table_referenceContext ctx) {
        if (ctx.table_factor() != null) {
            return (FromReference)this.visit((ParseTree)ctx.table_factor());
        }
        return (FromReference)this.visit((ParseTree)ctx.joined_table());
    }

    @Override
    public FromReference visitTable_factor(OBParser.Table_factorContext ctx) {
        if (ctx.tbl_name() != null) {
            return (FromReference)this.visit((ParseTree)ctx.tbl_name());
        }
        if (ctx.table_subquery() != null) {
            return (FromReference)this.visit((ParseTree)ctx.table_subquery());
        }
        if (ctx.table_reference() != null) {
            return (FromReference)this.visit((ParseTree)ctx.table_reference());
        }
        MySQLSelectBodyFactory factory = new MySQLSelectBodyFactory(ctx.select_with_parens());
        ExpressionReference reference = new ExpressionReference(ctx, (Expression)factory.generate(), null);
        if (ctx.use_flashback() != null) {
            reference.setFlashbackUsage(this.visitFlashbackUsage(ctx.use_flashback()));
        }
        return reference;
    }

    @Override
    public FromReference visitJoined_table(OBParser.Joined_tableContext ctx) {
        FromReference right;
        FromReference left;
        JoinType joinType = null;
        if (ctx.inner_join_type() != null) {
            joinType = ctx.inner_join_type().CROSS() != null ? JoinType.CROSS_JOIN : (ctx.inner_join_type().INNER() != null ? JoinType.INNER_JOIN : JoinType.JOIN);
        } else if (ctx.outer_join_type() != null) {
            joinType = this.getOuterJoinType(ctx.outer_join_type());
        } else if (ctx.natural_join_type() != null) {
            OBParser.Natural_join_typeContext naturalJoin = ctx.natural_join_type();
            if (naturalJoin.outer_join_type() != null) {
                JoinType outerJ = this.getOuterJoinType(naturalJoin.outer_join_type());
                joinType = JoinType.valueOf("NATURAL_" + outerJ.name().toUpperCase());
            } else {
                joinType = naturalJoin.INNER() != null ? JoinType.NATURAL_INNER_JOIN : JoinType.NATURAL_JOIN;
            }
        }
        if (joinType == null) {
            throw new IllegalStateException("Missing join type");
        }
        List<OBParser.Table_factorContext> tableFactors = ctx.table_factor();
        if (tableFactors.size() == 2) {
            left = (FromReference)this.visit((ParseTree)tableFactors.get(0));
            right = (FromReference)this.visit((ParseTree)tableFactors.get(1));
        } else {
            left = (FromReference)this.visit((ParseTree)ctx.joined_table());
            right = (FromReference)this.visit((ParseTree)tableFactors.get(0));
        }
        JoinCondition condition = null;
        OBParser.Join_conditionContext joinCondition = ctx.join_condition();
        if (joinCondition != null) {
            condition = joinCondition.ON() != null ? this.getFromOnExpr(joinCondition.expr(), joinCondition) : this.getFromUsingColumnList(joinCondition.column_list(), joinCondition);
        } else if (ctx.ON() != null) {
            condition = this.getFromOnExpr(ctx.expr(), null);
        } else if (ctx.USING() != null) {
            condition = this.getFromUsingColumnList(ctx.column_list(), null);
        }
        return new JoinReference(ctx, left, right, joinType, condition);
    }

    @Override
    public FromReference visitTbl_name(OBParser.Tbl_nameContext ctx) {
        OBParser.Relation_factorContext relationFactor = ctx.relation_factor();
        String schema = MySQLFromReferenceFactory.getSchemaName(relationFactor);
        String relationName = MySQLFromReferenceFactory.getRelation(relationFactor);
        String alias = null;
        if (ctx.relation_name() != null) {
            alias = ctx.relation_name().getText();
        }
        NameReference nameReference = new NameReference(ctx, schema, relationName, alias);
        if (ctx.use_partition() != null) {
            nameReference.setPartitionUsage(this.visitPartitonUsage(ctx.use_partition()));
        }
        if (ctx.use_flashback() != null) {
            nameReference.setFlashbackUsage(this.visitFlashbackUsage(ctx.use_flashback()));
        }
        return nameReference;
    }

    public static String getSchemaName(OBParser.Relation_factorContext context) {
        if (context == null || context.normal_relation_factor() == null) {
            return null;
        }
        return MySQLFromReferenceFactory.getSchemaName(context.normal_relation_factor());
    }

    public static String getRelation(OBParser.Relation_factorContext context) {
        if (context == null) {
            return null;
        }
        if (context.normal_relation_factor() != null) {
            return MySQLFromReferenceFactory.getRelation(context.normal_relation_factor());
        }
        OBParser.Dot_relation_factorContext d = context.dot_relation_factor();
        if (d.relation_name() != null) {
            return d.relation_name().getText();
        }
        if (d.mysql_reserved_keyword() != null) {
            return d.mysql_reserved_keyword().getText();
        }
        return null;
    }

    public static String getSchemaName(OBParser.Normal_relation_factorContext c) {
        List names = c.relation_name().stream().map(RuleContext::getText).collect(Collectors.toList());
        if (c.mysql_reserved_keyword() != null) {
            return (String)names.get(0);
        }
        if (names.size() == 2) {
            return (String)names.get(0);
        }
        return null;
    }

    public static RelationFactor getRelationFactor(OBParser.Normal_relation_factorContext ctx) {
        RelationFactor relationFactor = new RelationFactor((ParserRuleContext)ctx, MySQLFromReferenceFactory.getRelation(ctx));
        relationFactor.setSchema(MySQLFromReferenceFactory.getSchemaName(ctx));
        return relationFactor;
    }

    public static RelationFactor getRelationFactor(OBParser.Relation_factorContext ctx) {
        RelationFactor relationFactor = new RelationFactor((ParserRuleContext)ctx, MySQLFromReferenceFactory.getRelation(ctx));
        relationFactor.setSchema(MySQLFromReferenceFactory.getSchemaName(ctx));
        return relationFactor;
    }

    public static String getRelation(OBParser.Normal_relation_factorContext c) {
        List names = c.relation_name().stream().map(RuleContext::getText).collect(Collectors.toList());
        if (c.mysql_reserved_keyword() != null) {
            return c.mysql_reserved_keyword().getText();
        }
        if (names.size() == 2) {
            return (String)names.get(1);
        }
        if (names.size() == 1) {
            return (String)names.get(0);
        }
        return null;
    }

    @Override
    public FromReference visitTable_subquery(OBParser.Table_subqueryContext ctx) {
        MySQLSelectBodyFactory factory = new MySQLSelectBodyFactory(ctx.select_with_parens());
        String alias = ctx.relation_name().getText();
        ExpressionReference reference = new ExpressionReference(ctx, (Expression)factory.generate(), alias);
        if (ctx.use_flashback() != null) {
            reference.setFlashbackUsage(this.visitFlashbackUsage(ctx.use_flashback()));
        }
        return reference;
    }

    private FlashbackUsage visitFlashbackUsage(OBParser.Use_flashbackContext ctx) {
        MySQLExpressionFactory factory = new MySQLExpressionFactory(ctx.bit_expr());
        return new FlashbackUsage(ctx, FlashBackType.AS_OF_SNAPSHOT, (Expression)factory.generate());
    }

    private PartitionUsage visitPartitonUsage(OBParser.Use_partitionContext usePartition) {
        ArrayList<String> nameList = new ArrayList<String>();
        this.visitNameList(usePartition.name_list(), nameList);
        return new PartitionUsage(usePartition, PartitionType.PARTITION, nameList);
    }

    private void visitNameList(OBParser.Name_listContext ctx, List<String> nameList) {
        if (ctx.NAME_OB() != null && ctx.name_list() == null) {
            nameList.add(ctx.NAME_OB().getText());
            return;
        }
        this.visitNameList(ctx.name_list(), nameList);
        nameList.add(ctx.NAME_OB().getText());
    }

    private JoinType getOuterJoinType(OBParser.Outer_join_typeContext ctx) {
        ArrayList<String> joinList = new ArrayList<String>();
        if (ctx.FULL() != null) {
            joinList.add(ctx.FULL().getText());
        } else if (ctx.LEFT() != null) {
            joinList.add(ctx.LEFT().getText());
        } else if (ctx.RIGHT() != null) {
            joinList.add(ctx.RIGHT().getText());
        }
        if (ctx.OUTER() != null) {
            joinList.add(ctx.OUTER().getText());
        }
        joinList.add("JOIN");
        return JoinType.valueOf(String.join((CharSequence)"_", joinList).toUpperCase());
    }

    private JoinCondition getFromOnExpr(OBParser.ExprContext exprContext, ParserRuleContext parent) {
        MySQLExpressionFactory factory = new MySQLExpressionFactory(exprContext);
        return new OnJoinCondition((ParserRuleContext)(parent == null ? exprContext : parent), (Expression)factory.generate());
    }

    private JoinCondition getFromUsingColumnList(OBParser.Column_listContext columnCtxList, ParserRuleContext parent) {
        List<ColumnReference> columnList = columnCtxList.column_definition_ref().stream().map(child -> {
            MySQLColumnRefFactory factory = new MySQLColumnRefFactory((OBParser.Column_definition_refContext)((Object)child));
            return (ColumnReference)factory.generate();
        }).collect(Collectors.toList());
        return new UsingJoinCondition((ParserRuleContext)(parent == null ? columnCtxList : parent), columnList);
    }
}

