/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnRefFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.insert.Insert;
import com.oceanbase.tools.sqlparser.statement.insert.InsertBody;
import com.oceanbase.tools.sqlparser.statement.insert.SingleTableInsert;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLInsertFactory
extends OBParserBaseVisitor<Insert>
implements StatementFactory<Insert> {
    private final OBParser.Insert_stmtContext insertStmtContext;

    public MySQLInsertFactory(@NonNull OBParser.Insert_stmtContext insertStmtContext) {
        if (insertStmtContext == null) {
            throw new NullPointerException("insertStmtContext is marked non-null but is null");
        }
        this.insertStmtContext = insertStmtContext;
    }

    @Override
    public Insert generate() {
        return (Insert)this.visit((ParseTree)this.insertStmtContext);
    }

    @Override
    public Insert visitInsert_stmt(OBParser.Insert_stmtContext ctx) {
        OBParser.Column_listContext columns = ctx.single_table_insert().column_list();
        InsertBody insertBody = new InsertBody(ctx.single_table_insert());
        if (columns != null) {
            insertBody.setColumns(columns.column_definition_ref().stream().map(c -> {
                MySQLColumnRefFactory factory = new MySQLColumnRefFactory((OBParser.Column_definition_refContext)((Object)c));
                return (ColumnReference)factory.generate();
            }).collect(Collectors.toList()));
        }
        SingleTableInsert insert = new SingleTableInsert((ParserRuleContext)ctx, insertBody);
        if (ctx.replace_with_opt_hint() != null) {
            insert.setReplace(true);
        }
        return insert;
    }
}

